/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.config;

import com.google.gson.GsonBuilder;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.HeirarchicalJsonConfigAdapter;
import com.minelittlepony.common.util.settings.Setting;
import ivorius.psychedelicraft.config.FeatureCustomConfig;
import ivorius.psychedelicraft.config.Generation;
import ivorius.psychedelicraft.config.MessageDistortion;
import ivorius.psychedelicraft.config.TickRates;
import ivorius.psychedelicraft.fluid.alcohol.TickRate;
import ivorius.psychedelicraft.util.CodecTypeAdapter;
import java.nio.file.Path;
import net.minecraft.class_1761;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;

public class PSConfig
extends Config {
    public static final int MINUTE = 1200;
    public final Setting<Integer> randomTicksUntilRiftSpawn = this.value("balancing", "randomTicksUntilRiftSpawn", 216000).addComment("Controls how frequently zero rifts spawn.").addComment("Set to 0 to disable rift spawning entirely").addComment("Default: 216000");
    public final Setting<Integer> dryingTableTickDuration = this.value("balancing", "dryingTableTickDuration", 19200).addComment("Sets the number of ticks the wooden drying table takes on average to cook items").addComment("Default: 19200");
    public final Setting<Integer> ironDryingTableTickDuration = this.value("balancing", "ironDryingTableTickDuration", 14400).addComment("Sets the number of ticks the stone drying table takes on average to cook items").addComment("Default: 14400");
    public final Setting<Integer> slurryHardeningTime = this.value("balancing", "slurryHardeningTime", 36000).addComment("Sets the number of ticks it takes for slurry to congeal into dirt").addComment("Default: 36000");
    public final Setting<Boolean> enableHarmonium = this.value("balancing", "enableHarmonium", true).addComment("Sets whether harmonium is obtainable").addComment("Default: true");
    public final Setting<Boolean> enableRiftJars = this.value("balancing", "enableRiftJars", true).addComment("Sets whether rift jars are obtainable. Rift jars are only useful if rift spawning is enabled as well.").addComment("Default: true");
    public final Setting<Boolean> disableMolotovs = this.value("balancing", "disableMolotovs", false).addComment("Sets whether molotov cocktails are (not) obtainable.").addComment("Default: false");
    public final Setting<Generation> worldGeneration = this.value("balancing", "worldGeneration", new Generation(FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, FeatureCustomConfig.DEFAULT, true, true, true)).addComment("Settings affecting world generation and in-game mechanics");
    public final Setting<TickRates> fluidAttributes = this.value("balancing", "fluidAttributes", new TickRates(TickRate.getDefaults())).addComment("Sets the rate at which each fluid is processed.").addComment("Delete the entry for a fluid and restart the game to have the default value for that fluid populated.");
    public final Setting<MessageDistortion> messageDistortion = this.value("balancing", "messageDistortion", (Object)MessageDistortion.BOTH).addComment("Sets whether drug effects are able to mess with chat messages.").addComment("Default: BOTH").addComment("OUTGOING - Messages others see from you are affected").addComment("INCOMING - Messages you see from others are affected").addComment("BOTH - All messages are affected").addComment("NONE - No messages are affected");

    public PSConfig(Path path) {
        super((Config.Adapter)new HeirarchicalJsonConfigAdapter(new GsonBuilder().registerTypeAdapter(FeatureCustomConfig.InclusionFilter.class, new CodecTypeAdapter<FeatureCustomConfig.InclusionFilter>(FeatureCustomConfig.InclusionFilter.CODEC)).registerTypeAdapter(TickRates.class, new CodecTypeAdapter<TickRates>(TickRates.CODEC))), path);
        this.enableHarmonium.onChanged(PSConfig::forceInventoryGroupsRefresh);
        this.enableRiftJars.onChanged(PSConfig::forceInventoryGroupsRefresh);
        this.disableMolotovs.onChanged(PSConfig::forceInventoryGroupsRefresh);
    }

    private static void forceInventoryGroupsRefresh(boolean v) {
        class_1761.class_8128 context = class_7706.field_42466;
        if (context != null) {
            class_7706.field_42466 = null;
            class_7706.method_47330((class_7699)context.comp_1251(), (boolean)context.comp_1252(), (class_7225.class_7874)context.comp_1253());
        }
    }
}

