/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.datagen.providers.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_7923;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class SoundTypeBuilder {
    private class_3419 category = class_3419.field_15254;
    private Optional<String> subtitle = Optional.empty();
    private final List<Sound> sounds = new ArrayList<Sound>();

    public static SoundTypeBuilder of(class_3414 event) {
        return SoundTypeBuilder.of().subtitle("subtitles." + event.method_14833().method_12836() + "." + event.method_14833().method_12832());
    }

    public static SoundTypeBuilder of() {
        return new SoundTypeBuilder();
    }

    private SoundTypeBuilder() {
    }

    public SoundTypeBuilder category(class_3419 category) {
        this.category = category;
        return this;
    }

    public SoundTypeBuilder subtitle(String subtitle) {
        this.subtitle = Optional.of(subtitle);
        return this;
    }

    public SoundTypeBuilder sound(Sound.Builder sound) {
        this.sounds.add(sound.build(""));
        return this;
    }

    public SoundTypeBuilder sound(Sound.Builder sound, int count) {
        for (int i = 1; i <= count; ++i) {
            this.sounds.add(sound.build("" + i));
        }
        return this;
    }

    public SoundType build() {
        Preconditions.checkState((!this.sounds.isEmpty() ? 1 : 0) != 0, (Object)"Sound definition must have at least one sound file");
        for (Sound sound : this.sounds) {
            if (sound.type() != Sound.RegistrationType.SOUND_EVENT) continue;
            class_7923.field_41172.method_17966(sound.name()).orElseThrow(() -> new IllegalStateException("References sound event " + String.valueOf(sound.name()) + " does not exist"));
        }
        return new SoundType(this.sounds, this.category, this.subtitle);
    }

    public record Sound(class_2960 name, RegistrationType type, float volume, float pitch, int weight, int attenuationDistance, boolean stream, boolean preload) {
        private static final Codec<Sound> MAP_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("name").forGetter(Sound::name), (App)RegistrationType.CODEC.optionalFieldOf("type", (Object)RegistrationType.FILE).forGetter(Sound::type), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Sound::volume), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Sound::pitch), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(Sound::weight), (App)Codec.INT.optionalFieldOf("attenuation_distance", (Object)16).forGetter(Sound::attenuationDistance), (App)Codec.BOOL.optionalFieldOf("stream", (Object)false).forGetter(Sound::stream), (App)Codec.BOOL.optionalFieldOf("preload", (Object)false).forGetter(Sound::preload)).apply((Applicative)i, Sound::new));
        private static final Codec<Sound> STRING_CODEC = class_2960.field_25139.xmap(id -> new Sound((class_2960)id, RegistrationType.FILE, 1.0f, 1.0f, 1, 16, false, false), Sound::name);
        public static final Codec<Sound> CODEC = Codec.xor(STRING_CODEC, MAP_CODEC).xmap(Either::unwrap, sound -> {
            if (sound.type() != RegistrationType.FILE || sound.volume() != 1.0f || sound.pitch() != 1.0f || sound.weight() != 1 || sound.attenuationDistance() != 16 || sound.stream() || sound.preload()) {
                return Either.right((Object)sound);
            }
            return Either.left((Object)sound);
        });

        public static Builder builder(class_2960 name) {
            return new Builder(name);
        }

        public static enum RegistrationType implements class_3542
        {
            FILE("fule"),
            SOUND_EVENT("event");

            public static final Codec<RegistrationType> CODEC;
            private final String name;

            private RegistrationType(String name) {
                this.name = name;
            }

            public String method_15434() {
                return this.name;
            }

            static {
                CODEC = class_3542.method_28140(RegistrationType::values);
            }
        }

        public static class Builder {
            private final class_2960 name;
            private float volume = 1.0f;
            private float pitch = 1.0f;
            private int attenuationDistance = 16;
            private int weight = 1;
            private boolean stream = false;
            private boolean preload = false;
            private RegistrationType type = RegistrationType.FILE;

            private Builder(class_2960 name) {
                this.name = name;
            }

            public Builder volume(float volume) {
                this.volume = volume;
                return this;
            }

            public Builder pitch(float pitch) {
                this.pitch = pitch;
                return this;
            }

            public Builder attenuationDistance(int attenuationDistance) {
                this.attenuationDistance = attenuationDistance;
                return this;
            }

            public Builder weight(int weight) {
                this.weight = weight;
                return this;
            }

            public Builder stream(boolean stream) {
                this.stream = stream;
                return this;
            }

            public Builder preload(boolean preload) {
                this.preload = preload;
                return this;
            }

            public Builder type(RegistrationType type) {
                this.type = type;
                return this;
            }

            public Sound build(String suffix) {
                return new Sound(this.name.method_48331(suffix), this.type, this.volume, this.pitch, this.weight, this.attenuationDistance, this.stream, this.preload);
            }
        }
    }

    public record SoundType(List<Sound> sounds, class_3419 category, Optional<String> subtitle) {
        private static final Map<String, class_3419> CATEGORIES = Arrays.stream(class_3419.values()).collect(Collectors.toMap(class_3419::method_14840, Function.identity()));
        private static final Codec<class_3419> SOUND_CATEGORY_CODEC = Codec.stringResolver(class_3419::method_14840, name -> CATEGORIES.getOrDefault(name.toLowerCase(Locale.ROOT), class_3419.field_15254));
        public static final Codec<SoundType> CODEC = RecordCodecBuilder.create(i -> i.group((App)Sound.CODEC.listOf().fieldOf("sounds").forGetter(SoundType::sounds), (App)SOUND_CATEGORY_CODEC.fieldOf("category").forGetter(SoundType::category), (App)Codec.STRING.optionalFieldOf("subtitle").forGetter(SoundType::subtitle)).apply((Applicative)i, SoundType::new));
    }
}

