/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity;

import com.google.common.base.Suppliers;
import ivorius.psychedelicraft.ParticleHelper;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.entity.PSEntities;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class RealityRiftEntity
extends class_1297 {
    public static final float CLOSING_DECAY_RATE = 0.05f;
    public static final float RIFT_DECAY_RATE = 4.1666666E-5f;
    public static final float ANIMATION_CHANGE_RATE = 0.005f;
    public static final float RIFT_COLLAPSE_THRESHOLD = 0.9f;
    public static final float CRITICAL_RIFT_BLEED_AMOUNT = 0.2f;
    public static final double AFFECT_PER_BLOCK = 5.0E-4;
    private static final class_2940<Float> SIZE = class_2945.method_12791(RealityRiftEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> INSTABILITY = class_2945.method_12791(RealityRiftEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> CLOSING = class_2945.method_12791(RealityRiftEntity.class, (class_2941)class_2943.field_13323);
    private float prevVvisualRiftSize;
    private float visualRiftSize;

    public static void spawn(class_1297 entity) {
        RealityRiftEntity rift = (RealityRiftEntity)PSEntities.REALITY_RIFT.method_5883(entity.method_37908());
        rift.method_5814(entity.method_23317() + (entity.method_37908().method_8409().method_43058() - 0.5) * 100.0, entity.method_23318() + (entity.method_37908().method_8409().method_43058() - 0.5) * 100.0, entity.method_23321() + (entity.method_37908().method_8409().method_43058() - 0.5) * 100.0);
        entity.method_37908().method_8649((class_1297)rift);
    }

    RealityRiftEntity(class_1299<RealityRiftEntity> type, class_1937 par1World) {
        super(type, par1World);
        this.setRiftSize((float)this.method_37908().method_8409().method_43385(0.5, 0.5));
    }

    public class_238 method_5830() {
        return this.method_5829().method_1014(20.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SIZE, (Object)Float.valueOf(0.0f)).method_56912(CLOSING, (Object)false).method_56912(INSTABILITY, (Object)Float.valueOf(0.0f));
    }

    public float getRiftSize() {
        return ((Float)this.method_5841().method_12789(SIZE)).floatValue();
    }

    public float getRiftSize(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevVvisualRiftSize, (float)this.visualRiftSize);
    }

    public void setRiftSize(float size) {
        this.method_5841().method_12778(SIZE, (Object)Float.valueOf(Math.max(0.0f, size)));
    }

    public void addToRift(float size) {
        this.setRiftSize(this.getRiftSize() + size);
    }

    public float takeFromRift(float size) {
        if (this.isCritical()) {
            return 0.2f;
        }
        float riftSize = this.getRiftSize();
        float newVal = Math.max(riftSize - size, 0.0f);
        this.setRiftSize(newVal);
        return riftSize - newVal;
    }

    public float getInstability() {
        return ((Float)this.method_5841().method_12789(INSTABILITY)).floatValue();
    }

    public void setInstability(float instability) {
        this.method_5841().method_12778(INSTABILITY, (Object)Float.valueOf(Math.max(0.0f, instability)));
    }

    public boolean isRiftClosing() {
        return (Boolean)this.method_5841().method_12789(CLOSING);
    }

    public void setRiftClosing(boolean closing) {
        this.method_5841().method_12778(CLOSING, (Object)closing);
    }

    public boolean isCritical() {
        return (this.getInstability() > 0.0f || this.getRiftSize() > 3.0f) && !this.isRiftClosing();
    }

    public boolean method_5696() {
        return true;
    }

    public class_2561 method_5476() {
        return super.method_5476().method_27661().method_27692(class_124.field_1051);
    }

    public void method_5773() {
        super.method_5773();
        this.method_18799(class_243.field_1353);
        if (this.method_37908() instanceof class_3218) {
            if ((Integer)Psychedelicraft.getConfig().randomTicksUntilRiftSpawn.get() == 0) {
                this.method_5768();
                return;
            }
            this.emitEffects();
            if (this.isCritical()) {
                this.spreadCorruption();
            }
            if (this.isRiftClosing()) {
                this.setRiftSize(this.getRiftSize() - 0.05f);
            } else if (!this.isCritical()) {
                this.setRiftSize(this.getRiftSize() - 4.1666666E-5f);
            }
            if (this.getInstability() >= 0.9f) {
                this.setRiftClosing(true);
            }
            if (this.visualRiftSize <= 0.0f && this.getRiftSize() <= 0.0f) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
        } else {
            class_243 pos = this.method_19538();
            Supplier<class_243> particlePositionSupplier = () -> {
                float distance = this.field_5974.method_43057() * this.field_5974.method_43057();
                return ParticleHelper.apply(pos, x -> x + (double)((this.field_5974.method_43057() * 8.0f - 4.0f) * distance)).method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0);
            };
            ParticleHelper.spawnParticles(this.method_37908(), (class_2394)class_2398.field_11237, particlePositionSupplier, (Supplier<class_243>)Suppliers.ofInstance((Object)class_243.field_1353), this.field_5974.method_43048(3));
            ParticleHelper.spawnParticles(this.method_37908(), (class_2394)new class_2390(new Vector3f(1.0f, 0.5f, 0.5f), 1.0f), particlePositionSupplier, (Supplier<class_243>)Suppliers.ofInstance((Object)new class_243(-10.0, -10.0, -10.0)), this.field_5974.method_43048(2));
            ParticleHelper.spawnParticles(this.method_37908(), (class_2394)class_2398.field_11215, (Supplier<class_243>)Suppliers.ofInstance((Object)pos.method_1031(0.0, (double)(1.0f + this.method_17682() / 2.0f), 0.0)), () -> {
                float distance = this.field_5974.method_43057() * this.field_5974.method_43057();
                return ParticleHelper.apply(class_243.field_1353, x -> x + (double)((this.field_5974.method_43057() * 8.0f - 4.0f) * distance)).method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0);
            }, 1);
        }
        this.prevVvisualRiftSize = this.visualRiftSize;
        this.visualRiftSize = MathUtils.nearValue(this.visualRiftSize, this.getRiftSize(), 0.05f, 0.005f);
    }

    private void emitEffects() {
        float searchDistance = 5.0f + this.getInstability() * 50.0f;
        boolean critical = this.isCritical();
        for (class_1309 entity : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014((double)searchDistance), class_1301.field_6156)) {
            double dist = entity.method_5739((class_1297)this);
            double effect = ((double)searchDistance - dist) * 5.0E-4 * (double)this.getRiftSize();
            if (!(effect > 0.0)) continue;
            DrugProperties.of((class_1297)entity).ifPresentOrElse(drugProperties -> {
                drugProperties.addToDrug(DrugType.ZERO, effect * 20.0);
                drugProperties.addToDrug(DrugType.POWER, effect * 200.0);
            }, () -> {
                if (critical) {
                    entity.method_5643(this.method_48923().method_48831(), (float)effect * 20.0f);
                }
            });
        }
    }

    private void spreadCorruption() {
        float prevS = this.getInstability();
        float newS = Math.min(prevS + 0.001f, 1.0f);
        this.setInstability(newS);
        float prevDesRange = prevS * 50.0f;
        float newDesRange = newS * 50.0f;
        if (prevDesRange < newDesRange) {
            int desRange = class_3532.method_15386((float)newDesRange);
            class_2338 center = this.method_24515();
            class_2338.method_25996((class_2338)center, (int)desRange, (int)desRange, (int)desRange).forEach(p -> {
                if (p.method_19771((class_2382)center, (double)newDesRange) && !p.method_19771((class_2382)center, (double)prevDesRange) && !this.method_37908().method_22347(p)) {
                    this.method_37908().method_8501(p, PSBlocks.GLITCH.method_9564());
                }
            });
        }
    }

    public void method_5768() {
        this.setRiftClosing(true);
        this.method_32876((class_6880)class_5712.field_37676);
    }

    public void method_5749(class_2487 compound) {
        if (compound.method_10573("riftSize", 5)) {
            this.setRiftSize(compound.method_10583("riftSize"));
        }
        if (compound.method_10545("isRiftClosing")) {
            this.setRiftClosing(compound.method_10577("isRiftClosing"));
        }
        if (compound.method_10573("instability", 5)) {
            this.setInstability(compound.method_10583("instability"));
        }
    }

    public void method_5652(class_2487 compound) {
        compound.method_10548("riftSize", this.getRiftSize());
        compound.method_10556("isRiftClosing", this.isRiftClosing());
        compound.method_10548("instability", this.getInstability());
    }
}

