/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import ivorius.psychedelicraft.entity.drug.Attribute;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.List;
import java.util.stream.Stream;

public class HallucinationTypes {
    public static final int ENTITIES = 0;
    public static final int DESATURATION = 1;
    public static final int SUPER_SATURATION = 2;
    public static final int SLOW_COLOR_ROTATION = 3;
    public static final int QUICK_COLOR_ROTATION = 4;
    public static final int BIG_WAVES = 5;
    public static final int SMALL_WAVES = 6;
    public static final int WIGGLE_WAVES = 7;
    public static final int PULSES = 8;
    public static final int SURFACE_FRACTALS = 9;
    public static final int DISTANT_WORLD_DEFORMATION = 10;
    public static final int SHATTERING_FRACTALS = 11;
    public static final int BLOOM = 101;
    public static final int COLOR_BLOOM = 102;
    public static final int COLOR_CONTRAST = 103;
    private static final IntList COLOR = IntList.of((int[])new int[]{1, 2, 3, 4, 8, 9, 101, 102, 103});
    private static final IntList MOVEMENT = IntList.of((int[])new int[]{5, 6, 7, 10, 11});
    private static final IntList CONTEXTUAL = IntList.of((int)0);
    public static final IntList ALL = IntList.of((int[])Stream.of(COLOR, MOVEMENT, CONTEXTUAL).flatMapToInt(IntCollection::intStream).toArray());
    private static final List<Category> CATEGORIES = List.of(new Category(COLOR, Drug.COLOR_HALLUCINATION_STRENGTH), new Category(MOVEMENT, Drug.MOVEMENT_HALLUCINATION_STRENGTH), new Category(CONTEXTUAL, Drug.CONTEXTUAL_HALLUCINATION_STRENGTH));
    private final Object2FloatMap<Category> values = new Object2FloatOpenHashMap();

    public float update(DrugProperties properties) {
        float totalHallucinationValue = 0.0f;
        for (Category category : CATEGORIES) {
            totalHallucinationValue += this.values.computeFloat((Object)category, (c, currentValue) -> Float.valueOf(MathUtils.nearValue(currentValue == null ? 0.0f : currentValue.floatValue(), c.getDesiredValue(properties), 0.01f, 0.01f)));
        }
        return totalHallucinationValue;
    }

    public float getMultiplier(int hallucination) {
        float value = 1.0f;
        for (Category c : CATEGORIES) {
            if (!c.hallucinations.contains(hallucination)) continue;
            value *= MathUtils.project(this.values.getFloat((Object)c), 0.0f, 0.5f);
        }
        return value;
    }

    private record Category(IntList hallucinations, Attribute modifier) {
        public float getDesiredValue(DrugProperties properties) {
            return properties.getModifier(this.modifier);
        }
    }
}

