/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.influence;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector3f;

public class DrugInfluenceInstance {
    public static final Codec<DrugInfluenceInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DrugType.REGISTRY.method_39673().fieldOf("drugType").forGetter(i -> i.drugType), (App)Codec.INT.fieldOf("delay").forGetter(i -> i.delay), (App)Codec.DOUBLE.fieldOf("influenceSpeed").forGetter(i -> i.factor), (App)Codec.DOUBLE.fieldOf("influenceSpeedPlus").forGetter(i -> i.base), (App)Codec.DOUBLE.fieldOf("maxInfluence").forGetter(i -> i.targetRemaining), (App)DrugInfluence.COLOR_CODEC.optionalFieldOf("color").forGetter(i -> i.color)).apply((Applicative)instance, DrugInfluenceInstance::new));
    public static final Codec<List<DrugInfluenceInstance>> LIST_CODEC = CODEC.listOf();
    public static final class_9139<class_9129, DrugInfluenceInstance> PACKET_CODEC = class_9139.method_58025((class_9139)class_9135.method_56365((class_5321)DrugType.REGISTRY.method_30517()), i -> i.drugType, (class_9139)class_9135.field_49675, i -> i.delay, (class_9139)class_9135.field_48553, i -> i.factor, (class_9139)class_9135.field_48553, i -> i.base, (class_9139)class_9135.field_48553, i -> i.targetRemaining, DrugInfluence.COLOR_PACKET_CODEC, i -> i.color, DrugInfluenceInstance::new);
    public final DrugType<?> drugType;
    public final double factor;
    public final double base;
    public final Optional<Vector3f> color;
    private int delay;
    private double targetRemaining;

    public DrugInfluenceInstance(DrugInfluence influence) {
        this(influence.drugType(), influence.delay(), influence.factor(), influence.base(), influence.target(), influence.color());
    }

    public DrugInfluenceInstance(DrugType<?> drugType, int delay, double factor, double base, double target, Optional<Vector3f> color) {
        this.drugType = drugType;
        this.delay = delay;
        this.factor = factor;
        this.base = base;
        this.targetRemaining = target;
        this.color = color;
    }

    public boolean isOf(DrugType<?> type) {
        return this.drugType == type;
    }

    public boolean update(DrugProperties properties) {
        if (--this.delay > 0) {
            return false;
        }
        if (this.targetRemaining > 0.0) {
            double addition = Math.min(this.targetRemaining, this.base + this.targetRemaining * this.factor);
            properties.addToDrug(this.drugType, addition, this);
            this.targetRemaining -= addition;
        }
        return this.targetRemaining <= 0.0;
    }
}

