/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.type;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluenceInstance;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class SimpleDrug
implements Drug {
    protected double effect;
    protected double effectActive;
    protected boolean locked = false;
    private final double decreaseSpeed;
    private final double decreaseSpeedPlus;
    private final boolean invisible;
    private final DrugType<? extends SimpleDrug> type;
    private int ticksActive;

    static <T extends SimpleDrug> Products.P4<RecordCodecBuilder.Mu<T>, Double, Double, Boolean, Integer> fillCodecFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.DOUBLE.fieldOf("effect").forGetter(SimpleDrug::getDesiredValue), (App)Codec.DOUBLE.fieldOf("effectActive").forGetter(SimpleDrug::getActiveValue), (App)Codec.BOOL.fieldOf("locked").forGetter(SimpleDrug::isLocked), (App)Codec.INT.fieldOf("ticksActive").forGetter(SimpleDrug::getTicksActive));
    }

    public static <T extends SimpleDrug> MapCodec<T> createCodec(DrugType<T> type) {
        return RecordCodecBuilder.mapCodec(instance -> SimpleDrug.fillCodecFields(instance).apply((Applicative)instance, (effect, effectActive, locked, ticksActive) -> {
            SimpleDrug i = (SimpleDrug)type.create();
            i.setActiveValue((double)effectActive);
            i.setDesiredValue((double)effect);
            i.setLocked((boolean)locked);
            i.setTicksActive((int)ticksActive);
            return i;
        }));
    }

    public SimpleDrug(DrugType<? extends SimpleDrug> type, double decSpeed, double decSpeedPlus) {
        this(type, decSpeed, decSpeedPlus, false);
    }

    public SimpleDrug(DrugType<? extends SimpleDrug> type, double decSpeed, double decSpeedPlus, boolean invisible) {
        this.type = type;
        this.decreaseSpeed = decSpeed;
        this.decreaseSpeedPlus = decSpeedPlus;
        this.invisible = invisible;
    }

    public final DrugType<? extends SimpleDrug> getType() {
        return this.type;
    }

    public void setActiveValue(double value) {
        this.effectActive = value;
    }

    @Override
    public double getActiveValue() {
        return this.effectActive;
    }

    public double getDesiredValue() {
        return this.effect;
    }

    @Override
    public int getTicksActive() {
        return this.ticksActive;
    }

    protected void setTicksActive(int ticksActive) {
        this.ticksActive = ticksActive;
    }

    @Override
    public void setDesiredValue(double value) {
        this.effect = value;
    }

    @Override
    public void addToDesiredValue(double value) {
        if (!this.locked) {
            this.effect += value;
        }
    }

    @Override
    public void addToDesiredValue(double value, DrugInfluenceInstance influence) {
        this.addToDesiredValue(value);
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isVisible() {
        return !this.invisible;
    }

    @Override
    public final void update(DrugProperties properties) {
        if (this.getActiveValue() > 0.0) {
            ++this.ticksActive;
            if (this.ticksActive == 1) {
                properties.markDirty();
            }
            if (!properties.asEntity().method_37908().field_9236) {
                if (this.tickSideEffects(properties, properties.asEntity().method_37908().field_9229)) {
                    this.reset(properties);
                    properties.markDirty();
                }
            } else {
                this.tickClientEffects(properties, properties.asEntity().method_37908().field_9229);
            }
        } else {
            this.ticksActive = 0;
        }
        if (!this.locked) {
            this.effect *= this.decreaseSpeed;
            this.effect -= this.decreaseSpeedPlus;
        }
        this.effect = class_3532.method_15350((double)this.effect, (double)0.0, (double)1.0);
        this.setActiveValue(MathUtils.nearValue(this.effectActive, this.effect, 0.05, 0.005));
    }

    protected boolean tickSideEffects(DrugProperties properties, class_5819 random) {
        if (Drug.HEART_BEAT_SPEED.get(properties) > 3.0f) {
            properties.increaseCardiacArrestSideEffect();
            return true;
        }
        return false;
    }

    protected void tickClientEffects(DrugProperties properties, class_5819 random) {
    }

    @Override
    public void onWakeUp(DrugProperties drugProperties) {
        this.reset(drugProperties);
    }

    @Override
    public void reset(DrugProperties drugProperties) {
        if (!this.locked) {
            this.effect = 0.0;
        }
    }

    @Override
    public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.setDesiredValue(compound.method_10574("effect"));
        this.setActiveValue(compound.method_10574("effectActive"));
        this.setLocked(compound.method_10577("locked"));
        this.ticksActive = compound.method_10550("ticksActive");
    }

    @Override
    public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10549("effect", this.getDesiredValue());
        compound.method_10549("effectActive", this.getActiveValue());
        compound.method_10556("locked", this.isLocked());
        compound.method_10569("ticksActive", this.getTicksActive());
    }

    @Override
    public Optional<class_2561> trySleep(class_2338 pos) {
        return Optional.empty();
    }

    protected static void rotateEntityPitch(class_1297 entity, double amount) {
        entity.method_36457((float)class_3532.method_15350((double)((double)entity.method_36455() + amount), (double)-90.0, (double)90.0));
    }

    protected static void rotateEntityYaw(class_1297 entity, double amount) {
        entity.method_36456((entity.method_36454() + (float)amount) % 360.0f);
        entity.field_5982 = entity.method_36454();
    }
}

