/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.PSGameRules;
import ivorius.psychedelicraft.entity.drug.DrugAttributeFunctions;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class SleepDeprivationDrug
extends SimpleDrug {
    public static final int TICKS_PER_DAY = 24000;
    public static final int TICKS_UNTIL_PHANTOM_SPAWN = 72000;
    public static final MapCodec<SleepDeprivationDrug> CODEC = RecordCodecBuilder.mapCodec(instance -> SimpleDrug.fillCodecFields(instance).and((App)Codec.FLOAT.fieldOf("storedEnergy").forGetter(f -> Float.valueOf(f.storedEnergy))).apply((Applicative)instance, (effect, effectActive, locked, ticksActive, storedEnergy) -> {
        SleepDeprivationDrug i = new SleepDeprivationDrug();
        i.setActiveValue((double)effectActive);
        i.setDesiredValue((double)effect);
        i.setLocked((boolean)locked);
        i.setTicksActive((int)ticksActive);
        i.storedEnergy = storedEnergy.floatValue();
        return i;
    }));
    public static final DrugAttributeFunctions FUNCTIONS = DrugAttributeFunctions.builder().put(MOVEMENT_HALLUCINATION_STRENGTH, f -> Math.max(0.0f, f - 0.8f) * 3.0f).put(CONTEXTUAL_HALLUCINATION_STRENGTH, f -> Math.max(0.0f, f - 0.8f) * 4.0f).put(SOUND_VOLUME, f -> 1.0f + Math.max(0.0f, (f - 0.5f) * 2.0f)).put(DESATURATION_HALLUCINATION_STRENGTH, f -> Math.max(0.0f, (f - 0.5f) * 2.0f)).put(DROWSYNESS, 1.0f).put(MOTION_BLUR, f -> Math.max(0.0f, f - 0.6f) * 3.0f).put(DIG_SPEED, f -> 1.0f - Math.max(0.0f, f * 0.9f - 0.4f)).put(SPEED, f -> 1.0f - Math.max(0.0f, f * 0.9f - 0.4f)).build();
    private static final float INCREASE_PER_TICKS = 1.3888889E-5f;
    private float storedEnergy;

    public SleepDeprivationDrug() {
        super(DrugType.SLEEP_DEPRIVATION, 1.0, 0.0);
    }

    @Override
    protected boolean tickSideEffects(DrugProperties properties, class_5819 random) {
        float caffiene = properties.getDrugValue(DrugType.CAFFEINE) + properties.getDrugValue(DrugType.COCAINE) * 3.0f;
        this.storedEnergy = MathUtils.approach(this.storedEnergy, Math.min(1.0f, caffiene * 10.0f), 0.02f);
        if (caffiene > 0.1f) {
            this.setDesiredValue(0.0);
        } else if (properties.asEntity().method_37908().method_8450().method_8355(PSGameRules.DO_SLEEP_DEPRIVATION)) {
            this.setDesiredValue(this.getDesiredValue() + 4.6296295295178425E-6);
        }
        return super.tickSideEffects(properties, random);
    }

    @Override
    public void onWakeUp(DrugProperties drugProperties) {
        super.onWakeUp(drugProperties);
        this.setActiveValue(0.0);
    }

    @Override
    public double getActiveValue() {
        return Math.max(0.0, super.getActiveValue() - (double)this.storedEnergy);
    }

    @Override
    public void reset(DrugProperties drugProperties) {
        super.reset(drugProperties);
        if (!this.locked) {
            this.storedEnergy = 0.0f;
        }
    }

    @Override
    public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNbt(compound, lookup);
        this.storedEnergy = compound.method_10583("storedEnergy");
    }

    @Override
    public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNbt(compound, lookup);
        compound.method_10548("storedEnergy", this.storedEnergy);
    }
}

