/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.ConsumableFluid;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.alcohol.FluidAppearance;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class DrugFluid
extends SimpleFluid
implements ConsumableFluid {
    protected final Map<String, class_2960> flowTextures = new HashMap<String, class_2960>();
    protected final Map<String, class_2960> stillTextures = new HashMap<String, class_2960>();

    public DrugFluid(class_2960 id, Settings settings) {
        super(id, settings);
    }

    @Nullable
    public class_4174 getFoodLevel(class_1799 fluidStack) {
        return ((Settings)this.getSettings()).foodLevel;
    }

    public void getDrugInfluences(ItemFluids fluidStack, List<DrugInfluence> list) {
        this.getDrugInfluencesPerLiter(fluidStack, influence -> list.add(influence.copyWithTarget(influence.target() / 81000.0 * (double)fluidStack.amount())));
    }

    protected void getDrugInfluencesPerLiter(ItemFluids stack, Consumer<DrugInfluence> consumer) {
        ((Settings)this.getSettings()).drugInfluences.forEach(consumer);
    }

    @Override
    public boolean canConsume(class_1799 fluidStack, class_1309 entity, ConsumableFluid.ConsumptionType type) {
        if (type == ConsumableFluid.ConsumptionType.DRINK) {
            return ((Settings)this.getSettings()).drinkable && (!(entity instanceof class_1657) || this.getFoodLevel(fluidStack) == null || ((class_1657)entity).method_7344().method_7587());
        }
        return ((Settings)this.getSettings()).injectable;
    }

    @Override
    public void consume(ItemFluids stack, class_1309 entity, ConsumableFluid.ConsumptionType type) {
        DrugProperties.of((class_1297)entity).ifPresent(drugProperties -> {
            ArrayList<DrugInfluence> drugInfluences = new ArrayList<DrugInfluence>();
            this.getDrugInfluences(stack, drugInfluences);
            drugProperties.addAll(drugInfluences);
        });
        if (type == ConsumableFluid.ConsumptionType.DRINK && ((Settings)this.getSettings()).foodLevel != null && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            player.method_7344().method_7585(((Settings)this.getSettings()).foodLevel.comp_2491(), ((Settings)this.getSettings()).foodLevel.comp_2492());
        }
    }

    @Override
    public float getFireStrength(ItemFluids fluidStack) {
        return this.getAlcohol(fluidStack) * (float)fluidStack.amount() / 81000.0f * 2.0f;
    }

    @Override
    public float getExplosionStrength(ItemFluids fluidStack) {
        return this.getAlcohol(fluidStack) * (float)fluidStack.amount() / 81000.0f * 0.6f;
    }

    @Override
    public Optional<class_2960> getFlowTexture(ItemFluids stack) {
        return Optional.ofNullable(((Settings)this.getSettings()).appearance.apply(stack)).map(FluidAppearance::flowing).map(name -> this.flowTextures.computeIfAbsent((String)name, this::getFlowTexture));
    }

    @Override
    public Optional<class_2960> getStandingTexture(ItemFluids stack) {
        return Optional.ofNullable(((Settings)this.getSettings()).appearance.apply(stack)).map(FluidAppearance::still).map(name -> this.stillTextures.computeIfAbsent((String)name, this::getFlowTexture));
    }

    protected class_2960 getFlowTexture(String name) {
        return this.getId().method_45134(p -> "block/fluid/" + name);
    }

    private float getAlcohol(ItemFluids fluidStack) {
        float alcohol = 0.0f;
        ArrayList<DrugInfluence> drugInfluences = new ArrayList<DrugInfluence>();
        this.getDrugInfluences(fluidStack, drugInfluences);
        for (DrugInfluence drugInfluence : drugInfluences) {
            if (!drugInfluence.isOf(DrugType.ALCOHOL)) continue;
            alcohol = (float)((double)alcohol + drugInfluence.target());
        }
        return class_3532.method_15363((float)alcohol, (float)0.0f, (float)1.0f);
    }

    @Override
    public boolean isSuitableContainer(class_1799 container) {
        return container.method_31574((class_1792)PSItems.SYRINGE) || container.method_31574(class_1802.field_8469) || container.method_31574((class_1792)PSItems.FILLED_GLASS_BOTTLE);
    }

    @Override
    public class_6862<class_1792> getPreferredContainerTag() {
        return PSTags.Items.DRUG_RECEPTICALS;
    }

    public static class Settings
    extends SimpleFluid.Settings {
        private boolean drinkable;
        private boolean injectable;
        private List<DrugInfluence> drugInfluences = new ArrayList<DrugInfluence>();
        private class_4174 foodLevel;
        protected Function<ItemFluids, FluidAppearance> appearance = stack -> null;

        public Settings drinkable() {
            this.drinkable = true;
            return this;
        }

        public Settings injectable() {
            this.injectable = true;
            return this;
        }

        public Settings influence(DrugInfluence ... influences) {
            this.drugInfluences.addAll(List.of(influences));
            return this;
        }

        public Settings food(class_4174 food) {
            this.foodLevel = food;
            return this;
        }

        public Settings appearance(FluidAppearance appearance) {
            this.appearance = stack -> appearance;
            return this;
        }
    }
}

