/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.alcohol;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import ivorius.psychedelicraft.fluid.AlcoholicFluid;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public record AlcoholicFluidState(int distillation, int maturation, int fermentation, boolean vinegar) implements Function<ItemFluids, ItemFluids>
{
    private static final Interner<AlcoholicFluidState> INTERNER = Interners.newStrongInterner();
    public static final AlcoholicFluidState EMPTY = (AlcoholicFluidState)INTERNER.intern((Object)new AlcoholicFluidState(0, 0, 0, false));
    public static final AlcoholicFluidState VINEGAR = (AlcoholicFluidState)INTERNER.intern((Object)new AlcoholicFluidState(0, 0, 0, true));

    @Override
    public ItemFluids apply(ItemFluids stack) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(stack.attributes());
        this.apply((Map<String, Integer>)attributes);
        return stack.withAttributes(attributes);
    }

    @Override
    public void apply(Map<String, Integer> attributes) {
        AlcoholicFluid.DISTILLATION.set(attributes, (Integer)this.distillation);
        AlcoholicFluid.MATURATION.set(attributes, (Integer)this.maturation);
        AlcoholicFluid.FERMENTATION.set(attributes, (Integer)this.fermentation);
        AlcoholicFluid.VINEGAR.set(attributes, (Boolean)this.vinegar);
    }

    public boolean isDefault() {
        return this.distillation == 0 && this.maturation == 0 && this.fermentation == 0 && !this.vinegar;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int distillation;
        private int maturation;
        private int fermentation;
        private boolean vinegar;

        public Builder distillation(int distillation) {
            this.distillation = distillation;
            return this;
        }

        public Builder maturation(int maturation) {
            this.maturation = maturation;
            return this;
        }

        public Builder fermentation(int fermentation) {
            this.fermentation = fermentation;
            return this;
        }

        public Builder vinegar() {
            this.vinegar = true;
            return this;
        }

        public AlcoholicFluidState build() {
            return (AlcoholicFluidState)INTERNER.intern((Object)new AlcoholicFluidState(this.distillation, this.maturation, this.fermentation, this.vinegar));
        }
    }
}

