/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.container;

import ivorius.psychedelicraft.block.FluidCauldronBlock;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public interface FluidCauldronBehavior {
    public static final class_5620 AIR = (state, world, pos, player, hand, stack) -> {
        ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack.method_7972());
        ItemFluids fluid = t.fluids();
        @Nullable class_2248 cauldron = fluid.fluid().getPhysical().getCauldron();
        if (cauldron != null && t.fluids().amount() >= 27000) {
            int levels = Math.min(t.fluids().amount() / 27000, 3);
            class_1792 item = stack.method_7909();
            t.withdraw(levels * 27000);
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t.toItemStack()));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            FluidCauldronBehavior.setCauldronState(world, pos, fluid, levels);
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
            return class_9062.field_47728;
        }
        return class_9062.field_47731;
    };
    public static final class_5620 WATER = FluidCauldronBehavior.createCauldronInteraction((w, pos) -> SimpleFluid.of((class_3611)class_3612.field_15910).getDefaultStack());
    public static final class_5620 LAVA = FluidCauldronBehavior.createCauldronInteraction((w, pos) -> SimpleFluid.of((class_3611)class_3612.field_15908).getDefaultStack());
    public static final class_5620 OTHER_FLUID = FluidCauldronBehavior.createCauldronInteraction((w, pos) -> w.method_35230(pos, PSBlockEntities.CAULDRON).map(FluidCauldronBlock.Data::getFluid).orElse(ItemFluids.EMPTY));

    public static void register(class_1792 item) {
        class_5620.field_27775.comp_1982().put(item, AIR);
        class_5620.field_27777.comp_1982().put(item, LAVA);
        class_5620.field_27776.comp_1982().put(item, WATER);
        FluidCauldronBlock.BEHAVIOUR.comp_1982().put(item, OTHER_FLUID);
    }

    public static class_5620 createCauldronInteraction(BiFunction<class_1937, class_2338, ItemFluids> fluidTypeSupplier) {
        return (state, world, pos, player, hand, stack) -> {
            class_1792 item = stack.method_7909();
            ItemFluids fluidType = (ItemFluids)fluidTypeSupplier.apply(world, pos);
            ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack.method_7972());
            int maxTransferred = FluidCapacity.get(stack);
            if (t.fluids().isEmpty() && maxTransferred >= 27000) {
                int levelChange = maxTransferred / 27000;
                ItemFluids fluid = fluidType.ofAmount(levelChange * 27000);
                if (!t.canAccept(fluid)) {
                    return class_9062.field_47733;
                }
                if (!world.field_9236) {
                    t.deposit(fluid);
                    player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t.toItemStack()));
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956((Object)item));
                    FluidCauldronBehavior.decrementFluidLevel(state, world, pos, fluidType);
                    FluidCauldronBehavior.setCauldronState(world, pos, fluidType, FluidCauldronBehavior.getFluidLevel(state) - levelChange);
                    world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                    world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_33596(null, (class_6880)class_5712.field_28167, pos);
                }
                return class_9062.field_47728;
            }
            if (!t.fluids().canCombine(fluidType) || t.fluids().amount() < 27000 || !FluidCauldronBehavior.incrementFluidLevel(state, world, pos, fluidType)) {
                return class_9062.field_47731;
            }
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            t.withdraw(27000);
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t.toItemStack()));
            return class_9062.field_47728;
        };
    }

    private static int getFluidLevel(class_2680 state) {
        return state.method_28500((class_2769)class_5556.field_27206).orElse(state.method_27852(class_2246.field_10593) ? 0 : 3);
    }

    private static boolean incrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos, ItemFluids fluidType) {
        int level = FluidCauldronBehavior.getFluidLevel(state);
        if (level < 3) {
            FluidCauldronBehavior.setCauldronState(world, pos, fluidType, level + 1);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
            return true;
        }
        return false;
    }

    private static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos, ItemFluids fluidType) {
        FluidCauldronBehavior.setCauldronState(world, pos, fluidType, FluidCauldronBehavior.getFluidLevel(state) - 1);
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
    }

    private static void setCauldronState(class_1937 world, class_2338 pos, ItemFluids fluidType, int level) {
        world.method_8501(pos, FluidCauldronBehavior.getCauldronState(fluidType, level));
        world.method_35230(pos, PSBlockEntities.CAULDRON).ifPresent(data -> data.setFluid(fluidType));
    }

    private static class_2680 getCauldronState(ItemFluids fluidType, int level) {
        if (level <= 0) {
            return class_2246.field_10593.method_9564();
        }
        if (level >= 3 && fluidType.isOf((class_3611)class_3612.field_15908)) {
            return class_2246.field_27098.method_9564();
        }
        return (class_2680)fluidType.fluid().getPhysical().getCauldron().method_9564().method_47968((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level));
    }
}

