/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.mixin;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugPropertiesContainer;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3902;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class MixinPlayerEntity
extends class_1309
implements DrugPropertiesContainer {
    @Nullable
    private Supplier<DrugProperties> drugProperties = Suppliers.memoize(() -> new DrugProperties((class_1657)this));

    MixinPlayerEntity() {
        super(null, null);
    }

    @Override
    public DrugProperties getDrugProperties() {
        return this.drugProperties.get();
    }

    @Inject(method={"canResetTimeBySleeping"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanResetTimeBySleeping(CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue((Object)this.getDrugProperties().canResetTimeBySleeping((Boolean)info.getReturnValue()));
    }

    @Inject(method={"getSleepTimer"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetSleepTimer(CallbackInfoReturnable<Integer> info) {
        info.setReturnValue((Object)this.getDrugProperties().getSleepTimer((Integer)info.getReturnValue()));
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void afterTick(CallbackInfo info) {
        this.getDrugProperties().onTick();
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo info) {
        if (!this.getDrugProperties().onAwoken()) {
            info.cancel();
        }
    }

    @Inject(method={"trySleep(Lnet/minecraft/util/math/BlockPos;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTrySleep(class_2338 pos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> info) {
        if (!this.method_37908().field_9236) {
            this.getDrugProperties().trySleep(pos).ifPresent(reason -> {
                ((class_1657)this).method_7353(reason, true);
                info.setReturnValue((Object)Either.right((Object)class_3902.field_17274));
            });
        }
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)Float.valueOf(((Float)info.getReturnValue()).floatValue() * this.getDrugProperties().getModifier(Drug.DIG_SPEED)));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    private void onWriteCustomDataToTag(class_2487 tag, CallbackInfo info) {
        tag.method_10566("psychedelicraft_drug_properties", (class_2520)this.getDrugProperties().toNbt((class_7225.class_7874)this.method_56673()));
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    private void onReadCustomDataFromTag(class_2487 tag, CallbackInfo info) {
        if (tag.method_10573("psychedelicraft_drug_properties", 10)) {
            this.getDrugProperties().fromNbt(tag.method_10562("psychedelicraft_drug_properties"), (class_7225.class_7874)this.method_56673());
        }
    }
}

