/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import ivorius.psychedelicraft.util.CodecUtils;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;

public record MashingRecipe(String mashingGroup, class_7710 category, ItemFluids.Predicate baseFluid, ItemFluids result, Ingredients ingredients, int stewTime) implements class_1860<Input>
{
    public static final MapCodec<MashingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(MashingRecipe::mashingGroup), (App)class_7710.field_40252.optionalFieldOf("category", (Object)class_7710.field_40251).forGetter(MashingRecipe::category), (App)ItemFluids.Predicate.CODEC.fieldOf("base_fluid").forGetter(MashingRecipe::baseFluid), (App)ItemFluids.CODEC.fieldOf("result").forGetter(MashingRecipe::result), (App)Ingredients.CODEC.fieldOf("ingredients").forGetter(MashingRecipe::ingredients), (App)Codec.INT.optionalFieldOf("stew_time", (Object)0).forGetter(MashingRecipe::stewTime)).apply((Applicative)instance, MashingRecipe::new));
    public static final class_9139<class_9129, MashingRecipe> PACKET_CODEC = class_9139.method_58025((class_9139)class_9135.field_48554, MashingRecipe::mashingGroup, RecipeUtils.CRAFTING_RECIPE_CATEGORY_PACKET_CODEC, MashingRecipe::category, ItemFluids.Predicate.PACKET_CODEC, MashingRecipe::baseFluid, ItemFluids.PACKET_CODEC, MashingRecipe::result, Ingredients.PACKET_CODEC, MashingRecipe::ingredients, (class_9139)class_9135.field_49675, MashingRecipe::stewTime, MashingRecipe::new);

    public class_3956<?> method_17716() {
        return PSRecipes.MASHING_TYPE;
    }

    public class_1865<?> method_8119() {
        return PSRecipes.MASHING;
    }

    public String method_8112() {
        return this.mashingGroup;
    }

    public class_1799 method_17447() {
        return PSItems.MASH_TUB.method_7854();
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients.ingredients();
    }

    public boolean matches(Input input, class_1937 world) {
        return !input.tankFluid().isEmpty() && this.baseFluid.test(input.tankFluid()) && this.ingredients.matches(input);
    }

    public boolean matchesPartially(Input input, class_1937 world) {
        return !input.tankFluid().isEmpty() && this.baseFluid.test(input.tankFluid()) && this.ingredients.includes(input);
    }

    public class_1799 craft(Input input, class_7225.class_7874 lookup) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return width * height > 0;
    }

    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return class_1799.field_8037;
    }

    public class_2371<class_1799> getRemainder(Input input) {
        ItemMound unmatchedInputs = new ItemMound(input.inputs());
        this.ingredients.removeMatches(unmatchedInputs);
        return unmatchedInputs.convertToItemStacks();
    }

    public boolean method_8118() {
        return true;
    }

    public record Ingredients(class_2371<Entry> counts, class_2371<class_1856> ingredients) {
        public static final Codec<Ingredients> CODEC = CodecUtils.toDefaultedList(Entry.CODEC, Entry.EMPTY).xmap(Ingredients::new, Ingredients::counts);
        public static final class_9139<class_9129, Ingredients> PACKET_CODEC = Entry.PACKET_CODEC.method_56433(PacketCodecUtils.toDefaultedList()).method_56432(Ingredients::new, Ingredients::counts);

        public Ingredients(class_2371<Entry> counts) {
            this(counts, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])counts.stream().map(Entry::ingredient).toArray(class_1856[]::new))));
        }

        public boolean matches(Input input) {
            return this.removeMatches(new ItemMound(input.inputs()));
        }

        public boolean includes(Input input) {
            return !input.inputs().isEmpty() && this.ingredients.stream().anyMatch(i -> input.inputs().countMatches((Predicate<class_1799>)i) > 0);
        }

        public boolean removeMatches(ItemMound inputs) {
            return this.counts().stream().filter(ingredient -> !inputs.removeWhere((Predicate<class_1799>)ingredient.ingredient(), ingredient.minimum())).count() == 0L;
        }

        public record Entry(class_1856 ingredient, int minimum) {
            public static final Entry EMPTY = new Entry(class_1856.field_9017, 0);
            public static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_1856.field_46096.fieldOf("ingredient").forGetter(Entry::ingredient), (App)Codec.INT.fieldOf("count").forGetter(Entry::minimum)).apply((Applicative)i, Entry::new));
            public static final class_9139<class_9129, Entry> PACKET_CODEC = class_9139.method_56435((class_9139)class_1856.field_48355, Entry::ingredient, (class_9139)class_9135.field_49675, Entry::minimum, Entry::new);
        }
    }

    public record Input(ItemFluids tankFluid, class_1799 solids, ItemMound inputs) implements class_9695
    {
        public class_1799 method_59984(int slot) {
            return this.solids;
        }

        public int method_59983() {
            return 1;
        }

        public boolean method_59987() {
            return this.solids.method_7960() && this.tankFluid.isEmpty() && this.inputs.isEmpty();
        }
    }

    public static enum MatchResult {
        NONE,
        INPUTS_ONLY,
        INGREDIENTS_ONLY,
        BOTH;


        public boolean isMatch() {
            return this == INPUTS_ONLY || this == BOTH;
        }

        public boolean isCraftable() {
            return this == BOTH;
        }

        public static MatchResult of(boolean inputs, boolean ingredients) {
            return inputs && ingredients ? BOTH : (inputs ? INPUTS_ONLY : (ingredients ? INGREDIENTS_ONLY : NONE));
        }
    }
}

