/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.BunsenBurnerRecipe;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import ivorius.psychedelicraft.util.CodecUtils;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ReactingRecipe(BunsenBurnerRecipe.ReactionType reactionType, String reducingGroup, class_7710 category, Result result, Ingredients ingredients, int stewTime) implements BunsenBurnerRecipe
{
    public static final MapCodec<ReactingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BunsenBurnerRecipe.ReactionType.CODEC.optionalFieldOf("reaction_type", (Object)BunsenBurnerRecipe.ReactionType.INGREDIENTS).forGetter(ReactingRecipe::reactionType), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ReactingRecipe::reducingGroup), (App)class_7710.field_40252.optionalFieldOf("category", (Object)class_7710.field_40251).forGetter(ReactingRecipe::category), (App)Result.CODEC.fieldOf("result").forGetter(ReactingRecipe::result), (App)Ingredients.CODEC.fieldOf("ingredients").forGetter(ReactingRecipe::ingredients), (App)Codec.INT.optionalFieldOf("stew_time", (Object)0).forGetter(ReactingRecipe::stewTime)).apply((Applicative)instance, ReactingRecipe::new));
    public static final class_9139<class_9129, ReactingRecipe> PACKET_CODEC = class_9139.method_58025(BunsenBurnerRecipe.ReactionType.PACKET_CODEC, ReactingRecipe::reactionType, (class_9139)class_9135.field_48554, ReactingRecipe::reducingGroup, RecipeUtils.CRAFTING_RECIPE_CATEGORY_PACKET_CODEC, ReactingRecipe::category, Result.PACKET_CODEC, ReactingRecipe::result, Ingredients.PACKET_CODEC, ReactingRecipe::ingredients, (class_9139)class_9135.field_49675, ReactingRecipe::stewTime, ReactingRecipe::new);

    public class_1865<?> method_8119() {
        return PSRecipes.REACTING;
    }

    public String method_8112() {
        return this.reducingGroup;
    }

    public class_1799 method_17447() {
        return PSItems.BUNSEN_BURNER.method_7854();
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients.solids();
    }

    public boolean matches(BunsenBurnerRecipe.Input input, class_1937 world) {
        return this.reactionType == input.type() && this.ingredients.matchSolids(new ItemMound(input.input())) && this.ingredients.matchFluids(FluidMound.of(input.fluids()));
    }

    public boolean method_8118() {
        return true;
    }

    public class_1799 craft(BunsenBurnerRecipe.Input input, class_7225.class_7874 lookup) {
        if (this.ingredients.matchSolids(input.input())) {
            if (this.reactionType == BunsenBurnerRecipe.ReactionType.ADDITIONS) {
                this.result.impurity.ifPresent(input.consumer()::accept);
            } else {
                int level = this.ingredients.consumeMatchingFluids(input.fluids());
                if (!this.result.fluid().isEmpty()) {
                    input.consumer().accept(level == 0 ? this.result.fluid() : this.result.fluid().ofAmount(this.result.fluid().amount() * level));
                    this.result.impurity.ifPresent(input.consumer()::accept);
                }
            }
        }
        return this.result.byProduct();
    }

    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return this.result.byProduct();
    }

    public record Result(ItemFluids fluid, class_1799 byProduct, Optional<Impurities.Impurity> impurity) {
        public static final MapCodec<Result> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemFluids.CODEC.fieldOf("fluid").forGetter(Result::fluid), (App)class_1799.field_49266.optionalFieldOf("by_product", (Object)class_1799.field_8037).forGetter(Result::byProduct), (App)Impurities.Impurity.CODEC.optionalFieldOf("impurity").forGetter(Result::impurity)).apply((Applicative)instance, Result::new));
        public static final class_9139<class_9129, Result> PACKET_CODEC = class_9139.method_56436(ItemFluids.PACKET_CODEC, Result::fluid, (class_9139)class_1799.field_49268, Result::byProduct, (class_9139)class_9135.method_56382(PacketCodecUtils.ofEnum(Impurities.Impurity.class)), Result::impurity, Result::new);
    }

    public record Ingredients(class_2371<FluidIngredient> fluids, class_2371<class_1856> solids) {
        public static final MapCodec<Ingredients> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtils.toDefaultedList(FluidIngredient.CODEC, FluidIngredient.EMPTY).optionalFieldOf("fluids", (Object)class_2371.method_10211()).forGetter(Ingredients::fluids), (App)CodecUtils.toDefaultedList(class_1856.field_46096, class_1856.field_9017).optionalFieldOf("solids", (Object)class_2371.method_10211()).forGetter(Ingredients::solids)).apply((Applicative)instance, Ingredients::new));
        public static final class_9139<class_9129, Ingredients> PACKET_CODEC = class_9139.method_56435((class_9139)FluidIngredient.PACKET_CODEC.method_56433(PacketCodecUtils.toDefaultedList()), Ingredients::fluids, (class_9139)class_1856.field_48355.method_56433(PacketCodecUtils.toDefaultedList()), Ingredients::solids, Ingredients::new);

        public boolean matchSolids(ItemMound items) {
            if (this.solids().isEmpty()) {
                return items.isEmpty();
            }
            return this.solids().stream().allMatch(solid -> items.removeWhere((Predicate<class_1799>)solid, 1));
        }

        public boolean matchFluids(FluidMound fluids) {
            return this.fluids().isEmpty() || this.fluids().stream().allMatch(ingredient -> fluids.removeMatch((FluidIngredient)ingredient, -1) > 0);
        }

        public int consumeMatchingFluids(FluidMound fluids) {
            return this.fluids().isEmpty() ? 0 : this.fluids().stream().mapToInt(ingredient -> fluids.removeMatch((FluidIngredient)ingredient, -1)).sum();
        }
    }
}

