/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.config;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.util.SRPELootTable;
import energon.srpextra.util.SRPEMobInside;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraftforge.common.config.Configuration;

public class ParasiteBaseConfig {
    public boolean active;
    public float followRange;
    public float movementSpeed;
    public float attackDamage;
    public float armor;
    public float armorToughness;
    public float knockbackResistance;
    public float health;
    public SRPELootTable.LootTable lootTableList;
    public String[] lootTable;
    public int lootMaxRoll = 100;
    public boolean dropOneTypeItem = false;
    public String[] listSpawnMinions;
    public SRPEMobInside.MobInside mobInsideList;
    public String[] minionEffect;
    public boolean onlyOneMinionFromRoll = false;
    public boolean onlyOneEffectMinionFromRoll = false;
    public float minionsSpawnDistanceXZ;
    public float minionsSpawnDistanceY;
    public float minionsVelocityXZ;
    public float minionsVelocityY;
    public float minionsOffsetY;

    public ParasiteBaseConfig(boolean active, float followRange, float movementSpeed, float attackDamage, float armor, float armorToughness, float knockbackResistance, float health, String[] lootTable, String[] listSpawnMinions, String[] minionEffect, float minionsSpawnDistance, float minionsSpawnDistanceY, float minionsVelocityXZ, float minionsVelocityY, float minionsOffsetY) {
        this.active = active;
        this.followRange = followRange;
        this.movementSpeed = movementSpeed;
        this.attackDamage = attackDamage;
        this.armor = armor;
        this.armorToughness = armorToughness;
        this.knockbackResistance = knockbackResistance;
        this.health = health;
        this.lootTable = lootTable;
        this.listSpawnMinions = listSpawnMinions;
        this.minionEffect = minionEffect;
        this.minionsSpawnDistanceXZ = minionsSpawnDistance;
        this.minionsSpawnDistanceY = minionsSpawnDistanceY;
        this.minionsVelocityXZ = minionsVelocityXZ;
        this.minionsVelocityY = minionsVelocityY;
        this.minionsOffsetY = minionsOffsetY;
    }

    public void init(Configuration config, String category) {
        this.active = config.getBoolean(" Active", category, this.active, "Set to false if you want to disable entity.");
        this.followRange = config.getFloat("# Follow Range", category, this.followRange, 0.0f, 128.0f, "Follow range.");
        this.movementSpeed = config.getFloat("# Movement Speed", category, this.movementSpeed, 0.0f, 99.0f, "Movement speed.");
        this.attackDamage = config.getFloat("# Attack Damage", category, this.attackDamage, 0.0f, 999999.0f, "Attack damage (melee).");
        this.armor = config.getFloat("# Armor", category, this.armor, 0.0f, 999999.0f, "Armor.");
        this.armorToughness = config.getFloat("# Armor Toughness", category, this.armorToughness, 0.0f, 999999.0f, "Armor Toughness.");
        this.knockbackResistance = config.getFloat("# Knockback Resistance", category, this.knockbackResistance, 0.0f, 999999.0f, "Knockback resistance.");
        this.health = config.getFloat("# Health", category, this.health, 0.0f, 999999.0f, "Health.");
        this.lootTable = config.getStringList("$ Loot Table", category, this.lootTable, "Loot TableEx. \"100;minecraft:nether_star;0;5;1\" Where:  \n \"100\" is the chance to drop (100%), \n \"minecraft:nether_star\" is the item, \n \"0\" is the meta of items, \n \"5\" is the max number of items, \n \"1\" is the min number of items  \n");
        this.lootTableList = SRPELootTable.generate(category, this.lootTable);
        this.listSpawnMinions = config.getStringList("& List Mobs Inside", category, this.listSpawnMinions, "List of creatures that will appear after the deathEx. \"50;minecraft:zombie;5;1\" Where:  \n \"50\" it's a chance to create an entity (50%), \n \"minecraft:zombie\" is the entity, \n \"5\" is the maximum number of entities, \n \"1\" is a minimum number of entities  \n");
        this.minionEffect = config.getStringList("& List of Bonus Effects for Mobs Inside", category, this.minionEffect, "The list of effects that will be applied to the creatures that were spawned after death.Ex. \"100;minecraft:speed;5;1;1000;500;true\" Where:  \n \"100\" it's a chance to apply an effect (100%), \n \"minecraft:speed\" is the effect, \n \"5\" is the maximum level effect, \n \"1\" is a minimum level effect, \n \"1000\" Applies the effect of the potion for a maximum of 1000 ticks (50 seconds), \n \"500\" Applies the effect of the potion for a minimum of 500 ticks (25 seconds), \n \"true\" effect particle  \n");
        this.minionsSpawnDistanceXZ = config.getFloat("& Mobs Inside Spawn Distance XZ", category, this.minionsSpawnDistanceXZ, 0.0f, 999.0f, "Entity creation distance from entity center.");
        this.minionsSpawnDistanceY = config.getFloat("& Mobs Inside Spawn Distance Y", category, this.minionsSpawnDistanceY, 0.0f, 999.0f, "Entity creation distance from entity center.");
        this.minionsVelocityXZ = config.getFloat("& Mobs Inside Velocity XZ", category, this.minionsVelocityXZ, 0.0f, 100.0f, "Max: XZ Velocity.");
        this.minionsVelocityY = config.getFloat("& Mobs Inside Velocity Y", category, this.minionsVelocityY, 0.0f, 100.0f, "Max: Y Velocity.");
        this.minionsOffsetY = config.getFloat("& Mobs Inside Offset Y", category, this.minionsOffsetY, 0.0f, 999.0f, "Offset Y");
        this.mobInsideList = SRPEMobInside.generate(category, this.listSpawnMinions);
    }

    public void spawnMobInside(EntityLivingBase summoner) {
        this.mobInsideList.spawnMobInside(summoner, 100, this.minionsSpawnDistanceXZ, this.minionsSpawnDistanceY, this.minionsVelocityXZ, this.minionsVelocityY, this.minionsOffsetY);
    }

    public void spawnDeathLoot(EntityLivingBase dead) {
        this.lootTableList.spawnLoots(dead, this.lootMaxRoll);
    }

    public void addBaseAttributes(EntityLivingBase entity) {
        entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.followRange);
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movementSpeed);
        entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(this.attackDamage * SRPConfig.globalDamageMultiplier));
        entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(this.armor * SRPConfig.globalArmorMultiplier));
        entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)this.armorToughness);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)(this.knockbackResistance * SRPConfig.globalKDResistanceMultiplier));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.health * SRPConfig.globalHealthMultiplier));
    }
}

