/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.config;

import energon.srpextra.Main;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class SRPEConfigSystem {
    private static final String phaseSpawnXp = "  Ex. \"25;srparasites:fer_human;2;5;0,1,-1;minecraft:forest,minecraft:ocean\"  Where:\n \"25\" is spawn weight,\n \"srparasites:fer_human\" is the entity,\n \"2\" is the minimum group count,\n \"5\" is the maximum group count,\n \"0,1,-1\" is the dimension ID where the entity can spawn (If 'all' is entered, the mob will spawn in any dimension. If 'default' is entered, it will spawn only in -1, 0, and 1 (If a mod for parasitic dimension is installed, its identifiers will also be added automatically),\n \"minecraft:forest,minecraft:ocean\" These are the biomes where entities will spawn (If 'all' is entered, the entity will spawn in any biome). Support: blacklist biomes(!minecraft:forest, ..), biome types(forest,ocean, ..) and blacklist biome type(!forest, !dry, ..).\n (Optional) \"n150,c250\" - To spawn, need a node or a colony at a distance(150-node,250-colony).\n    Examples: \"25;srparasites:fer_human;2;5;0,1,-1;minecraft:forest,ocean\", \"25;srparasites:fer_human;1;3;default;all;n150\", \"25;srparasites:fer_human;2;5;0,1,-1;all;c150,n150\", \"25;srparasites:fer_human;2;5;all;forest,!minecraft:birch_forest\".";
    public static String[] phaseZeroEntityList = new String[0];
    public static String[] phaseOneEntityList = new String[0];
    public static String[] phaseTwoEntityList = new String[]{"25;srparasites:sim_vindicator;1;2;all;spooky", "5;srparasites:sim_evoker;1;1;all;spooky", "25;srparasites:sim_witch;1;2;all;all", "25;srparasites:sim_ocelot;1;2;all;jungle", "25;srparasites:sim_squid;1;3;all;ocean,beach,river"};
    public static String[] phaseThreeEntityList = new String[]{"25;srparasites:sim_vindicator;1;3;all;spooky", "5;srparasites:sim_evoker;1;1;all;spooky", "25;srparasites:sim_witch;1;2;all;all", "25;srparasites:sim_ocelot;1;2;all;jungle", "10;srparasites:hi_creeper;1;2;all;all", "10;srparasites:hi_stray;1;3;all;cold,hills", "10;srparasites:hi_skeleton_srpe;1;3;all;all", "25;srparasites:sim_squid;1;3;all;ocean,beach,river"};
    public static String[] phaseFourEntityList = new String[]{"25;srparasites:sim_vindicator;1;3;all;spooky", "10;srparasites:sim_evoker;1;1;all;spooky", "25;srparasites:sim_witch;1;2;all;all", "25;srparasites:sim_ocelot;1;2;all;jungle", "10;srparasites:hi_creeper;1;3;all;all", "10;srparasites:hi_stray;1;3;all;cold,hills", "10;srparasites:hi_skeleton_srpe;1;3;all;all", "5;srparasites:pri_stalker;1;1;all;all", "15;srparasites:pri_devourer;1;2;all;ocean,beach,river", "1;srparasites:wendigo;1;1;all;all", "25;srparasites:sim_squid;1;3;all;ocean,beach,river"};
    public static String[] phaseFiveEntityList = new String[]{"25;srparasites:sim_vindicator;1;3;all;spooky", "10;srparasites:sim_evoker;1;1;all;spooky", "25;srparasites:sim_witch;1;2;all;all", "25;srparasites:sim_ocelot;1;2;all;jungle", "15;srparasites:hi_creeper;1;2;all;all", "15;srparasites:hi_stray;1;3;all;cold,hills", "15;srparasites:hi_skeleton_srpe;1;3;all;all", "10;srparasites:pri_stalker;1;2;all;all", "15;srparasites:pri_devourer;1;2;all;ocean,beach,river", "1;srparasites:wendigo;1;1;all;all", "25;srparasites:sim_squid;1;3;all;ocean,beach,river"};
    public static String[] phaseSixEntityList = new String[]{"15;srparasites:fer_adventurer;1;2;all;all", "15;srparasites:fer_ocelot;1;3;all;jungle", "15;srparasites:fer_witch;1;3;all;all", "5;srparasites:ada_vermin;1;1;all;all", "5;srparasites:ada_tozoon;1;1;all;all", "5;srparasites:ada_stalker;1;1;all;all", "15;srparasites:pri_stalker;1;2;all;all", "15;srparasites:pri_devourer;1;3;all;ocean,beach,river", "1;srparasites:wendigo;1;1;all;all"};
    public static String[] phaseSevenEntityList = new String[]{"15;srparasites:fer_adventurer;1;2;all;all", "15;srparasites:fer_ocelot;1;3;all;jungle", "15;srparasites:fer_witch;1;3;all;all", "5;srparasites:ada_stalker;1;1;all;all", "5;srparasites:ada_vermin;1;1;all;all", "5;srparasites:ada_tozoon;1;1;all;all"};
    public static String[] phaseEightEntityList = new String[]{"15;srparasites:fer_adventurer;1;2;all;all", "15;srparasites:fer_ocelot;1;3;all;jungle", "15;srparasites:fer_witch;1;3;all;all", "5;srparasites:ada_stalker;1;1;all;all", "5;srparasites:ada_vermin;1;2;all;all", "10;srparasites:ada_tozoon;1;1;all;all"};
    public static String[] phaseNineEntityList = new String[]{"15;srparasites:fer_adventurer;1;2;all;all", "15;srparasites:fer_ocelot;1;3;all;jungle", "15;srparasites:fer_witch;1;3;all;all", "5;srparasites:ada_stalker;1;1;all;all", "10;srparasites:ada_vermin;1;2;all;all", "15;srparasites:ada_tozoon;1;2;all;all"};
    public static String[] phaseTenEntityList = new String[]{"15;srparasites:fer_adventurer;1;2;all;all", "15;srparasites:fer_ocelot;1;3;all;jungle", "15;srparasites:fer_witch;1;3;all;all", "5;srparasites:ada_stalker;1;1;all;all", "15;srparasites:ada_vermin;1;2;all;all", "20;srparasites:ada_tozoon;1;2;all;all"};
    public static boolean useSRPExtraEntitySpawn = false;
    public static boolean SRPEPhaseSpawn = true;
    public static boolean SRPExtra = true;
    public static boolean addSRPPhaseSpawnList = true;
    public static boolean addSRPExtraPhaseSpawnList = true;
    public static boolean addSRPExtraAddonsPhaseSpawnList = true;
    public static boolean ignoreSRPRules = false;
    public static int minDistanceSpawnEntity = 32;
    public static int maxDistanceSpawnEntity = 64;
    public static int maxDistanceSpawnEntityAboveAndBelow = 32;
    public static int minDistanceSpawnEntityAboveAndBelow = 16;
    public static int spawnSelectLogic = 3;
    public static int countTickSpawn = 5;
    public static int countTickSpawnPlusPlayer = 1;
    public static int maxYCoordinateParasiteSpawn = 250;
    public static int minYCoordinateParasiteSpawn = 5;
    public static int worldAquaMobCap = 15;
    public static int worldAquaMobCapPlusPlayer = 3;
    public static String[] mergeAquaInfValues = new String[]{"srparasites:sim_squid;2"};
    public static String[] mergeAquaMobTable = new String[]{"srparasites:pri_devourer;4"};
    public static String[] SRPEMergeInfValues = new String[]{"srparasites:sim_witch;1", "srparasites:sim_vindicator;1", "srparasites:sim_ocelot;1"};
    public static String[] SRPEMergeMobTable = new String[]{"srparasites:pri_stalker;1"};
    public static String[] cothVictim = new String[]{"minecraft:witch;srparasites:sim_witch", "minecraft:vindication_illager;srparasites:sim_vindicator", "minecraft:evocation_illager;srparasites:sim_evoker", "minecraft:ocelot;srparasites:sim_ocelot"};
    public static String[] hijackedVictim = new String[]{"minecraft:stray;srparasites:hi_stray", "minecraft:creeper;srparasites:hi_creeper", "minecraft:skeleton;srparasites:hi_skeleton_srpe"};
    public static boolean nocubessrpnestsCompatibility = false;
    public static boolean cotesiaCompatibility = true;
    public static String[] cotesiaCompatibilityCostSettings = new String[]{"srparasites:sim_ocelot|1|10", "srparasites:sim_ocelothead|1|5", "srparasites:sim_vindicator|1|15", "srparasites:sim_vindicatorhead|1|10", "srparasites:sim_evoker|1|20|100", "srparasites:sim_witch|1|10", "srparasites:sim_witchhead|1|5", "srparasites:hi_creeper|0|10", "srparasites:hi_creeperhead|0|5", "srparasites:hi_skeleton_srpe|0|10", "srparasites:hi_skeletonhead|0|5", "srparasites:hi_stray|0|10", "srparasites:fer_wolf_srpe|1|25", "srparasites:pri_stalker|2|30", "srparasites:ada_vermin|3|80|120", "srparasites:ada_tozoon|3|100|150", "srparasites:wendigo|2|50"};
    public static String[] locationTests = new String[]{"srparasites:sim_vindicator;all;spooky;8", "srparasites:sim_vindicatorhead;all;spooky", "srparasites:sim_evoker;all;spooky;8", "srparasites:sim_ocelot;all;jungle;8", "srparasites:sim_ocelothead;all;jungle;8", "srparasites:hi_stray;all;cold,hills;8"};

    private static void initMainSettings(Configuration config) {
        String category = "main";
        config.addCustomCategoryComment(category, "Main Settings\n!!!After updating the mod, configurations will be recreated!!!\n!!!It is recommended to save the configurations in another location!!!");
        minDistanceSpawnEntity = config.getInt("minDistanceSpawnEntity", category, minDistanceSpawnEntity, 4, 256, "Minimum distance from players at which entities can spawn.");
        maxDistanceSpawnEntity = config.getInt("maxDistanceSpawnEntity", category, maxDistanceSpawnEntity, 8, 256, "Maximum distance from players at which entities can spawn.");
        spawnSelectLogic = config.getInt("spawnSelectLogic", category, spawnSelectLogic, -99, 99, "Logic for selecting the entity spawn location.");
        maxDistanceSpawnEntityAboveAndBelow = config.getInt("maxDistanceSpawnEntityAboveAndBelow", category, maxDistanceSpawnEntityAboveAndBelow, 4, 128, "Maximum distance above and below the player at which entities can spawn.");
        countTickSpawn = config.getInt("countTickSpawn", category, countTickSpawn, 1, 999, "Number of ticks between attempts to spawn an entity.");
        countTickSpawnPlusPlayer = config.getInt("countTickSpawnPlusPlayer", category, countTickSpawnPlusPlayer, 0, 999999, "The number of ticks that will be added to \"countTickSpawn\" for each player.");
        maxYCoordinateParasiteSpawn = config.getInt("maxYCoordinateParasiteSpawn", category, maxYCoordinateParasiteSpawn, 1, 254, "Maximum height at which the parasite can spawned.");
        minYCoordinateParasiteSpawn = config.getInt("minYCoordinateParasiteSpawn", category, minYCoordinateParasiteSpawn, 1, 254, "Minimum height at which the parasite can spawned.");
        worldAquaMobCap = config.getInt("Aqua Mob Cap", category, worldAquaMobCap, 0, 50000, "Parasites will not spawn if local number is greater than this.");
        worldAquaMobCapPlusPlayer = config.getInt("Aqua Mob Cap", category, worldAquaMobCapPlusPlayer, 0, 50000, "Each Player will increase the mob cap by this value.");
        addSRPPhaseSpawnList = config.getBoolean(":addSRPPhaseSpawnList", category, addSRPPhaseSpawnList, "Add a list of SRP phase spawn?");
        addSRPExtraPhaseSpawnList = config.getBoolean(":addSRPExtraPhaseSpawnList", category, addSRPExtraPhaseSpawnList, "Add a list of SRPExtra phase spawn?");
        addSRPExtraAddonsPhaseSpawnList = config.getBoolean(":addSRPExtraAddonsPhaseSpawnList", category, addSRPExtraAddonsPhaseSpawnList, "Add a list of SRPExtra Addons phase spawn?");
        ignoreSRPRules = config.getBoolean("ignoreSRPRules", category, ignoreSRPRules, "Ignore SRP Phase Spawn Rules");
        useSRPExtraEntitySpawn = config.getBoolean("*useSRPExtraEntitySpawn", category, useSRPExtraEntitySpawn, "Replace the original entity spawning from SRP with the custom SRPExtra.");
        SRPExtra = config.getBoolean("*SRPExtra", category, SRPExtra, "If SRPExtra Phase Spawn is disabled, should the mob lists be added to SRP Phase Spawn?");
        SRPEPhaseSpawn = config.getBoolean("*SRPEPhaseSpawn", category, SRPEPhaseSpawn, "If false, completely disables the custom spawn event.");
    }

    private static void initPhase(Configuration config) {
        String category = "phase";
        config.addCustomCategoryComment(category, "Phase Settings  Ex. \"25;srparasites:fer_human;2;5;0,1,-1;minecraft:forest,minecraft:ocean\"  Where:\n \"25\" is spawn weight,\n \"srparasites:fer_human\" is the entity,\n \"2\" is the minimum group count,\n \"5\" is the maximum group count,\n \"0,1,-1\" is the dimension ID where the entity can spawn (If 'all' is entered, the mob will spawn in any dimension. If 'default' is entered, it will spawn only in -1, 0, and 1 (If a mod for parasitic dimension is installed, its identifiers will also be added automatically),\n \"minecraft:forest,minecraft:ocean\" These are the biomes where entities will spawn (If 'all' is entered, the entity will spawn in any biome). Support: blacklist biomes(!minecraft:forest, ..), biome types(forest,ocean, ..) and blacklist biome type(!forest, !dry, ..).\n (Optional) \"n150,c250\" - To spawn, need a node or a colony at a distance(150-node,250-colony).\n    Examples: \"25;srparasites:fer_human;2;5;0,1,-1;minecraft:forest,ocean\", \"25;srparasites:fer_human;1;3;default;all;n150\", \"25;srparasites:fer_human;2;5;0,1,-1;all;c150,n150\", \"25;srparasites:fer_human;2;5;all;forest,!minecraft:birch_forest\".");
        phaseZeroEntityList = config.getStringList("Phase 0", category, phaseZeroEntityList, "Custom SRPExtra Phase 0 Spawn Entity List");
        phaseOneEntityList = config.getStringList("Phase 1", category, phaseOneEntityList, "Custom SRPExtra Phase 1 Spawn Entity List");
        phaseTwoEntityList = config.getStringList("Phase 2", category, phaseTwoEntityList, "Custom SRPExtra Phase 2 Spawn Entity List");
        phaseThreeEntityList = config.getStringList("Phase 3", category, phaseThreeEntityList, "Custom SRPExtra Phase 3 Spawn Entity List");
        phaseFourEntityList = config.getStringList("Phase 4", category, phaseFourEntityList, "Custom SRPExtra Phase 4 Spawn Entity List");
        phaseFiveEntityList = config.getStringList("Phase 5", category, phaseFiveEntityList, "Custom SRPExtra Phase 5 Spawn Entity List");
        phaseSixEntityList = config.getStringList("Phase 6", category, phaseSixEntityList, "Custom SRPExtra Phase 6 Spawn Entity List");
        phaseSevenEntityList = config.getStringList("Phase 7", category, phaseSevenEntityList, "Custom SRPExtra Phase 7 Spawn Entity List");
        phaseEightEntityList = config.getStringList("Phase 8", category, phaseEightEntityList, "Custom SRPExtra Phase 8 Spawn Entity List");
        phaseNineEntityList = config.getStringList("Phase 9", category, phaseNineEntityList, "Custom SRPExtra Phase 9 Spawn Entity List");
        phaseTenEntityList = config.getStringList("phase 10", category, phaseTenEntityList, "Custom SRPExtra Phase 10 Spawn Entity List");
    }

    public static void initMergeSystem(Configuration cfg) {
        String category = "merge_system";
        String MergeDescription = " \n The Assimilated have the ability to learn from their battles and if the conditions are met, they will \n start to melt until they're some Moving Flesh \n If 2 of these things meet, they will fuse together and grow, if they get big enough they will spawn \n a mob from the Mob List.\n \n Conditions for the Assimilated to turn into Moving Flesh: \n \n -The first condition: the Assimilated needs to reach the primitive killcount. \n -The second condition: it needs to be next to 3 more Assimilated, regardless of their killcount/specie \n OR it needs to be next to a Moving Flesh. \n If the Assimilated with the killcount is next to atleast 3 more Assimilated, the four of them will start \n to melt BUT if it is next to a Moving flesh, only it will start to melt.";
        String mergeS = " Ex. \"minecraft:infhuman;11\"  Where: \n \"minecraft:infhuman\" is for the entity, \n \"11\" is for the value the entity has (value must be an integer). \n Each Assimilated has a value, the value then passes to the Moving Flesh and when 2 Moving Flesh merge together both values will add up\n If the value matches one in the list, the corresponding entity will spawn, else it will be a random one. \n";
        String mergeI = " Ex. \"srparasites:infhuman;22\"  Where: \n \"srparasites:infhuman\" is for the entity (only works for Assimilated versions minus Big Spider, Enderdragon), \n \"22\" is for the value the Moving Flesh will have (value must be an integer). \n";
        cfg.addCustomCategoryComment(category, "Merge System" + MergeDescription);
        SRPEMergeMobTable = cfg.getStringList("SRPEMergeMobTable", category, SRPEMergeMobTable, "Mob list used in the merge system to spawn mobs." + mergeS);
        SRPEMergeInfValues = cfg.getStringList("SRPEMergeInfValues", category, SRPEMergeInfValues, "Assimilated mob list with their values used in the merge system to spawn mobs." + mergeI);
        category = "aqua_merge_System";
        MergeDescription = " \n The Aqua Assimilated have the ability to learn from their battles and if the conditions are met, they will \n start to melt until they're some Moving Flesh \n If 2 of these things meet, they will fuse together and grow, if they get big enough they will spawn \n a mob from the Mob List.\n \n Conditions for the Aqua Assimilated to turn into Swimming Flesh: \n \n -The first condition: the Aqua Assimilated needs to reach the primitive killcount. \n -The second condition: it needs to be next to 3 more Aqua Assimilated, regardless of their killcount/specie \n OR it needs to be next to a Swimming Flesh. \n If the Aqua Assimilated with the killcount is next to atleast 3 more Aqua Assimilated, the four of them will start \n to melt BUT if it is next to a Swimming flesh, only it will start to melt.";
        cfg.addCustomCategoryComment(category, MergeDescription);
        mergeS = " Ex. \"srparasites:pri_hammerhead;1;4\"   Where: \n \"srparasites:pri_hammerhead\" is the entity that will be produced,\n \"1\" is the minimum amount of points that the Swimming Flesh must have,\n (Optionally) \"4\" is the maximum amount of points. If the flesh has more points than that, this entity will not be rolled during the transformation.\n Each Aqua Assimilated has a value, the value then passes to the Swimming Flesh and when 2 Swimming Flesh merge together both values will add up\n If the value matches one in the list, the corresponding entity will spawn, else it will be a random one. \n";
        mergeI = " Ex. \"srparasites:sim_drowned;3\"  Where: \n \"srparasites:sim_drowned\" is for the entity (only works for Aqua Assimilated versions), \n \"3\" is for the value the Swimming Flesh will have (value must be an integer). \n";
        mergeAquaMobTable = cfg.getStringList("aquaMergeMobTable", category, mergeAquaMobTable, "Mob list used in the merge system to spawn mobs." + mergeS);
        mergeAquaInfValues = cfg.getStringList("aquaMergeInfValues", category, mergeAquaInfValues, "Aqua Assimilated mob list with their values used in the merge system to spawn mobs." + mergeI);
    }

    public static void initVictim(Configuration cfg) {
        String category = "status_effects";
        cfg.addCustomCategoryComment(category, "Victim");
        hijackedVictim = cfg.getStringList("hijackedVictim", category, hijackedVictim, "Table that will be used for hijacking mobs.");
        cothVictim = cfg.getStringList("cothVictim", category, cothVictim, "Table that will be used for converting mobs, the Rupter will also be using this.");
    }

    public static void initTestLocationSRP(Configuration cfg) {
        String category = "srp_spawn_location_test";
        cfg.addCustomCategoryComment(category, "Dimension or biome test for a specific entity class.");
        locationTests = cfg.getStringList("Location Tests", category, locationTests, "(Works only with SRP Phase Spawn) Ex. \"srparasites:rupter;0,1,-1;ocean,minecraft:forest,!spooky;3\", Where: \n \"srparasites:rupter\" is the parasite for which the location check will be applied,\n \"0,1,-1\" are the dimensions where it can naturally spawn (\"all\" - any dimension),\n \"ocean,minecraft:forest,!spooky\" are the biomes and biome types where it can naturally appear (\"all\" - any biomes),\n \"3\" (Optional) is the phase after which the check will no longer apply.");
    }

    public static void initCompatibility(Configuration cfg) {
        String category = "compatibility";
        cfg.addCustomCategoryComment(category, "Compatibility Settings");
        nocubessrpnestsCompatibility = cfg.getBoolean("nocubessrpnestsCompatibility", category, nocubessrpnestsCompatibility, "Removes the spawn of Nest and Flesh Worm (If SRPExtra Structures on).");
        cotesiaCompatibility = cfg.getBoolean("cotesiaCompatibility", category, cotesiaCompatibility, "Cotesia Glomerata");
        cotesiaCompatibilityCostSettings = cfg.getStringList("cotesiaCompatibilityCostSettings", category, cotesiaCompatibilityCostSettings, "Biomass cost and bloom tier for each parasite. Most systems in this mod, specifically those revolving around factories, need parasites to be registered here.\nThe bloom tier is the base bloom level needed to create or salvage it.\nList a parasite as 'resourceLocation|tier|cost' without the quotes. 'srparasites:rupter|0|3' is a good example.\n'resourceLocation|tier|cost|addedFuseTime' can be used to add more ticks to the construction time for a parasite in a factory.\nThis extra fuse time is unaffected by the Global Fuse Scalar.");
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        Main.configSystem = new Configuration(new File(event.getModConfigurationDirectory() + "/srpextra/SRPEConfigSystem.cfg"), "0.6.2");
        if (!Main.configSystem.getDefinedConfigVersion().equals(Main.configSystem.getLoadedConfigVersion()) && Main.configSystem.getConfigFile().exists() && Main.configSystem.getConfigFile().delete()) {
            SRPEConfigSystem.error("!!!Config System Rewrite!!!", 3);
        }
        SRPEConfigSystem.readConfig(Main.configSystem);
    }

    public static void error(String errorXp, int i) {
        while (--i > 0) {
            System.out.println(errorXp);
        }
    }

    public static void readConfig(Configuration config) {
        try {
            config.load();
            SRPEConfigSystem.initMainSettings(config);
            SRPEConfigSystem.initPhase(config);
            SRPEConfigSystem.initMergeSystem(config);
            SRPEConfigSystem.initVictim(config);
            SRPEConfigSystem.initCompatibility(config);
            SRPEConfigSystem.initTestLocationSRP(config);
        }
        catch (Exception var5) {
            SRPEConfigSystem.error("!!!Config System Error!!!", 5);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

