/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.encyclopedia.data;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.encyclopedia.stats.EStatsType;
import energon.srpextra.encyclopedia.stats.IStatsBase;
import energon.srpextra.encyclopedia.stats.StatsAttributes;
import energon.srpextra.encyclopedia.stats.StatsCanSpawn;
import energon.srpextra.encyclopedia.stats.StatsLootTable;
import energon.srpextra.encyclopedia.stats.StatsMobInside;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.util.EParasiteType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class ParasiteDataBase {
    public List<IStatsBase> STATES = new ArrayList<IStatsBase>();
    public final EntityEntry entityEntry;
    public final int parasiteId;
    public final EParasiteType entityType;
    public final IESpawnRule spawnRule;

    public ParasiteDataBase(EntityEntry entityEntry, int id, EParasiteType type, IESpawnRule spawnRule) {
        this.entityEntry = entityEntry;
        this.parasiteId = id;
        this.entityType = type;
        this.spawnRule = spawnRule;
    }

    public int getParasiteId() {
        return this.parasiteId;
    }

    public ResourceLocation getRegistryName() {
        return this.entityEntry.getRegistryName();
    }

    public String getName() {
        return this.entityEntry.getName();
    }

    public String getTranslatedName() {
        return I18n.func_74838_a((String)this.getName());
    }

    public Class<? extends Entity> getEntityClass() {
        return this.entityEntry.getEntityClass();
    }

    public Entity getEntity(World world) {
        return this.entityEntry.newInstance(world);
    }

    @Nullable
    public IStatsBase getStatsByType(EStatsType type) {
        for (IStatsBase stats : this.STATES) {
            if (stats.getStateType() != type) continue;
            return stats;
        }
        return null;
    }

    public int getCountNaturalTransformForPhaseSpawn() {
        IStatsBase rule = this.getStatsByType(EStatsType.CAN_SPAWN);
        if (rule != null) {
            return ((StatsCanSpawn)rule).transformCountForNaturalSpawn();
        }
        return -1;
    }

    public byte getTransformDataID() {
        IStatsBase rule = this.getStatsByType(EStatsType.CAN_SPAWN);
        if (rule != null) {
            Byte trID = ((StatsCanSpawn)rule).getTransformEntityID();
            return trID != null ? trID : (byte)this.parasiteId;
        }
        return (byte)this.parasiteId;
    }

    public void spawnMobInside(EntityLivingBase summoner) {
        IStatsBase stats = this.getStatsByType(EStatsType.MOB_INSIDE);
        if (stats != null) {
            ((StatsMobInside)stats).spawnMobInside(summoner, this);
        }
    }

    public void spawnDeathLoot(EntityLivingBase summoner) {
        IStatsBase stats = this.getStatsByType(EStatsType.LOOT_TABLE);
        if (stats != null) {
            ((StatsLootTable)stats).spawnLootTable(summoner, this);
        }
    }

    public void addBaseAttributes(EntityLivingBase entity) {
        IStatsBase stats = this.getStatsByType(EStatsType.ATTRIBUTES);
        if (stats != null) {
            ((StatsAttributes)stats).config.addBaseAttributes(entity);
        } else {
            entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(5.0f * SRPConfig.globalDamageMultiplier));
            entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(1.0f * SRPConfig.globalArmorMultiplier));
            entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(1.0);
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.3 * (double)SRPConfig.globalKDResistanceMultiplier);
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(15.0f * SRPConfig.globalHealthMultiplier));
        }
    }
}

