/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity.feral;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIGetFollowers;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPlayer;
import com.dhanantry.scapeandrunparasites.util.SRPReference;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import energon.srpextra.config.SRPEConfigMobs;
import energon.srpextra.entity.ai.SRPEAI_Swimming;
import energon.srpextra.entity.feral.SRPEPFeral;
import energon.srpextra.init.SRPEItems;
import energon.srpextra.util.SRPEAttributes;
import energon.srpextra.util.Utilities;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFerPlayer
extends SRPEPFeral {
    public byte skillID = 0;
    public float skillProgress = 1.0f;
    public float animationProgressPRE = 1.0f;
    public boolean performAttack = false;
    public boolean newMob = true;

    public EntityFerPlayer(World worldIn) {
        super(worldIn);
    }

    public int canSpawnByIDData() {
        return SRPConfigMobs.infhumanCanSpawnAssimilatedNat;
    }

    public int getIDSpawn() {
        return 40;
    }

    public int getParasiteIDRegister() {
        return -137;
    }

    @Override
    public byte spawnRuleID() {
        return 2;
    }

    public void func_82149_j(Entity pre) {
        super.func_82149_j(pre);
        if (this.newMob && pre instanceof EntityInfPlayer) {
            this.newMob = false;
            EntityInfPlayer player = (EntityInfPlayer)pre;
            this.func_184201_a(EntityEquipmentSlot.HEAD, player.func_184582_a(EntityEquipmentSlot.HEAD));
            this.func_184201_a(EntityEquipmentSlot.LEGS, player.func_184582_a(EntityEquipmentSlot.LEGS));
            this.func_184201_a(EntityEquipmentSlot.FEET, player.func_184582_a(EntityEquipmentSlot.FEET));
            if (player.func_145818_k_()) {
                this.func_96094_a(player.func_95999_t());
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance p_onInitialSpawn_1_, @Nullable IEntityLivingData p_onInitialSpawn_2_) {
        if (this.newMob) {
            SRPReference.setSimPlayerName((EntityParasiteBase)this);
        }
        return super.func_180482_a(p_onInitialSpawn_1_, p_onInitialSpawn_2_);
    }

    @Override
    public EntityParasiteBase getPreVersion() {
        return SRPConfigMobs.infadventurerEnabled ? new EntityInfPlayer(this.field_70170_p) : null;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SRPEAI_Swimming((EntityMob)this, 0.25, 0.1f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatus((EntityParasiteBase)this, 1.5, false, 0.0){

            protected void checkAndPerformAttack(EntityLivingBase target, double distance) {
                double d0 = this.getAttackReachSqr(target);
                if (!this.isTargetParasite(target) && distance <= d0 && this.attackTick <= 0 && this.attacker.func_70685_l((Entity)target)) {
                    this.attackTick = 15;
                    EntityFerPlayer.this.attack();
                }
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIGetFollowers((EntityParasiteBase)this, 1, 16));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)SRPEConfigMobs.followRangeFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)SRPEConfigMobs.movementSpeedFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPEAttributes.damageFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPEAttributes.armorFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)SRPEConfigMobs.armorToughnessFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(SRPEAttributes.KBFeralPlayer);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPEAttributes.healthFeralPlayer);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.animationProgressPRE = this.skillProgress;
        }
        if (this.skillProgress != 1.0f) {
            this.skillProgressHandler();
        } else if (this.skillID != 0) {
            this.skillID = 0;
            this.performAttack = false;
        }
    }

    public void skillProgressHandler() {
        switch (this.skillID) {
            case 101: {
                this.skillProgress = Math.min(this.skillProgress + 0.08f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.5f)) break;
                this.performAttack = false;
                EntityLivingBase target = this.func_70638_az();
                if (target == null || !(target.func_70068_e((Entity)this) < 12.0) || !this.func_70685_l((Entity)target)) break;
                this.func_70652_k((Entity)target);
                break;
            }
            case 102: {
                this.skillProgress = Math.min(this.skillProgress + 0.06f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.7f)) break;
                this.performAttack = false;
                EntityLivingBase target = this.func_70638_az();
                if (target == null || !(target.func_70068_e((Entity)this) < 12.0) || !this.func_70685_l((Entity)target)) break;
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * (double)1.4f));
                break;
            }
            default: {
                this.skillProgress = Math.min(this.skillProgress + 0.05f, 1.0f);
            }
        }
    }

    public void attack() {
        int random = this.field_70146_Z.nextInt(6);
        if (random == 5) {
            this.changeSkill((byte)102, false);
            return;
        }
        this.changeSkill((byte)101, false);
    }

    public boolean changeSkill(byte id, boolean ignore) {
        if (this.skillID == 0 || ignore) {
            this.skillID = id;
            this.skillProgress = 0.0f;
            this.performAttack = true;
            this.field_70170_p.func_72960_a((Entity)this, id);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 101: 
            case 102: {
                this.skillID = id;
                this.skillProgress = 0.0f;
                this.animationProgressPRE = 0.0f;
                return;
            }
        }
        super.func_70103_a(id);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkillProgress(float partial) {
        return this.skillProgress == 1.0f ? 1.0f : this.animationProgressPRE + (this.skillProgress - this.animationProgressPRE) * partial;
    }

    @Override
    public void spawnMobInside() {
        Utilities.summonMinionsListVelocityOffset(this.field_70170_p, (Entity)this, 1.0f, SRPEConfigMobs.listSpawnMinionsFeralPlayer, SRPEConfigMobs.minionEffectFeralPlayer, false, SRPEConfigMobs.minionsSpawnDistanceEntityFeralPlayer, false, this.field_70146_Z, SRPEConfigMobs.minionsVelocityXZFeralPlayer, SRPEConfigMobs.minionsVelocityYFeralPlayer, SRPEConfigMobs.minionsVelocityXZFeralPlayer);
    }

    @Override
    public void spawnDeathLoot() {
        Utilities.ADVANCEDLootEntityDeathDrop((EntityParasiteBase)this, SRPEConfigMobs.lootTableFeralPlayerADVANCED, 100, false, this.field_70146_Z);
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        return new ItemStack(SRPEItems.itemmobspawner_ferplayer);
    }
}

