/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.init;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.config.ParasiteBaseConfig;
import energon.srpextra.config.SRPEConfigMobs;
import energon.srpextra.encyclopedia.ParasitesDataHandler;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.encyclopedia.stats.StatsAttributes;
import energon.srpextra.encyclopedia.stats.StatsLootTable;
import energon.srpextra.encyclopedia.stats.StatsMobInside;
import energon.srpextra.encyclopedia.stats.StatsPhaseSpawnList;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.entity.adapted.EntityIkiAdapted_SRPE;
import energon.srpextra.entity.adapted.EntityMikuAdapted;
import energon.srpextra.entity.adapted.EntityWymoAdapted;
import energon.srpextra.entity.crude.EntityFog;
import energon.srpextra.entity.crude.EntityLeshAqua;
import energon.srpextra.entity.feral.EntityFerOcelot;
import energon.srpextra.entity.feral.EntityFerPlayer;
import energon.srpextra.entity.feral.EntityFerWitch;
import energon.srpextra.entity.feral.EntityFerWolf_SRPE;
import energon.srpextra.entity.head.EntityHiCreeperHead;
import energon.srpextra.entity.head.EntityHiSkeletonHead;
import energon.srpextra.entity.head.EntityInfOcelotHead;
import energon.srpextra.entity.head.EntityInfVindicatorHead;
import energon.srpextra.entity.head.EntityInfWitchHead;
import energon.srpextra.entity.hijacked.EntityHiCreeper;
import energon.srpextra.entity.hijacked.EntityHiSkeleton_SRPE;
import energon.srpextra.entity.hijacked.EntityHiStray;
import energon.srpextra.entity.infected.EntityInfEvoker;
import energon.srpextra.entity.infected.EntityInfOcelot;
import energon.srpextra.entity.infected.EntityInfVindicator;
import energon.srpextra.entity.infected.EntityInfWitch;
import energon.srpextra.entity.primitive.EntityMiku;
import energon.srpextra.entity.tendril.EntityTendrilMiku;
import energon.srpextra.entity.tendril.EntityTendrilWymo;
import energon.srpextra.entity.tile.EntityGoreAqua;
import energon.srpextra.entity.tile.EntityRemainAqua;
import energon.srpextra.entity.tile.ParasiteFangs;
import energon.srpextra.util.EParasiteType;
import energon.srpextra.util.preset.SRPEEntitySpawnRules;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SRPEEntities {
    public static EntityEntry[] SRPExtraENTITIES;

    private static <T extends Entity> EntityEntry CreateEntityMob(String name, Class<T> cls, int id, boolean active, EParasiteType type, IESpawnRule spawnRule) {
        if (!active) {
            return null;
        }
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("srpextra." + name);
        builder.id(new ResourceLocation("srparasites", name), id);
        builder.tracker(64, 3, true);
        if (SRPConfig.vanillaEggs) {
            builder.egg(8611072, 16711900);
        }
        EntityEntry entry = builder.build();
        ParasiteDataBase data = new ParasiteDataBase(entry, -id, type, spawnRule);
        data.STATES.add(new StatsPhaseSpawnList());
        ParasitesDataHandler.PARASITES.add(data);
        return entry;
    }

    private static <T extends Entity> EntityEntry CreateEntityMob(String name, Class<T> cls, int id, ParasiteBaseConfig config, EParasiteType type, IESpawnRule spawnRule) {
        if (!config.active) {
            return null;
        }
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("srpextra." + name);
        builder.id(new ResourceLocation("srparasites", name), id);
        builder.tracker(64, 3, true);
        if (SRPConfig.vanillaEggs) {
            builder.egg(8611072, 16711900);
        }
        EntityEntry entry = builder.build();
        ParasiteDataBase data = new ParasiteDataBase(entry, -id, type, spawnRule);
        data.STATES.add(new StatsAttributes(config));
        data.STATES.add(new StatsLootTable());
        data.STATES.add(new StatsMobInside());
        data.STATES.add(new StatsPhaseSpawnList());
        ParasitesDataHandler.PARASITES.add(data);
        return entry;
    }

    private static <T extends Entity> EntityEntry CreateEntityProjectile(String name, Class<T> cls, int moid) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("srpextra." + name);
        builder.id(new ResourceLocation("srparasites", name), moid);
        builder.tracker(64, 3, true);
        return builder.build();
    }

    @Mod.EventBusSubscriber(modid="srpextra")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<EntityEntry> event) {
            IForgeRegistry registry = event.getRegistry();
            SRPExtraENTITIES = new EntityEntry[]{SRPEEntities.CreateEntityMob("hi_creeper", EntityHiCreeper.class, 1, SRPEConfigMobs.HijackedCreeperConfig, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("pri_stalker", EntityMiku.class, 129, SRPEConfigMobs.activeStalker, EParasiteType.PRIMITIVE, SRPEEntitySpawnRules.RULE_THREE), SRPEEntities.CreateEntityMob("ada_stalker", EntityMikuAdapted.class, 130, SRPEConfigMobs.activeAdaptedStalker, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_THREE), SRPEEntities.CreateEntityMob("tendril_stalker", EntityTendrilMiku.class, 1130, SRPEConfigMobs.activeAdaptedStalker, EParasiteType.TENDRIL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("hi_creeperhead", EntityHiCreeperHead.class, 257, SRPEConfigMobs.activeHijackedCreeper_Head, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("hi_skeleton_srpe", EntityHiSkeleton_SRPE.class, 2, SRPEConfigMobs.activeHijackedSkeleton, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("hi_skeletonhead", EntityHiSkeletonHead.class, 258, SRPEConfigMobs.activeHijackedSkeleton_Head, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_witch", EntityInfWitch.class, 4, SRPEConfigMobs.activeAssimilatedWitch, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_witchhead", EntityInfWitchHead.class, 260, SRPEConfigMobs.activeAssimilatedWitch_Head, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("hi_stray", EntityHiStray.class, 3, SRPEConfigMobs.activeHijackedSkeleton_Stray, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_vindicator", EntityInfVindicator.class, 5, SRPEConfigMobs.activeAssimilatedVindicator, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_vindicatorhead", EntityInfVindicatorHead.class, 261, SRPEConfigMobs.activeAssimilatedVindicator_Head, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_evoker", EntityInfEvoker.class, 6, SRPEConfigMobs.activeAssimilatedEvoker, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityProjectile("parasite_fangs", ParasiteFangs.class, 1000), SRPEEntities.CreateEntityMob("sim_ocelot", EntityInfOcelot.class, 7, SRPEConfigMobs.activeAssimilatedOcelot, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("sim_ocelothead", EntityInfOcelotHead.class, 263, SRPEConfigMobs.activeAssimilatedOcelot_Head, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("fer_wolf_srpe", EntityFerWolf_SRPE.class, 133, SRPEConfigMobs.activeFeralWolf, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("ada_vermin", EntityIkiAdapted_SRPE.class, 131, SRPEConfigMobs.activeAdaptedIki, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_THREE), SRPEEntities.CreateEntityMob("ada_tozoon", EntityWymoAdapted.class, 132, SRPEConfigMobs.activeAdaptedWymo, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_FOUR), SRPEEntities.CreateEntityMob("tendril_tozoon", EntityTendrilWymo.class, 1132, SRPEConfigMobs.activeAdaptedWymo, EParasiteType.TENDRIL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("wendigo", EntityFog.class, 8, SRPEConfigMobs.activeWendigo, EParasiteType.CRUDE, SRPEEntitySpawnRules.RULE_THREE), SRPEEntities.CreateEntityMob("swimming_flesh", EntityLeshAqua.class, 134, SRPEConfigMobs.activeLeshAqua, EParasiteType.CRUDE, SRPEEntitySpawnRules.RULE_AQUA_TWO), SRPEEntities.CreateEntityMob("fer_witch", EntityFerWitch.class, 516, SRPEConfigMobs.activeFeralWitch, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("fer_ocelot", EntityFerOcelot.class, 519, SRPEConfigMobs.activeFeralOcelot, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityMob("fer_adventurer", EntityFerPlayer.class, 137, SRPEConfigMobs.activeFeralPlayer, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO), SRPEEntities.CreateEntityProjectile("remain_aqua", EntityRemainAqua.class, 1001), SRPEEntities.CreateEntityProjectile("gore_aqua", EntityGoreAqua.class, 1002)};
            for (int i = 0; i < SRPExtraENTITIES.length; ++i) {
                if (SRPExtraENTITIES[i] == null) continue;
                registry.register((IForgeRegistryEntry)SRPExtraENTITIES[i]);
            }
        }
    }
}

