/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.init;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import energon.srpextra.config.SRPEConfigSystem;
import energon.srpextra.entity.IGetESpawnRuleID;
import energon.srpextra.util.Utilities;
import energon.srpextra.util.preset.SRPEEntitySpawnRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.ArrayUtils;

public class SRPEPhases {
    public static String[] zero = new String[0];
    public static String[] one = new String[0];
    public static String[] two = new String[0];
    public static String[] three = new String[0];
    public static String[] four = new String[0];
    public static String[] five = new String[0];
    public static String[] six = new String[0];
    public static String[] seven = new String[0];
    public static String[] eight = new String[0];
    public static String[] nine = new String[0];
    public static String[] ten = new String[0];
    public static List<PhaseUtilsKeys> PHASES = new ArrayList<PhaseUtilsKeys>();
    public static int[] DEFAULT_DIM = new int[]{0, -1, 1};

    public static void registerPhasesList() {
        if (SRPEConfigSystem.useSRPExtraEntitySpawn) {
            if (SRPEConfigSystem.addSRPPhaseSpawnList) {
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryZero, 0);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryOne, 1);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryTwo, 2);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryThree, 3);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryFour, 4);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryFive, 5);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntrySix, 6);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntrySeven, 7);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryEight, 8);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryNine, 9);
                SRPEPhases.utilRefSRPList(SRPConfigSystems.phaseSpawnEntryTen, 10);
            }
            if (SRPEConfigSystem.addSRPExtraPhaseSpawnList) {
                zero = (String[])ArrayUtils.addAll((Object[])zero, (Object[])SRPEConfigSystem.phaseZeroEntityList);
                one = (String[])ArrayUtils.addAll((Object[])one, (Object[])SRPEConfigSystem.phaseOneEntityList);
                two = (String[])ArrayUtils.addAll((Object[])two, (Object[])SRPEConfigSystem.phaseTwoEntityList);
                three = (String[])ArrayUtils.addAll((Object[])three, (Object[])SRPEConfigSystem.phaseThreeEntityList);
                four = (String[])ArrayUtils.addAll((Object[])four, (Object[])SRPEConfigSystem.phaseFourEntityList);
                five = (String[])ArrayUtils.addAll((Object[])five, (Object[])SRPEConfigSystem.phaseFiveEntityList);
                six = (String[])ArrayUtils.addAll((Object[])six, (Object[])SRPEConfigSystem.phaseSixEntityList);
                seven = (String[])ArrayUtils.addAll((Object[])seven, (Object[])SRPEConfigSystem.phaseSevenEntityList);
                eight = (String[])ArrayUtils.addAll((Object[])eight, (Object[])SRPEConfigSystem.phaseEightEntityList);
                nine = (String[])ArrayUtils.addAll((Object[])nine, (Object[])SRPEConfigSystem.phaseNineEntityList);
                ten = (String[])ArrayUtils.addAll((Object[])ten, (Object[])SRPEConfigSystem.phaseTenEntityList);
            }
        } else if (SRPEConfigSystem.SRPExtra && SRPEConfigSystem.addSRPExtraPhaseSpawnList) {
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseZeroEntityList, (byte)0);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseOneEntityList, (byte)1);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseTwoEntityList, (byte)2);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseThreeEntityList, (byte)3);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseFourEntityList, (byte)4);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseFiveEntityList, (byte)5);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseSixEntityList, (byte)6);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseSevenEntityList, (byte)7);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseEightEntityList, (byte)8);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseNineEntityList, (byte)9);
            SRPEPhases.addToSRPList(SRPEConfigSystem.phaseTenEntityList, (byte)10);
        }
    }

    public static void srpExtraLists() {
        SRPEPhases.handlerRegPhases(zero, (byte)0);
        SRPEPhases.handlerRegPhases(one, (byte)1);
        SRPEPhases.handlerRegPhases(two, (byte)2);
        SRPEPhases.handlerRegPhases(three, (byte)3);
        SRPEPhases.handlerRegPhases(four, (byte)4);
        SRPEPhases.handlerRegPhases(five, (byte)5);
        SRPEPhases.handlerRegPhases(six, (byte)6);
        SRPEPhases.handlerRegPhases(seven, (byte)7);
        SRPEPhases.handlerRegPhases(eight, (byte)8);
        SRPEPhases.handlerRegPhases(nine, (byte)9);
        SRPEPhases.handlerRegPhases(ten, (byte)10);
    }

    public static void autoSRPExtraAddons(String[] lists) {
        if (SRPEConfigSystem.addSRPExtraAddonsPhaseSpawnList) {
            for (String list : lists) {
                String[] parts = list.split(">");
                if (parts.length != 2) continue;
                if (SRPEConfigSystem.useSRPExtraEntitySpawn) {
                    SRPEPhases.addToSRPExtraList(parts[1].split("\\|"), Integer.parseInt(parts[0]));
                    continue;
                }
                if (!SRPEConfigSystem.SRPExtra) continue;
                SRPEPhases.addToSRPList(parts[1].split("\\|"), Byte.parseByte(parts[0]));
            }
        }
    }

    private static void utilRefSRPList(String[] elements, int phase) {
        for (String element : elements) {
            String[] parts = element.split(";");
            if (parts.length != 4) continue;
            SRPEPhases.addToSRPExtraList(parts[3] + ";" + parts[0] + ";" + parts[1] + ";" + parts[2], phase);
        }
    }

    public static void addToSRPExtraList(String addSpawn, int phase) {
        switch (phase) {
            case 0: {
                zero = (String[])ArrayUtils.add((Object[])zero, (Object)addSpawn);
                break;
            }
            case 1: {
                one = (String[])ArrayUtils.add((Object[])one, (Object)addSpawn);
                break;
            }
            case 2: {
                two = (String[])ArrayUtils.add((Object[])two, (Object)addSpawn);
                break;
            }
            case 3: {
                three = (String[])ArrayUtils.add((Object[])three, (Object)addSpawn);
                break;
            }
            case 4: {
                four = (String[])ArrayUtils.add((Object[])four, (Object)addSpawn);
                break;
            }
            case 5: {
                five = (String[])ArrayUtils.add((Object[])five, (Object)addSpawn);
                break;
            }
            case 6: {
                six = (String[])ArrayUtils.add((Object[])six, (Object)addSpawn);
                break;
            }
            case 7: {
                seven = (String[])ArrayUtils.add((Object[])seven, (Object)addSpawn);
                break;
            }
            case 8: {
                eight = (String[])ArrayUtils.add((Object[])eight, (Object)addSpawn);
                break;
            }
            case 9: {
                nine = (String[])ArrayUtils.add((Object[])nine, (Object)addSpawn);
                break;
            }
            case 10: {
                ten = (String[])ArrayUtils.add((Object[])ten, (Object)addSpawn);
            }
        }
    }

    public static void addToSRPExtraList(String[] addSpawn, int phase) {
        switch (phase) {
            case 0: {
                zero = (String[])ArrayUtils.addAll((Object[])zero, (Object[])addSpawn);
                break;
            }
            case 1: {
                one = (String[])ArrayUtils.addAll((Object[])one, (Object[])addSpawn);
                break;
            }
            case 2: {
                two = (String[])ArrayUtils.addAll((Object[])two, (Object[])addSpawn);
                break;
            }
            case 3: {
                three = (String[])ArrayUtils.addAll((Object[])three, (Object[])addSpawn);
                break;
            }
            case 4: {
                four = (String[])ArrayUtils.addAll((Object[])four, (Object[])addSpawn);
                break;
            }
            case 5: {
                five = (String[])ArrayUtils.addAll((Object[])five, (Object[])addSpawn);
                break;
            }
            case 6: {
                six = (String[])ArrayUtils.addAll((Object[])six, (Object[])addSpawn);
                break;
            }
            case 7: {
                seven = (String[])ArrayUtils.addAll((Object[])seven, (Object[])addSpawn);
                break;
            }
            case 8: {
                eight = (String[])ArrayUtils.addAll((Object[])eight, (Object[])addSpawn);
                break;
            }
            case 9: {
                nine = (String[])ArrayUtils.addAll((Object[])nine, (Object[])addSpawn);
                break;
            }
            case 10: {
                ten = (String[])ArrayUtils.addAll((Object[])ten, (Object[])addSpawn);
            }
        }
    }

    private static boolean checkWaterParasites(String parasite) {
        return SRPEEntitySpawnRules.DEFAULT_RULES.get(parasite) != null;
    }

    private static void addToSRPList(String[] list, byte phase) {
        block13: for (String phaseParts : list) {
            String[] parts = phaseParts.split(";");
            if (parts.length <= 3) continue;
            if (SRPEConfigSystem.SRPEPhaseSpawn && SRPEPhases.checkWaterParasites(parts[1])) {
                SRPEPhases.addToSRPExtraList(phaseParts, (int)phase);
                continue;
            }
            String addSpawn = parts[1] + ";" + parts[2] + ";" + parts[3] + ";" + parts[0];
            switch (phase) {
                case 0: {
                    SRPConfigSystems.phaseSpawnEntryZero = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryZero, (Object)addSpawn);
                    continue block13;
                }
                case 1: {
                    SRPConfigSystems.phaseSpawnEntryOne = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryOne, (Object)addSpawn);
                    continue block13;
                }
                case 2: {
                    SRPConfigSystems.phaseSpawnEntryTwo = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryTwo, (Object)addSpawn);
                    continue block13;
                }
                case 3: {
                    SRPConfigSystems.phaseSpawnEntryThree = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryThree, (Object)addSpawn);
                    continue block13;
                }
                case 4: {
                    SRPConfigSystems.phaseSpawnEntryFour = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryFour, (Object)addSpawn);
                    continue block13;
                }
                case 5: {
                    SRPConfigSystems.phaseSpawnEntryFive = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryFive, (Object)addSpawn);
                    continue block13;
                }
                case 6: {
                    SRPConfigSystems.phaseSpawnEntrySix = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntrySix, (Object)addSpawn);
                    continue block13;
                }
                case 7: {
                    SRPConfigSystems.phaseSpawnEntrySeven = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntrySeven, (Object)addSpawn);
                    continue block13;
                }
                case 8: {
                    SRPConfigSystems.phaseSpawnEntryEight = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryEight, (Object)addSpawn);
                    continue block13;
                }
                case 9: {
                    SRPConfigSystems.phaseSpawnEntryNine = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryNine, (Object)addSpawn);
                    continue block13;
                }
                case 10: {
                    SRPConfigSystems.phaseSpawnEntryTen = (String[])ArrayUtils.add((Object[])SRPConfigSystems.phaseSpawnEntryTen, (Object)addSpawn);
                }
            }
        }
    }

    public static void handlerRegPhases(String[] list, byte phase) {
        if (SRPEConfigSystem.SRPEPhaseSpawn && list.length != 0) {
            PHASES.addAll(SRPEPhases.generatePhaseList(list, phase));
        }
    }

    public static List<PhaseUtilsKeys> getKeys(byte p, Integer dimID) {
        ArrayList<PhaseUtilsKeys> searchKeys = new ArrayList<PhaseUtilsKeys>();
        for (PhaseUtilsKeys keys : PHASES) {
            if (keys.phase != p) continue;
            if (keys.dimension == null) {
                searchKeys.add(keys);
                continue;
            }
            if (keys.dimension != dimID) continue;
            searchKeys.add(keys);
        }
        return searchKeys;
    }

    public static List<PhaseUtilsKeys> getKeysAllLevels(byte p) {
        ArrayList<PhaseUtilsKeys> searchKeys = new ArrayList<PhaseUtilsKeys>();
        for (PhaseUtilsKeys keys : PHASES) {
            if (keys.phase != p) continue;
            searchKeys.add(keys);
        }
        return searchKeys;
    }

    public static CompactPhaseUtil getMathPhaseSpawnList(byte phase, Integer dimID) {
        ArrayList<PhaseUtilsValues> finalValues = new ArrayList<PhaseUtilsValues>();
        int finalWeight = 0;
        if (dimID == null) {
            for (PhaseUtilsKeys key : SRPEPhases.getKeysAllLevels(phase)) {
                finalValues.addAll(key.value);
                for (PhaseUtilsValues val : key.value) {
                    finalWeight += val.weight;
                }
            }
        } else {
            for (PhaseUtilsKeys key : SRPEPhases.getKeys(phase, dimID)) {
                finalValues.addAll(key.value);
                for (PhaseUtilsValues val : key.value) {
                    finalWeight += val.weight;
                }
            }
        }
        return new CompactPhaseUtil(finalValues, finalWeight);
    }

    public static boolean Validate(String entity) {
        Class mobClass = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        return mobClass == null || !EntityParasiteBase.class.isAssignableFrom(mobClass);
    }

    public static List<PhaseUtilsKeys> generatePhaseList(String[] list, byte sPhase) {
        ArrayList<PhaseUtilsKeys> phaseKeys = new ArrayList<PhaseUtilsKeys>();
        for (String element : list) {
            String[] stringArray;
            PhaseUtilsKeys phase;
            String[] parts = element.split(";");
            if (parts.length == 4) {
                if (SRPEPhases.Validate(parts[1]) || (phase = SRPEPhases.getUU(sPhase, null, phaseKeys, new PhaseUtilsValues(Integer.parseInt(parts[0]), parts[1], Integer.parseInt(parts[2]), Integer.parseInt(parts[3])))) == null) continue;
                phaseKeys.add(phase);
                continue;
            }
            if (parts.length <= 4 || SRPEPhases.Validate(parts[1])) continue;
            PhaseUtilsValues values = new PhaseUtilsValues(Integer.parseInt(parts[0]), parts[1], Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
            if (parts.length > 5) {
                values.addBiomes(parts[5]);
                if (parts.length > 6) {
                    for (String disParts : parts[6].split(",")) {
                        if (disParts.toLowerCase().contains("n")) {
                            values.distanceNode = Integer.parseInt(disParts.substring(1));
                            continue;
                        }
                        if (!disParts.toLowerCase().contains("c")) continue;
                        values.distanceColony = Integer.parseInt(disParts.substring(1));
                    }
                }
            }
            if (parts[4].equalsIgnoreCase("all")) {
                phase = SRPEPhases.getUU(sPhase, null, phaseKeys, values);
                if (phase == null) continue;
                phaseKeys.add(phase);
                continue;
            }
            if (parts[4].equalsIgnoreCase("default")) {
                for (int i : DEFAULT_DIM) {
                    phase = SRPEPhases.getUU(sPhase, i, phaseKeys, values);
                    if (phase == null) continue;
                    phaseKeys.add(phase);
                }
                continue;
            }
            for (String dim : stringArray = parts[4].split(",")) {
                phase = SRPEPhases.getUU(sPhase, Integer.parseInt(dim), phaseKeys, values);
                if (phase == null) continue;
                phaseKeys.add(phase);
            }
        }
        return phaseKeys;
    }

    public static List<PhaseUtilsKeys> SRPGeneratePhaseList(String[] list, byte sPhase) {
        ArrayList<PhaseUtilsKeys> phaseKeys = new ArrayList<PhaseUtilsKeys>();
        for (String element : list) {
            PhaseUtilsKeys phase;
            String[] parts = element.split(";");
            if (parts.length != 4 || SRPEPhases.Validate(parts[0]) || (phase = SRPEPhases.getUU(sPhase, null, phaseKeys, new PhaseUtilsValues(Integer.parseInt(parts[3]), parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2])))) == null) continue;
            phaseKeys.add(phase);
        }
        return phaseKeys;
    }

    public static PhaseUtilsKeys getUU(byte sPhase, Integer dim, List<PhaseUtilsKeys> keys, PhaseUtilsValues value) {
        for (PhaseUtilsKeys key : keys) {
            if (key.phase != sPhase || key.dimension != dim) continue;
            key.value.add(value);
            return null;
        }
        PhaseUtilsKeys ppp = new PhaseUtilsKeys(sPhase, dim);
        ppp.value.add(value);
        return ppp;
    }

    public static int addParasite(byte phase, Integer dim, PhaseUtilsValues value) {
        if (SRPEPhases.Validate(value.parasiteName)) {
            return 2;
        }
        for (PhaseUtilsKeys keys : PHASES) {
            if (keys.dimension != dim || keys.phase != phase) continue;
            keys.value.add(value);
            return 1;
        }
        return 0;
    }

    public static boolean removeParasite(byte phase, Integer dim, String name) {
        for (PhaseUtilsKeys keys : PHASES) {
            if (keys.dimension != dim || keys.phase != phase) continue;
            for (int i = 0; i < keys.value.size(); ++i) {
                PhaseUtilsValues values = keys.value.get(i);
                if (!values.parasiteName.equals(name)) continue;
                keys.value.remove(i);
                return true;
            }
        }
        return false;
    }

    public static boolean clearListParasites(byte phase, Integer dim) {
        for (PhaseUtilsKeys keys : PHASES) {
            if (keys.dimension != dim || keys.phase != phase) continue;
            keys.value.clear();
            return true;
        }
        return false;
    }

    public static class CompactPhaseUtil {
        public List<PhaseUtilsValues> values;
        public int totalWeight;

        public CompactPhaseUtil(List<PhaseUtilsValues> v, int tw) {
            this.values = v;
            this.totalWeight = tw;
        }

        @Nullable
        public PhaseUtilsValues getRandomValue(Random random) {
            int randomNumber = random.nextInt(this.totalWeight + 1);
            int test = 0;
            for (PhaseUtilsValues value : this.values) {
                if ((test += value.weight) <= randomNumber) continue;
                return value;
            }
            return null;
        }

        public String toString() {
            return "WEIGHT: " + this.totalWeight + "  VALUES: " + this.values;
        }
    }

    public static class PhaseUtilsKeys {
        public byte phase;
        public Integer dimension = null;
        public List<PhaseUtilsValues> value = new ArrayList<PhaseUtilsValues>();

        public PhaseUtilsKeys(byte p, Integer dim) {
            this.phase = p;
            this.dimension = dim;
        }

        public String toString() {
            return this.dimension.toString();
        }
    }

    public static class PhaseUtilsValues {
        public int weight;
        public String parasiteName;
        public int min;
        public int max;
        public Integer distanceNode = null;
        public Integer distanceColony = null;
        public String[] biomes = null;
        public boolean BLB = true;
        public Byte spawnRuleID = null;

        public PhaseUtilsValues(int w, String name, int mn, int mx) {
            this.weight = w;
            this.parasiteName = name;
            this.min = mn;
            this.max = mx;
        }

        public void generateSpawnRuleID(World world) {
            if (SRPEEntitySpawnRules.DEFAULT_RULES.get(this.parasiteName) != null) {
                this.spawnRuleID = SRPEEntitySpawnRules.DEFAULT_RULES.get(this.parasiteName);
                return;
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.parasiteName), (World)world);
            if (entity instanceof IGetESpawnRuleID) {
                this.spawnRuleID = ((IGetESpawnRuleID)entity).spawnRuleID();
            } else if (entity != null) {
                AxisAlignedBB box = entity.func_174813_aQ();
                this.spawnRuleID = box.field_72337_e < 1.0 && box.field_72336_d < 1.0 ? Byte.valueOf((byte)1) : (box.field_72337_e < 2.0 && box.field_72336_d < 1.0 ? Byte.valueOf((byte)2) : (box.field_72337_e < 3.0 && box.field_72336_d < 1.0 ? Byte.valueOf((byte)3) : (box.field_72337_e < 4.0 && box.field_72336_d < 1.0 ? Byte.valueOf((byte)4) : Byte.valueOf((byte)3))));
            }
        }

        public void addBiomes(String biomeUtil) {
            if (!biomeUtil.equalsIgnoreCase("all")) {
                for (String test : this.biomes = biomeUtil.split(",")) {
                    if (test.charAt(0) == '!') continue;
                    this.BLB = false;
                    return;
                }
            }
        }

        public boolean distanceWCheck(World world, BlockPos pos) {
            int d2;
            int d1;
            int i;
            SRPWorldData data;
            if (this.distanceNode != null) {
                data = SRPWorldData.get((World)world);
                for (i = 0; i < data.getNodes("x").size(); ++i) {
                    d1 = (Integer)data.getNodes("x").get(i) - pos.func_177958_n();
                    if (d1 * d1 + (d2 = (Integer)data.getNodes("z").get(i) - pos.func_177952_p()) * d2 <= this.distanceNode * this.distanceNode) continue;
                    return false;
                }
            }
            if (this.distanceColony != null) {
                data = SRPWorldData.get((World)world);
                for (i = 0; i < data.getColonies("x").size(); ++i) {
                    d1 = (Integer)data.getColonies("x").get(i) - pos.func_177958_n();
                    if (d1 * d1 + (d2 = (Integer)data.getColonies("z").get(i) - pos.func_177952_p()) * d2 <= this.distanceColony * this.distanceColony) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean biomeCheck(World world, BlockPos pos) {
            if (this.biomes == null || this.biomes.length == 0) {
                return true;
            }
            Biome biomeCheck = world.func_180494_b(pos);
            if (biomeCheck.getRegistryName() == null) {
                return false;
            }
            String biomeCheckName = biomeCheck.getRegistryName().toString();
            boolean test = this.BLB;
            for (String partsB : this.biomes) {
                boolean cc = biomeCheckName.equals(partsB.toLowerCase().replace("!", ""));
                boolean cc2 = Utilities.checkBiomeType(biomeCheck, partsB.replace("!", ""));
                if (partsB.charAt(0) == '!') {
                    if (!(partsB.contains(":") ? cc : cc2)) continue;
                    return false;
                }
                if (partsB.contains(":")) {
                    if (!cc || test) continue;
                    test = true;
                    continue;
                }
                if (!cc2 || test) continue;
                test = true;
            }
            return test;
        }

        public String toString() {
            StringBuilder message = new StringBuilder();
            message.append(this.parasiteName).append("*(").append(this.min).append("-").append(this.max).append("):").append(this.weight);
            if (this.biomes != null) {
                message.append("\n      biomes: ").append(Arrays.toString(this.biomes));
            }
            if (this.distanceNode != null) {
                message.append("\n      node distance: ").append(this.distanceNode);
            }
            if (this.distanceColony != null) {
                message.append("   colony distance: ").append(this.distanceColony);
            }
            return message.toString();
        }
    }

    public static class ADVANCED_PhaseUtilsValues
    extends PhaseUtilsValues {
        public String[] effect_list;
        public String death_loot;
        public String[] itemInHand;

        public ADVANCED_PhaseUtilsValues(int weight, String parasiteName, int min, int max, String[] ef, String death_l, String[] items_hand) {
            super(weight, parasiteName, min, max);
            this.effect_list = ef;
            this.death_loot = death_l;
            this.itemInHand = items_hand;
        }
    }
}

