/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.network;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanSpawn;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSpawning;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.Main;
import energon.srpextra.entity.ISRPExtraEntity;
import energon.srpextra.init.SRPEPhases;
import energon.srpextra.util.SRPEWorldSpawnMob;
import energon.srpextra.util.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SRPExtraCommand
extends CommandBase {
    public String func_71517_b() {
        return "srpextra";
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "srpextra <text>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, "srpextra");
    }

    public static String fun(char l, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, l);
        return new String(chars);
    }

    public void func_184881_a(MinecraftServer minecraftServer, ICommandSender iCommandSender, String[] strings) throws CommandException {
        if (strings.length == 0) {
            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("------------------------\n> info - Displays all information about the parasite.\n> test - checks whether the parasite can naturally spawn in a specific area.\n> phase_list - displays the list (SRP + SRPE) of parasites that will naturally spawn. Available parameters: <phase> <dim_id>\n> phase_srp - a section that interacts only with SRP data.\n> phase_srpe - a section that interacts only with SRPE data.\n------------------------"));
            return;
        }
        switch (strings[0]) {
            case "info": {
                if (strings.length == 2) {
                    Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(strings[1]), (World)iCommandSender.func_130014_f_());
                    if (entity instanceof EntityParasiteBase) {
                        EntityParasiteBase parasiteBase = (EntityParasiteBase)entity;
                        StringBuilder builder = new StringBuilder();
                        builder.append("> ").append(entity.func_145748_c_().func_150260_c()).append("    ID: ").append(parasiteBase.getParasiteIDRegister());
                        if (entity instanceof ISRPExtraEntity) {
                            builder.append("     (SRPExtra Parasite)");
                        }
                        builder.append("\n> ").append(Utilities.getStrParasiteType(parasiteBase));
                        builder.append("\n> Health: ").append(String.format("%.2f", Float.valueOf(parasiteBase.func_110138_aP()))).append("   Follow Range: ").append(String.format("%.2f", parasiteBase.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b()));
                        builder.append("\n> Move Speed: ").append(String.format("%.2f", parasiteBase.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b())).append("   Knockback Resistance: ").append(String.format("%.2f", parasiteBase.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b()));
                        builder.append("\n> Armor: ").append(String.format("%.2f", parasiteBase.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b())).append("   Armor Toughness: ").append(String.format("%.2f", parasiteBase.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111125_b()));
                        builder.append("\n> Rules:");
                        if (entity instanceof EntityCanSpawn) {
                            EntityCanSpawn canSpawn = (EntityCanSpawn)entity;
                            builder.append("\n> Required Assimilation Count: ").append(canSpawn.canSpawnByIDData()).append("   Has: ").append(SRPSaveData.get((World)iCommandSender.func_130014_f_()).getNumberIDDataSpawn(canSpawn.getIDSpawn()));
                        }
                        String ttt = SRPExtraCommand.fun('-', 40);
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString(ttt + "\n" + builder.toString() + "\n" + ttt));
                    } else {
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Invalid type: not a subclass of EntityParasiteBase."));
                    }
                } else {
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<name>"));
                }
                return;
            }
            case "test": {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The command is not available yet."));
                return;
            }
            case "phase_list": {
                if (strings.length > 1) {
                    byte phase = Byte.parseByte(strings[1]);
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<<<<<SRP<<<<<" + SRPExtraCommand.getPhaseList(phase) + "\n>>>>>>>>>>>>>>"));
                    SRPEPhases.CompactPhaseUtil compact = SRPEPhases.getMathPhaseSpawnList(phase, strings.length == 3 ? Integer.valueOf(Integer.parseInt(strings[2])) : null);
                    StringBuilder text = new StringBuilder("<<<<<SRPE<<<<");
                    for (SRPEPhases.PhaseUtilsValues value : compact.values) {
                        text.append("\n  ").append(value.parasiteName).append("*(").append(value.min).append("-").append(value.max).append("):").append(value.weight);
                    }
                    text.append("\n>>>>>>>>>>>>>>");
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString(text.toString()));
                } else {
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<<<<<SRP<<<<<\nPhase 0:" + SRPExtraCommand.getPhaseList((byte)0) + "\nPhase 1:" + SRPExtraCommand.getPhaseList((byte)1) + "\nPhase 2:" + SRPExtraCommand.getPhaseList((byte)2) + "\nPhase 3:" + SRPExtraCommand.getPhaseList((byte)3) + "\nPhase 4:" + SRPExtraCommand.getPhaseList((byte)4) + "\nPhase 5:" + SRPExtraCommand.getPhaseList((byte)5) + "\nPhase 6:" + SRPExtraCommand.getPhaseList((byte)6) + "\nPhase 7:" + SRPExtraCommand.getPhaseList((byte)7) + "\nPhase 8:" + SRPExtraCommand.getPhaseList((byte)8) + "\nPhase 9:" + SRPExtraCommand.getPhaseList((byte)9) + "\nPhase 10:" + SRPExtraCommand.getPhaseList((byte)10) + "\n>>>>>>>>>>>>>>"));
                    StringBuilder text = new StringBuilder("<<<<<SRPE<<<<");
                    for (byte pp = 0; pp < 11; pp = (byte)(pp + 1)) {
                        SRPEPhases.CompactPhaseUtil compact = SRPEPhases.getMathPhaseSpawnList(pp, null);
                        text.append("\nPHASE ").append(pp).append(":");
                        for (SRPEPhases.PhaseUtilsValues value : compact.values) {
                            text.append("\n  ").append(value.parasiteName).append("*(").append(value.min).append("-").append(value.max).append("):").append(value.weight);
                        }
                    }
                    text.append("\n>>>>>>>>>>>>>>");
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString(text.toString()));
                }
                return;
            }
            case "phase_srp": {
                switch (strings[1]) {
                    case "spawn_status": {
                        if (SRPConfigSystems.phaseCustomSpawner) {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRP Phase Spawn is enabled."));
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRP Phase Spawn is disabled."));
                        }
                        return;
                    }
                    case "spawn_off": {
                        SRPConfigSystems.phaseCustomSpawner = false;
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRP Phase Spawn is disabled."));
                        return;
                    }
                    case "spawn_on": {
                        SRPConfigSystems.phaseCustomSpawner = true;
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRP Phase Spawn is enabled."));
                        return;
                    }
                    case "list_info": {
                        if (strings.length == 3) {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<<<<<SRP<<<<<" + SRPExtraCommand.getPhaseList(Byte.parseByte(strings[2])) + "\n>>>>>>>>>>>>>>"));
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<<<<<SRP<<<<<\nPhase 0:" + SRPExtraCommand.getPhaseList((byte)0) + "\nPhase 1:" + SRPExtraCommand.getPhaseList((byte)1) + "\nPhase 2:" + SRPExtraCommand.getPhaseList((byte)2) + "\nPhase 3:" + SRPExtraCommand.getPhaseList((byte)3) + "\nPhase 4:" + SRPExtraCommand.getPhaseList((byte)4) + "\nPhase 5:" + SRPExtraCommand.getPhaseList((byte)5) + "\nPhase 6:" + SRPExtraCommand.getPhaseList((byte)6) + "\nPhase 7:" + SRPExtraCommand.getPhaseList((byte)7) + "\nPhase 8:" + SRPExtraCommand.getPhaseList((byte)8) + "\nPhase 9:" + SRPExtraCommand.getPhaseList((byte)9) + "\nPhase 10:" + SRPExtraCommand.getPhaseList((byte)10) + "\n>>>>>>>>>>>>>>"));
                        }
                        return;
                    }
                    case "list_add": {
                        if (strings.length == 7) {
                            Class testEntity = EntityList.getClass((ResourceLocation)new ResourceLocation(strings[3]));
                            if (testEntity != null && EntityParasiteBase.class.isAssignableFrom(testEntity)) {
                                SRPSpawning.getSpawns((byte)Byte.parseByte(strings[2])).add(new Biome.SpawnListEntry(testEntity, Integer.parseInt(strings[6]), Integer.parseInt(strings[4]), Integer.parseInt(strings[5])));
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString(testEntity.getSimpleName() + " added."));
                            } else {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The parasite with this name does not exist."));
                            }
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<phase> <name> <min> <max> <weight>"));
                        }
                        return;
                    }
                    case "list_remove": {
                        if (strings.length == 4) {
                            List link = SRPSpawning.getSpawns((byte)Byte.parseByte(strings[2]));
                            if (link.isEmpty()) {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The phase list is empty."));
                                return;
                            }
                            Class testEntity = EntityList.getClass((ResourceLocation)new ResourceLocation(strings[3]));
                            if (testEntity == null) {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The entity with this name does not exist"));
                                return;
                            }
                            for (int i = 0; i < link.size(); ++i) {
                                Biome.SpawnListEntry util = (Biome.SpawnListEntry)link.get(i);
                                if (util.field_76300_b != testEntity) continue;
                                link.remove(i);
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString(testEntity.getSimpleName() + " removed."));
                                return;
                            }
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The entity is not in the list."));
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<phase> <name>"));
                        }
                        return;
                    }
                    case "list_clear": {
                        if (strings.length == 3) {
                            SRPSpawning.getSpawns((byte)Byte.parseByte(strings[2])).clear();
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The list has been cleared."));
                        } else {
                            for (byte pp = 0; pp < 11; pp = (byte)(pp + 1)) {
                                SRPSpawning.getSpawns((byte)pp).clear();
                            }
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("All lists have been cleared."));
                        }
                        return;
                    }
                }
                return;
            }
            case "phase_srpe": {
                switch (strings[1]) {
                    case "spawn_debug": {
                        if (strings.length == 3) {
                            SRPEWorldSpawnMob.DEBUG = Boolean.parseBoolean(strings[2]);
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<boolean>"));
                        }
                        if (SRPEWorldSpawnMob.DEBUG) {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Debug is enabled."));
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Debug is disabled."));
                        }
                        return;
                    }
                    case "spawn_status": {
                        if (SRPEWorldSpawnMob.ENABLE) {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRPE Phase Spawn is enabled."));
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRPE Phase Spawn is disabled."));
                        }
                        return;
                    }
                    case "spawn_off": {
                        SRPEWorldSpawnMob.ENABLE = false;
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRPE Phase Spawn is disabled."));
                        return;
                    }
                    case "spawn_on": {
                        SRPEWorldSpawnMob.ENABLE = true;
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("SRPE Phase Spawn is enabled."));
                        return;
                    }
                    case "list_info": {
                        StringBuilder text = new StringBuilder("<<<<<SRPE<<<<");
                        if (strings.length == 4) {
                            Integer dimID = Integer.parseInt(strings[3]);
                            byte phase = Byte.parseByte(strings[2]);
                            for (SRPEPhases.PhaseUtilsKeys keys : SRPEPhases.PHASES) {
                                if (keys.phase != phase || keys.dimension != dimID) continue;
                                text.append("\nDimension ").append(dimID).append(", Phase ").append(phase).append(":");
                                for (SRPEPhases.PhaseUtilsValues value : keys.value) {
                                    text.append("\n  ").append(value.toString());
                                }
                            }
                        } else if (strings.length == 3) {
                            byte phase = Byte.parseByte(strings[2]);
                            for (SRPEPhases.PhaseUtilsKeys keys : SRPEPhases.PHASES) {
                                if (keys.phase != phase) continue;
                                text.append("\nDimension ").append(keys.dimension).append(", Phase ").append(phase).append(":");
                                for (SRPEPhases.PhaseUtilsValues value : keys.value) {
                                    text.append("\n  ").append(value.toString());
                                }
                            }
                        } else {
                            for (SRPEPhases.PhaseUtilsKeys keys : SRPEPhases.PHASES) {
                                text.append("\nDimension ").append(keys.dimension).append(", Phase ").append(keys.phase).append(":");
                                for (SRPEPhases.PhaseUtilsValues value : keys.value) {
                                    text.append("\n  ").append(value.toString());
                                }
                            }
                        }
                        text.append("\n>>>>>>>>>>>>>>");
                        iCommandSender.func_145747_a((ITextComponent)new TextComponentString(text.toString()));
                        return;
                    }
                    case "list_add": {
                        if (strings.length > 6) {
                            switch (SRPEPhases.addParasite(Byte.parseByte(strings[2]), strings.length == 8 ? Integer.valueOf(Integer.parseInt(strings[7])) : null, new SRPEPhases.PhaseUtilsValues(Integer.parseInt(strings[6]), strings[3], Integer.parseInt(strings[4]), Integer.parseInt(strings[5])))) {
                                case 0: {
                                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The phase or dimension was not found for adding."));
                                    break;
                                }
                                case 1: {
                                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Added."));
                                    break;
                                }
                                case 2: {
                                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The entity is not a subclass of EntityParasiteBase."));
                                }
                            }
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<phase> <name> <min> <max> <weight> <(Optional)dim_id>"));
                        }
                        return;
                    }
                    case "list_remove": {
                        if (strings.length > 3) {
                            if (SRPEPhases.removeParasite(Byte.parseByte(strings[2]), strings.length == 5 ? Integer.valueOf(Integer.parseInt(strings[4])) : null, strings[3])) {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Removed."));
                            } else {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The entity is not in the list."));
                            }
                        } else {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("<phase> <name> <(Optional)dim_id>"));
                        }
                        return;
                    }
                    case "list_clear": {
                        if (strings.length > 2) {
                            if (SRPEPhases.clearListParasites(Byte.parseByte(strings[2]), strings.length == 4 ? Integer.valueOf(Integer.parseInt(strings[3])) : null)) {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The list has been cleared."));
                            } else {
                                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("The phase or dimension was not found for clearing."));
                            }
                        } else {
                            for (SRPEPhases.PhaseUtilsKeys keys : SRPEPhases.PHASES) {
                                keys.value.clear();
                            }
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("All lists have been cleared."));
                        }
                        return;
                    }
                }
                return;
            }
            case "help": {
                if (strings.length > 1) {
                    switch (strings[1]) {
                        case "info": {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Displays all information about the parasite. Available parameters: <name>"));
                            return;
                        }
                        case "test": {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Checks whether the parasite can naturally spawn in a specific area. Available parameters: <name>"));
                            return;
                        }
                        case "phase_list": {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Displays the list (SRP + SRPE) of parasites that will naturally spawn. Available parameters: <(optional)phase> <(optional)dim_id>"));
                            return;
                        }
                        case "phase_srp": {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("A section that interacts only with SRP data.\n  > spawn_status - displays the current state of SRP Phase Spawn.\n  > spawn_off - disables SRP Phase Spawn.\n  > spawn_on - enables SRP Phase Spawn.\n  > list_info - displays the list of entities that will spawn through SRP Phase Spawn. Available parameters: <(optional)phase>\n  > list_add - adds a parasite to the SRP spawn list. Available parameters: <phase> <name> <min> <max> <weight>\n  > list_remove - removes a specific parasite by name from the SRP spawn lists. Available parameters: <phase> <name>\n  > list_clear - clears the SRP spawn lists. Available parameters: <(optional)phase>"));
                            return;
                        }
                        case "phase_srpe": {
                            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("A section that interacts only with SRPE data.\n  > spawn_debug - displays information about entity spawning through SRPE Phase Spawn. Available parameter: <(optional)boolean>\n  > spawn_status - displays the current state of SRPE Phase Spawn.\n  > spawn_off - disables SRPE Phase Spawn.\n  > spawn_on - enables SRPE Phase Spawn.\n  > list_info - displays the list of entities that will spawn through SRPE Phase Spawn. Available parameters: <(optional)phase> <(optional)dim_id>\n  > list_add - adds a parasite to the SRPE spawn list. Available parameters: <phase> <name> <min> <max> <weight> <(optional)dim_id>\n  > list_remove - removes a specific parasite by name from the SRPE spawn lists. Available parameters: <phase> <name> <(optional)dim_id>\n  > list_clear - clears the SRPE spawn lists. Available parameters: <(optional)phase> <(optional)dim_id>"));
                            return;
                        }
                    }
                } else {
                    iCommandSender.func_145747_a((ITextComponent)new TextComponentString("------------------------\n> info - Displays all information about the parasite.\n> test - checks whether the parasite can naturally spawn in a specific area.\n> phase_list - displays the list (SRP + SRPE) of parasites that will naturally spawn.\n> phase_srp - a section that interacts only with SRP data.\n> phase_srpe - a section that interacts only with SRPE data.\n------------------------"));
                }
                return;
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> tab = new ArrayList<String>();
        if (args.length == 1) {
            tab.add("info");
            tab.add("test");
            tab.add("phase_list");
            tab.add("phase_srp");
            tab.add("phase_srpe");
            tab.add("help");
        } else {
            switch (args[0]) {
                case "info": {
                    tab.addAll(Main.ALL_PARASITES);
                    break;
                }
                case "test": {
                    tab.addAll(Main.ALL_PARASITES);
                    break;
                }
                case "phase_list": {
                    if (args.length == 3) {
                        tab.add(sender.func_130014_f_().field_73011_w.getDimension() + "");
                        break;
                    }
                    tab.add(SRPSaveData.get((World)sender.func_130014_f_()).getEvolutionPhase(sender.func_130014_f_().field_73011_w.getDimension()) + "");
                    break;
                }
                case "phase_srp": {
                    tab.add("spawn_status");
                    tab.add("spawn_off");
                    tab.add("spawn_on");
                    tab.add("list_info");
                    tab.add("list_add");
                    tab.add("list_remove");
                    tab.add("list_clear");
                    break;
                }
                case "phase_srpe": {
                    tab.add("spawn_debug");
                    tab.add("spawn_status");
                    tab.add("spawn_off");
                    tab.add("spawn_on");
                    tab.add("list_info");
                    tab.add("list_add");
                    tab.add("list_remove");
                    tab.add("list_clear");
                    break;
                }
                case "help": {
                    tab.add("info");
                    tab.add("test");
                    tab.add("phase_list");
                    tab.add("phase_srp");
                    tab.add("phase_srpe");
                }
            }
        }
        return tab;
    }

    public static String getPhaseList(byte phase) {
        StringBuilder message = new StringBuilder();
        for (Biome.SpawnListEntry entry : SRPSpawning.getSpawns((byte)phase)) {
            message.append("\n  ").append(entry.toString());
        }
        return message.toString();
    }
}

