/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.client.renderer.entity.feral;

import com.google.common.collect.Maps;
import energon.srpextra.client.model.entity.feral.ModelFerPlayer_ArmorLayer;
import energon.srpextra.entity.feral.EntityFerPlayer;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;

public class RenderLayerFerPlayer
implements LayerRenderer<EntityFerPlayer> {
    public static final ModelFerPlayer_ArmorLayer armorModel = new ModelFerPlayer_ArmorLayer();
    private final RenderLivingBase<?> renderer;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public RenderLayerFerPlayer(RenderLivingBase<?> renderer) {
        this.renderer = renderer;
    }

    public void doRenderLayer(EntityFerPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        armorModel.func_78086_a((EntityLivingBase)entity, limbSwing, limbSwingAmount, partialTicks);
        this.renderLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
        this.renderLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
    }

    public void renderLayer(EntityFerPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slot) {
        ItemArmor itemarmor;
        ItemStack stack = entity.func_184582_a(slot);
        if (stack.func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)stack.func_77973_b()).func_185083_B_() == slot) {
            this.hideAll();
            this.renderer.func_110776_a(this.getArmorResource((Entity)entity, stack, slot, null));
            if (itemarmor.hasOverlay(stack)) {
                int i = itemarmor.func_82814_b(stack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)1.0f);
                switch (slot) {
                    case HEAD: {
                        RenderLayerFerPlayer.armorModel.ARMOR_LowerTorso.field_78807_k = false;
                        armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                        break;
                    }
                    case LEGS: {
                        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegL.field_78807_k = false;
                        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegR.field_78807_k = false;
                        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_CUSTOMBODY.field_78807_k = false;
                        armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                        break;
                    }
                    case FEET: {
                        RenderLayerFerPlayer.armorModel.ARMOR_LegL.field_78807_k = false;
                        RenderLayerFerPlayer.armorModel.ARMOR_LegR.field_78807_k = false;
                        armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    }
                }
                this.renderer.func_110776_a(this.getArmorResource((Entity)entity, stack, slot, "overlay"));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            switch (slot) {
                case HEAD: {
                    RenderLayerFerPlayer.armorModel.ARMOR_LowerTorso.field_78807_k = false;
                    armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    break;
                }
                case LEGS: {
                    RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegL.field_78807_k = false;
                    RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegR.field_78807_k = false;
                    RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_CUSTOMBODY.field_78807_k = false;
                    armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    break;
                }
                case FEET: {
                    RenderLayerFerPlayer.armorModel.ARMOR_LegL.field_78807_k = false;
                    RenderLayerFerPlayer.armorModel.ARMOR_LegR.field_78807_k = false;
                    armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                }
            }
            if (stack.func_77962_s()) {
                LayerArmorBase.func_188364_a(this.renderer, (EntityLivingBase)entity, (ModelBase)armorModel, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            }
        }
    }

    public void hideAll() {
        RenderLayerFerPlayer.armorModel.ARMOR_LowerTorso.field_78807_k = true;
        RenderLayerFerPlayer.armorModel.ARMOR_LegR.field_78807_k = true;
        RenderLayerFerPlayer.armorModel.ARMOR_LegL.field_78807_k = true;
        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegR.field_78807_k = true;
        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_LegL.field_78807_k = true;
        RenderLayerFerPlayer.armorModel.ARMOR_LEGSLAYER_CUSTOMBODY.field_78807_k = true;
    }

    public boolean func_177142_b() {
        return false;
    }

    private boolean isLegSlot(EntityEquipmentSlot p_isLegSlot_1_) {
        return p_isLegSlot_1_ == EntityEquipmentSlot.LEGS;
    }

    public ResourceLocation getArmorResource(Entity p_getArmorResource_1_, ItemStack p_getArmorResource_2_, EntityEquipmentSlot p_getArmorResource_3_, String p_getArmorResource_4_) {
        String texture = ((ItemArmor)p_getArmorResource_2_.func_77973_b()).func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.isLegSlot(p_getArmorResource_3_) ? 2 : 1, p_getArmorResource_4_ == null ? "" : String.format("_%s", p_getArmorResource_4_));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)p_getArmorResource_1_, (ItemStack)p_getArmorResource_2_, (String)s1, (EntityEquipmentSlot)p_getArmorResource_3_, (String)p_getArmorResource_4_));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

