/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.config;

import energon.srpextra.Main;
import energon.srpextra.config.SRPEConfigSystem;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class SRPEConfigExtra {
    public static boolean infEndermanWaterWeak = true;
    public static byte infEndermanWaterWeakPhaseCanceled = (byte)5;
    public static boolean neutralParasitesBecomeAggressiveOnParasiteDamagesPlayer = true;
    public static boolean neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerSetTarget = true;
    public static float neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerChance = 0.4f;
    public static int neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerHeight = 4;
    public static int neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerRadius = 8;
    public static boolean neutralParasitesBecomeAggressiveOnPlayerHit = true;
    public static boolean neutralParasitesBecomeAggressiveOnPlayerHitSetTarget = true;
    public static float neutralParasitesBecomeAggressiveOnPlayerHitChance = 0.8f;
    public static int neutralParasitesBecomeAggressiveOnPlayerHitHeight = 6;
    public static int neutralParasitesBecomeAggressiveOnPlayerHitRadius = 12;
    public static boolean onParasiteDamagesPlayer = true;
    public static float onParasiteDamagesPlayerChance = 0.7f;
    public static int onParasiteDamagesPlayerHeight = 4;
    public static int onParasiteDamagesPlayerRadius = 8;
    public static boolean onPlayerDamagesParasite = true;
    public static float onPlayerDamagesParasiteChance = 0.7f;
    public static int onPlayerDamagesParasiteHeight = 4;
    public static int onPlayerDamagesParasiteRadius = 8;

    private static void initMainSettings(Configuration config) {
        String category = "+main";
        config.addCustomCategoryComment(category, "Main Settings\n!!!After updating the mod, configurations will be recreated!!!\n!!!It is recommended to save the configurations in another location!!!");
    }

    public static void infEndermanFix(Configuration config) {
        String category = "sim_enderman";
        infEndermanWaterWeak = config.getBoolean("Water weakness", category, infEndermanWaterWeak, "Set to true to make Assimilated Enderman to be much weaker.");
        infEndermanWaterWeakPhaseCanceled = (byte)config.getInt("Phase water unaffected to Enderman", category, (int)infEndermanWaterWeakPhaseCanceled, -2, 127, "From this phase on, water are no longer adversaries to Enderman if \"Water weakness\" is enable.");
    }

    public static void initNeutralParasiteLogic(Configuration config, String category) {
        config.addCustomCategoryComment(category, "Settings for neutral parasites (related to hostile parasites)");
        neutralParasitesBecomeAggressiveOnParasiteDamagesPlayer = config.getBoolean("neutralAggroOnNearbyHit", category, neutralParasitesBecomeAggressiveOnParasiteDamagesPlayer, "If true, neutral parasites will become aggressive if another parasite hits a nearby player.");
        neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerSetTarget = config.getBoolean("neutralAggroOnNearbyHit_setTarget", category, neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerSetTarget, "If true, all neutral parasites will be aggressive toward the player who triggered the event.");
        neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerChance = config.getFloat("neutralAggroOnNearbyHit_chance", category, neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerChance, 0.0f, 1.0f, "Chance to trigger event.");
        neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerHeight = config.getInt("neutralAggroOnNearbyHit_height", category, neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerHeight, 0, 999, "Vertical distance at which all neutral parasites become aggressive.");
        neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerRadius = config.getInt("neutralAggroOnNearbyHit_radius", category, neutralParasitesBecomeAggressiveOnParasiteDamagesPlayerRadius, 0, 999, "Radius at which all neutral parasites become aggressive.");
        neutralParasitesBecomeAggressiveOnPlayerHit = config.getBoolean("neutralAggroToPlayerOnGetHit", category, neutralParasitesBecomeAggressiveOnPlayerHit, "If true, neutral parasites will become aggressive if a player hits a nearby parasite.");
        neutralParasitesBecomeAggressiveOnPlayerHitSetTarget = config.getBoolean("neutralAggroToPlayerOnHit_setTarget", category, neutralParasitesBecomeAggressiveOnPlayerHitSetTarget, "If true, all neutral parasites will be aggressive toward the player who triggered the event.");
        neutralParasitesBecomeAggressiveOnPlayerHitChance = config.getFloat("neutralAggroToPlayerOnHit_chance", category, neutralParasitesBecomeAggressiveOnPlayerHitChance, 0.0f, 1.0f, "Chance to trigger event.");
        neutralParasitesBecomeAggressiveOnPlayerHitHeight = config.getInt("neutralAggroToPlayerOnHit_height", category, neutralParasitesBecomeAggressiveOnPlayerHitHeight, 0, 999, "Vertical distance at which all neutral parasites become aggressive.");
        neutralParasitesBecomeAggressiveOnPlayerHitRadius = config.getInt("neutralAggroToPlayerOnHit_radius", category, neutralParasitesBecomeAggressiveOnPlayerHitRadius, 0, 999, "Radius at which all neutral parasites become aggressive.");
    }

    public static void initRevealHiddenEntities(Configuration config) {
        String category = "reveal_hidden";
        config.addCustomCategoryComment(category, "");
        onParasiteDamagesPlayer = config.getBoolean("on_parasite_damages_player", category, onParasiteDamagesPlayer, "If true, when the player damages the parasite, all hidden parasites transform.");
        onParasiteDamagesPlayerChance = config.getFloat("on_parasite_damages_player_chance", category, onParasiteDamagesPlayerChance, 0.0f, 1.0f, "Chance to trigger event.");
        onParasiteDamagesPlayerHeight = config.getInt("on_parasite_damages_player_height", category, onParasiteDamagesPlayerHeight, 0, 999, "Vertical distance from the parasite in which all hidden parasites transform.");
        onParasiteDamagesPlayerRadius = config.getInt("on_parasite_damages_player_radius", category, onParasiteDamagesPlayerRadius, 0, 999, "Radius around the parasite in which all hidden parasites transform.");
        onPlayerDamagesParasite = config.getBoolean("on_player_damages_parasite", category, onPlayerDamagesParasite, "If true, when the parasite attacks the player, all nearby hidden parasites transform.");
        onPlayerDamagesParasiteChance = config.getFloat("on_player_damages_parasite_chance", category, onPlayerDamagesParasiteChance, 0.0f, 1.0f, "Chance to trigger event.");
        onPlayerDamagesParasiteHeight = config.getInt("on_player_damages_parasite_height", category, onPlayerDamagesParasiteHeight, 0, 999, "Vertical distance from the parasite in which all hidden parasites transform.");
        onPlayerDamagesParasiteRadius = config.getInt("on_player_damages_parasite_radius", category, onPlayerDamagesParasiteRadius, 0, 999, "Radius around the parasite in which all hidden parasites transform.");
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        Main.configExtra = new Configuration(new File(event.getModConfigurationDirectory() + "/srpextra/SRPEConfigExtra.cfg"), "0.6.1");
        if (!Main.configExtra.getDefinedConfigVersion().equals(Main.configExtra.getLoadedConfigVersion()) && Main.configExtra.getConfigFile().exists() && Main.configExtra.getConfigFile().delete()) {
            SRPEConfigSystem.error("!!!Config Extra Rewrite!!!", 3);
        }
        SRPEConfigExtra.readConfig(Main.configExtra);
    }

    public static void readConfig(Configuration config) {
        try {
            config.load();
            SRPEConfigExtra.initMainSettings(config);
            SRPEConfigExtra.infEndermanFix(config);
            SRPEConfigExtra.initNeutralParasiteLogic(config, "neutral_parasite_logic");
            SRPEConfigExtra.initRevealHiddenEntities(config);
        }
        catch (Exception var5) {
            SRPEConfigSystem.error("!!!Config Extra Error!!!", 5);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

