/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.config;

import energon.srpextra.Main;
import energon.srpextra.config.SRPEConfigSystem;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class SRPEConfigGraphic {
    public static boolean useGlowingEyes = false;
    public static boolean useParasiteVision = true;

    private static void initMainSettings(Configuration config) {
        String category = "+main";
        config.addCustomCategoryComment(category, "Main Settings\n!!!After updating the mod, configurations will be recreated!!!\n!!!It is recommended to save the configurations in another location!!!");
    }

    private static void initGraphic(Configuration config) {
        String category = "graphic";
        config.addCustomCategoryComment(category, "Render Settings");
        useGlowingEyes = config.getBoolean("useGlowingEyes", category, useGlowingEyes, "Entities from the mod will be rendered (if possible(false)) with glowing eyes.");
    }

    private static void initParasiteVision(Configuration cfg) {
        String category = "parasite_vision";
        cfg.addCustomCategoryComment(category, "Parasite Vision Settings");
        useParasiteVision = cfg.getBoolean("useParasiteVision", category, useParasiteVision, "Add shaders for the parasite's point of view?");
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        Main.configGraphic = new Configuration(new File(event.getModConfigurationDirectory() + "/srpextra/SRPEConfigGraphic.cfg"), "0.6");
        if (!Main.configGraphic.getDefinedConfigVersion().equals(Main.configGraphic.getLoadedConfigVersion()) && Main.configGraphic.getConfigFile().exists() && Main.configGraphic.getConfigFile().delete()) {
            SRPEConfigSystem.error("!!!Config Graphic Rewrite!!!", 3);
        }
        SRPEConfigGraphic.readConfig(Main.configGraphic);
    }

    public static void readConfig(Configuration config) {
        try {
            config.load();
            SRPEConfigGraphic.initMainSettings(config);
            SRPEConfigGraphic.initGraphic(config);
            SRPEConfigGraphic.initParasiteVision(config);
        }
        catch (Exception var5) {
            SRPEConfigSystem.error("!!!Config Graphic Graphic!!!", 5);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

