/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.init;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPFeral;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPHijacked;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.network.SRPPacketParticle;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.config.SRPEConfigSystem;
import energon.srpextra.entity.IPTransformHandler;
import energon.srpextra.entity.hijacked.IHijacked;
import energon.srpextra.entity.infected.IInfected;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SRPETransform {
    public static List<InfConvertUnit> CONVERT_INF = new ArrayList<InfConvertUnit>();
    public static List<HiConvertUnit> CONVERT_HI = new ArrayList<HiConvertUnit>();
    public static List<MergeUnit> LAND_MERGE = new ArrayList<MergeUnit>();
    public static List<MergeUnit> AQUA_MERGE = new ArrayList<MergeUnit>();

    public static void init() {
        SRPETransform.addAquaMerge(SRPEConfigSystem.mergeAquaMobTable);
    }

    public static void addAquaMerge(String[] merge) {
        for (String element : merge) {
            Class convert;
            String[] parts = element.split(";");
            if (parts.length <= 1 || (convert = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[0]))) == null) continue;
            AQUA_MERGE.add(new MergeUnit(convert, Integer.parseInt(parts[1]), parts.length == 3 ? Integer.valueOf(Integer.parseInt(parts[2])) : null));
        }
    }

    public static void addLandMerge(String[] merge) {
        for (String element : merge) {
            Class convert;
            String[] parts = element.split(";");
            if (parts.length <= 1 || (convert = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[0]))) == null) continue;
            LAND_MERGE.add(new MergeUnit(convert, Integer.parseInt(parts[1]), parts.length == 3 ? Integer.valueOf(Integer.parseInt(parts[2])) : null));
        }
    }

    public static void addInfConvert(String[] m) {
        for (String element : m) {
            String[] parts = element.split(";");
            if (parts.length != 2) continue;
            Class target = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[0]));
            Class convert = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[1]));
            if (target == null || convert == null) continue;
            CONVERT_INF.add(new InfConvertUnit(target, parts[0], convert));
        }
    }

    public static void addHiConvert(String[] m) {
        for (String element : m) {
            String[] parts = element.split(";");
            if (parts.length != 2) continue;
            Class target = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[0]));
            Class convert = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[1]));
            if (target == null || convert == null) continue;
            CONVERT_HI.add(new HiConvertUnit(target, convert));
        }
    }

    @Nullable
    public static InfConvertUnit getConvert_INF(Class<? extends Entity> target) {
        for (InfConvertUnit unit : CONVERT_INF) {
            if (unit.target != target) continue;
            return unit;
        }
        return null;
    }

    @Nullable
    public static HiConvertUnit getConvert_HI(Class<? extends Entity> target) {
        for (HiConvertUnit unit : CONVERT_HI) {
            if (unit.target != target) continue;
            return unit;
        }
        return null;
    }

    @Nullable
    public static Entity getAquaMerge(int code, Random random, World world) {
        if (AQUA_MERGE.isEmpty()) {
            return null;
        }
        ArrayList<MergeUnit> list = new ArrayList<MergeUnit>();
        for (MergeUnit test : AQUA_MERGE) {
            if (test.min > code || test.max != null && code > test.max) continue;
            list.add(test);
        }
        if (list.isEmpty()) {
            return AQUA_MERGE.get(random.nextInt(AQUA_MERGE.size())).getMerged(world);
        }
        return ((MergeUnit)list.get(random.nextInt(list.size()))).getMerged(world);
    }

    @Nullable
    public static Entity getLandMerge(int code, Random random, World world) {
        if (LAND_MERGE.isEmpty()) {
            return null;
        }
        ArrayList<MergeUnit> list = new ArrayList<MergeUnit>();
        for (MergeUnit test : LAND_MERGE) {
            if (test.min > code || test.max != null && code > test.max) continue;
            list.add(test);
        }
        if (list.isEmpty()) {
            return LAND_MERGE.get(random.nextInt(LAND_MERGE.size())).getMerged(world);
        }
        return ((MergeUnit)list.get(random.nextInt(list.size()))).getMerged(world);
    }

    public static void convertEntity(EntityLivingBase target, NBTTagCompound tags, boolean ignoreKey, @Nullable String[] list) {
        if (target != null && !target.field_70170_p.field_72995_K && tags.func_74764_b("srpcothimmunity")) {
            SRPSaveData data;
            World world;
            Entity out;
            int key = tags.func_74762_e("srpcothimmunity");
            if (key == 0 && !ignoreKey) {
                target.func_184596_c(SRPPotions.COTH_E);
                return;
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 3, false, false));
            SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70130_N, target.field_70131_O, 1));
            tags.func_74768_a("srpcothimmunity", ++key);
            if (key < 3 && !ignoreKey) {
                return;
            }
            InfConvertUnit rule = SRPETransform.getConvert_INF(target.getClass());
            if (rule != null && (out = rule.getConvertedEntity(world, (data = SRPSaveData.get((World)(world = target.field_70170_p))).getEvolutionPhase(target.field_71093_bK) < SRPConfigSystems.evolutionFeralNoSim)) instanceof EntityLiving) {
                if (out instanceof EntityPInfected) {
                    data.addNumberIDDataSpawn(((EntityPInfected)out).getParasiteIDRegister());
                    ((EntityPInfected)out).setHost(rule.target_HostName);
                } else if (out instanceof IInfected) {
                    data.addNumberIDDataSpawn(((EntityParasiteBase)out).getParasiteIDRegister());
                }
                out.func_82149_j((Entity)target);
                BlockPos pos = new BlockPos((Entity)target);
                ((EntityLiving)out).func_180482_a(world.func_175649_E(pos), null);
                if (target.func_145818_k_()) {
                    out.func_96094_a(target.func_95999_t());
                    out.func_174805_g(target.func_174833_aM());
                }
                if (out instanceof IPTransformHandler) {
                    ((IPTransformHandler)out).onInitialTransform(target);
                }
                world.func_72900_e((Entity)target);
                world.func_72838_d(out);
                if (out instanceof IPTransformHandler) {
                    ((IPTransformHandler)out).afterTransform();
                } else if (out instanceof EntityParasiteBase) {
                    world.func_180498_a((EntityPlayer)null, 1026, pos, 0);
                    ((EntityParasiteBase)out).particleStatus((byte)7);
                }
                if (out instanceof EntityPInfected) {
                    ((EntityPInfected)out).cannotDespawn(SRPConfig.convertedDespawn);
                } else if (out instanceof IInfected) {
                    ((EntityParasiteBase)out).cannotDespawn(SRPConfig.convertedDespawn);
                }
                if (key >= 10) {
                    ((EntityLiving)out).func_70690_d(new PotionEffect(SRPPotions.EPEL_E, 600, 0, false, false));
                }
                return;
            }
            if (!ignoreKey) {
                ParasiteEventEntity.spawnInsider((EntityLivingBase)target, (World)target.field_70170_p, (NBTTagCompound)tags);
            }
        }
    }

    public static boolean convertEntityFeral(EntityLivingBase target, NBTTagCompound tags, boolean ignoreKey, String[] list) {
        return false;
    }

    public static boolean hijackEntity(EntityLivingBase target, @Nullable String[] list) {
        Entity out;
        if (target == null || target.field_70170_p.field_72995_K) {
            return false;
        }
        World world = target.field_70170_p;
        HiConvertUnit rule = SRPETransform.getConvert_HI(target.getClass());
        if (rule != null && (out = rule.getConvertedEntity(world)) instanceof EntityLiving) {
            if (out instanceof EntityPHijacked) {
                SRPSaveData.get((World)world).addNumberIDDataSpawn(((EntityPHijacked)out).getParasiteIDRegister());
            } else if (out instanceof IHijacked) {
                SRPSaveData.get((World)world).addNumberIDDataSpawn(((EntityParasiteBase)out).getParasiteIDRegister());
            }
            out.func_82149_j((Entity)target);
            BlockPos pos = new BlockPos((Entity)target);
            ((EntityLiving)out).func_180482_a(world.func_175649_E(pos), null);
            if (target.func_145818_k_()) {
                out.func_96094_a(target.func_95999_t());
                out.func_174805_g(target.func_174833_aM());
            }
            if (out instanceof IPTransformHandler) {
                ((IPTransformHandler)out).onInitialTransform(target);
            }
            world.func_72900_e((Entity)target);
            world.func_72838_d(out);
            if (out instanceof IPTransformHandler) {
                ((IPTransformHandler)out).afterTransform();
            } else {
                world.func_180498_a((EntityPlayer)null, 1026, pos, 0);
                world.func_72960_a(out, (byte)7);
            }
            if (out instanceof EntityPHijacked) {
                ((EntityPHijacked)out).cannotDespawn(SRPConfig.convertedDespawn);
            } else if (out instanceof IHijacked) {
                ((EntityParasiteBase)out).cannotDespawn(SRPConfig.convertedDespawn);
            }
            return true;
        }
        return false;
    }

    public static boolean mergeAquaLesh(EntityParasiteBase host, int code) {
        if (!AQUA_MERGE.isEmpty()) {
            host.particleStatus((byte)7);
            host.func_70106_y();
            Entity out = SRPETransform.getAquaMerge(code, host.func_70681_au(), host.field_70170_p);
            if (out != null) {
                out.func_82149_j((Entity)host);
                if (out instanceof EntityLiving) {
                    ((EntityLiving)out).func_180482_a(host.field_70170_p.func_175649_E(host.func_180425_c()), null);
                }
                if (out instanceof EntityParasiteBase) {
                    ((EntityParasiteBase)out).cannotDespawn(SRPConfig.convertedDespawn);
                    if (SRPConfigSystems.useEvolution) {
                        SRPSaveData.get((World)host.field_70170_p).setTotalKills(host.field_71093_bK, SRPConfigSystems.valueMerge, true, host.field_70170_p, true);
                    }
                }
                if (host.func_145818_k_()) {
                    out.func_96094_a(host.func_95999_t());
                }
                host.field_70170_p.func_72838_d(out);
                return true;
            }
        }
        return false;
    }

    public static class MergeUnit {
        public Class<? extends Entity> entity;
        public int min;
        public Integer max;

        public MergeUnit(Class<? extends Entity> entity, int min, Integer max) {
            this.entity = entity;
            this.min = min;
            this.max = max;
        }

        @Nullable
        public Entity getMerged(World world) {
            return EntityList.func_191304_a(this.entity, (World)world);
        }
    }

    public static class InfConvertUnit {
        public Class<? extends Entity> target;
        public String target_HostName;
        public Class<? extends Entity> maybeParasite;
        public Class<? extends Entity> feralVersion;

        public InfConvertUnit(Class<? extends Entity> t, String name, Class<? extends Entity> end) {
            this.target = t;
            this.target_HostName = name;
            this.maybeParasite = end;
        }

        @Nullable
        public Entity getConvertedEntity(World world, boolean spawnFeral) {
            EntityPFeral feral;
            if (spawnFeral && this.feralVersion != null) {
                return EntityList.func_191304_a(this.feralVersion, (World)world);
            }
            Entity converted = EntityList.func_191304_a(this.maybeParasite, (World)world);
            if (spawnFeral && converted instanceof EntityPInfected && (feral = ((EntityPInfected)converted).getFeral()) != null) {
                this.feralVersion = feral.getClass();
                return feral;
            }
            return converted;
        }
    }

    public static class HiConvertUnit {
        public Class<? extends Entity> target;
        public Class<? extends Entity> maybeParasite;

        public HiConvertUnit(Class<? extends Entity> target, Class<? extends Entity> maybeParasite) {
            this.target = target;
            this.maybeParasite = maybeParasite;
        }

        @Nullable
        public Entity getConvertedEntity(World world) {
            return EntityList.func_191304_a(this.maybeParasite, (World)world);
        }
    }
}

