/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity.primitive;

import com.dhanantry.scapeandrunparasites.entity.EntityBody;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAISkill;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityBodyParts;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import energon.srpextra.entity.IGetESpawnRuleID;
import energon.srpextra.entity.ai.SRPEAI_AttackMelee_RE;
import energon.srpextra.entity.ai.SRPEAI_Swimming;
import energon.srpextra.entity.primitive.SRPEPPrimitive;
import energon.srpextra.init.SRPEItems;
import energon.srpextra.util.SRPEAttributes;
import energon.srpextra.util.Utilities;
import energon.srpextra.util.config.SRPEConfigMobs;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMiku
extends SRPEPPrimitive
implements IGetESpawnRuleID,
EntityBodyParts {
    public byte skillID = 0;
    public float skillProgress = 1.0f;
    public float animationProgressPRE = 1.0f;
    public boolean performAttack = false;
    public float lowRot = 0.0f;
    public float preLowRot = 0.0f;
    public EntityBody HEAD = new EntityBody((EntityParasiteBase)this, 0.7f, 1.2f, 1.0f, 0.3f, 2.8f, -1, 1, false);

    public EntityMiku(World w) {
        super(w);
        this.func_70105_a(0.8f, 2.8f);
        this.setSkillBreakBlocksValues(SRPEConfigMobs.maxBlockHardnessSkillBreakBlockStalker, 3, 3);
    }

    public float func_70047_e() {
        return 2.7f;
    }

    @Override
    public byte spawnRuleID() {
        return 3;
    }

    @Override
    public int getParasiteIDRegister() {
        return -4;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(2.0);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SRPEAI_Swimming((EntityMob)this, 0.25, 0.15f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new SRPEAI_AttackMelee_RE((EntityCreature)this, 1.0, false){

            @Override
            public void checkAndPerformAttack(EntityLivingBase target, double distanceSQ) {
                double d0 = this.getAttackReachSqr(target);
                if (distanceSQ <= d0) {
                    this.attackTick = EntityMiku.this.meleeAttack();
                }
                if (distanceSQ <= 144.0 && this.attacker.func_70681_au().nextFloat() < 0.05f && this.attacker.func_70685_l((Entity)target)) {
                    if (EntityMiku.this.changeSkill((byte)104)) {
                        this.attackTick = 10;
                        double dx = target.field_70165_t - this.attacker.field_70165_t;
                        double dy = target.field_70163_u + (double)target.func_70047_e() * 0.3 - this.attacker.field_70163_u;
                        double dz = target.field_70161_v - this.attacker.field_70161_v;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        this.attacker.field_70159_w = dx / distance * 0.3;
                        this.attacker.field_70181_x = dy / distance * 0.3 + 0.1;
                        this.attacker.field_70179_y = dz / distance * 0.3;
                        this.attacker.field_70133_I = true;
                    } else {
                        this.attackTick = 5;
                    }
                }
            }

            @Override
            public double getAttackReachSqr(EntityLivingBase p_getAttackReachSqr_1_) {
                return 9.0;
            }
        });
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (SRPEConfigMobs.cooldownSkillBreakBlockStalker != -1) {
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAISkill((EntityParasiteBase)this, SRPEConfigMobs.cooldownSkillBreakBlockStalker, 24, 0, false, 13, true));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkillProgress(float partial) {
        return this.skillProgress == 1.0f ? 1.0f : this.animationProgressPRE + (this.skillProgress - this.animationProgressPRE) * partial;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.animationProgressPRE = this.skillProgress;
            if (this.preLowRot != this.lowRot) {
                this.preLowRot = this.lowRot;
            }
        }
        if (this.skillProgress < 1.0f) {
            this.skillProgressHandler();
        } else {
            this.skillProgress = 1.0f;
            if (this.skillID != 0) {
                this.skillID = 0;
                this.performAttack = false;
            }
        }
        IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b(3));
        this.lowRot = state.func_177230_c() != Blocks.field_150350_a && !state.func_185904_a().func_76224_d() ? Math.min(this.lowRot + 0.07f, 1.0f) : Math.max(this.lowRot - 0.08f, 0.0f);
        this.headUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public float getRoAnimation(float partialTick) {
        if (this.lowRot == 0.0f) {
            return 0.0f;
        }
        return this.preLowRot + (this.lowRot - this.preLowRot) * partialTick;
    }

    public void headUpdate() {
        if (this.HEAD != null) {
            if (this.HEAD.getFather() == null || this.field_70128_L) {
                this.field_70170_p.func_72973_f((Entity)this.HEAD);
                this.HEAD = null;
            } else {
                this.HEAD.func_70071_h_();
                double yawRad = Math.toRadians(this.field_70177_z);
                double offsetX = -MathHelper.func_76126_a((float)((float)yawRad)) * (0.1f + this.lowRot * 0.7f);
                double offsetZ = MathHelper.func_76134_b((float)((float)yawRad)) * (0.1f + this.lowRot * 0.7f);
                double X = this.field_70165_t + offsetX;
                double Y = this.field_70163_u + (double)2.8f - (double)this.lowRot;
                double Z = this.field_70161_v + offsetZ;
                this.HEAD.func_70107_b(X, Y, Z);
            }
        }
    }

    public int meleeAttack() {
        if ((double)this.field_70146_Z.nextFloat() < 0.3) {
            return this.changeSkill((byte)102) ? 25 : 10;
        }
        return this.changeSkill(this.field_70146_Z.nextBoolean() ? (byte)101 : 100) ? 20 : 10;
    }

    public void skillProgressHandler() {
        switch (this.skillID) {
            case 100: 
            case 101: {
                this.skillProgress = Math.min(this.skillProgress + 0.05f, 1.0f);
                if (!this.field_70170_p.field_72995_K && this.performAttack && this.skillProgress > 0.3f) {
                    this.performAttack = false;
                    EntityLivingBase target = this.func_70638_az();
                    if (target != null && target.func_70092_e(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v) < 17.0 && this.func_70685_l((Entity)target)) {
                        this.func_70652_k((Entity)target);
                    }
                }
                return;
            }
            case 102: {
                this.skillProgress = Math.min(this.skillProgress + 0.03f, 1.0f);
                if (!this.field_70170_p.field_72995_K && this.performAttack && this.skillProgress > 0.5f) {
                    this.performAttack = false;
                    EntityLivingBase target = this.func_70638_az();
                    if (target != null && target.func_70092_e(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v) < 17.0 && this.func_70685_l((Entity)target)) {
                        this.func_70652_k((Entity)target);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)103);
                    } else if (this.field_70146_Z.nextBoolean()) {
                        this.func_70624_b(null);
                    }
                }
                return;
            }
            case 103: {
                this.skillProgress = Math.min(this.skillProgress + 0.2f, 1.0f);
                return;
            }
            case 104: {
                this.skillProgress = Math.min(this.skillProgress + 0.16f, 1.0f);
                return;
            }
        }
        this.skillProgress = Math.min(this.skillProgress + 0.05f, 1.0f);
    }

    public boolean changeSkill(byte id) {
        if (this.skillID == 0) {
            this.skillID = id;
            this.skillProgress = 0.0f;
            this.performAttack = true;
            this.field_70170_p.func_72960_a((Entity)this, id);
            return true;
        }
        return false;
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.skillID = id;
                this.skillProgress = 0.0f;
                this.animationProgressPRE = 0.0f;
                return;
            }
        }
        super.func_70103_a(id);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)SRPEConfigMobs.followRangeStalker);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)SRPEConfigMobs.movementSpeedStalker);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPEAttributes.damageStalker);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPEAttributes.armorStalker);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a((double)SRPEConfigMobs.armorToughnessStalker);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(SRPEAttributes.KBStalker);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPEAttributes.healthStalker);
    }

    @Override
    public void spawnMinions() {
        Utilities.summonMinionsListVelocityOffset(this.field_70170_p, (Entity)this, 1.0f, SRPEConfigMobs.listSpawnMinionsStalker, SRPEConfigMobs.minionEffectStalker, SRPEConfigMobs.onlyOneEffectMinionFromRollStalker, SRPEConfigMobs.minionsSpawnDistanceEntityStalker, SRPEConfigMobs.onlyOneMinionFromRollStalker, this.field_70146_Z, SRPEConfigMobs.minionsVelocityXZStalker, SRPEConfigMobs.minionsVelocityYStalker, SRPEConfigMobs.minionsVelocityXZStalker);
    }

    @Override
    public void spawnDeathLoot() {
        Utilities.lootEntityDeathDrop((Entity)this, SRPEConfigMobs.lootTableStalker, SRPEConfigMobs.lootMaxRollStalker, SRPEConfigMobs.dropOneTypeItemStalker, this.field_70146_Z);
    }

    public boolean attackEntityBodyFrom(DamageSource damageSource, float v, int i, boolean b) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        return this.func_70097_a(damageSource, v * 1.5f);
    }

    public void setBodyPartDead(int i) {
        if (i == 1 && this.HEAD != null) {
            this.field_70170_p.func_72973_f((Entity)this.HEAD);
            this.HEAD = null;
        }
    }

    public void onRemovedFromWorld() {
        if (this.HEAD != null) {
            this.field_70170_p.func_72973_f((Entity)this.HEAD);
            this.HEAD = null;
        }
        super.onRemovedFromWorld();
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.MOBSILENCE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        return SRPSounds.MOBSILENCE;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SRPSounds.MOBSILENCE;
    }

    protected void func_180429_a(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.func_184185_a(SRPSounds.MONSTER_STEP, 0.05f, 1.0f);
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        return new ItemStack(SRPEItems.SPAWN_Miku);
    }
}

