/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.events;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAta;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityIki;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityWymo;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.entity.adapted.EntityIkiAdapted;
import energon.srpextra.entity.adapted.EntityWymoAdapted;
import energon.srpextra.entity.ai.SRPEAI_SpawnNext;
import energon.srpextra.entity.feral.EntityFeralWolf;
import energon.srpextra.entity.infected.EntityAssimilatedOcelot;
import energon.srpextra.util.Utilities;
import energon.srpextra.util.config.SRPEConfigMobs;
import energon.srpextra.util.config.SRPEConfigSystem;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityInject {
    public static HashMap<Class<?>, spawnUtil> testList = new HashMap();

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            Entity entity = event.getEntity();
            if (entity instanceof EntityAta && SRPEConfigMobs.gnatAttackCreeper) {
                ((EntityParasiteBase)event.getEntity()).field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)((EntityParasiteBase)event.getEntity()), EntityCreeper.class, false, false));
            } else if (entity instanceof EntityCreeper && SRPEConfigMobs.inheritSkillsAssimilatedOcelot) {
                ((EntityCreeper)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)((EntityCreeper)event.getEntity()), EntityAssimilatedOcelot.class, 6.0f, 1.0, 1.2));
            } else {
                if (entity instanceof EntityInfWolf) {
                    return;
                }
                if (entity instanceof EntityFerWolf && SRPEConfigMobs.activeFeralWolf) {
                    World world = entity.field_70170_p;
                    EntityFeralWolf wolf = new EntityFeralWolf(world);
                    wolf.func_82149_j(entity);
                    wolf.func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                    world.func_72838_d((Entity)wolf);
                    entity.func_70106_y();
                } else if (entity instanceof EntityIki && SRPEConfigMobs.activeAdaptedIki) {
                    ((EntityIki)entity).field_70714_bg.func_75776_a(8, (EntityAIBase)new SRPEAI_SpawnNext((EntityParasiteBase)((EntityIki)entity), EntityIkiAdapted::new, (int)SRPConfig.adaptedKills));
                } else if (entity instanceof EntityWymo && SRPEConfigMobs.activeAdaptedWymo) {
                    ((EntityWymo)entity).field_70714_bg.func_75776_a(8, (EntityAIBase)new SRPEAI_SpawnNext((EntityParasiteBase)((EntityWymo)entity), EntityWymoAdapted::new, (int)SRPConfig.adaptedKills));
                }
            }
        }
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase entity;
        if (!event.getWorld().field_72995_K && !SRPEConfigSystem.useSRPExtraEntitySpawn && (entity = event.getEntityLiving()) instanceof EntityParasiteBase) {
            spawnUtil util = testList.get(entity.getClass());
            if (util == null) {
                return;
            }
            if (!util.test(entity.func_130014_f_(), entity.func_180425_c())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Pre event) {
    }

    public static void addClassTest(Class<?> mobClass, int[] dimensions, String[] biomes, Integer PS) {
        if (dimensions.length > 0 || biomes.length > 0) {
            if (PS == null) {
                testList.putIfAbsent(mobClass, new spawnUtil(dimensions, biomes));
            } else {
                testList.putIfAbsent(mobClass, new spawnUtil(dimensions, biomes, PS));
            }
        }
    }

    public static void addCustomTests(String[] elements) {
        for (String element : elements) {
            String[] parts = element.split(";");
            if (parts.length != 3 && parts.length != 4) continue;
            try {
                int[] dimensions;
                Class entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation(parts[0]));
                if (entityClass == null || !EntityParasiteBase.class.isAssignableFrom(entityClass)) continue;
                if (parts[1].equalsIgnoreCase("all")) {
                    dimensions = new int[]{};
                } else {
                    String[] partsD = parts[1].split(",");
                    dimensions = new int[partsD.length];
                    for (int i = 0; i < partsD.length; ++i) {
                        dimensions[i] = Integer.parseInt(partsD[i]);
                    }
                }
                String[] biomes = parts[2].equalsIgnoreCase("all") ? new String[]{} : parts[2].split(",");
                EntityInject.addClassTest(entityClass, dimensions, biomes, parts.length == 3 ? null : Integer.valueOf(Integer.parseInt(parts[3])));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public static class spawnUtil {
        public int[] dimensions;
        public String[] biomes;
        public Integer phaseStop = null;
        public boolean BLB = true;

        public spawnUtil(int[] dim, String[] bio) {
            this.dimensions = dim;
            this.biomes = bio;
            this.ACBBL();
        }

        public spawnUtil(int[] dim, String[] bio, int phaseS) {
            this(dim, bio);
            this.phaseStop = phaseS;
        }

        public void ACBBL() {
            for (String test : this.biomes) {
                if (test.charAt(0) == '!') continue;
                this.BLB = false;
                return;
            }
        }

        public boolean test(World world, BlockPos pos) {
            if (this.phaseStop != null && SRPSaveData.get((World)world).getEvolutionPhase(world.field_73011_w.getDimension()) >= this.phaseStop) {
                return true;
            }
            return this.checkDimension(world.field_73011_w.getDimension()) && this.checkBiome(world, pos);
        }

        public boolean checkDimension(int dimId) {
            if (this.dimensions.length == 0) {
                return true;
            }
            for (int test : this.dimensions) {
                if (dimId != test) continue;
                return true;
            }
            return false;
        }

        public boolean checkBiome(World world, BlockPos pos) {
            if (this.biomes.length == 0) {
                return true;
            }
            Biome biomeCheck = world.func_180494_b(pos);
            if (biomeCheck.getRegistryName() == null) {
                return false;
            }
            String biomeCheckName = biomeCheck.getRegistryName().toString();
            boolean test = this.BLB;
            for (String partsB : this.biomes) {
                boolean cc = biomeCheckName.equals(partsB.toLowerCase().replace("!", ""));
                boolean cc2 = Utilities.checkBiomeType(biomeCheck, partsB.replace("!", ""));
                if (partsB.charAt(0) == '!') {
                    if (!(partsB.contains(":") ? cc : cc2)) continue;
                    return false;
                }
                if (partsB.contains(":")) {
                    if (!cc || test) continue;
                    test = true;
                    continue;
                }
                if (!cc2 || test) continue;
                test = true;
            }
            return test;
        }

        public String toString() {
            return "Dimensions: " + Arrays.toString(this.dimensions) + ", Biomes: " + Arrays.toString(this.biomes) + (this.phaseStop == null ? "" : ", Phase Stop Test: " + this.phaseStop);
        }
    }
}

