/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.items;

import com.dhanantry.scapeandrunparasites.block.BlockGore;
import com.dhanantry.scapeandrunparasites.entity.EntityRemain;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.items.SRPEItemBase;
import energon.srpextra.items.SRPEItemCheck;
import energon.srpextra.util.config.SRPEConfigItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SRPEItemRemainsCanister
extends SRPEItemBase {
    public SRPEItemRemainsCanister(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("container"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
                if (itemStack.func_77942_o()) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ParasiteElement")) {
                if (this.summon(pos.func_177972_a(facing), world, stack, player) && SRPEConfigItems.debugCanister) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.failed")));
                }
            } else {
                String name = null;
                List entities = world.func_72872_a(EntityRemain.class, new AxisAlignedBB(pos));
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityRemain)) continue;
                    name = (String)SRPEItemCheck.getFieldValue(entity, "parasite");
                    switch ((BlockGore.EnumType)world.func_180495_p(pos).func_177229_b((IProperty)BlockGore.VARIANT)) {
                        case SIM_BIG: {
                            name = name + ";sim;";
                            break;
                        }
                        case PRI_BIG: {
                            name = name + ";pri;";
                            break;
                        }
                        case ADA_BIG: {
                            name = name + ";ada;";
                            break;
                        }
                        case PURE_BIG: {
                            name = name + ";pure;";
                        }
                    }
                    name = name + Byte.toString((Byte)SRPEItemCheck.getFieldValue(entity, "skin"));
                    world.func_175698_g(pos);
                    entity.func_70106_y();
                    break;
                }
                if (name == null || name.isEmpty()) {
                    if (SRPEConfigItems.debugCanister) {
                        player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.failed")));
                    }
                } else {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74778_a("ParasiteElement", name);
                    if (SRPEConfigItems.debugCanister) {
                        player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.saved") + " " + name.split(";")[0]));
                    }
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean summon(BlockPos pos, World world, ItemStack itemStack, EntityPlayer player) {
        String[] element = itemStack.func_77978_p().func_74779_i("ParasiteElement").split(";");
        if (element.length == 3) {
            switch (element[1]) {
                case "sim": {
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.SIM_BIG));
                    break;
                }
                case "pri": {
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PRI_BIG));
                    break;
                }
                case "ada": {
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.ADA_BIG));
                    break;
                }
                case "pure": {
                    world.func_175656_a(pos, SRPBlocks.Gore.func_176223_P().func_177226_a((IProperty)BlockGore.VARIANT, (Comparable)BlockGore.EnumType.PURE_BIG));
                }
            }
            EntityRemain remain = new EntityRemain(world);
            remain.setSkin(Byte.parseByte(element[2]));
            remain.setGoal(20 * SRPConfig.infectedRemainValue);
            remain.setParasite(element[0]);
            remain.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)remain);
            if (SRPEConfigItems.debugCanister) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.placed")));
            }
            if (!player.func_184812_l_()) {
                itemStack.func_77982_d(null);
            }
            return false;
        }
        return true;
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("ParasiteElement")) {
            String[] element = itemStack.func_77978_p().func_74779_i("ParasiteElement").split(";");
            if (element.length == 3) {
                tooltip.add(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.saved") + " " + element[0]);
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"tooltip.srpextra.itemremains_canister.function.empty"));
        }
    }
}

