/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util.config;

import energon.srpextra.Main;
import energon.srpextra.util.config.SRPEConfigSystem;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class SRPEConfigItems {
    public static boolean debugCanister = false;

    private static void initMainSettings(Configuration config) {
        String category = "+main";
        config.addCustomCategoryComment(category, "Main Settings\n!!!After updating the mod, configurations will be recreated!!!\n!!!It is recommended to save the configurations in another location!!!");
    }

    public static void initCanister(Configuration cfg) {
        String category = "canister";
        cfg.addCustomCategoryComment(category, "Canister Settings");
        debugCanister = cfg.getBoolean("Debug", category, debugCanister, "Debug Mod");
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        Main.configItems = new Configuration(new File(event.getModConfigurationDirectory() + "/srpextra/SRPEConfigItems.cfg"), "0.5.1");
        if (!Main.configItems.getDefinedConfigVersion().equals(Main.configItems.getLoadedConfigVersion()) && Main.configItems.getConfigFile().exists() && Main.configItems.getConfigFile().delete()) {
            SRPEConfigSystem.error("!!!Config Blocks Rewrite!!!", 3);
        }
        SRPEConfigItems.readConfig(Main.configItems);
    }

    public static void readConfig(Configuration config) {
        try {
            config.load();
            SRPEConfigItems.initMainSettings(config);
            SRPEConfigItems.initCanister(config);
        }
        catch (Exception var5) {
            SRPEConfigSystem.error("!!!Config Blocks Error!!!", 5);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

