/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import energon.srpextra.world.SRPEStructureUtils;
import energon.srpextra.world.WorldGenCenter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SRPEFile {
    private static List<String> startStructureList = new ArrayList<String>();
    public static boolean addSRPExtraAddonsStructure = true;
    public static boolean enable = true;

    public static void readFile() {
        File customDir;
        SRPEFile test = new SRPEFile();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            customDir = new File(Minecraft.func_71410_x().field_71412_D, "srpextra");
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                customDir = new File(server.func_71238_n(), "srpextra");
            } else {
                enable = false;
                return;
            }
        }
        test.check(customDir);
        if (enable) {
            SRPEFile.createListStructures(customDir, startStructureList);
        }
    }

    public static void addonStructures(File customDir, List<String> listS) {
        if (enable && addSRPExtraAddonsStructure) {
            SRPEFile.createListStructures(customDir, listS);
        }
    }

    public static void createListStructures(File customDir, List<String> listS) {
        for (String element : listS) {
            String name = element.split(";")[0];
            File fileConfig = new File(customDir, name + ".json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                if (!fileConfig.exists()) continue;
                FileReader reader = new FileReader(fileConfig);
                Throwable throwable = null;
                try {
                    int j;
                    JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    String other = null;
                    if (jsonObject.has("structure_location")) {
                        other = jsonObject.get("structure_location").getAsString();
                    }
                    JsonArray array = jsonObject.getAsJsonArray("biomes");
                    String[] bio = new String[array.size()];
                    for (int j2 = 0; j2 < bio.length; ++j2) {
                        bio[j2] = array.get(j2).getAsString();
                    }
                    array = jsonObject.getAsJsonArray("dimensions");
                    int[] dim = new int[array.size()];
                    for (int j3 = 0; j3 < dim.length; ++j3) {
                        dim[j3] = array.get(j3).getAsInt();
                    }
                    SRPEStructureUtils utils = new SRPEStructureUtils(name, jsonObject.get("type").getAsInt(), jsonObject.get("weight").getAsInt(), jsonObject.get("tier").getAsInt(), jsonObject.get("phase").getAsInt(), jsonObject.get("offsetX").getAsInt(), jsonObject.get("offsetY").getAsInt(), jsonObject.get("offsetZ").getAsInt(), dim, bio, jsonObject.get("rotation").getAsBoolean(), other);
                    if (utils.weight == -199) continue;
                    if (jsonObject.has("element_settings") && jsonObject.has("elements")) {
                        array = jsonObject.getAsJsonArray("element_settings");
                        String[] settings = new String[array.size()];
                        for (int j4 = 0; j4 < settings.length; ++j4) {
                            settings[j4] = array.get(j4).getAsString();
                        }
                        array = jsonObject.getAsJsonArray("elements");
                        String[] ele = new String[array.size()];
                        for (j = 0; j < ele.length; ++j) {
                            ele[j] = array.get(j).getAsString();
                        }
                        utils.addMassive(settings, ele);
                    }
                    boolean ttest = true;
                    if (jsonObject.has("include_entities_structure_location") && !utils.structureLocation.contains("main:server:")) {
                        ttest = jsonObject.get("include_entities_structure_location").getAsBoolean();
                    }
                    if (jsonObject.has("include_entities") && ttest) {
                        array = jsonObject.getAsJsonArray("include_entities");
                        String[] mobs = new String[array.size()];
                        for (j = 0; j < mobs.length; ++j) {
                            mobs[j] = array.get(j).getAsString();
                        }
                        utils.includeEntities = mobs;
                    }
                    WorldGenCenter.structureList.add(utils);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void check(File customDir) {
        block30: {
            if (!customDir.exists()) {
                customDir.mkdirs();
            }
            File fileConfig = new File(customDir, "config.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                if (!fileConfig.exists()) {
                    JsonArray jsonArray = new JsonArray();
                    for (String nn : startStructureList) {
                        jsonArray.add(nn.split(";")[0]);
                        this.include(customDir, nn);
                    }
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("Enable?", Boolean.valueOf(true));
                    jsonObject.addProperty("Add structures from SRPExtra addons?", Boolean.valueOf(true));
                    jsonObject.addProperty("Global Weight", (Number)100);
                    jsonObject.addProperty("Every x chunks, try to spawn a Tier 0 structure", (Number)4);
                    jsonObject.addProperty("Every x chunks, try to spawn a Tier 1 structure", (Number)8);
                    jsonObject.addProperty("Every x chunks, try to spawn a Tier 2 structure", (Number)16);
                    jsonObject.add("Structures", (JsonElement)jsonArray);
                    jsonObject.addProperty("data_version", (Number)1);
                    jsonArray = new JsonArray();
                    jsonArray.add("SRPExtra - 0.7");
                    jsonArray.add("Documentation for Structure Configuration");
                    jsonArray.add("Required Fields");
                    jsonArray.add("type (Integer(-5 - 5)) - Specifies the method for locating and spawning the structure.");
                    jsonArray.add("  -5 - Bedrock level (2).");
                    jsonArray.add("  -4 - Searches for a location from height 8 to (ocean level - 16) where there will be an air gap.");
                    jsonArray.add("  -3 - Searches for a random location from height 8 to 40.");
                    jsonArray.add("  -2 - Searches for a location beneath the seabed.");
                    jsonArray.add("  -1 - Searches for a location at ocean level where there is water.");
                    jsonArray.add("   0 - Searches for a location using the 4-point method to fit into the terrain height.");
                    jsonArray.add("   1 - Searching for a flat location for spawning.");
                    jsonArray.add("   2 - Takes the height value at sea level.");
                    jsonArray.add("   3 - Searches for a location between heights 90 and 128 with solid ground.");
                    jsonArray.add("   4 - Takes the height 64 blocks above the ground.");
                    jsonArray.add("   5 - Takes the value of world height minus 10 (246).");
                    jsonArray.add("weight (Integer) - Determines the spawn weight of the structure.");
                    jsonArray.add("tier (Integer(0 - 2)) - Specifies how frequently the structure will spawn based on its tier. Higher tiers have spawn priority.");
                    jsonArray.add("phase (Integer) - Indicates the phase of parasite evolution after which the structure can spawn.");
                    jsonArray.add("offsetX (Integer), offsetY (Integer), offsetZ (Integer) - Specifies offsets for the structure along the X, Y, and Z axes.");
                    jsonArray.add("rotation (Boolean) - Determines whether the structure will rotate randomly upon spawning.");
                    jsonArray.add("biomes (Array of Strings) - Specifies the biomes where the structure can spawn. Supports biome types and exclusion rules (e.g., !hot or !ocean).");
                    jsonArray.add("dimensions (Array of Integers) - Specifies the dimensions in which the structure can spawn.");
                    jsonArray.add("");
                    jsonArray.add("Optional Fields");
                    jsonArray.add("data_version (Integer) - Version of the date used to create the structure, allowing old versions of structure configuration files to be used in new versions.");
                    jsonArray.add("structure_location (String) - The path to the .nbt file located in the resource directory. If the structure is not found, the .nbt file will be used with the name of the .json file.");
                    jsonArray.add("element_settings (Array of Strings) - Defines parameters for structure offsets and local adjustments.");
                    jsonArray.add("  First Line: Parameters for offsetting structures (16;16;3;3) -- (16;16) - Global blending between location structures x z, OPTIONAL (3;3) - Local blending between location structures x z");
                    jsonArray.add("  Subsequent Lines: Key-value pairs, where:");
                    jsonArray.add("     Identifier for the structure ; Name of the structure to be placed.");
                    jsonArray.add("elements (Array of Arrays (Matrix)) - A customizable matrix (any size) for spawning structures.");
                    jsonArray.add("  Each cell contains two values:");
                    jsonArray.add("     Probability of spawning ; Identifier referencing element_settings.");
                    jsonArray.add("include_entities (Array of Strings) -  Specifies entities to spawn within the structures zone.");
                    jsonArray.add("  Format: (100;srparasites:rupter;3;6;0;false)");
                    jsonArray.add("     Spawn probability ;  Identifier for the entity ; Minimum number of entities to spawn ; Maximum number of entities to spawn ; Defines how the entities will spawn ; Whether the entities should despawn (doesn't work) ; Optional: (100;srparasites:rupter;3;6;0;false;bob1,bob2,bob3) - The name that will be randomly assigned to the entity.");
                    jsonArray.add("        (Defines how the entities will spawn):");
                    jsonArray.add("           -2 - Searches for a random spot within a structure at the bottom of a body of water.");
                    jsonArray.add("           -1 - Searches for a random spot within a structure on the surface of a body of water.");
                    jsonArray.add("            0 - Searches for a random location within the structure area with solid ground and a 2-block air gap.");
                    jsonArray.add("            1 - Searches for a random spot within a structure where an entity can fit.");
                    jsonArray.add("include_entities_structure_location (Boolean) -  If a structure along the path was found, should more entities be added during spawn?");
                    jsonObject.add("Description", (JsonElement)jsonArray);
                    try (FileWriter writer = new FileWriter(fileConfig);){
                        gson.toJson((JsonElement)jsonObject, (Appendable)writer);
                        break block30;
                    }
                }
                try (FileReader reader = new FileReader(fileConfig);){
                    JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    startStructureList = new ArrayList<String>();
                    addSRPExtraAddonsStructure = jsonObject.get("Add structures from SRPExtra addons?").getAsBoolean();
                    WorldGenCenter.tierZero = jsonObject.get("Every x chunks, try to spawn a Tier 0 structure").getAsInt();
                    WorldGenCenter.tierOne = jsonObject.get("Every x chunks, try to spawn a Tier 1 structure").getAsInt();
                    WorldGenCenter.tierTwo = jsonObject.get("Every x chunks, try to spawn a Tier 2 structure").getAsInt();
                    WorldGenCenter.globalWeight = jsonObject.get("Global Weight").getAsInt();
                    enable = jsonObject.get("Enable?").getAsBoolean();
                    for (JsonElement parts : jsonObject.getAsJsonArray("Structures")) {
                        startStructureList.add(parts.getAsString());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void include(File customDir, String element) {
        Throwable throwable;
        InputStream input2;
        String name = element.split(";")[0];
        String dir = element.split(";")[1];
        try {
            input2 = this.getClass().getResourceAsStream("/assets/" + dir + "/custom/" + name + ".json");
            throwable = null;
            try {
                if (input2 != null) {
                    Files.copy(input2, new File(customDir, name + ".json").toPath(), new CopyOption[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input2 != null) {
                    if (throwable != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        input2.close();
                    }
                }
            }
        }
        catch (IOException input2) {
            // empty catch block
        }
        if (element.split(";").length == 2) {
            try {
                input2 = this.getClass().getResourceAsStream("/assets/" + dir + "/custom/" + name + ".nbt");
                throwable = null;
                try {
                    if (input2 != null) {
                        Files.copy(input2, new File(customDir, name + ".nbt").toPath(), new CopyOption[0]);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (input2 != null) {
                        if (throwable != null) {
                            try {
                                input2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            input2.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

