/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.encyclopedia.data;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.encyclopedia.stats.IStatsBase;
import energon.srpextra.encyclopedia.stats.SF_Attributes;
import energon.srpextra.encyclopedia.stats.SF_LootTable;
import energon.srpextra.encyclopedia.stats.SF_MobInside;
import energon.srpextra.encyclopedia.stats.STATS_ENUM;
import energon.srpextra.encyclopedia.stats.StatsCanSpawn;
import energon.srpextra.encyclopedia.stats.StatsHaveHead;
import energon.srpextra.encyclopedia.stats.StatsHavePart;
import energon.srpextra.encyclopedia.stats.StatsNextParasite;
import energon.srpextra.encyclopedia.stats.StatsPreParasite;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.init.SRPEPhases;
import energon.srpextra.util.EParasiteType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class ParasiteDataBase {
    public static ResourceLocation PARASITE_VIEW_SHADER = new ResourceLocation("srpextra", "shaders/parasite.json");
    public static ResourceLocation DEFAULT_REG_NAME = new ResourceLocation("minecraft", "zombie");
    public static String DEFAULT_NAME = "minecraft.zombie";
    public List<IStatsBase> STATES = new ArrayList<IStatsBase>();
    public final EntityEntry parasiteEntry;
    public final int parasiteId;
    @Nonnull
    public final EParasiteType parasiteType;
    @Nonnull
    public final IESpawnRule spawnRule;

    public ParasiteDataBase(EntityEntry entityEntry, int id, @Nonnull EParasiteType type, @Nonnull IESpawnRule spawnRule) {
        this.parasiteEntry = entityEntry;
        this.parasiteId = id;
        this.parasiteType = type;
        this.spawnRule = spawnRule;
    }

    public void addState(IStatsBase state) {
        if (this.parasiteType != EParasiteType.VOID) {
            this.STATES.add(state);
        }
    }

    public void addAllStats(Collection<IStatsBase> stats) {
        if (this.parasiteType != EParasiteType.VOID) {
            this.STATES.addAll(stats);
        }
    }

    public int getParasiteId() {
        return this.parasiteId;
    }

    public ResourceLocation getRegistryName() {
        return this.parasiteEntry != null ? this.parasiteEntry.getRegistryName() : DEFAULT_REG_NAME;
    }

    public String getName() {
        return this.parasiteEntry != null ? this.parasiteEntry.getName() : DEFAULT_NAME;
    }

    public String getTranslatedName() {
        return I18n.func_74838_a((String)this.getName());
    }

    public Class<? extends Entity> getEntityClass() {
        return this.parasiteEntry != null ? this.parasiteEntry.getEntityClass() : EntityZombie.class;
    }

    public Entity getEntity(World world) {
        return this.parasiteEntry != null ? this.parasiteEntry.newInstance(world) : new EntityZombie(world);
    }

    public float getHealth() {
        IStatsBase state = this.getStatsByType(STATS_ENUM.ATTRIBUTES);
        return state != null ? ((SF_Attributes)state).getHealth() : 1.0f;
    }

    public float getMoveSpeed() {
        IStatsBase state = this.getStatsByType(STATS_ENUM.ATTRIBUTES);
        return state != null ? ((SF_Attributes)state).getMovementSpeed() : 0.2f;
    }

    @Nullable
    public IStatsBase getStatsByType(STATS_ENUM type) {
        for (IStatsBase stats : this.STATES) {
            if (!stats.getStateType().equals(type)) continue;
            return stats;
        }
        return null;
    }

    public boolean isWaterParasite() {
        return this.spawnRule.isWaterMob();
    }

    public int getCountNaturalTransformForPhaseSpawn() {
        IStatsBase rule = this.getStatsByType(STATS_ENUM.CAN_SPAWN);
        if (rule != null) {
            return ((StatsCanSpawn)rule).transformCountForNaturalSpawn();
        }
        return -1;
    }

    public byte getTransformDataID() {
        IStatsBase rule = this.getStatsByType(STATS_ENUM.CAN_SPAWN);
        if (rule != null) {
            Byte trID = ((StatsCanSpawn)rule).getTransformEntityID();
            return trID != null ? trID : (byte)this.parasiteId;
        }
        return (byte)this.parasiteId;
    }

    public void spawnMobInside(EntityLivingBase summoner) {
        IStatsBase stats = this.getStatsByType(STATS_ENUM.MOB_INSIDE);
        if (stats != null) {
            ((SF_MobInside)stats).spawnMobInside(summoner, this);
        }
        if ((stats = this.getStatsByType(STATS_ENUM.HAVE_HEAD)) != null) {
            ((StatsHaveHead)stats).spawnHead(summoner, this);
        }
    }

    public void spawnDeathLoot(EntityLivingBase summoner) {
        IStatsBase stats = this.getStatsByType(STATS_ENUM.LOOT_TABLE);
        if (stats != null) {
            ((SF_LootTable)stats).spawnLootTable(summoner, this);
        }
    }

    public void addBaseAttributes(EntityLivingBase entity) {
        IStatsBase stats = this.getStatsByType(STATS_ENUM.ATTRIBUTES);
        if (stats != null) {
            ((SF_Attributes)stats).addAttributes(entity);
        } else {
            entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(5.0f * SRPConfig.globalDamageMultiplier));
            entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)(1.0f * SRPConfig.globalArmorMultiplier));
            entity.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(1.0);
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.3 * (double)SRPConfig.globalKDResistanceMultiplier);
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(12.0f * SRPConfig.globalHealthMultiplier));
        }
    }

    public void initParasiteView() {
        ClientRegistry.registerEntityShader(this.getEntityClass(), (ResourceLocation)PARASITE_VIEW_SHADER);
    }

    public void addPhaseSpawnValue(SRPEPhases.PhaseUtilsValues value) {
    }

    @Nullable
    public EntityParasiteBase getPreVersion(Entity summoner) {
        Entity entity;
        IStatsBase state = this.getStatsByType(STATS_ENUM.PRE_PARASITE);
        if (state != null && (entity = ((StatsPreParasite)state).getEntity(summoner.field_70170_p)) instanceof EntityParasiteBase) {
            return (EntityParasiteBase)entity;
        }
        return null;
    }

    @Nullable
    public EntityParasiteBase getNextVersion(Entity summoner) {
        Entity entity;
        IStatsBase state = this.getStatsByType(STATS_ENUM.NEXT_PARASITE);
        if (state != null && (entity = ((StatsNextParasite)state).getEntity(summoner.field_70170_p)) instanceof EntityParasiteBase) {
            return (EntityParasiteBase)entity;
        }
        return null;
    }

    public void initEntity_PRE(EntityParasiteBase entity) {
        IStatsBase state = this.getStatsByType(STATS_ENUM.ATTRIBUTES);
        if (state != null) {
            ((SF_Attributes)state).addCustomStats(entity);
        }
    }

    public void initEntity_AI(EntityParasiteBase entity) {
        IStatsBase state = this.getStatsByType(STATS_ENUM.ATTRIBUTES);
        if (state != null) {
            ((SF_Attributes)state).addCustomAI(entity);
        }
    }

    @Nullable
    public ParasiteDataBase getPartEntity() {
        IStatsBase state = this.getStatsByType(STATS_ENUM.PART);
        if (state != null) {
            return ((StatsHavePart)state).part;
        }
        return null;
    }
}

