/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAdapted;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAncient;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPCosmical;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPCrude;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPFeral;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPHijacked;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPMalleable;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPreeminent;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPrimitive;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPure;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationary;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import energon.srpextra.Main;
import energon.srpextra.config.SRPEConfigSystem;
import energon.srpextra.entity.ICustomRemains;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.entity.IParasite;
import energon.srpextra.entity.ISRPExtraEntity;
import energon.srpextra.entity.IWaterParasite;
import energon.srpextra.entity.adapted.IAdapted;
import energon.srpextra.entity.ancient.IAncient;
import energon.srpextra.entity.awakened.IAwakened;
import energon.srpextra.entity.crude.ICrude;
import energon.srpextra.entity.derived.IDerived;
import energon.srpextra.entity.deterrent.IDeterrent;
import energon.srpextra.entity.deterrent.INexus;
import energon.srpextra.entity.feral.IFeral;
import energon.srpextra.entity.head.IHead;
import energon.srpextra.entity.hijacked.IHijacked;
import energon.srpextra.entity.inborn.IInborn;
import energon.srpextra.entity.infected.IInfected;
import energon.srpextra.entity.primitive.IPrimitive;
import energon.srpextra.entity.pure.IPreeminent;
import energon.srpextra.entity.pure.IPure;
import energon.srpextra.entity.tendril.ITendril;
import energon.srpextra.inject.CotesiaInject;
import energon.srpextra.network.SRPEPacketHandler;
import energon.srpextra.util.EParasiteType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class Utilities {
    private static String getButParts() {
        return I18n.func_74838_a((String)"srpextra.parasite_type_but");
    }

    public static String getStrParasiteType(EntityParasiteBase parasiteBase) {
        if (parasiteBase instanceof ISRPExtraEntity) {
            if (parasiteBase instanceof IAdapted) {
                if (parasiteBase instanceof EntityPAdapted) {
                    return EParasiteType.ADAPTIVE.getTranslateName();
                }
                return EParasiteType.ADAPTIVE.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IPrimitive) {
                if (parasiteBase instanceof EntityPPrimitive) {
                    return EParasiteType.PRIMITIVE.getTranslateName();
                }
                return EParasiteType.PRIMITIVE.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IInfected) {
                if (parasiteBase instanceof EntityPInfected) {
                    return EParasiteType.INFECTED.getTranslateName();
                }
                return " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IInborn) {
                return EParasiteType.INBORN.getTranslateName();
            }
            if (parasiteBase instanceof IHijacked) {
                if (parasiteBase instanceof EntityPHijacked) {
                    return EParasiteType.HIJACKED.getTranslateName();
                }
                return EParasiteType.HIJACKED.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IFeral) {
                if (parasiteBase instanceof EntityPFeral) {
                    return EParasiteType.FERAL.getTranslateName();
                }
                return EParasiteType.FERAL.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof INexus) {
                if (parasiteBase instanceof EntityPStationaryArchitect) {
                    return EParasiteType.NEXUS.getTranslateName();
                }
                return EParasiteType.NEXUS.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IDeterrent) {
                if (parasiteBase instanceof EntityPStationary) {
                    return EParasiteType.DETERRENT.getTranslateName();
                }
                return EParasiteType.DETERRENT.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IPreeminent) {
                if (parasiteBase instanceof EntityPPreeminent) {
                    return EParasiteType.PREEMINENT.getTranslateName();
                }
                return EParasiteType.PREEMINENT.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IPure) {
                if (parasiteBase instanceof EntityPPure) {
                    return EParasiteType.PURE.getTranslateName();
                }
                return EParasiteType.PURE.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof ICrude) {
                if (parasiteBase instanceof EntityPCrude) {
                    return EParasiteType.CRUDE.getTranslateName();
                }
                return EParasiteType.CRUDE.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IAwakened || parasiteBase instanceof IAncient) {
                if (parasiteBase instanceof EntityPAncient) {
                    return EParasiteType.ANCIENT.getTranslateName();
                }
                return EParasiteType.ANCIENT.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof IDerived) {
                if (parasiteBase instanceof EntityPCosmical) {
                    return EParasiteType.DERIVED.getTranslateName();
                }
                return EParasiteType.DERIVED.getTranslateName() + Utilities.getButParts() + " " + Utilities.getStrTrueParasiteType(parasiteBase);
            }
            if (parasiteBase instanceof ITendril) {
                return EParasiteType.TENDRIL.getTranslateName();
            }
            if (parasiteBase instanceof IHead) {
                return EParasiteType.HEAD.getTranslateName();
            }
        }
        return Utilities.getStrTrueParasiteType(parasiteBase);
    }

    public static String getStrTrueParasiteType(EntityParasiteBase parasiteBase) {
        return EParasiteType.getTrueParasiteType(parasiteBase).getTranslateName();
    }

    public static NonNullList<ItemStack> lootBlockDrop(NonNullList<ItemStack> drops, int maxRandom, String[] lootTable, Random random) {
        int randomNum = random.nextInt(maxRandom);
        int num = 0;
        Item item = null;
        for (String roll : lootTable) {
            String[] parts = roll.trim().split(",");
            if (randomNum >= (num += Integer.parseInt(parts[0]))) continue;
            for (int i = 1; i < parts.length; ++i) {
                String[] loot = parts[i].split(";");
                if (loot.length != 5 || random.nextInt(100) >= Integer.parseInt(loot[0]) || (item = Item.func_111206_d((String)loot[1])) == null) continue;
                int count = random.nextInt(Math.abs(Integer.parseInt(loot[3]) - Integer.parseInt(loot[4])) + 1) + Integer.parseInt(loot[4]);
                drops.add((Object)new ItemStack(item, count, Integer.parseInt(loot[2])));
            }
            break;
        }
        return drops;
    }

    public static void lootEntityDeathDrop(Entity entity, String[] lootTable, int maxRoll, boolean oneTypeItem, Random random) {
        for (String lootString : lootTable) {
            int max;
            int randomNum = random.nextInt(maxRoll);
            Item item = null;
            Object[] parts = lootString.trim().split(";");
            if (parts.length != 5) {
                System.out.println(Arrays.toString(parts));
                continue;
            }
            if (randomNum >= Integer.parseInt((String)parts[0]) || (item = Item.func_111206_d((String)parts[1])) == null) continue;
            int min = Integer.parseInt((String)parts[4]);
            int count = min < (max = Integer.parseInt((String)parts[3])) ? min + random.nextInt(max - min + 1) : max + random.nextInt(min - max + 1);
            entity.func_70099_a(new ItemStack(item, count, Integer.parseInt((String)parts[2])), 0.1f);
            if (!oneTypeItem) continue;
            return;
        }
    }

    public static void ADVANCEDLootEntityDeathDrop(EntityParasiteBase entity, @Nullable String[] lootTable, int maxRoll, boolean oneTypeItem, Random random) {
        if (lootTable == null) {
            return;
        }
        for (String lootString : lootTable) {
            int max;
            int randomNum = random.nextInt(maxRoll);
            Item item = null;
            String[] parts = lootString.trim().split(";");
            if (parts.length != 5 && parts.length != 6) continue;
            boolean test = false;
            if (parts.length == 6) {
                String[] skins;
                for (String hhh : skins = parts[5].split(",")) {
                    if (Integer.parseInt(hhh) != entity.getSkin()) continue;
                    test = true;
                    break;
                }
            } else {
                test = true;
            }
            if (randomNum >= Integer.parseInt(parts[0]) || !test || (item = Item.func_111206_d((String)parts[1])) == null) continue;
            int min = Integer.parseInt(parts[4]);
            int count = min < (max = Integer.parseInt(parts[3])) ? min + random.nextInt(max - min + 1) : max + random.nextInt(min - max + 1);
            entity.func_70099_a(new ItemStack(item, count, Integer.parseInt(parts[2])), 0.1f);
            if (!oneTypeItem) continue;
            return;
        }
    }

    public static void summonMinionsListVelocity(World world, Entity summoner, String[] listMinions, String[] listEffects, boolean oneEffect, int rangeSpawnMinions, boolean oneMinion, Random random, double VX, double VY, double VZ) {
        for (String minions : listMinions) {
            int max;
            Object[] parts = minions.split(";");
            if (parts.length != 4) {
                System.out.println(Arrays.toString(parts) + " - CustomSummon > summonMinionsListVelocity > Error Length");
                continue;
            }
            if (random.nextInt(100) >= Integer.parseInt((String)parts[0])) continue;
            int min = Integer.parseInt((String)parts[3]);
            int count = min < (max = Integer.parseInt((String)parts[2])) ? min + random.nextInt(max - min + 1) : (min != max ? max + random.nextInt(min - max + 1) : min);
            for (int i = 0; i < count; ++i) {
                Entity minion = EntityList.func_188429_b((ResourceLocation)new ResourceLocation((String)parts[1]), (World)world);
                if (!(minion instanceof EntityLivingBase)) continue;
                EntityLivingBase entityEffect = Utilities.applyEffectList((EntityLivingBase)minion, listEffects, oneEffect, random);
                entityEffect.func_82149_j(summoner);
                entityEffect.func_70107_b(summoner.field_70165_t + (double)random.nextInt(rangeSpawnMinions * 2 + 1) - (double)rangeSpawnMinions, summoner.field_70163_u + 0.5, summoner.field_70161_v + (double)random.nextInt(rangeSpawnMinions * 2 + 1) - (double)rangeSpawnMinions);
                entityEffect.func_70024_g((random.nextDouble() - 0.5) * VX, random.nextDouble() * 0.7 * VY, (random.nextDouble() - 0.5) * VZ);
                world.func_72838_d((Entity)entityEffect);
            }
            if (!oneMinion) continue;
            return;
        }
    }

    public static void summonMinionsListVelocityOffset(World world, Entity summoner, float offsetY, String[] listMinions, String[] listEffects, boolean oneEffect, int rangeSpawnMinions, boolean oneMinion, Random random, double VX, double VY, double VZ) {
        for (String minions : listMinions) {
            int max;
            Object[] parts = minions.split(";");
            if (parts.length != 4) {
                System.out.println(Arrays.toString(parts) + " - CustomSummon > summonMinionsListVelocity > Error Length");
                continue;
            }
            if (random.nextInt(100) >= Integer.parseInt((String)parts[0])) continue;
            int min = Integer.parseInt((String)parts[3]);
            int count = min < (max = Integer.parseInt((String)parts[2])) ? min + random.nextInt(max - min + 1) : (min != max ? max + random.nextInt(min - max + 1) : min);
            for (int i = 0; i < count; ++i) {
                Entity minion = EntityList.func_188429_b((ResourceLocation)new ResourceLocation((String)parts[1]), (World)world);
                if (!(minion instanceof EntityLivingBase)) continue;
                EntityLivingBase entityEffect = Utilities.applyEffectList((EntityLivingBase)minion, listEffects, oneEffect, random);
                entityEffect.func_82149_j(summoner);
                entityEffect.func_70107_b(summoner.field_70165_t + (double)random.nextInt(rangeSpawnMinions * 2 + 1) - (double)rangeSpawnMinions, summoner.field_70163_u + 0.5 + (double)offsetY, summoner.field_70161_v + (double)random.nextInt(rangeSpawnMinions * 2 + 1) - (double)rangeSpawnMinions);
                entityEffect.func_70024_g((random.nextDouble() - 0.5) * VX, random.nextDouble() * 0.7 * VY, (random.nextDouble() - 0.5) * VZ);
                world.func_72838_d((Entity)entityEffect);
            }
            if (!oneMinion) continue;
            return;
        }
    }

    public static EntityLivingBase applyEffectList(EntityLivingBase entityLivingBase, String[] listEffects, boolean oneEffect, Random rand) {
        for (String minionEffect : listEffects) {
            Potion potion;
            Object[] parts3 = minionEffect.split(";");
            if (parts3.length != 7) {
                System.out.println(Arrays.toString(parts3) + " - CustomSummon > applyEffectList > Error Length");
                continue;
            }
            if (rand.nextInt(100) >= Integer.parseInt((String)parts3[0]) || (potion = Potion.func_180142_b((String)parts3[1])) == null) continue;
            int effectLevel = rand.nextInt(Math.abs(Integer.parseInt((String)parts3[2]) - Integer.parseInt((String)parts3[3])) + 1) + Integer.parseInt((String)parts3[3]);
            int effectTime = rand.nextInt(Math.abs(Integer.parseInt((String)parts3[4]) - Integer.parseInt((String)parts3[5])) + 1) + Integer.parseInt((String)parts3[5]);
            entityLivingBase.func_70690_d(new PotionEffect(potion, effectTime, effectLevel, Boolean.parseBoolean((String)parts3[6]), false));
            if (!oneEffect) continue;
            return entityLivingBase;
        }
        return entityLivingBase;
    }

    public static void applyEffectListFF(EntityLivingBase entityLivingBase, String[] listEffects, boolean oneEffect, Random rand) {
        for (String minionEffect : listEffects) {
            Potion potion;
            Object[] parts3 = minionEffect.split(";");
            if (parts3.length != 7) {
                System.out.println(Arrays.toString(parts3) + " - CustomSummon > applyEffectList > Error Length");
                continue;
            }
            if (rand.nextInt(100) >= Integer.parseInt((String)parts3[0]) || (potion = Potion.func_180142_b((String)parts3[1])) == null) continue;
            int effectLevel = rand.nextInt(Math.abs(Integer.parseInt((String)parts3[2]) - Integer.parseInt((String)parts3[3])) + 1) + Integer.parseInt((String)parts3[3]);
            int effectTime = rand.nextInt(Math.abs(Integer.parseInt((String)parts3[4]) - Integer.parseInt((String)parts3[5])) + 1) + Integer.parseInt((String)parts3[5]);
            entityLivingBase.func_70690_d(new PotionEffect(potion, effectTime, effectLevel, Boolean.parseBoolean((String)parts3[6]), false));
            if (!oneEffect) continue;
            return;
        }
    }

    public static int SRPEGetMergePoint(String name) {
        for (String element : SRPConfigSystems.mergeInfValues) {
            String[] parts = element.split(";");
            if (!parts[0].equals(name) || parts.length != 2) continue;
            return Integer.parseInt(parts[1]);
        }
        return 0;
    }

    public static int SRPEGetAquaMergePoint(String name) {
        for (String element : SRPEConfigSystem.mergeAquaInfValues) {
            String[] parts = element.split(";");
            if (!parts[0].equals(name) || parts.length != 2) continue;
            return Integer.parseInt(parts[1]);
        }
        return 0;
    }

    public static void SRPESpawnNext(EntityParasiteBase entityin, EntityParasiteBase entityout, boolean effects, boolean thunder) {
        if (!entityin.field_70128_L && entityout != null) {
            boolean flag = entityin.func_70027_ad();
            entityout.func_82149_j((Entity)entityin);
            entityout.func_180482_a(entityin.field_70170_p.func_175649_E(new BlockPos((Entity)entityout)), null);
            if (entityout instanceof ICustomRemains) {
                ((ICustomRemains)entityout).clearInv();
            }
            entityout.cannotDespawn(entityin.func_70692_ba());
            if (entityin.func_145818_k_()) {
                entityout.func_96094_a(entityin.func_95999_t());
                entityout.func_174805_g(entityin.func_174833_aM());
            }
            entityin.field_70170_p.func_72838_d((Entity)entityout);
            entityin.func_70106_y();
            if (entityin instanceof EntityPMalleable && entityout instanceof EntityPMalleable) {
                ((EntityPMalleable)entityout).copyResistancesFrom((EntityPMalleable)entityin);
            }
            if (effects) {
                entityout.particleStatus((byte)7);
            }
            if (thunder && SRPConfig.thunderEnable) {
                entityout.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entityout.field_70170_p, entityout.field_70165_t, entityout.field_70163_u, entityout.field_70161_v, true));
            }
            if (flag) {
                entityout.func_70606_j(entityout.func_110138_aP() * 0.5f);
                entityout.func_70015_d(8);
            }
        }
    }

    public static void summonMobList(World world, BlockPos pos, String[] listMinions, Random random, int strSizeX, int strSizeY, int strSizeZ) {
        for (String minions : listMinions) {
            String[] parts = minions.split(";");
            if (parts.length < 6 || random.nextInt(100) >= Integer.parseInt(parts[0])) continue;
            int countMinions = random.nextInt(Math.abs(Integer.parseInt(parts[3]) - Integer.parseInt(parts[2])) + 1) + Integer.parseInt(parts[2]);
            for (int i = 0; i < countMinions; ++i) {
                BlockPos entityPos;
                Entity minion = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(parts[1]), (World)world);
                if (!(minion instanceof EntityLiving) || (entityPos = Utilities.getRandomPos(world, pos, Integer.parseInt(parts[4]), random, strSizeX, strSizeY, strSizeZ)) == null) continue;
                EntityLiving entity = (EntityLiving)minion;
                entity.func_180482_a(world.func_175649_E(pos), null);
                if (!Boolean.parseBoolean(parts[5])) {
                    entity.func_110163_bv();
                }
                if (parts.length > 6) {
                    String[] name = parts[6].split(",");
                    entity.func_96094_a(name[random.nextInt(name.length)]);
                    entity.func_174805_g(false);
                }
                entity.func_70080_a((double)entityPos.func_177958_n() + 0.5, (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entity);
            }
        }
    }

    @Nullable
    private static BlockPos getRandomPos(World world, BlockPos pos, int type, Random random, int strSizeX, int strSizeY, int strSizeZ) {
        switch (type) {
            case 0: {
                return Utilities.zeroGRP(world, pos, random, strSizeX, strSizeY, strSizeZ, 30);
            }
            case 1: {
                return Utilities.oneGRP(world, pos, random, strSizeX, strSizeY, strSizeZ, 10);
            }
            case -1: {
                return Utilities.aquaGRP(world, pos, random, strSizeX, strSizeY, strSizeZ, 30);
            }
            case -2: {
                return Utilities.belowGRP(world, pos, random, strSizeX, strSizeY, strSizeZ, 30);
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos oneGRP(World world, BlockPos pos, Random random, int strSizeX, int strSizeY, int strSizeZ, int lucky) {
        for (int i = 0; i < lucky; ++i) {
            int z;
            int y;
            int x = random.nextInt(strSizeX);
            if (!world.func_180495_p(pos.func_177982_a(x, y = random.nextInt(strSizeY), z = random.nextInt(strSizeZ))).func_185904_a().func_76222_j() || world.func_180495_p(pos.func_177982_a(x, y, z)).func_185914_p() || !world.func_175623_d(pos.func_177982_a(x, y + 1, z))) continue;
            return pos.func_177982_a(x, y, z);
        }
        return null;
    }

    @Nullable
    public static BlockPos zeroGRP(World world, BlockPos pos, Random random, int strSizeX, int strSizeY, int strSizeZ, int lucky) {
        for (int i = 0; i < lucky; ++i) {
            int z;
            int y;
            int x = random.nextInt(strSizeX);
            if (!world.func_180495_p(pos.func_177982_a(x, y = random.nextInt(strSizeY), z = random.nextInt(strSizeZ))).func_185904_a().func_76222_j() || !world.func_180495_p(pos.func_177982_a(x, y - 1, z)).func_185914_p() || world.func_180495_p(pos.func_177982_a(x, y, z)).func_185914_p() || !world.func_175623_d(pos.func_177982_a(x, y + 1, z))) continue;
            return pos.func_177982_a(x, y, z);
        }
        return null;
    }

    @Nullable
    public static BlockPos aquaGRP(World world, BlockPos pos, Random random, int strSizeX, int strSizeY, int strSizeZ, int lucky) {
        for (int i = 0; i < lucky; ++i) {
            int z;
            int y;
            int x = random.nextInt(strSizeX);
            if (!world.func_180495_p(pos.func_177982_a(x, (y = random.nextInt(strSizeY)) - 1, z = random.nextInt(strSizeZ))).func_185904_a().func_76224_d() || !world.func_180495_p(pos.func_177982_a(x, y, z)).func_185904_a().func_76224_d() || !world.func_175623_d(pos.func_177982_a(x, y + 1, z))) continue;
            return pos.func_177982_a(x, y, z);
        }
        return null;
    }

    @Nullable
    public static BlockPos belowGRP(World world, BlockPos pos, Random random, int strSizeX, int strSizeY, int strSizeZ, int lucky) {
        for (int i = 0; i < lucky; ++i) {
            int z;
            int y;
            int x = random.nextInt(strSizeX);
            if (!world.func_180495_p(pos.func_177982_a(x, (y = random.nextInt(strSizeY)) - 1, z = random.nextInt(strSizeZ))).func_185914_p() || !world.func_180495_p(pos.func_177982_a(x, y, z)).func_185904_a().func_76224_d() || !world.func_180495_p(pos.func_177982_a(x, y + 1, z)).func_185904_a().func_76224_d()) continue;
            return pos.func_177982_a(x, y, z);
        }
        return null;
    }

    public static boolean checkCountParasites(World world, int startValue) {
        for (Entity entity : world.field_72996_f) {
            if (!(entity instanceof EntityParasiteBase)) continue;
            ++startValue;
        }
        return SRPConfig.worldMobCap + world.field_73010_i.size() * SRPConfig.worldMobCapPlusPlayer > startValue;
    }

    public static boolean checkCountAquaParasites(World world, int startValue) {
        for (Entity entity : world.field_72996_f) {
            if (!(entity instanceof IWaterParasite)) continue;
            ++startValue;
        }
        return SRPEConfigSystem.worldAquaMobCap + world.field_73010_i.size() * SRPEConfigSystem.worldAquaMobCapPlusPlayer > startValue;
    }

    public static boolean checkBiomeType(Biome biome, String typeName) {
        BiomeDictionary.Type type = null;
        for (BiomeDictionary.Type test : BiomeDictionary.Type.getAll()) {
            if (!typeName.equalsIgnoreCase(test.getName())) continue;
            type = test;
            break;
        }
        return type != null && BiomeDictionary.hasType((Biome)biome, type);
    }

    @Nullable
    public static BlockPos getRandomTeleportationPosition(@Nonnull BlockPos start, World world, @Nonnull IESpawnRule rule, int xzDiameter, int yDiameter, int maxYTest, Random random) {
        return Utilities.getRandomTeleportationPosition(start, world, rule, xzDiameter, yDiameter, maxYTest, random, 3, world.func_72800_K());
    }

    @Nullable
    public static BlockPos getRandomTeleportationPosition(@Nonnull BlockPos start, World world, @Nonnull IESpawnRule rule, int xzDiameter, int yDiameter, int maxYTest, Random random, int minHeight, int maxHeight) {
        start = start.func_177963_a(((double)random.nextFloat() - 0.5) * (double)xzDiameter, ((double)random.nextFloat() - 0.5) * (double)yDiameter, ((double)random.nextFloat() - 0.5) * (double)xzDiameter);
        int yTest = start.func_177956_o();
        maxYTest *= maxYTest;
        int y = 0;
        int step = 1;
        while (y * y < maxYTest) {
            int n = y = step % 2 == 0 ? -step / 2 : step / 2;
            if (minHeight < y + yTest && y + yTest < maxHeight) {
                switch (rule.canSpawnHere(world, start.func_177981_b(y), (byte)0)) {
                    case 1: {
                        return start.func_177981_b(y);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            ++step;
        }
        return null;
    }

    @Nullable
    public static BlockPos getRandomTeleportationPosition(@Nonnull BlockPos start, World world, @Nonnull IESpawnRule rule, int xzRadius, int yDiameter, int maxYTest, int xzMinDistanceFromCenter, Random random) {
        return Utilities.getRandomTeleportationPosition(start, world, rule, xzRadius, yDiameter, maxYTest, xzMinDistanceFromCenter, random, 3, world.func_72800_K());
    }

    @Nullable
    public static BlockPos getRandomTeleportationPosition(@Nonnull BlockPos start, World world, @Nonnull IESpawnRule rule, int xzRadius, int yDiameter, int maxYTest, int xzMinDistanceFromCenter, Random random, int minHeight, int maxHeight) {
        int posX = random.nextInt(xzRadius) * (random.nextBoolean() ? -1 : 1);
        int posZ = posX * posX > xzMinDistanceFromCenter * xzMinDistanceFromCenter ? random.nextInt(xzRadius) * (random.nextBoolean() ? -1 : 1) : (xzMinDistanceFromCenter + random.nextInt(Math.max(xzRadius - xzMinDistanceFromCenter, 1))) * (random.nextBoolean() ? -1 : 1);
        start = start.func_177963_a((double)posX, ((double)random.nextFloat() - 0.5) * (double)yDiameter, (double)posZ);
        int yTest = start.func_177956_o();
        maxYTest *= maxYTest;
        int y = 0;
        int step = 1;
        while (y * y < maxYTest) {
            int n = y = step % 2 == 0 ? -step / 2 : step / 2;
            if (minHeight < y + yTest && y + yTest < maxHeight) {
                switch (rule.canSpawnHere(world, start.func_177981_b(y), (byte)0)) {
                    case 1: {
                        return start.func_177981_b(y);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
            ++step;
        }
        return null;
    }

    public static List<EntityLivingBase> getTargetInZone(EntityLivingBase entity, float angle, float offset, float offsetY, float radius, float height) {
        double yawRad = Math.toRadians(entity.field_70177_z + angle);
        double offsetX = -MathHelper.func_76126_a((float)((float)yawRad)) * offset;
        double offsetZ = MathHelper.func_76134_b((float)((float)yawRad)) * offset;
        double X = entity.field_70165_t + offsetX;
        double Y = entity.field_70163_u + (double)offsetY;
        double Z = entity.field_70161_v + offsetZ;
        SRPEPacketHandler.spawnParticleBox(entity.field_71093_bK, X, Y, Z, radius, height, 0);
        return entity.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(X - (double)radius, Y, Z - (double)radius, X + (double)radius, Y + (double)height, Z + (double)radius), target -> {
            if (Main.srpcotesia && CotesiaInject.isParasite(target)) {
                return false;
            }
            return !(target instanceof EntityParasiteBase) && !(target instanceof IParasite) && target.func_70089_S() && entity.func_70685_l((Entity)target);
        });
    }

    public static EntityLivingBase getNearestRandomEntity(EntityLivingBase entity, int radius, int height) {
        List mobs = entity.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u - (double)height, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + (double)height, entity.field_70161_v + (double)radius), test -> !(test instanceof EntityPlayer) && test != entity);
        return mobs.isEmpty() ? null : (EntityLivingBase)mobs.get(entity.func_70681_au().nextInt(mobs.size()));
    }

    public static AxisAlignedBB getBox(Entity entity, int radius, int height) {
        return new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u - (double)height, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + (double)height, entity.field_70161_v + (double)radius);
    }
}

