/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.encyclopedia;

import com.dhanantry.scapeandrunparasites.entity.monster.crude.EntityLesh;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerBear;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerCow;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerEnderman;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerHorse;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerPig;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.hijacked.EntityHiGolem;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityMudo;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityDorpa;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfBear;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfCow;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfDragonE;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfEnderman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHorse;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPig;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPlayer;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSquid;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfCowHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfDragonEHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfEndermanHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfHorseHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfHumanHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfPigHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfPlayerHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfSheepHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfVillagerHead;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfWolfHead;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityIki;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityLum;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityWymo;
import com.dhanantry.scapeandrunparasites.init.SRPEntities;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.encyclopedia.stats.StatsCanSpawn;
import energon.srpextra.encyclopedia.stats.StatsFerPre;
import energon.srpextra.encyclopedia.stats.StatsHaveHead;
import energon.srpextra.encyclopedia.stats.StatsInfNext;
import energon.srpextra.encyclopedia.stats.StatsIsHead;
import energon.srpextra.encyclopedia.stats.StatsLootTable_FromSRP;
import energon.srpextra.encyclopedia.stats.StatsMobInside_FromSRP;
import energon.srpextra.encyclopedia.stats.StatsNextParasite;
import energon.srpextra.encyclopedia.stats.StatsPreParasite;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.util.EParasiteType;
import energon.srpextra.util.preset.SRPEEntitySpawnRules;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class ParasiteDataHandler {
    public static List<ParasiteDataBase> PARASITES = new ArrayList<ParasiteDataBase>();
    public static ParasiteDataBase EXAMPLE = new ParasiteDataBase(null, -999999, EParasiteType.VOID, SRPEEntitySpawnRules.RULE_TWO);
    public static ParasiteDataBase INF_EVOKER;
    public static ParasiteDataBase INF_VINDICATOR;
    public static ParasiteDataBase INF_VINDICATOR_HEAD;
    public static ParasiteDataBase INF_WITCH;
    public static ParasiteDataBase INF_WITCH_HEAD;
    public static ParasiteDataBase INF_OCELOT;
    public static ParasiteDataBase INF_OCELOT_HEAD;
    public static ParasiteDataBase HI_CREEPER;
    public static ParasiteDataBase HI_CREEPER_HEAD;
    public static ParasiteDataBase HI_SKELETON;
    public static ParasiteDataBase HI_SKELETON_HEAD;
    public static ParasiteDataBase HI_SKELETON_STRAY;
    public static ParasiteDataBase FER_PLAYER;
    public static ParasiteDataBase FER_WOLF;
    public static ParasiteDataBase FER_OCELOT;
    public static ParasiteDataBase FER_WITCH;
    public static ParasiteDataBase CRUDE_LESH_AQUA;
    public static ParasiteDataBase CRUDE_WENDIGO;
    public static ParasiteDataBase PRI_STALKER;
    public static ParasiteDataBase ADA_STALKER;
    public static ParasiteDataBase ADA_VERMIN;
    public static ParasiteDataBase ADA_TOZOON;
    public static ParasiteDataBase TENDRIL_WUMO;
    public static ParasiteDataBase TENDRIL_STALKER;
    public static ParasiteDataBase REMAIN_AQUA;
    public static ParasiteDataBase GORE_AQUA;
    public static ParasiteDataBase DORPA;
    public static ParasiteDataBase INF_BEAR;
    public static ParasiteDataBase FER_BEAR;
    public static ParasiteDataBase INF_COW;
    public static ParasiteDataBase INF_COW_HEAD;
    public static ParasiteDataBase FER_COW;
    public static ParasiteDataBase INF_DRAGON;
    public static ParasiteDataBase INF_DRAGON_HEAD;
    public static ParasiteDataBase INF_ENDERMAN;
    public static ParasiteDataBase INF_ENDERMAN_HEAD;
    public static ParasiteDataBase FER_ENDERMAN;
    public static ParasiteDataBase INF_HORSE;
    public static ParasiteDataBase INF_HORSE_HEAD;
    public static ParasiteDataBase FER_HORSE;
    public static ParasiteDataBase INF_HUMAN;
    public static ParasiteDataBase INF_HUMAN_HEAD;
    public static ParasiteDataBase FER_HUMAN;
    public static ParasiteDataBase INF_PIG;
    public static ParasiteDataBase INF_PIG_HEAD;
    public static ParasiteDataBase FER_PIG;
    public static ParasiteDataBase INF_PLAYER;
    public static ParasiteDataBase INF_PLAYER_HEAD;
    public static ParasiteDataBase INF_SHEEP;
    public static ParasiteDataBase INF_SHEEP_HEAD;
    public static ParasiteDataBase FER_SHEEP;
    public static ParasiteDataBase INF_SQUID;
    public static ParasiteDataBase INF_VILLAGER;
    public static ParasiteDataBase INF_VILLAGER_HEAD;
    public static ParasiteDataBase FER_VILLAGER;
    public static ParasiteDataBase INF_WOLF;
    public static ParasiteDataBase INF_WOLF_HEAD;
    public static ParasiteDataBase HI_GOLEM;
    public static ParasiteDataBase PRI_VERMIN;
    public static ParasiteDataBase PRI_TOZOON;
    public static ParasiteDataBase PRI_LUM;
    public static ParasiteDataBase CRUDE_LESH;
    public static ParasiteDataBase RUPTER;

    @Nonnull
    public static ParasiteDataBase getParasiteDataByRegName(String regName) {
        for (ParasiteDataBase data : PARASITES) {
            if (!data.getRegistryName().toString().equals(regName)) continue;
            return data;
        }
        return EXAMPLE;
    }

    @Nullable
    public static ParasiteDataBase getParasiteDataByRegNameTrue(String regName) {
        for (ParasiteDataBase data : PARASITES) {
            if (!data.getRegistryName().toString().equals(regName)) continue;
            return data;
        }
        return null;
    }

    @Nonnull
    public static ParasiteDataBase getParasiteDataByClass(Class<?> entityClass) {
        for (ParasiteDataBase data : PARASITES) {
            if (data.getEntityClass() != entityClass) continue;
            return data;
        }
        return EXAMPLE;
    }

    @Nullable
    public static ParasiteDataBase getParasiteDataByClassTrue(Class<?> entityClass) {
        for (ParasiteDataBase data : PARASITES) {
            if (data.getEntityClass() != entityClass) continue;
            return data;
        }
        return null;
    }

    @Nonnull
    private static ParasiteDataBase createDataForSRPEntity(Class<?> entityClass, int id, @Nonnull EParasiteType type, @Nonnull IESpawnRule spawnRule) {
        for (EntityEntry entry : SRPEntities.SRPENTITIES) {
            if (entry.getEntityClass() != entityClass) continue;
            ParasiteDataBase dataBase = new ParasiteDataBase(entry, id, type, spawnRule);
            PARASITES.add(dataBase);
            return dataBase;
        }
        return EXAMPLE;
    }

    public static void addInfFer(ParasiteDataBase inf, ParasiteDataBase fer) {
        inf.addState(new StatsInfNext());
        inf.addState(new StatsNextParasite(fer));
        fer.addState(new StatsFerPre());
        fer.addState(new StatsPreParasite(inf));
    }

    public static void addHead(ParasiteDataBase owner, ParasiteDataBase head, float chance, float healthMulti, float damageMulti) {
        head.addState(new StatsIsHead());
        head.addState(new StatsNextParasite(owner));
        owner.addState(new StatsHaveHead(head, chance, healthMulti, damageMulti));
    }

    public static void addPriAda(ParasiteDataBase pri, ParasiteDataBase ada) {
        pri.addState(new StatsNextParasite(ada));
        ada.addState(new StatsPreParasite(pri));
    }

    public static void addLootTableSRP(ParasiteDataBase data, String[] strings) {
        data.addState(new StatsLootTable_FromSRP(data.getRegistryName().toString(), strings));
    }

    public static void addMobInsideSRP(ParasiteDataBase data, String string) {
        data.addState(new StatsMobInside_FromSRP(data.getRegistryName().toString(), string));
    }

    public static void initSRPEntity() {
        DORPA = ParasiteDataHandler.createDataForSRPEntity(EntityDorpa.class, 2, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        DORPA.addState(new StatsCanSpawn(0));
        ParasiteDataHandler.addLootTableSRP(DORPA, SRPConfigMobs.dorpaLoot);
        ParasiteDataHandler.addMobInsideSRP(DORPA, SRPConfigMobs.dorpamob);
        INF_BEAR = ParasiteDataHandler.createDataForSRPEntity(EntityInfBear.class, 49, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        ParasiteDataHandler.addLootTableSRP(INF_BEAR, SRPConfigMobs.infbearLoot);
        INF_BEAR.addState(new StatsCanSpawn(SRPConfigMobs.infbearCanSpawnAssimilatedNat));
        FER_BEAR = ParasiteDataHandler.createDataForSRPEntity(EntityFerBear.class, 306, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_BEAR.addState(new StatsCanSpawn(SRPConfigMobs.infbearCanSpawnAssimilatedNat, (byte)49));
        ParasiteDataHandler.addLootTableSRP(FER_BEAR, SRPConfigMobs.ferbearLoot);
        ParasiteDataHandler.addInfFer(INF_BEAR, FER_BEAR);
        INF_COW = ParasiteDataHandler.createDataForSRPEntity(EntityInfCow.class, 13, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_COW.addState(new StatsCanSpawn(SRPConfigMobs.infcowCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_COW, SRPConfigMobs.infcowLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_COW, SRPConfigMobs.infcowmob);
        FER_COW = ParasiteDataHandler.createDataForSRPEntity(EntityFerCow.class, 93, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_COW.addState(new StatsCanSpawn(SRPConfigMobs.infcowCanSpawnAssimilatedNat, (byte)13));
        ParasiteDataHandler.addLootTableSRP(FER_COW, SRPConfigMobs.fercowLoot);
        ParasiteDataHandler.addInfFer(INF_COW, FER_COW);
        INF_COW_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfCowHead.class, 28, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_COW_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infcowCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_COW_HEAD, SRPConfigMobs.infcowheadLoot);
        ParasiteDataHandler.addHead(INF_COW, INF_COW_HEAD, SRPConfigMobs.infcowheadchance, SRPConfigMobs.infcowHealthHead, SRPConfigMobs.infcowDamageHead);
        INF_DRAGON = ParasiteDataHandler.createDataForSRPEntity(EntityInfDragonE.class, 64, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_THREE);
        INF_DRAGON.addState(new StatsCanSpawn(SRPConfigMobs.infdragoneCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_DRAGON, SRPConfigMobs.infdragoneLoot);
        INF_DRAGON_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfDragonEHead.class, 70, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_TWO);
        INF_DRAGON_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infdragoneCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_DRAGON_HEAD, SRPConfigMobs.infdragoneheadLoot);
        ParasiteDataHandler.addHead(INF_DRAGON, INF_DRAGON_HEAD, 0.0f, SRPConfigMobs.infdragoneHealthHead, SRPConfigMobs.infdragoneDamageHead);
        INF_ENDERMAN = ParasiteDataHandler.createDataForSRPEntity(EntityInfEnderman.class, 59, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_THREE);
        INF_ENDERMAN.addState(new StatsCanSpawn(SRPConfigMobs.infendermanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_ENDERMAN, SRPConfigMobs.infendermanLoot);
        FER_ENDERMAN = ParasiteDataHandler.createDataForSRPEntity(EntityFerEnderman.class, 94, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_THREE);
        FER_ENDERMAN.addState(new StatsCanSpawn(SRPConfigMobs.infendermanCanSpawnAssimilatedNat, (byte)59));
        ParasiteDataHandler.addLootTableSRP(FER_ENDERMAN, SRPConfigMobs.ferendermanLoot);
        ParasiteDataHandler.addInfFer(INF_ENDERMAN, FER_ENDERMAN);
        INF_ENDERMAN_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfEndermanHead.class, 69, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_ENDERMAN_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infendermanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_ENDERMAN_HEAD, SRPConfigMobs.infendermanheadLoot);
        ParasiteDataHandler.addHead(INF_ENDERMAN, INF_ENDERMAN_HEAD, SRPConfigMobs.infendermanheadchance, SRPConfigMobs.infendermanHealthHead, SRPConfigMobs.infendermanDamageHead);
        INF_HORSE = ParasiteDataHandler.createDataForSRPEntity(EntityInfHorse.class, 44, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_THREE);
        INF_HORSE.addState(new StatsCanSpawn(SRPConfigMobs.infhorseCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_HORSE, SRPConfigMobs.infhorseLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_HORSE, SRPConfigMobs.infhorsemob);
        FER_HORSE = ParasiteDataHandler.createDataForSRPEntity(EntityFerHorse.class, 95, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_THREE);
        FER_HORSE.addState(new StatsCanSpawn(SRPConfigMobs.infhorseCanSpawnAssimilatedNat, (byte)44));
        ParasiteDataHandler.addLootTableSRP(FER_HORSE, SRPConfigMobs.ferhorseLoot);
        ParasiteDataHandler.addInfFer(INF_HORSE, FER_HORSE);
        INF_HORSE_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfHorseHead.class, 45, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_HORSE_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infhorseCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_HORSE_HEAD, SRPConfigMobs.infhorseheadLoot);
        ParasiteDataHandler.addHead(INF_HORSE, INF_HORSE_HEAD, SRPConfigMobs.infhorseheadchance, SRPConfigMobs.infhorseHealthHead, SRPConfigMobs.infhorseDamageHead);
        INF_HUMAN = ParasiteDataHandler.createDataForSRPEntity(EntityInfHuman.class, 6, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_HUMAN.addState(new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_HUMAN, SRPConfigMobs.infhumanLoot);
        FER_HUMAN = ParasiteDataHandler.createDataForSRPEntity(EntityFerHuman.class, 96, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_HUMAN.addState(new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat, (byte)6));
        ParasiteDataHandler.addLootTableSRP(FER_HUMAN, SRPConfigMobs.ferhumanLoot);
        ParasiteDataHandler.addInfFer(INF_HUMAN, FER_HUMAN);
        INF_HUMAN_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfHumanHead.class, 46, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_HUMAN_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_HUMAN_HEAD, SRPConfigMobs.infhumanheadLoot);
        ParasiteDataHandler.addHead(INF_HUMAN, INF_HUMAN_HEAD, SRPConfigMobs.infhumanheadchance, SRPConfigMobs.infhumanHealthHead, SRPConfigMobs.infhumanDamageHead);
        INF_PIG = ParasiteDataHandler.createDataForSRPEntity(EntityInfPig.class, 26, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_PIG.addState(new StatsCanSpawn(SRPConfigMobs.infpigCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_PIG, SRPConfigMobs.infpigLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_PIG, SRPConfigMobs.infpigmob);
        FER_PIG = ParasiteDataHandler.createDataForSRPEntity(EntityFerPig.class, 97, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_PIG.addState(new StatsCanSpawn(SRPConfigMobs.infpigCanSpawnAssimilatedNat, (byte)26));
        ParasiteDataHandler.addLootTableSRP(FER_PIG, SRPConfigMobs.ferpigLoot);
        ParasiteDataHandler.addInfFer(INF_PIG, FER_PIG);
        INF_PIG_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfPigHead.class, 31, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_PIG_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infpigCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_PIG_HEAD, SRPConfigMobs.infpigheadLoot);
        ParasiteDataHandler.addHead(INF_PIG, INF_PIG_HEAD, SRPConfigMobs.infpigheadchance, SRPConfigMobs.infpigHealthHead, SRPConfigMobs.infpigDamageHead);
        INF_PLAYER = ParasiteDataHandler.createDataForSRPEntity(EntityInfPlayer.class, 40, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_PLAYER.addState(new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_PLAYER, SRPConfigMobs.infadventurerLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_PLAYER, SRPConfigMobs.infadventurermob);
        ParasiteDataHandler.addInfFer(INF_PLAYER, FER_PLAYER);
        INF_PLAYER_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfPlayerHead.class, 71, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_PLAYER_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_PLAYER_HEAD, SRPConfigMobs.infadventurerheadLoot);
        ParasiteDataHandler.addHead(INF_PLAYER, INF_PLAYER_HEAD, SRPConfigMobs.infadventurerheadchance, SRPConfigMobs.infadventurerHealthHead, SRPConfigMobs.infadventurerDamageHead);
        INF_SHEEP = ParasiteDataHandler.createDataForSRPEntity(EntityInfSheep.class, 14, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_SHEEP.addState(new StatsCanSpawn(SRPConfigMobs.infsheepCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_SHEEP, SRPConfigMobs.infsheepLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_SHEEP, SRPConfigMobs.infsheepmob);
        FER_SHEEP = ParasiteDataHandler.createDataForSRPEntity(EntityFerSheep.class, 98, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_SHEEP.addState(new StatsCanSpawn(SRPConfigMobs.infsheepCanSpawnAssimilatedNat, (byte)14));
        ParasiteDataHandler.addLootTableSRP(FER_SHEEP, SRPConfigMobs.fersheepLoot);
        ParasiteDataHandler.addInfFer(INF_SHEEP, FER_SHEEP);
        INF_SHEEP_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfSheepHead.class, 22, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_SHEEP_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infsheepCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_SHEEP_HEAD, SRPConfigMobs.infsheepheadLoot);
        ParasiteDataHandler.addHead(INF_SHEEP, INF_SHEEP_HEAD, SRPConfigMobs.infsheepheadchance, SRPConfigMobs.infsheepHealthHead, SRPConfigMobs.infsheepDamageHead);
        INF_SQUID = ParasiteDataHandler.createDataForSRPEntity(EntityInfSquid.class, 307, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_AQUA_TWO);
        INF_SQUID.addState(new StatsCanSpawn(SRPConfigMobs.infsquidCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_SQUID, SRPConfigMobs.infsquidLoot);
        INF_VILLAGER = ParasiteDataHandler.createDataForSRPEntity(EntityInfVillager.class, 27, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_VILLAGER.addState(new StatsCanSpawn(SRPConfigMobs.infvillagerCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_VILLAGER, SRPConfigMobs.infvillagerLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_VILLAGER, SRPConfigMobs.infvillagermob);
        FER_VILLAGER = ParasiteDataHandler.createDataForSRPEntity(EntityFerVillager.class, 99, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO);
        FER_VILLAGER.addState(new StatsCanSpawn(SRPConfigMobs.infvillagerCanSpawnAssimilatedNat, (byte)27));
        ParasiteDataHandler.addLootTableSRP(FER_VILLAGER, SRPConfigMobs.fervillagerLoot);
        ParasiteDataHandler.addInfFer(INF_VILLAGER, FER_VILLAGER);
        INF_VILLAGER_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfVillagerHead.class, 32, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_VILLAGER_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infvillagerCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_VILLAGER_HEAD, SRPConfigMobs.infvillagerheadLoot);
        ParasiteDataHandler.addHead(INF_VILLAGER, INF_VILLAGER_HEAD, SRPConfigMobs.infvillagerheadchance, SRPConfigMobs.infvillagerHealthHead, SRPConfigMobs.infvillagerDamageHead);
        INF_WOLF = ParasiteDataHandler.createDataForSRPEntity(EntityInfWolf.class, 15, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO);
        INF_WOLF.addState(new StatsCanSpawn(SRPConfigMobs.infwolfCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_WOLF, SRPConfigMobs.infwolfLoot);
        ParasiteDataHandler.addMobInsideSRP(INF_WOLF, SRPConfigMobs.infwolfmob);
        ParasiteDataHandler.addInfFer(INF_WOLF, FER_WOLF);
        INF_WOLF_HEAD = ParasiteDataHandler.createDataForSRPEntity(EntityInfWolfHead.class, 21, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE);
        INF_WOLF_HEAD.addState(new StatsCanSpawn(SRPConfigMobs.infwolfCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(INF_WOLF_HEAD, SRPConfigMobs.infwolfheadLoot);
        ParasiteDataHandler.addHead(INF_WOLF, INF_WOLF_HEAD, SRPConfigMobs.infwolfheadchance, SRPConfigMobs.infwolfHealthHead, SRPConfigMobs.infwolfDamageHead);
        HI_GOLEM = ParasiteDataHandler.createDataForSRPEntity(EntityHiGolem.class, 301, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_THREE);
        HI_GOLEM.addState(new StatsCanSpawn(SRPConfigMobs.higolemCanSpawnAssimilatedNat));
        ParasiteDataHandler.addLootTableSRP(HI_GOLEM, SRPConfigMobs.higolemLoot);
        PRI_VERMIN = ParasiteDataHandler.createDataForSRPEntity(EntityIki.class, 92, EParasiteType.PRIMITIVE, SRPEEntitySpawnRules.RULE_TWO);
        ParasiteDataHandler.addLootTableSRP(PRI_VERMIN, SRPConfigMobs.ikiLoot);
        ParasiteDataHandler.addPriAda(PRI_VERMIN, ADA_VERMIN);
        PRI_TOZOON = ParasiteDataHandler.createDataForSRPEntity(EntityWymo.class, 37, EParasiteType.PRIMITIVE, SRPEEntitySpawnRules.RULE_THREE);
        ParasiteDataHandler.addLootTableSRP(PRI_TOZOON, SRPConfigMobs.wymoLoot);
        ParasiteDataHandler.addPriAda(PRI_TOZOON, ADA_TOZOON);
        PRI_LUM = ParasiteDataHandler.createDataForSRPEntity(EntityLum.class, 66, EParasiteType.PRIMITIVE, SRPEEntitySpawnRules.RULE_AQUA_THREE);
        ParasiteDataHandler.addLootTableSRP(PRI_LUM, SRPConfigMobs.lumLoot);
        CRUDE_LESH = ParasiteDataHandler.createDataForSRPEntity(EntityLesh.class, 23, EParasiteType.CRUDE, SRPEEntitySpawnRules.RULE_TWO);
        RUPTER = ParasiteDataHandler.createDataForSRPEntity(EntityMudo.class, 12, EParasiteType.INBORN, SRPEEntitySpawnRules.RULE_ONE);
    }
}

