/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.init;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import energon.srpextra.config.SRPEConfigMobs;
import energon.srpextra.config.preset.IConfigADV;
import energon.srpextra.config.preset.ParasiteConfig;
import energon.srpextra.config.preset.ParasiteConfig_VOID;
import energon.srpextra.encyclopedia.ParasiteDataEvent;
import energon.srpextra.encyclopedia.ParasiteDataHandler;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.encyclopedia.stats.IStatsBase;
import energon.srpextra.encyclopedia.stats.SF_Attributes;
import energon.srpextra.encyclopedia.stats.StatsCanSpawn;
import energon.srpextra.encyclopedia.stats.StatsHavePart;
import energon.srpextra.encyclopedia.stats.StatsLootTable;
import energon.srpextra.encyclopedia.stats.StatsMobInside;
import energon.srpextra.encyclopedia.stats.StatsPhaseSpawnList;
import energon.srpextra.encyclopedia.stats.StatsPreParasite;
import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.entity.adapted.EntityIkiAdapted_SRPE;
import energon.srpextra.entity.adapted.EntityMikuAdapted;
import energon.srpextra.entity.adapted.EntityWymoAdapted;
import energon.srpextra.entity.crude.EntityFog;
import energon.srpextra.entity.crude.EntityLeshAqua;
import energon.srpextra.entity.feral.EntityFerOcelot;
import energon.srpextra.entity.feral.EntityFerPlayer;
import energon.srpextra.entity.feral.EntityFerWitch;
import energon.srpextra.entity.feral.EntityFerWolf_SRPE;
import energon.srpextra.entity.head.EntityHiCreeperHead;
import energon.srpextra.entity.head.EntityHiSkeletonHead;
import energon.srpextra.entity.head.EntityInfOcelotHead;
import energon.srpextra.entity.head.EntityInfVindicatorHead;
import energon.srpextra.entity.head.EntityInfWitchHead;
import energon.srpextra.entity.hijacked.EntityHiCreeper;
import energon.srpextra.entity.hijacked.EntityHiSkeleton_SRPE;
import energon.srpextra.entity.hijacked.EntityHiStray;
import energon.srpextra.entity.infected.EntityInfEvoker;
import energon.srpextra.entity.infected.EntityInfOcelot;
import energon.srpextra.entity.infected.EntityInfVindicator;
import energon.srpextra.entity.infected.EntityInfWitch;
import energon.srpextra.entity.primitive.EntityMiku;
import energon.srpextra.entity.tendril.EntityTendrilMiku;
import energon.srpextra.entity.tendril.EntityTendrilWymo;
import energon.srpextra.entity.tile.EntityGoreAqua;
import energon.srpextra.entity.tile.EntityRemainAqua;
import energon.srpextra.entity.tile.ParasiteFangs;
import energon.srpextra.util.EParasiteType;
import energon.srpextra.util.preset.SRPEEntitySpawnRules;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SRPEEntities {
    public static EntityEntry INF_EVOKER_FANGS;

    public static <T extends Entity> ParasiteDataBase createParasite(IForgeRegistry<EntityEntry> registry, String name, Class<T> cls, int id, ParasiteConfig config, EParasiteType type, IESpawnRule spawnRule, String translateKey, IStatsBase ... stats) {
        if (config.active) {
            EntityEntryBuilder builder = EntityEntryBuilder.create();
            builder.entity(cls);
            builder.name(translateKey + name);
            builder.id(new ResourceLocation("srparasites", name), id);
            builder.tracker(64, 3, true);
            if (SRPConfig.vanillaEggs) {
                builder.egg(8611072, 16711900);
            }
            EntityEntry entry = builder.build();
            ParasiteDataBase data = new ParasiteDataBase(entry, id, type, spawnRule);
            data.addState(new SF_Attributes(config));
            data.addState(new StatsLootTable());
            if (config instanceof IConfigADV) {
                data.addState(new StatsMobInside());
            }
            data.addState(new StatsPhaseSpawnList());
            data.addAllStats(Arrays.asList(stats));
            ParasiteDataHandler.PARASITES.add(data);
            registry.register((IForgeRegistryEntry)entry);
            return data;
        }
        return ParasiteDataHandler.EXAMPLE;
    }

    private static <T extends Entity> EntityEntry CreateEntity(IForgeRegistry<EntityEntry> registry, String name, Class<T> cls, int id, boolean active, String translateKey) {
        if (active) {
            EntityEntryBuilder builder = EntityEntryBuilder.create();
            builder.entity(cls);
            builder.name(translateKey + name);
            builder.id(new ResourceLocation("srparasites", name), id);
            builder.tracker(64, 3, true);
            EntityEntry entry = builder.build();
            registry.register((IForgeRegistryEntry)entry);
            return entry;
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="srpextra")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<EntityEntry> event) {
            MinecraftForge.EVENT_BUS.post((Event)new ParasiteDataEvent.ParasiteData_Pre());
            IForgeRegistry r = event.getRegistry();
            ParasiteDataHandler.INF_WITCH = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_witch", EntityInfWitch.class, -4, SRPEConfigMobs.AssimilatedWitchConfig, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.INF_WITCH_HEAD = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_witchhead", EntityInfWitchHead.class, -260, SRPEConfigMobs.AssimilatedWitchHeadConfig, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.addHead(ParasiteDataHandler.INF_WITCH, ParasiteDataHandler.INF_WITCH_HEAD, 0.5f, 0.3f, 0.3f);
            ParasiteDataHandler.INF_VINDICATOR = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_vindicator", EntityInfVindicator.class, -5, SRPEConfigMobs.AssimilatedVindicatorConfig, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.INF_VINDICATOR_HEAD = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_vindicatorhead", EntityInfVindicatorHead.class, -261, SRPEConfigMobs.AssimilatedVindicatorHeadConfig, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.addHead(ParasiteDataHandler.INF_VINDICATOR, ParasiteDataHandler.INF_VINDICATOR_HEAD, 0.5f, 0.3f, 0.3f);
            ParasiteDataHandler.INF_EVOKER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_evoker", EntityInfEvoker.class, -6, SRPEConfigMobs.AssimilatedEvokerConfig, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.INF_OCELOT = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_ocelot", EntityInfOcelot.class, -7, SRPEConfigMobs.AssimilatedOcelotConfig, EParasiteType.INFECTED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.INF_OCELOT_HEAD = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "sim_ocelothead", EntityInfOcelotHead.class, -263, SRPEConfigMobs.AssimilatedOcelotHeadConfig, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.addHead(ParasiteDataHandler.INF_OCELOT, ParasiteDataHandler.INF_OCELOT_HEAD, 0.5f, 0.3f, 0.3f);
            ParasiteDataHandler.HI_CREEPER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "hi_creeper", EntityHiCreeper.class, -1, SRPEConfigMobs.HijackedCreeperConfig, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new StatsCanSpawn(SRPEConfigMobs.neededAssimilationValueHijackedCreeper));
            ParasiteDataHandler.HI_CREEPER_HEAD = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "hi_creeperhead", EntityHiCreeperHead.class, -257, SRPEConfigMobs.HijackedCreeperHeadConfig, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.addHead(ParasiteDataHandler.HI_CREEPER, ParasiteDataHandler.HI_CREEPER_HEAD, 0.5f, 0.3f, 0.3f);
            ParasiteDataHandler.HI_SKELETON = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "hi_skeleton_srpe", EntityHiSkeleton_SRPE.class, -2, SRPEConfigMobs.HijackedSkeletonConfig, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.HI_SKELETON_STRAY = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "hi_stray", EntityHiStray.class, -3, SRPEConfigMobs.HijackedSkeletonStrayConfig, EParasiteType.HIJACKED, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.HI_SKELETON_HEAD = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "hi_skeletonhead", EntityHiSkeletonHead.class, -258, SRPEConfigMobs.HijackedSkeletonHeadConfig, EParasiteType.HEAD, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.addHead(ParasiteDataHandler.HI_SKELETON, ParasiteDataHandler.HI_SKELETON_HEAD, SRPEConfigMobs.chanceSpawnHeadHijackedSkeleton, 0.3f, 0.3f);
            ParasiteDataHandler.addHead(ParasiteDataHandler.HI_SKELETON_STRAY, ParasiteDataHandler.HI_SKELETON_HEAD, SRPEConfigMobs.chanceSpawnHeadHijackedSkeletonStray, 0.3f, 0.3f);
            ParasiteDataHandler.FER_WOLF = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "fer_wolf_srpe", EntityFerWolf_SRPE.class, -133, SRPEConfigMobs.FeralWolfConfig, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new StatsCanSpawn(SRPConfigMobs.infwolfCanSpawnAssimilatedNat, (byte)15));
            ParasiteDataHandler.FER_OCELOT = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "fer_ocelot", EntityFerOcelot.class, -519, SRPEConfigMobs.FeralOcelotConfig, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.FER_WITCH = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "fer_witch", EntityFerWitch.class, -516, SRPEConfigMobs.FeralWitchConfig, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.FER_PLAYER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "fer_adventurer", EntityFerPlayer.class, -137, SRPEConfigMobs.FeralPlayerConfig, EParasiteType.FERAL, SRPEEntitySpawnRules.RULE_TWO, "srpextra.", new StatsCanSpawn(SRPConfigMobs.infhumanCanSpawnAssimilatedNat, (byte)40));
            ParasiteDataHandler.CRUDE_WENDIGO = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "wendigo", EntityFog.class, -8, SRPEConfigMobs.CrudeWendigoConfig, EParasiteType.CRUDE, SRPEEntitySpawnRules.RULE_THREE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.CRUDE_LESH_AQUA = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "swimming_flesh", EntityLeshAqua.class, -134, SRPEConfigMobs.CrudeLeshAquaConfig, EParasiteType.CRUDE, SRPEEntitySpawnRules.RULE_AQUA_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.PRI_STALKER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "pri_stalker", EntityMiku.class, -129, SRPEConfigMobs.PrimitiveStalkerConfig, EParasiteType.PRIMITIVE, SRPEEntitySpawnRules.RULE_THREE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.ADA_VERMIN = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "ada_vermin", EntityIkiAdapted_SRPE.class, -131, SRPEConfigMobs.AdaptedVerminConfig, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_THREE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.ADA_TOZOON = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "ada_tozoon", EntityWymoAdapted.class, -132, SRPEConfigMobs.AdaptedWymoConfig, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_FOUR, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.ADA_STALKER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "ada_stalker", EntityMikuAdapted.class, -130, SRPEConfigMobs.AdaptedStalkerConfig, EParasiteType.ADAPTIVE, SRPEEntitySpawnRules.RULE_THREE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.TENDRIL_STALKER = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "tendril_stalker", EntityTendrilMiku.class, -1130, SRPEConfigMobs.AdaptedStalkerTendrilConfig, EParasiteType.TENDRIL, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.TENDRIL_WUMO = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "tendril_tozoon", EntityTendrilWymo.class, -1132, SRPEConfigMobs.AdaptedWymoTendrilConfig, EParasiteType.TENDRIL, SRPEEntitySpawnRules.RULE_ONE, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.REMAIN_AQUA = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "remain_aqua", EntityRemainAqua.class, -1001, new ParasiteConfig_VOID(), EParasiteType.REMAIN, SRPEEntitySpawnRules.RULE_AQUA_TWO, "srpextra.", new IStatsBase[0]);
            ParasiteDataHandler.GORE_AQUA = SRPEEntities.createParasite((IForgeRegistry<EntityEntry>)r, "gore_aqua", EntityGoreAqua.class, -1002, new ParasiteConfig_VOID(), EParasiteType.GORE, SRPEEntitySpawnRules.RULE_AQUA_TWO, "srpextra.", new IStatsBase[0]);
            INF_EVOKER_FANGS = SRPEEntities.CreateEntity((IForgeRegistry<EntityEntry>)r, "parasite_fangs", ParasiteFangs.class, -1000, SRPEConfigMobs.AssimilatedEvokerConfig.active, "srpextra.");
            ParasiteDataHandler.ADA_STALKER.addState(new StatsHavePart(ParasiteDataHandler.TENDRIL_STALKER));
            ParasiteDataHandler.addPriAda(ParasiteDataHandler.PRI_STALKER, ParasiteDataHandler.ADA_STALKER);
            MinecraftForge.EVENT_BUS.post((Event)new ParasiteDataEvent.ParasiteData_Final());
        }

        @SubscribeEvent
        public static void onSRPLoaded(ParasiteDataEvent.ParasiteDataSRP_Final event) {
            ParasiteDataHandler.PRI_STALKER.addState(new StatsPreParasite(ParasiteDataHandler.CRUDE_LESH));
        }
    }
}

