/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class SRPELootTable {
    public static Map<String, LootTable> LOOT_TABLES = new HashMap<String, LootTable>();
    public static int maxCountEnch = 5;
    public static float chanceRepeatEnch = 0.5f;

    public static int generateLootTable(String name, String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] parts = pool.split(">");
                String[] sParts = parts[0].split(";");
                if (sParts.length <= 1) continue;
                Pool p = new Pool(Integer.parseInt(sParts[0]), sParts[1]);
                totalWeight += p.chance;
                if (sParts.length > 2) {
                    p.meta = Integer.parseInt(sParts[2]);
                }
                if (sParts.length > 3) {
                    p.addMinMax(Integer.parseInt(sParts[3]), Integer.parseInt(sParts[4]));
                }
                if (parts.length == 2 && p.generateEnchantments(parts[1].split(","))) {
                    return 1;
                }
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            LOOT_TABLES.putIfAbsent(name, new LootTable(totalWeight, (Pool[])genPools));
            return 0;
        }
        catch (NumberFormatException e) {
            LootTable table = new LootTable(0, new Pool[0]);
            LOOT_TABLES.putIfAbsent(name, table);
            return 0;
        }
    }

    public static LootTable generate(String name, String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] parts = pool.split(">");
                String[] sParts = parts[0].split(";");
                if (sParts.length <= 1) continue;
                Pool p = new Pool(Integer.parseInt(sParts[0]), sParts[1]);
                totalWeight += p.chance;
                if (sParts.length > 2) {
                    p.meta = Integer.parseInt(sParts[2]);
                }
                if (sParts.length > 3) {
                    p.addMinMax(Integer.parseInt(sParts[3]), Integer.parseInt(sParts[4]));
                }
                if (parts.length == 2 && p.generateEnchantments(parts[1].split(","))) {
                    return new LootTable(0, new Pool[0]);
                }
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            LootTable table = new LootTable(totalWeight, (Pool[])genPools);
            LOOT_TABLES.putIfAbsent(name, table);
            return table;
        }
        catch (NumberFormatException e) {
            LootTable table = new LootTable(0, new Pool[0]);
            LOOT_TABLES.putIfAbsent(name, table);
            return table;
        }
    }

    public static LootTable generate(String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] parts = pool.split(">");
                String[] sParts = parts[0].split(";");
                if (sParts.length <= 1) continue;
                Pool p = new Pool(Integer.parseInt(sParts[0]), sParts[1]);
                totalWeight += p.chance;
                if (sParts.length > 2) {
                    p.meta = Integer.parseInt(sParts[2]);
                }
                if (sParts.length > 3) {
                    p.addMinMax(Integer.parseInt(sParts[3]), Integer.parseInt(sParts[4]));
                }
                if (parts.length == 2 && p.generateEnchantments(parts[1].split(","))) {
                    return new LootTable(0, new Pool[0]);
                }
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            return new LootTable(totalWeight, (Pool[])genPools);
        }
        catch (NumberFormatException e) {
            return new LootTable(0, new Pool[0]);
        }
    }

    public static LootTable generateFromSRP(String name, String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] sParts = pool.split(";");
                if (sParts.length <= 2) continue;
                Pool p = new Pool(Integer.parseInt(sParts[1]), sParts[0]);
                totalWeight += p.chance;
                p.addMinMax(1, Integer.parseInt(sParts[2]));
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            LootTable table = new LootTable(totalWeight, (Pool[])genPools);
            LOOT_TABLES.putIfAbsent(name, table);
            return table;
        }
        catch (NumberFormatException e) {
            LootTable table = new LootTable(0, new Pool[0]);
            LOOT_TABLES.putIfAbsent(name, table);
            return table;
        }
    }

    public static class EnchPool {
        public int chance;
        public String enchName;
        public Integer min;
        public Integer max;

        public EnchPool(int c, String name) {
            this.chance = c;
            this.enchName = name;
        }

        public void addMinMax(int mn, int mx) {
            if (mn > mx) {
                this.max = mn;
                this.min = mx;
            } else {
                this.min = mn;
                this.max = mx;
            }
        }

        public int getRandomAmplifier(Random random) {
            if (this.max == null || this.min == null) {
                return 1;
            }
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        @Nullable
        public Enchantment getEnchantment() {
            return Enchantment.func_180305_b((String)this.enchName);
        }

        public String toString() {
            return "Chance: " + this.chance + " Ench: " + this.enchName + " Min Amp: " + this.min + " Max Amp: " + this.max;
        }
    }

    public static class EnchantmentPools {
        public int totalChance;
        public EnchPool[] enchantments;

        public EnchantmentPools(int weight, EnchPool[] pools) {
            this.totalChance = weight;
            this.enchantments = pools;
        }

        @Nullable
        public EnchPool getRandomEnchantmentPool(Random random) {
            int randomNum = random.nextInt(this.totalChance + 1);
            int test = 0;
            for (EnchPool pool : this.enchantments) {
                if ((test += pool.chance) <= randomNum) continue;
                return pool;
            }
            return null;
        }

        public void addEnchantments(Random random, ItemStack itemStack) {
            ArrayList<Enchantment> appliedEnch = new ArrayList<Enchantment>();
            for (int i = 0; i < maxCountEnch; ++i) {
                EnchPool pool = this.getRandomEnchantmentPool(random);
                if (pool == null) {
                    return;
                }
                Enchantment enchantment = pool.getEnchantment();
                if (enchantment != null && !appliedEnch.contains(enchantment)) {
                    appliedEnch.add(enchantment);
                    itemStack.func_77966_a(enchantment, pool.getRandomAmplifier(random));
                    if (random.nextFloat() < chanceRepeatEnch) continue;
                }
                return;
            }
        }

        public String toString() {
            StringBuilder info = new StringBuilder("Total Weight: " + this.totalChance);
            for (EnchPool pool : this.enchantments) {
                info.append("\n     ").append(pool.toString());
            }
            return info.toString();
        }
    }

    public static class Pool {
        public int chance;
        public String itemName;
        public Item item;
        public Integer min;
        public Integer max;
        public int meta = 0;
        public EnchantmentPools enchantments;

        public Pool(int c, String iName) {
            this.chance = c;
            this.itemName = iName;
        }

        public void addMinMax(int mn, int mx) {
            if (mn > mx) {
                this.max = mn;
                this.min = mx;
            } else {
                this.min = mn;
                this.max = mx;
            }
        }

        public boolean generateEnchantments(String[] pools) {
            Object[] enchPools = new EnchPool[]{};
            int totalWeight = 0;
            for (String pool : pools) {
                String[] parts = pool.split(";");
                if (parts.length == 1) {
                    return true;
                }
                EnchPool p = new EnchPool(Integer.parseInt(parts[0]), parts[1]);
                totalWeight += p.chance;
                if (parts.length == 4) {
                    p.addMinMax(Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                }
                enchPools = (EnchPool[])ArrayUtils.add((Object[])enchPools, (Object)p);
            }
            this.enchantments = new EnchantmentPools(totalWeight, (EnchPool[])enchPools);
            return false;
        }

        public ItemStack getItemStack(Random random) {
            if (this.item == Items.field_190931_a) {
                return ItemStack.field_190927_a;
            }
            if (this.item == null) {
                Item item = Item.func_111206_d((String)this.itemName);
                if (item == null) {
                    this.item = Items.field_190931_a;
                    return ItemStack.field_190927_a;
                }
                this.item = item;
            }
            ItemStack itemStack = this.min == null || this.max == null ? new ItemStack(this.item, 1, this.meta) : new ItemStack(this.item, random.nextInt(this.max - this.min + 1) + this.min, this.meta);
            if (this.enchantments != null) {
                this.enchantments.addEnchantments(random, itemStack);
            }
            return itemStack;
        }

        public String toString() {
            StringBuilder info = new StringBuilder("Chance: " + this.chance + " Item: " + this.itemName + " Meta: " + this.meta + " Min: " + this.min + " Max: " + this.max);
            if (this.enchantments != null) {
                info.append("\n   Enchantments: ").append(this.enchantments);
            }
            return info.toString();
        }
    }

    public static class LootTable {
        public Integer totalChance;
        public Pool[] pools;

        public LootTable(Pool[] p) {
            this.pools = p;
        }

        public LootTable(int weight, Pool[] p) {
            this(p);
            this.totalChance = weight;
        }

        @Nullable
        public ItemStack getRandomUseTW(Random random) {
            if (this.totalChance == null) {
                return null;
            }
            int randomNum = random.nextInt(this.totalChance + 1);
            int test = 0;
            for (Pool pool : this.pools) {
                if ((test += pool.chance) <= randomNum) continue;
                return pool.getItemStack(random);
            }
            return null;
        }

        public ItemStack[] getMRandom(Random random) {
            Object[] end = new ItemStack[]{};
            for (Pool pool : this.pools) {
                if (random.nextInt(100) >= pool.chance) continue;
                end = (ItemStack[])ArrayUtils.add((Object[])end, (Object)pool.getItemStack(random));
            }
            return end;
        }

        public void spawnLoots(EntityLivingBase summoner, int gw) {
            this.spawnLoots(summoner.func_70681_au(), summoner.field_70170_p, summoner.field_70165_t, summoner.field_70163_u, summoner.field_70161_v, gw);
        }

        public void spawnLoots(Random random, World world, double x, double y, double z, int gw) {
            for (Pool pool : this.pools) {
                if (random.nextInt(gw) >= pool.chance) continue;
                EntityItem entityItem = new EntityItem(world, x, y, z, pool.getItemStack(random));
                world.func_72838_d((Entity)entityItem);
            }
        }

        public String toString() {
            StringBuilder info = new StringBuilder("Total Weight: " + this.totalChance);
            for (Pool pool : this.pools) {
                info.append("\n").append(pool.toString());
            }
            return info.toString();
        }
    }
}

