/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.Main;
import energon.srpextra.config.SRPEConfigSystem;
import energon.srpextra.init.SRPEPhases;
import energon.srpextra.util.preset.IGetRandomPos;
import energon.srpextra.util.preset.NPListGetRandomPos;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SRPEWorldSpawnMob {
    public World world;
    public int tick = 0;
    public SRPSaveData data;
    public IGetRandomPos RandomPos;
    public static boolean DEBUG = false;
    public static boolean ENABLE = false;

    public SRPEWorldSpawnMob() {
        DEBUG = false;
        for (WorldServer nn : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (nn.field_73011_w.getDimension() != 0) continue;
            this.world = nn;
        }
        if (this.world == null) {
            for (WorldServer nn : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                this.world = nn;
                if (this.world != null) break;
            }
        }
        if (this.world != null) {
            this.data = SRPSaveData.get((World)this.world);
            ENABLE = !Main.srpcotesia;
        } else {
            ENABLE = false;
        }
        this.RandomPos = NPListGetRandomPos.RANDOM_POS.get(SRPEConfigSystem.spawnSelectLogic);
        if (this.RandomPos == null) {
            this.RandomPos = new NPListGetRandomPos.BASIC();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        int countPlayers;
        if (event.phase == TickEvent.Phase.END && ENABLE && ++this.tick > SRPEConfigSystem.countTickSpawn + (countPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().size()) * SRPEConfigSystem.countTickSpawnPlusPlayer) {
            this.tick = 0;
            if (this.world.func_175659_aa() != EnumDifficulty.PEACEFUL && this.world.func_82736_K().func_82766_b("doMobSpawning")) {
                for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    this.playerSpawn(player, countPlayers, player.func_70681_au());
                }
            }
        }
    }

    public void playerSpawn(EntityPlayer player, int count, Random random) {
        int dimID;
        byte phase;
        if (random.nextInt(count + 2) == 0 && (phase = this.data.getEvolutionPhase(dimID = player.field_70170_p.field_73011_w.getDimension())) >= 0) {
            SRPEPhases.CompactPhaseUtil comp = SRPEPhases.getMathPhaseSpawnList(phase, dimID);
            this.getParasiteFromList(player, random, comp, phase);
        }
    }

    public void getParasiteFromList(EntityPlayer player, Random random, SRPEPhases.CompactPhaseUtil compact, byte phase) {
        SRPEPhases.PhaseUtilsValues value = compact.getRandomValue(random);
        if (value != null) {
            this.spawnParasite(player, random, value, phase);
        }
    }

    public void spawnParasite(EntityPlayer player, Random random, SRPEPhases.PhaseUtilsValues value, byte phase) {
        World lWorld = player.field_70170_p;
        if (value.getSpawnRule() == null) {
            return;
        }
        int count = random.nextInt(value.max - value.min + 1) + value.min;
        BlockPos pos = null;
        for (int f = 0; f < count; ++f) {
            Event.Result canSpawn;
            if (!value.ruleStartSearch(lWorld)) {
                return;
            }
            if (f == 0) {
                pos = this.RandomPos.getRandomPos(lWorld, player.func_180425_c(), random, phase, value, value.getSpawnRule());
            } else {
                if (pos == null) {
                    return;
                }
                pos = this.RandomPos.getNearestRandomPos(lWorld, pos, random, phase, value, value.getSpawnRule());
            }
            if (pos == null) {
                if (!random.nextBoolean()) continue;
                --f;
                continue;
            }
            Entity entity = value.createEntity(lWorld, random, pos);
            if (entity == null || !(entity instanceof EntityParasiteBase)) continue;
            ((EntityParasiteBase)entity).canSpawnSpawn = true;
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            if (!SRPEConfigSystem.ignoreSRPRules && (canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)((EntityLiving)entity), (World)lWorld, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p())) == Event.Result.DENY) {
                if (DEBUG) {
                    for (EntityPlayer entityPlayer : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                        entityPlayer.func_145747_a((ITextComponent)new TextComponentString("KILLED: " + entity.func_70005_c_()));
                    }
                }
                return;
            }
            if (DEBUG) {
                for (EntityPlayer entityPlayer : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentString("SPAWNED: " + entity.func_70005_c_() + "   POS: " + entity.func_180425_c() + "   SpawnRule: " + value.getSpawnRule().getClass().getSimpleName()));
                }
            }
            ((EntityLiving)entity).func_180482_a(lWorld.func_175649_E(new BlockPos(entity)), null);
            lWorld.func_72838_d(entity);
        }
    }
}

