/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAdapted;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAncient;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPCosmical;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPCrude;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPFeral;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPHijacked;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPreeminent;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPrimitive;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPure;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationary;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import energon.srpextra.entity.ISRPExtraEntity;
import energon.srpextra.entity.adapted.IAdapted;
import energon.srpextra.entity.ancient.IAncient;
import energon.srpextra.entity.awakened.IAwakened;
import energon.srpextra.entity.crude.ICrude;
import energon.srpextra.entity.derived.IDerived;
import energon.srpextra.entity.deterrent.IDeterrent;
import energon.srpextra.entity.deterrent.INexus;
import energon.srpextra.entity.feral.IFeral;
import energon.srpextra.entity.head.IHead;
import energon.srpextra.entity.hijacked.IHijacked;
import energon.srpextra.entity.inborn.IInborn;
import energon.srpextra.entity.infected.IInfected;
import energon.srpextra.entity.primitive.IPrimitive;
import energon.srpextra.entity.pure.IPreeminent;
import energon.srpextra.entity.pure.IPure;
import energon.srpextra.entity.tendril.ITendril;
import net.minecraft.util.text.translation.I18n;

public enum EParasiteType {
    INBORN(0, "inborn"),
    INFECTED(1, "infected"),
    FERAL(2, "feral"),
    HIJACKED(3, "hijacked"),
    PRIMITIVE(4, "primitive"),
    ADAPTIVE(5, "adapted"),
    CRUDE(6, "crude"),
    PURE(7, "pure"),
    DERIVED(8, "derived"),
    NEXUS(9, "nexus"),
    DETERRENT(10, "deterrent"),
    PREEMINENT(11, "preeminent"),
    ANCIENT(12, "ancient"),
    HEAD(-1, "head"),
    TENDRIL(-2, "tendril");

    public final byte id;
    public final String name;

    private EParasiteType(int i, String n2) {
        this.id = (byte)i;
        this.name = n2;
    }

    public String getTranslateName() {
        return I18n.func_74838_a((String)("srpextra.parasite_type." + this.name));
    }

    public static EParasiteType getParasiteType(EntityParasiteBase parasiteBase) {
        if (parasiteBase instanceof ISRPExtraEntity) {
            if (parasiteBase instanceof IAdapted) {
                return ADAPTIVE;
            }
            if (parasiteBase instanceof IPrimitive) {
                return PRIMITIVE;
            }
            if (parasiteBase instanceof IInfected) {
                return INFECTED;
            }
            if (parasiteBase instanceof IInborn) {
                return INBORN;
            }
            if (parasiteBase instanceof IHijacked) {
                return HIJACKED;
            }
            if (parasiteBase instanceof IFeral) {
                return FERAL;
            }
            if (parasiteBase instanceof INexus) {
                return NEXUS;
            }
            if (parasiteBase instanceof IDeterrent) {
                return DETERRENT;
            }
            if (parasiteBase instanceof IPreeminent) {
                return PREEMINENT;
            }
            if (parasiteBase instanceof IPure) {
                return PURE;
            }
            if (parasiteBase instanceof ICrude) {
                return CRUDE;
            }
            if (parasiteBase instanceof IAwakened || parasiteBase instanceof IAncient) {
                return ANCIENT;
            }
            if (parasiteBase instanceof IDerived) {
                return DERIVED;
            }
            if (parasiteBase instanceof ITendril) {
                return TENDRIL;
            }
            if (parasiteBase instanceof IHead) {
                return HEAD;
            }
        }
        return EParasiteType.getTrueParasiteType(parasiteBase);
    }

    public static EParasiteType getTrueParasiteType(EntityParasiteBase parasiteBase) {
        if (parasiteBase instanceof EntityPAdapted) {
            return ADAPTIVE;
        }
        if (parasiteBase instanceof EntityPPrimitive) {
            return PRIMITIVE;
        }
        if (parasiteBase instanceof EntityPInfected) {
            return INFECTED;
        }
        if (parasiteBase instanceof EntityPHijacked) {
            return HIJACKED;
        }
        if (parasiteBase instanceof EntityPFeral) {
            return FERAL;
        }
        if (parasiteBase instanceof EntityPStationaryArchitect) {
            return NEXUS;
        }
        if (parasiteBase instanceof EntityPStationary) {
            return DETERRENT;
        }
        if (parasiteBase instanceof EntityPPreeminent) {
            return PREEMINENT;
        }
        if (parasiteBase instanceof EntityPPure) {
            return PURE;
        }
        if (parasiteBase instanceof EntityPCrude) {
            return CRUDE;
        }
        if (parasiteBase instanceof EntityPAncient) {
            return ANCIENT;
        }
        if (parasiteBase instanceof EntityPCosmical) {
            return DERIVED;
        }
        return INBORN;
    }
}

