/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util.preset;

import energon.srpextra.entity.IESpawnRule;
import energon.srpextra.util.config.SRPEConfigSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SRPEEntitySpawnRules {
    public static Map<String, Byte> DEFAULT_RULES = new HashMap<String, Byte>();
    public static Map<Byte, IESpawnRule> SPAWN_RULES = new HashMap<Byte, IESpawnRule>();

    public static void init() {
        DEFAULT_RULES.putIfAbsent("srparasites:pri_devourer", (byte)-3);
        DEFAULT_RULES.putIfAbsent("srparasites:sim_squid", (byte)-3);
        SPAWN_RULES.putIfAbsent((byte)-3, new SpawnRule_AQUATHREE());
        SPAWN_RULES.putIfAbsent((byte)-2, new SpawnRule_AQUATWO());
        SPAWN_RULES.putIfAbsent((byte)0, new SpawnRule_ZERO());
        SPAWN_RULES.putIfAbsent((byte)1, new SpawnRule_ONE());
        SPAWN_RULES.putIfAbsent((byte)2, new SpawnRule_TWO());
        SPAWN_RULES.putIfAbsent((byte)3, new SpawnRule_THREE());
        SPAWN_RULES.putIfAbsent((byte)4, new SpawnRule_Four());
    }

    public static void addonRules(byte v, IESpawnRule rule) {
        if (SRPEConfigSystem.SRPEPhaseSpawn) {
            SPAWN_RULES.putIfAbsent(v, rule);
        }
    }

    public static void addonDefRules(String name, byte v) {
        if (SRPEConfigSystem.SRPEPhaseSpawn) {
            DEFAULT_RULES.putIfAbsent(name, v);
        }
    }

    public static class SpawnRule_Four
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            if (!world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_185913_b() && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                IBlockState state = world.func_180495_p(pos);
                if (world.func_180495_p(pos.func_177981_b(1)).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177981_b(2)).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177981_b(3)).func_185904_a().func_76222_j() && state.func_185904_a().func_76222_j() && !state.func_185904_a().func_76224_d()) {
                    return this.checkLight(world, pos, phase) ? 1 : 2;
                }
            }
            return 0;
        }
    }

    public static class SpawnRule_THREE
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            if (!world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_185913_b() && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                IBlockState state = world.func_180495_p(pos);
                if (world.func_180495_p(pos.func_177981_b(1)).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177981_b(2)).func_185904_a().func_76222_j() && state.func_185904_a().func_76222_j() && !state.func_185904_a().func_76224_d()) {
                    return this.checkLight(world, pos, phase) ? 1 : 2;
                }
            }
            return 0;
        }
    }

    public static class SpawnRule_TWO
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            return IESpawnRule.super.canSpawnHere(world, pos, phase);
        }
    }

    public static class SpawnRule_ONE
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            IBlockState state;
            if (!world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_185913_b() && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() && (state = world.func_180495_p(pos)).func_185904_a().func_76222_j() && !state.func_185904_a().func_76224_d()) {
                return this.checkLight(world, pos, phase) ? 1 : 2;
            }
            return 0;
        }
    }

    public static class SpawnRule_ZERO
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            return world.func_175623_d(pos) ? 1 : 0;
        }
    }

    public static class SpawnRule_AQUATWO
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            if (!world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() && world.func_180495_p(pos).func_185904_a().func_76224_d()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean checkLight(World world, BlockPos pos, byte phase) {
            return true;
        }
    }

    public static class SpawnRule_AQUATHREE
    implements IESpawnRule {
        @Override
        public int canSpawnHere(World world, BlockPos pos, byte phase) {
            if (!world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177979_c(1)).func_185904_a().func_76224_d() && world.func_180495_p(pos).func_185904_a().func_76224_d() && world.func_180495_p(pos.func_177981_b(1)).func_185904_a().func_76224_d()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean checkLight(World world, BlockPos pos, byte phase) {
            return true;
        }
    }
}

