/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.world;

import energon.srpextra.util.Utilities;
import energon.srpextra.world.WorldGenCenter;
import energon.srpextra.world.WorldGenSpawn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SRPEStructureUtils {
    public static HashMap<String, Template> templateHashMap = new HashMap();
    public String name;
    public String structureLocation;
    public int type;
    public int weight;
    public int tier;
    public int offsetX;
    public int offsetY;
    public int offsetZ;
    public int[] dimensionsId;
    public String[] biomes;
    public int phase;
    public boolean rotation;
    public boolean BLB = true;
    public String[] elementsSettings = null;
    public byte[][] elements = null;
    public byte[][] elementsChance = null;
    public String[] includeEntities = null;

    public SRPEStructureUtils(String strName, int strType, int strWeight, int strTier, int strPhase, int strOffsetX, int strOffsetY, int strOffsetZ, int[] dimId, String[] biomeName, boolean strRot, @Nullable String loc) {
        this.name = strName;
        this.type = strType;
        this.weight = strWeight;
        this.tier = strTier;
        this.phase = strPhase;
        this.offsetX = strOffsetX;
        this.offsetY = strOffsetY;
        this.offsetZ = strOffsetZ;
        this.dimensionsId = dimId;
        this.biomes = biomeName;
        this.ACBBL();
        this.rotation = strRot;
        Template nTemplate = new Template();
        if (loc == null) {
            this.util(nTemplate);
        } else {
            try (InputStream input = this.getClass().getResourceAsStream("/assets/" + loc.replace(':', '/') + (loc.contains(".nbt") ? "" : ".nbt"));){
                if (input != null) {
                    this.structureLocation = loc;
                    nTemplate.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)input));
                    templateHashMap.putIfAbsent(this.structureLocation, nTemplate);
                } else {
                    this.util(nTemplate);
                }
            }
            catch (IOException ignored) {
                this.util(nTemplate);
            }
        }
    }

    public void util(Template nTemplate) {
        File customDir;
        this.structureLocation = "main:server:" + this.name;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            customDir = new File(Minecraft.func_71410_x().field_71412_D, "srpextra/" + this.name + ".nbt");
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                customDir = new File(server.func_71238_n(), "srpextra/" + this.name + ".nbt");
            } else {
                return;
            }
        }
        try (FileInputStream fis = new FileInputStream(customDir);){
            nTemplate.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)fis));
            templateHashMap.putIfAbsent(this.structureLocation, nTemplate);
        }
        catch (IOException e) {
            this.weight = -199;
        }
    }

    public static Template getTemplate(String key) {
        return templateHashMap.get(key);
    }

    public void addMassive(String[] elementS, String[] matrix) {
        this.elements = new byte[matrix.length][matrix[0].split(";").length];
        this.elementsChance = new byte[matrix.length][matrix[0].split(";").length];
        for (int b = 0; b < matrix.length; ++b) {
            String[] parts = matrix[b].split(";");
            for (int i = 0; i < parts.length; ++i) {
                String[] finParts = parts[i].split(",");
                this.elementsChance[b][i] = Byte.parseByte(finParts[0]);
                this.elements[b][i] = Byte.parseByte(finParts[1]);
            }
        }
        this.elementsSettings = elementS;
    }

    private void ACBBL() {
        for (String test : this.biomes) {
            if (test.charAt(0) == '!') continue;
            this.BLB = false;
            return;
        }
    }

    public boolean checkWorld(int test) {
        if (this.dimensionsId.length == 0) {
            return true;
        }
        for (int i : this.dimensionsId) {
            if (i != test) continue;
            return true;
        }
        return false;
    }

    public boolean checkBiome(World world, BlockPos pos) {
        if (this.biomes.length == 0) {
            return true;
        }
        Biome biomeCheck = world.func_180494_b(pos);
        if (biomeCheck.getRegistryName() == null) {
            return false;
        }
        String biomeCheckName = biomeCheck.getRegistryName().toString();
        boolean test = this.BLB;
        for (String partsB : this.biomes) {
            boolean cc = biomeCheckName.equals(partsB.toLowerCase().replace("!", ""));
            boolean cc2 = Utilities.checkBiomeType(biomeCheck, partsB.replace("!", ""));
            if (partsB.charAt(0) == '!') {
                if (!(partsB.contains(":") ? cc : cc2)) continue;
                return false;
            }
            if (partsB.contains(":")) {
                if (!cc || test) continue;
                test = true;
                continue;
            }
            if (!cc2 || test) continue;
            test = true;
        }
        return test;
    }

    public int spawnStructure(World world, BlockPos pos, @Nullable PlacementSettings settings, Random random, boolean loop, int worldPhase) {
        if (this.elementsSettings != null && this.elements != null && loop) {
            this.spawnMassive(world, pos, random, worldPhase);
            return 1;
        }
        Template template = SRPEStructureUtils.getTemplate(this.structureLocation);
        BlockPos startPos = pos;
        if (template != null) {
            int rot;
            if (settings == null) {
                settings = new PlacementSettings();
                if (this.rotation) {
                    rot = random.nextInt(4);
                    settings.func_186220_a(this.rotation2(rot));
                } else {
                    rot = 1;
                }
            } else {
                rot = this.rotation3(settings.func_186215_c());
            }
            int x = template.func_186259_a().func_177958_n();
            int z = template.func_186259_a().func_177952_p();
            switch (rot) {
                case 0: {
                    pos = pos.func_177970_e(x - 1);
                    break;
                }
                case 2: {
                    pos = pos.func_177965_g(z - 1);
                    break;
                }
                case 3: {
                    pos = pos.func_177965_g(x - 1).func_177970_e(z - 1);
                    break;
                }
            }
            pos = pos.func_177982_a(this.offsetX - x / 2, this.offsetY, this.offsetZ - z / 2);
            if (pos.func_177956_o() < 0 || pos.func_177956_o() > world.func_72800_K() - 2) {
                return 5;
            }
            template.func_186260_a(world, pos, settings);
            this.spawnIncludeEntities(world, startPos.func_177982_a(this.offsetX - x / 2, this.offsetY, this.offsetZ - z / 2), random, x, template.func_186259_a().func_177956_o(), z);
            if (WorldGenCenter.debug) {
                for (EntityPlayer player : world.field_73010_i) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Name: " + this.name));
                    player.func_145747_a((ITextComponent)new TextComponentString(pos.toString()));
                    if (world.func_180494_b(pos).getRegistryName() == null) continue;
                    player.func_145747_a((ITextComponent)new TextComponentString(world.func_180494_b(pos).getRegistryName().toString()));
                }
            }
            return 1;
        }
        return 3;
    }

    private Rotation rotation2(int rot) {
        switch (rot) {
            default: {
                return Rotation.NONE;
            }
            case 2: {
                return Rotation.CLOCKWISE_90;
            }
            case 3: {
                return Rotation.CLOCKWISE_180;
            }
            case 0: 
        }
        return Rotation.COUNTERCLOCKWISE_90;
    }

    private int rotation3(Rotation rot) {
        switch (rot) {
            default: {
                return 1;
            }
            case CLOCKWISE_90: {
                return 2;
            }
            case CLOCKWISE_180: {
                return 3;
            }
            case COUNTERCLOCKWISE_90: 
        }
        return 0;
    }

    public void spawnIncludeEntities(World world, BlockPos pos, Random random) {
        BlockPos templateSize = SRPEStructureUtils.getTemplate(this.structureLocation).func_186259_a();
        this.spawnIncludeEntities(world, pos, random, templateSize.func_177958_n(), templateSize.func_177956_o(), templateSize.func_177952_p());
    }

    public void spawnIncludeEntities(World world, BlockPos pos, Random random, int strSizeX, int strSizeY, int strSizeZ) {
        if (this.includeEntities != null) {
            Utilities.summonMobList(world, pos, this.includeEntities, random, strSizeX, strSizeY, strSizeZ);
        }
    }

    public void spawnMassive(World world, BlockPos pos, Random random, int worldPhase) {
        if (this.elementsSettings.length < 2) {
            return;
        }
        int massOffsetX = Integer.parseInt(this.elementsSettings[0].split(";")[0]);
        int massOffsetZ = Integer.parseInt(this.elementsSettings[0].split(";")[1]);
        Integer useOOX = null;
        Integer useOOZ = null;
        if (this.elementsSettings.length < 4) {
            useOOX = Integer.parseInt(this.elementsSettings[0].split(";")[2]);
            useOOZ = Integer.parseInt(this.elementsSettings[0].split(";")[3]);
        }
        int startOffsetX = this.elements[0].length;
        int startOffsetZ = this.elements.length;
        pos = pos.func_177982_a(-(startOffsetX / 2 * massOffsetX), 0, -(startOffsetZ / 2 * massOffsetZ));
        for (int z = 0; z < startOffsetZ; ++z) {
            for (int x = 0; x < startOffsetX; ++x) {
                SRPEStructureUtils util;
                if (random.nextInt(100) >= this.elementsChance[z][x] || (util = WorldGenCenter.search(this.searchSettingsForElement(this.elements[z][x]))) == null) continue;
                if (useOOX != null) {
                    WorldGenSpawn.spawn(world, new BlockPos(SRPEStructureUtils.fastUtils(pos.func_177958_n(), x, massOffsetX, useOOX, random), 0, SRPEStructureUtils.fastUtils(pos.func_177952_p(), z, massOffsetZ, useOOZ, random)), util, random, false, worldPhase);
                    continue;
                }
                WorldGenSpawn.spawn(world, new BlockPos(SRPEStructureUtils.fastUtils2(pos.func_177958_n(), x, massOffsetX), 0, SRPEStructureUtils.fastUtils2(pos.func_177952_p(), z, massOffsetZ)), util, random, false, worldPhase);
            }
        }
    }

    private static int fastUtils(int pos, int length, int offset, int offsetFF, Random random) {
        return pos + length * offset + (random.nextInt(offsetFF * 2) - offsetFF);
    }

    private static int fastUtils2(int pos, int length, int offset) {
        return pos + length * offset;
    }

    @Nullable
    public String searchSettingsForElement(byte id) {
        for (int i = 1; i < this.elementsSettings.length; ++i) {
            if (Byte.parseByte(this.elementsSettings[i].split(";")[0]) != id) continue;
            return this.elementsSettings[i].split(";")[1];
        }
        return null;
    }

    public String toString() {
        return "[" + this.name + ":" + this.weight + ":" + Arrays.toString(this.biomes) + ":" + Arrays.toString(this.dimensionsId) + " :Phase - " + this.phase + " :Location - " + this.structureLocation + "]";
    }
}

