/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity.adapted;

import com.dhanantry.scapeandrunparasites.entity.EntityBody;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityBodyParts;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import energon.srpextra.encyclopedia.ParasiteDataHandler;
import energon.srpextra.encyclopedia.data.ParasiteDataBase;
import energon.srpextra.entity.adapted.SRPEPAdapted;
import energon.srpextra.entity.ai.SRPEAI_Swimming;
import energon.srpextra.entity.tendril.EntityTendrilMiku;
import energon.srpextra.init.SRPEItems;
import energon.srpextra.util.Utilities;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMikuAdapted
extends SRPEPAdapted
implements EntityBodyParts {
    private static final DataParameter<Boolean> TENDRIL_LEFT = EntityDataManager.func_187226_a(EntityMikuAdapted.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TENDRIL_RIGHT = EntityDataManager.func_187226_a(EntityMikuAdapted.class, (DataSerializer)DataSerializers.field_187198_h);
    public byte skillID = 0;
    public float skillProgress = 1.0f;
    public float animationProgressPRE = 1.0f;
    public boolean performAttack = false;
    public int cooldown = 0;
    public EntityBody head;
    public EntityBody tendrilLeft;
    public EntityBody tendrilRight;
    public float healthTendrilLeft;
    public float healthTendrilRight;
    public float lowRot = 0.0f;
    public float preLowRot = 0.0f;

    public EntityMikuAdapted(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.9f);
        this.head = new EntityBody((EntityParasiteBase)this, 0.7f, 1.2f, 1.0f, 0.3f, 2.8f, -1, 1, false);
        this.tendrilLeft = new EntityBody((EntityParasiteBase)this, 0.4f, 0.6f, 1.0f, 0.3f, 2.8f, -1, 2, false);
        this.tendrilRight = new EntityBody((EntityParasiteBase)this, 0.4f, 0.6f, 1.0f, 0.3f, 2.8f, -1, 3, false);
        ParasiteDataBase part = this.getData().getPartEntity();
        this.healthTendrilLeft = this.healthTendrilRight = part != null ? part.getHealth() : 1.0f;
    }

    @Override
    public ParasiteDataBase getData() {
        return ParasiteDataHandler.ADA_STALKER;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TENDRIL_LEFT, (Object)true);
        this.field_70180_af.func_187214_a(TENDRIL_RIGHT, (Object)true);
    }

    public boolean tendrilLeftActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TENDRIL_LEFT);
    }

    public boolean tendrilRightActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TENDRIL_RIGHT);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("tl", this.healthTendrilLeft);
        compound.func_74776_a("tr", this.healthTendrilRight);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("tl") && compound.func_74760_g("tl") > 0.0f) {
            this.healthTendrilLeft = compound.func_74760_g("tl");
        } else {
            this.healthTendrilLeft = 0.0f;
            this.field_70180_af.func_187227_b(TENDRIL_LEFT, (Object)false);
        }
        if (compound.func_74764_b("tr") && compound.func_74760_g("tr") > 0.0f) {
            this.healthTendrilRight = compound.func_74760_g("tr");
        } else {
            this.healthTendrilRight = 0.0f;
            this.field_70180_af.func_187227_b(TENDRIL_RIGHT, (Object)false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getRoAnimation(float partialTick) {
        return this.lowRot == 0.0f ? 0.0f : this.preLowRot + (this.lowRot - this.preLowRot) * partialTick;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkillProgress(float partial) {
        return this.skillProgress == 1.0f ? 1.0f : this.animationProgressPRE + (this.skillProgress - this.animationProgressPRE) * partial;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SRPEAI_Swimming((EntityMob)this, 0.25, 0.15f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        super.func_184651_r();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.animationProgressPRE = this.skillProgress;
            if (this.preLowRot != this.lowRot) {
                this.preLowRot = this.lowRot;
            }
        }
        if (this.skillProgress != 1.0f && this.func_70089_S()) {
            this.skillProgressHandler();
        } else if (this.skillID != 0) {
            this.skillID = 0;
            this.performAttack = false;
        }
        IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177981_b(3));
        this.lowRot = state.func_177230_c() != Blocks.field_150350_a && !state.func_185904_a().func_76224_d() ? Math.min(this.lowRot + 0.07f, 1.0f) : Math.max(this.lowRot - 0.08f, 0.0f);
        if (this.head != null && this.partUpdate(this.head, 0.0f, 0.5f + this.lowRot * 0.8f, 2.8f - this.lowRot * 0.7f)) {
            this.field_70170_p.func_72973_f((Entity)this.head);
            this.head = null;
        }
        if (this.tendrilLeft != null && this.partUpdate(this.tendrilLeft, -157.0f + this.lowRot * 20.0f, 0.9f - this.lowRot * 0.5f, 2.5f)) {
            this.field_70170_p.func_72973_f((Entity)this.tendrilLeft);
            this.tendrilLeft = null;
        }
        if (this.tendrilRight != null && this.partUpdate(this.tendrilRight, 150.0f - this.lowRot * 20.0f, 0.9f - this.lowRot * 0.5f, 2.5f)) {
            this.field_70170_p.func_72973_f((Entity)this.tendrilRight);
            this.tendrilRight = null;
        }
    }

    public boolean partUpdate(EntityBody part, float angle, float offset, float offsetHeight) {
        if (part.getFather() == null || this.field_70128_L) {
            return true;
        }
        part.func_70071_h_();
        double yawRad = Math.toRadians(this.field_70177_z + angle);
        double offsetX = -MathHelper.func_76126_a((float)((float)yawRad)) * offset;
        double offsetZ = MathHelper.func_76134_b((float)((float)yawRad)) * offset;
        double X = this.field_70165_t + offsetX;
        double Y = this.field_70163_u + (double)offsetHeight;
        double Z = this.field_70161_v + offsetZ;
        part.func_70107_b(X, Y, Z);
        return false;
    }

    protected void func_70619_bc() {
        EntityLivingBase target;
        if (this.cooldown != 0) {
            this.cooldown = Math.max(this.cooldown - 1, 0);
        }
        if ((target = this.func_70638_az()) != null) {
            this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.cooldown == 0) {
                EntityPlayer player;
                this.cooldown = 10;
                if (target instanceof EntityPlayer && ((player = (EntityPlayer)target).func_184812_l_() || player.func_175149_v())) {
                    this.func_70624_b(null);
                    return;
                }
                double distance = this.func_70068_e((Entity)target);
                if (distance < 12.0) {
                    this.field_70699_by.func_75499_g();
                } else if (this.field_70699_by.func_75500_f() || this.targetX != target.field_70165_t || this.targetZ != target.field_70161_v || this.field_70146_Z.nextFloat() < 0.3f) {
                    this.targetX = target.field_70165_t;
                    this.targetZ = target.field_70161_v;
                    this.field_70699_by.func_75497_a((Entity)target, 1.2);
                }
                if (distance < 25.0) {
                    int randomNum = this.field_70146_Z.nextInt(6);
                    if (randomNum == 5) {
                        if (this.changeSkill(this.field_70146_Z.nextBoolean() ? (byte)103 : 104, false)) {
                            this.cooldown = 15;
                        }
                    } else if (this.changeSkill(this.field_70146_Z.nextBoolean() ? (byte)101 : 102, false)) {
                        this.cooldown = 15;
                    }
                }
            }
        }
    }

    public void skillProgressHandler() {
        block0 : switch (this.skillID) {
            case 101: {
                this.skillProgress = Math.min(this.skillProgress + 0.07f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.7f)) break;
                this.performAttack = false;
                int max = 3;
                for (EntityLivingBase target : Utilities.getTargetInZone((EntityLivingBase)this, 20.0f, 3.0f, -1.0f, 2.5f, 5.0f)) {
                    if (--max < 0) break block0;
                    this.func_70652_k((Entity)target);
                }
                break;
            }
            case 102: {
                this.skillProgress = Math.min(this.skillProgress + 0.07f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.7f)) break;
                this.performAttack = false;
                int max = 3;
                for (EntityLivingBase target : Utilities.getTargetInZone((EntityLivingBase)this, -20.0f, 3.0f, -1.0f, 2.5f, 5.0f)) {
                    if (--max < 0) break block0;
                    this.func_70652_k((Entity)target);
                }
                break;
            }
            case 103: {
                this.skillProgress = Math.min(this.skillProgress + 0.07f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.7f)) break;
                this.performAttack = false;
                int max = 5;
                for (EntityLivingBase target : Utilities.getTargetInZone((EntityLivingBase)this, 0.0f, 3.0f, -1.0f, 3.5f, 5.0f)) {
                    if (--max < 0) break block0;
                    this.func_70652_k((Entity)target);
                    if (!((double)this.field_70146_Z.nextFloat() < 0.2)) continue;
                    target.func_70690_d(new PotionEffect(SRPPotions.BLEED_E, 1, 100));
                }
                break;
            }
            case 104: {
                this.skillProgress = Math.min(this.skillProgress + 0.07f, 1.0f);
                if (this.field_70170_p.field_72995_K || !this.performAttack || !(this.skillProgress > 0.7f)) break;
                this.performAttack = false;
                int max = 3;
                for (EntityLivingBase target : Utilities.getTargetInZone((EntityLivingBase)this, 0.0f, 4.0f, -2.0f, 2.0f, 6.0f)) {
                    if (--max < 0) break block0;
                    target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 1.5));
                    if (!((double)this.field_70146_Z.nextFloat() < 0.2)) continue;
                    target.func_70690_d(new PotionEffect(SRPPotions.BLEED_E, 1, 100));
                }
                break;
            }
            default: {
                this.skillProgress = Math.min(this.skillProgress + 0.05f, 1.0f);
            }
        }
    }

    public boolean changeSkill(byte id, boolean ignore) {
        if (this.skillID == 0 || ignore) {
            this.skillID = id;
            this.skillProgress = 0.0f;
            this.performAttack = true;
            this.field_70170_p.func_72960_a((Entity)this, id);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.skillID = id;
                this.skillProgress = 0.0f;
                this.animationProgressPRE = 0.0f;
                return;
            }
            case 112: {
                this.setBodyPartDead(2);
                return;
            }
            case 113: {
                this.setBodyPartDead(3);
                return;
            }
        }
        super.func_70103_a(id);
    }

    public boolean attackEntityBodyFrom(DamageSource damageSource, float v, int i, boolean b) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (i == 1) {
            v *= 1.3f;
        }
        if (this.func_70097_a(damageSource, v)) {
            switch (i) {
                case 2: {
                    if (this.tendrilLeft == null) break;
                    if (this.tendrilLeftActive()) {
                        this.healthTendrilLeft -= v;
                        if (this.healthTendrilLeft > 0.0f) break;
                        EntityTendrilMiku tendril = new EntityTendrilMiku(this.field_70170_p);
                        tendril.func_82149_j((Entity)this.tendrilLeft);
                        this.field_70170_p.func_72838_d((Entity)tendril);
                        this.field_70180_af.func_187227_b(TENDRIL_LEFT, (Object)false);
                        this.cutResistances(SRPConfig.adaptedPointDamCap / 2);
                    }
                    this.setBodyPartDead(2);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)112);
                    break;
                }
                case 3: {
                    if (this.tendrilRight == null) break;
                    if (this.tendrilRightActive()) {
                        this.healthTendrilRight -= v;
                        if (this.healthTendrilRight > 0.0f) break;
                        EntityTendrilMiku tendril = new EntityTendrilMiku(this.field_70170_p);
                        tendril.func_82149_j((Entity)this.tendrilRight);
                        this.field_70170_p.func_72838_d((Entity)tendril);
                        this.field_70180_af.func_187227_b(TENDRIL_RIGHT, (Object)false);
                        this.cutResistances(SRPConfig.adaptedPointDamCap / 2);
                    }
                    this.setBodyPartDead(3);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)113);
                }
            }
        }
        return false;
    }

    public void setBodyPartDead(int i) {
        switch (i) {
            case 1: {
                if (this.head == null) break;
                this.field_70170_p.func_72973_f((Entity)this.head);
                this.head = null;
                break;
            }
            case 2: {
                if (this.tendrilLeft == null) break;
                this.healthTendrilLeft = 0.0f;
                this.field_70170_p.func_72973_f((Entity)this.tendrilLeft);
                this.tendrilLeft = null;
                break;
            }
            case 3: {
                if (this.tendrilRight == null) break;
                this.healthTendrilRight = 0.0f;
                this.field_70170_p.func_72973_f((Entity)this.tendrilRight);
                this.tendrilRight = null;
            }
        }
    }

    public void onRemovedFromWorld() {
        if (this.head != null) {
            this.field_70170_p.func_72973_f((Entity)this.head);
            this.head = null;
        }
        if (this.tendrilLeft != null) {
            this.field_70170_p.func_72973_f((Entity)this.tendrilLeft);
            this.tendrilLeft = null;
        }
        if (this.tendrilRight != null) {
            this.field_70170_p.func_72973_f((Entity)this.tendrilRight);
            this.tendrilRight = null;
        }
        super.onRemovedFromWorld();
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.MOBSILENCE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        return SRPSounds.MOBSILENCE;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SRPSounds.MOBSILENCE;
    }

    protected void func_180429_a(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        this.func_184185_a(SRPSounds.MONSTER_STEP, 0.05f, 1.0f);
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        return new ItemStack(SRPEItems.itemmobspawner_mikuadapted);
    }
}

