/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.network;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.custom.SRPEFile;
import energon.srpextra.world.SRPEStructureUtils;
import energon.srpextra.world.WorldGenCenter;
import energon.srpextra.world.WorldGenSpawn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class SRPStructuresCommand
extends CommandBase {
    public String func_71517_b() {
        return "srpstructures";
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "srpstructures <text>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, "srpextra");
    }

    public void func_184881_a(MinecraftServer minecraftServer, ICommandSender iCommandSender, String[] strings) throws CommandException {
        if (strings.length < 1) {
            return;
        }
        switch (strings[0]) {
            case "set": {
                int[] nArray;
                String string = strings[1];
                if (strings.length == 4) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = Integer.parseInt(strings[2]);
                    nArray = nArray2;
                    nArray2[1] = Integer.parseInt(strings[3]);
                } else {
                    nArray = new int[]{};
                }
                SRPStructuresCommand.set(iCommandSender, string, nArray);
                break;
            }
            case "list": {
                SRPStructuresCommand.check(iCommandSender);
                break;
            }
            case "info": {
                SRPStructuresCommand.str_info(iCommandSender, strings[1]);
                break;
            }
            case "dev": {
                SRPStructuresCommand.dev(iCommandSender, strings);
                break;
            }
            case "off_spawn": {
                WorldGenCenter.ENABLE = false;
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Structure Spawn: " + WorldGenCenter.ENABLE));
                break;
            }
            case "on_spawn": {
                WorldGenCenter.ENABLE = true;
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Structure Spawn: " + WorldGenCenter.ENABLE));
                break;
            }
            default: {
                SRPStructuresCommand.help(iCommandSender);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> tab = new ArrayList<String>();
        if (args.length == 1) {
            tab.add("help");
            tab.add("list");
            tab.add("set");
            tab.add("info");
            tab.add("dev");
            tab.add("off_spawn");
            tab.add("on_spawn");
        } else if (args.length == 2 && args[0].equals("dev")) {
            tab.add("debug");
        }
        return tab;
    }

    private static void dev(ICommandSender iCommandSender, String[] strings) {
        switch (strings[1]) {
            case "debug": {
                WorldGenCenter.debug = !WorldGenCenter.debug;
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Debug: " + WorldGenCenter.debug + (SRPEFile.enable ? "" : " - ignored (SRPExtra Structure Spawn Disabled)")));
            }
        }
    }

    private static void set(ICommandSender iCommandSender, String name, int[] position) {
        SRPEStructureUtils u = WorldGenCenter.search(name);
        if (u == null) {
            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: Structure Name not found"));
            return;
        }
        int sw = position.length == 2 ? WorldGenSpawn.spawn(iCommandSender.func_130014_f_(), new BlockPos(position[0], 0, position[1]), u, iCommandSender.func_130014_f_().field_73012_v, true, SRPSaveData.get((World)iCommandSender.func_130014_f_()).getEvolutionPhase(iCommandSender.func_130014_f_().field_73011_w.getDimension())) : WorldGenSpawn.spawn(iCommandSender.func_130014_f_(), new BlockPos(iCommandSender.func_180425_c().func_177958_n(), 0, iCommandSender.func_180425_c().func_177952_p()), u, iCommandSender.func_130014_f_().field_73012_v, true, SRPSaveData.get((World)iCommandSender.func_130014_f_()).getEvolutionPhase(iCommandSender.func_130014_f_().field_73011_w.getDimension()));
        switch (sw) {
            case 0: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: Parasite phase is not suitable"));
                return;
            }
            case 1: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Success: Structure created"));
                return;
            }
            case 2: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: Position not found"));
                return;
            }
            case 3: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: Template not found"));
                break;
            }
            case 4: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: The biome is not suitable"));
                return;
            }
            case 5: {
                iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: The structure goes beyond the world's borders."));
                return;
            }
        }
    }

    private static void check(ICommandSender iCommandSender) {
        for (SRPEStructureUtils bb : WorldGenCenter.structureList) {
            iCommandSender.func_145747_a((ITextComponent)new TextComponentString(bb.toString()));
        }
    }

    private static void str_info(ICommandSender iCommandSender, String name) {
        SRPEStructureUtils u = WorldGenCenter.search(name);
        if (u == null) {
            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Error: Structure Name not found"));
            return;
        }
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("---------------------------"));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Name: " + u.name));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Template Location: " + u.structureLocation));
        if (u.elementsSettings != null && u.elements != null) {
            iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Places an array of structures upon spawning."));
        }
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Phase: " + u.phase));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Tier: " + u.tier));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Weight: " + u.weight));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Type: " + u.type));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Rotation: " + u.rotation));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Biomes: " + Arrays.toString(u.biomes)));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Dimensions: " + Arrays.toString(u.dimensionsId)));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("Include Entities: " + Arrays.toString(u.includeEntities)));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("---------------------------"));
    }

    private static void help(ICommandSender iCommandSender) {
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("\"list\" - list of available structures"));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("\"set <structure_name>\" - place a structure (optionally with x, z coordinates)"));
        iCommandSender.func_145747_a((ITextComponent)new TextComponentString("\"info <structure_name>\" - view all available information about the structure"));
    }
}

