/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.util;

import energon.srpextra.entity.IPFromInside;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class SRPEMobInside {
    public static Map<String, MobInside> MOB_INSIDES = new HashMap<String, MobInside>();

    public static MobInside generate(String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] parts = pool.split(">");
                String[] sParts = parts[0].split(";");
                if (sParts.length <= 1) continue;
                Pool p = new Pool(Integer.parseInt(sParts[0]), sParts[1]);
                totalWeight += p.chance;
                if (sParts.length > 2) {
                    p.addMinMax(Integer.parseInt(sParts[2]), Integer.parseInt(sParts[3]));
                }
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            return new MobInside(totalWeight, (Pool[])genPools);
        }
        catch (NumberFormatException e) {
            return new MobInside(0, new Pool[0]);
        }
    }

    public static MobInside generate(String name, String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] parts = pool.split(">");
                String[] sParts = parts[0].split(";");
                if (sParts.length <= 1) continue;
                Pool p = new Pool(Integer.parseInt(sParts[0]), sParts[1]);
                totalWeight += p.chance;
                if (sParts.length > 2) {
                    p.addMinMax(Integer.parseInt(sParts[2]), Integer.parseInt(sParts[3]));
                }
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            MobInside table = new MobInside(totalWeight, (Pool[])genPools);
            MOB_INSIDES.putIfAbsent(name, table);
            return table;
        }
        catch (NumberFormatException e) {
            MobInside table = new MobInside(0, new Pool[0]);
            MOB_INSIDES.putIfAbsent(name, table);
            return table;
        }
    }

    public static MobInside generateFromSRP(String name, String[] pools) {
        try {
            int totalWeight = 0;
            Object[] genPools = new Pool[]{};
            for (String pool : pools) {
                String[] sParts = pool.split(";");
                if (sParts.length != 3) continue;
                Pool p = new Pool(100, sParts[0]);
                totalWeight += p.chance;
                p.addMinMax(Integer.parseInt(sParts[1]), Integer.parseInt(sParts[2]));
                genPools = (Pool[])ArrayUtils.add((Object[])genPools, (Object)p);
            }
            MobInside table = new MobInside(totalWeight, (Pool[])genPools);
            MOB_INSIDES.putIfAbsent(name, table);
            return table;
        }
        catch (NumberFormatException e) {
            MobInside table = new MobInside(0, new Pool[0]);
            MOB_INSIDES.putIfAbsent(name, table);
            return table;
        }
    }

    public static class Effect {
    }

    public static class Pool {
        public String mobName;
        public int chance;
        public Integer min;
        public Integer max;
        public Effect[] effects;

        public Pool(int chance, String name) {
            this.chance = chance;
            this.mobName = name;
        }

        public void addMinMax(int mn, int mx) {
            if (mn > mx) {
                this.max = mn;
                this.min = mx;
            } else {
                this.min = mn;
                this.max = mx;
            }
        }

        @Nullable
        public Entity createEntity(World world) {
            return EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.mobName), (World)world);
        }
    }

    public static class MobInside {
        public Integer totalChance;
        public Pool[] pools;

        public MobInside(Pool[] p) {
            this.pools = p;
        }

        public MobInside(Integer gw, Pool[] p) {
            this(p);
            this.totalChance = gw;
        }

        public void spawnMobInside(World world, double x, double y, double z, Random random, int globalChance, float distanceXZ, float distanceY, float velocityXZ, float velocityY, float offsetY) {
            for (Pool pool : this.pools) {
                Entity entity;
                if (pool.chance <= random.nextInt(globalChance) || (entity = pool.createEntity(world)) == null) continue;
                entity.func_70080_a(x + (double)((random.nextFloat() - 0.5f) * distanceXZ), y - (double)offsetY + (double)((random.nextFloat() - 0.5f) * distanceY), z + (double)((random.nextFloat() - 0.5f) * distanceXZ), random.nextFloat() * 360.0f, 0.0f);
                entity.func_70016_h((double)((random.nextFloat() - 0.5f) * velocityXZ), (double)((random.nextFloat() - 0.5f) * velocityY), (double)((random.nextFloat() - 0.5f) * velocityXZ));
                world.func_72838_d(entity);
            }
        }

        public void spawnMobInside(EntityLivingBase summoner, int globalChance, float distanceXZ, float distanceY, float velocityXZ, float velocityY, float offsetY) {
            Random random = summoner.func_70681_au();
            for (Pool pool : this.pools) {
                Entity entity;
                if (random.nextInt(globalChance) >= pool.chance || !((entity = pool.createEntity(summoner.func_130014_f_())) instanceof EntityLivingBase)) continue;
                EntityLivingBase livingBase = (EntityLivingBase)entity;
                if (livingBase instanceof IPFromInside) {
                    ((IPFromInside)livingBase).informationAboutPreForm(summoner);
                }
                if (livingBase instanceof EntityLiving) {
                    ((EntityLiving)livingBase).func_180482_a(summoner.field_70170_p.func_175649_E(summoner.func_180425_c()), null);
                }
                livingBase.func_70080_a(summoner.field_70165_t + (double)((random.nextFloat() - 0.5f) * distanceXZ), summoner.field_70163_u + (double)offsetY + (double)((random.nextFloat() - 0.5f) * distanceY), summoner.field_70161_v + (double)((random.nextFloat() - 0.5f) * distanceXZ), random.nextFloat() * 360.0f, 0.0f);
                livingBase.func_70024_g((double)((random.nextFloat() - 0.5f) * velocityXZ), (double)((random.nextFloat() - 0.5f) * velocityY), (double)((random.nextFloat() - 0.5f) * velocityXZ));
                summoner.field_70170_p.func_72838_d((Entity)livingBase);
            }
        }
    }
}

