/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy;

import com.takaya7s.range_destroy.Command;
import com.takaya7s.range_destroy.Destroyer;
import com.takaya7s.range_destroy.ServerNetwork;
import com.takaya7s.range_destroy.config.ConfigManager;
import com.takaya7s.range_destroy.config.ModConfig;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class RangeDestroy
implements ModInitializer {
    public static final String MOD_ID = "range_destroy";
    public static ModConfig config = null;
    public static final Object LOCK_CONFIG = new Object();
    private boolean isFailedLoadConfig = false;
    private ServerNetwork serverNetwork = null;
    private Command command = null;
    Destroyer lastDestroyer = null;

    public void onInitialize() {
        int i;
        ConfigManager.backupConfig();
        config = ConfigManager.loadConfig();
        if (config == null) {
            config = ConfigManager.createDefaultConfig();
            this.isFailedLoadConfig = true;
        }
        if (RangeDestroy.config.treeEnable == null) {
            RangeDestroy.config.treeEnable = new ConcurrentHashMap();
        }
        if (RangeDestroy.config.treeSelect == null) {
            RangeDestroy.config.treeSelect = new ConcurrentHashMap();
        }
        if (RangeDestroy.config.groundEnable == null) {
            RangeDestroy.config.groundEnable = new ConcurrentHashMap();
        }
        if (RangeDestroy.config.groundSelect == null) {
            RangeDestroy.config.groundSelect = new ConcurrentHashMap();
        }
        if (RangeDestroy.config.oreEnable == null) {
            RangeDestroy.config.oreEnable = new ConcurrentHashMap();
        }
        if (RangeDestroy.config.oreSelect == null) {
            RangeDestroy.config.oreSelect = new ConcurrentHashMap();
        }
        for (i = 0; i < RangeDestroy.config.trees.size(); ++i) {
            ModConfig.Tree tree = RangeDestroy.config.trees.get(i);
            if (tree.name != null && !tree.name.isEmpty()) continue;
            tree.name = "id" + String.valueOf(i);
        }
        for (i = 0; i < RangeDestroy.config.grounds.size(); ++i) {
            ModConfig.Ground ground = RangeDestroy.config.grounds.get(i);
            if (ground.name != null && !ground.name.isEmpty()) continue;
            ground.name = "id" + String.valueOf(i);
        }
        for (i = 0; i < RangeDestroy.config.ores.size(); ++i) {
            ModConfig.Ore ore = RangeDestroy.config.ores.get(i);
            if (ore.name != null && !ore.name.isEmpty()) continue;
            ore.name = "id" + String.valueOf(i);
        }
        ServerEntityEvents.ENTITY_LOAD.register(this::onEntityLoad);
        ServerEntityEvents.ENTITY_UNLOAD.register(this::onEntityUnload);
        PlayerBlockBreakEvents.BEFORE.register(this::onPlayerBreakBlock);
        ServerNetwork.init();
        Command.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEntityLoad(class_1297 entity, class_3218 world) {
        String message;
        if (!entity.method_31747()) {
            return;
        }
        class_3222 player = (class_3222)entity;
        String uuid = player.method_7334().getId().toString();
        boolean isNeedSave = false;
        boolean enable = false;
        int index = 0;
        if (RangeDestroy.config.treeEnable.containsKey(uuid)) {
            index = RangeDestroy.config.treeSelect.getOrDefault(uuid, 0);
            if (index >= RangeDestroy.config.trees.size()) {
                index = 0;
                RangeDestroy.config.treeSelect.replace(uuid, index);
            }
            if (enable = RangeDestroy.config.treeEnable.get(uuid).booleanValue()) {
                message = "RangeDestroy: tree " + RangeDestroy.config.trees.get((int)index).name + " ON";
                player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
        } else {
            RangeDestroy.config.treeEnable.put(uuid, false);
            RangeDestroy.config.treeSelect.put(uuid, 0);
            isNeedSave = true;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerNetwork.S2C_TreeStatusPayload(enable, index));
        enable = false;
        index = 0;
        if (RangeDestroy.config.groundEnable.containsKey(uuid)) {
            index = RangeDestroy.config.groundSelect.getOrDefault(uuid, 0);
            if (index >= RangeDestroy.config.grounds.size()) {
                index = 0;
                RangeDestroy.config.groundSelect.replace(uuid, index);
            }
            if (enable = RangeDestroy.config.groundEnable.get(uuid).booleanValue()) {
                message = "RangeDestroy: ground " + RangeDestroy.config.grounds.get((int)index).name + " ON";
                player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
        } else {
            RangeDestroy.config.groundEnable.put(uuid, false);
            RangeDestroy.config.groundSelect.put(uuid, 0);
            isNeedSave = true;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerNetwork.S2C_GroundStatusPayload(enable, index));
        enable = false;
        index = 0;
        if (RangeDestroy.config.oreEnable.containsKey(uuid)) {
            index = RangeDestroy.config.oreSelect.getOrDefault(uuid, 0);
            if (index >= RangeDestroy.config.ores.size()) {
                index = 0;
                RangeDestroy.config.oreSelect.replace(uuid, index);
            }
            if (enable = RangeDestroy.config.oreEnable.get(uuid).booleanValue()) {
                message = "RangeDestroy: ore " + RangeDestroy.config.ores.get((int)index).name + " ON";
                player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
        } else {
            RangeDestroy.config.oreEnable.put(uuid, false);
            RangeDestroy.config.oreSelect.put(uuid, 0);
            isNeedSave = true;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerNetwork.S2C_OreStatusPayload(enable, index));
        if (isNeedSave) {
            Object object = LOCK_CONFIG;
            synchronized (object) {
                ConfigManager.saveConfig(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEntityUnload(class_1297 entity, class_3218 world) {
        if (!entity.method_31747()) {
            return;
        }
        Object object = LOCK_CONFIG;
        synchronized (object) {
            ConfigManager.saveConfig(config);
        }
    }

    private boolean onPlayerBreakBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return true;
        }
        class_3218 serverWorld = (class_3218)world;
        boolean defaultDestroy = true;
        Destroyer destroyer = null;
        destroyer = new Destroyer();
        destroyer.init(serverWorld, player, pos, state);
        defaultDestroy &= destroyer.destroyTree();
        defaultDestroy &= destroyer.destroyGround();
        this.lastDestroyer = destroyer;
        return defaultDestroy &= destroyer.destroyOre();
    }

    public static String getKeyBindId(String name) {
        return String.join((CharSequence)".", "key", MOD_ID, name);
    }

    public static class_2960 getIdentifier(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static class_8710.class_9154 getPayloadId(String name) {
        return new class_8710.class_9154(class_2960.method_60655((String)MOD_ID, (String)name));
    }
}

