/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy;

import com.takaya7s.range_destroy.BlockInfo;
import com.takaya7s.range_destroy.RangeDestroy;
import com.takaya7s.range_destroy.config.ModConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6017;
import net.minecraft.class_8567;

public class Destroyer {
    public class_3218 world;
    public class_1657 player;
    public class_2338 pos;
    public class_2680 state;
    public class_1799 tool;
    public String itemId;
    public String blockId;
    public List<BlockInfo> searchList = new ArrayList<BlockInfo>();
    public List<BlockInfo> checkedList = new ArrayList<BlockInfo>();
    public List<BlockInfo> destroyList = new ArrayList<BlockInfo>();
    public Set<BlockInfo> checkedHash = new HashSet<BlockInfo>(1024);

    public void init(class_3218 world, class_1657 player, class_2338 pos, class_2680 state) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.state = state;
        this.tool = player.method_6047();
        this.itemId = this.tool.method_7909().method_7876();
        this.blockId = state.method_26204().method_63499();
    }

    private boolean compareArray(String target, String[] ids) {
        for (String id : ids) {
            if (!target.equals(id) && !target.endsWith("." + id)) continue;
            return true;
        }
        return false;
    }

    private boolean checkStartTree(ModConfig.Tree treeConfig) {
        return this.compareArray(this.itemId, treeConfig.axeIds) && this.compareArray(this.blockId, treeConfig.logBlockIds);
    }

    private boolean checkStartGround(ModConfig.Ground groundConfig) {
        if (this.compareArray(this.itemId, groundConfig.shovelIds)) {
            return this.compareArray(this.blockId, groundConfig.dirtBlockIds);
        }
        if (this.compareArray(this.itemId, groundConfig.pickaxeIds)) {
            if (groundConfig.pickaxeOverShovel) {
                return this.compareArray(this.blockId, groundConfig.dirtBlockIds) || this.compareArray(this.blockId, groundConfig.stoneBlockIds);
            }
            return this.compareArray(this.blockId, groundConfig.stoneBlockIds);
        }
        return false;
    }

    private boolean checkStartOre(ModConfig.Ore oreConfig) {
        return this.compareArray(this.itemId, oreConfig.pickaxeIds) && this.compareArray(this.blockId, oreConfig.oreBlockIds);
    }

    private void checkLogToLeafAndLog(ModConfig.Tree treeConfig, BlockInfo source, int offsetX, int offsetY, int offsetZ, int distance) {
        BlockInfo check = this.newBlockInfo(source, offsetX, offsetY, offsetZ);
        if (this.compareArray(check.blockId, treeConfig.leefBlockIds)) {
            this.LogToLeaf(treeConfig, source, check);
        } else if (this.compareArray(check.blockId, treeConfig.logBlockIds)) {
            this.LogToLog(treeConfig, source, check, distance);
        } else {
            this.LogToOther(source, check);
        }
    }

    private void checkLogToLogOnly(ModConfig.Tree treeConfig, BlockInfo source, int offsetX, int offsetY, int offsetZ, int distance) {
        BlockInfo check = this.newBlockInfo(source, offsetX, offsetY, offsetZ);
        if (this.compareArray(check.blockId, treeConfig.logBlockIds)) {
            this.LogToLog(treeConfig, source, check, distance);
        }
    }

    private void LogToLog(ModConfig.Tree treeConfig, BlockInfo source, BlockInfo check, int distance) {
        if (check.distance < 0) {
            return;
        }
        if (!this.containChecked(check)) {
            if (source.isFirstGroup) {
                if (check.pos.method_10264() >= source.pos.method_10264() || treeConfig.destroyUnderLog) {
                    check.distance = 0;
                    this.searchList.addFirst(check);
                    this.checkedList.add(check);
                    this.destroyList.add(check);
                }
            } else {
                check.isFirstGroup = false;
                check.otherDistance = 0;
                this.searchList.addFirst(check);
                this.checkedList.add(check);
            }
        }
    }

    private void LogToLeaf(ModConfig.Tree treeConfig, BlockInfo source, BlockInfo check) {
        if (check.distance < 0) {
            return;
        }
        int index = this.searchChecked(check);
        if (index == -1) {
            if (source.isFirstGroup) {
                check.distance = 1;
                if (treeConfig.leavesRange > 0) {
                    this.searchList.add(check);
                    this.checkedList.add(check);
                    this.destroyList.add(check);
                } else {
                    this.checkedList.add(check);
                }
            } else {
                check.isFirstGroup = false;
                check.otherDistance = 1;
                if (check.otherDistance < treeConfig.keepLeavesRange) {
                    this.searchList.add(check);
                    this.checkedList.add(check);
                } else {
                    this.checkedList.add(check);
                }
            }
        } else {
            BlockInfo find = this.checkedList.get(index);
            if (source.isFirstGroup) {
                if (find.distance > 1) {
                    check.distance = 1;
                    this.searchList.add(check);
                    index = this.searchDestroy(check);
                    if (index == -1) {
                        this.destroyList.add(check);
                    } else {
                        this.destroyList.set(index, check);
                    }
                }
            } else {
                check.isFirstGroup = false;
                check.otherDistance = 1;
                if (find.otherDistance <= check.otherDistance) {
                    return;
                }
                if (check.otherDistance < treeConfig.keepLeavesRange) {
                    this.searchList.add(check);
                    this.checkedList.set(index, check);
                    index = this.searchDestroy(check);
                    if (index != -1) {
                        this.destroyList.remove(index);
                    }
                }
            }
        }
    }

    private void LogToOther(BlockInfo source, BlockInfo check) {
        if (check.distance < 0) {
            return;
        }
        check.distance = -1;
        this.checkedList.add(check);
    }

    private void checkLogToGroup(ModConfig.Tree treeConfig, BlockInfo target) {
        this.checkLogToLogOnly(treeConfig, target, -1, 1, -1, 3);
        this.checkLogToLogOnly(treeConfig, target, 0, 1, -1, 2);
        this.checkLogToLogOnly(treeConfig, target, 1, 1, -1, 3);
        this.checkLogToLogOnly(treeConfig, target, -1, 1, 0, 2);
        this.checkLogToLeafAndLog(treeConfig, target, 0, 1, 0, 1);
        this.checkLogToLogOnly(treeConfig, target, 1, 1, 0, 2);
        this.checkLogToLogOnly(treeConfig, target, -1, 1, 1, 3);
        this.checkLogToLogOnly(treeConfig, target, 0, 1, 1, 2);
        this.checkLogToLogOnly(treeConfig, target, 1, 1, 1, 3);
        this.checkLogToLogOnly(treeConfig, target, -1, 0, -1, 2);
        this.checkLogToLeafAndLog(treeConfig, target, 0, 0, -1, 1);
        this.checkLogToLogOnly(treeConfig, target, 1, 0, -1, 2);
        this.checkLogToLeafAndLog(treeConfig, target, -1, 0, 0, 1);
        this.checkLogToLeafAndLog(treeConfig, target, 1, 0, 0, 1);
        this.checkLogToLogOnly(treeConfig, target, -1, 0, 1, 2);
        this.checkLogToLeafAndLog(treeConfig, target, 0, 0, 1, 1);
        this.checkLogToLogOnly(treeConfig, target, 1, 0, 1, 2);
        this.checkLogToLogOnly(treeConfig, target, -1, -1, -1, 3);
        this.checkLogToLogOnly(treeConfig, target, 0, -1, -1, 2);
        this.checkLogToLogOnly(treeConfig, target, 1, -1, -1, 3);
        this.checkLogToLogOnly(treeConfig, target, -1, -1, 0, 2);
        this.checkLogToLeafAndLog(treeConfig, target, 0, -1, 0, 1);
        this.checkLogToLogOnly(treeConfig, target, 1, -1, 0, 2);
        this.checkLogToLogOnly(treeConfig, target, -1, -1, 1, 3);
        this.checkLogToLogOnly(treeConfig, target, 0, -1, 1, 2);
        this.checkLogToLogOnly(treeConfig, target, 1, -1, 1, 3);
    }

    private void checkLeafToLeafAndLog(ModConfig.Tree treeConfig, BlockInfo source, int offsetX, int offsetY, int offsetZ) {
        BlockInfo check = this.newBlockInfo(source, offsetX, offsetY, offsetZ);
        if (this.compareArray(check.blockId, treeConfig.leefBlockIds)) {
            this.LeafToLeaf(treeConfig, source, check);
        } else if (this.compareArray(check.blockId, treeConfig.logBlockIds)) {
            this.LeafToLog(source, check);
        } else {
            this.LeafToOther(treeConfig, source, check);
        }
    }

    private void LeafToLog(BlockInfo source, BlockInfo check) {
        if (check.distance < 0) {
            return;
        }
        if (!this.containChecked(check)) {
            check.isFirstGroup = false;
            check.otherDistance = 0;
            this.searchList.addFirst(check);
            this.checkedList.add(check);
        }
    }

    private void LeafToLeaf(ModConfig.Tree treeConfig, BlockInfo source, BlockInfo check) {
        if (check.distance < 0) {
            return;
        }
        int index = this.searchChecked(check);
        if (index == -1) {
            if (source.isFirstGroup) {
                check.distance = source.distance + 1;
                if (check.distance <= treeConfig.leavesRange) {
                    this.searchList.add(check);
                    this.checkedList.add(check);
                    this.destroyList.add(check);
                } else if (check.distance <= treeConfig.leavesRange + treeConfig.keepLeavesRange) {
                    this.searchList.add(check);
                    this.checkedList.add(check);
                } else {
                    this.checkedList.add(check);
                }
            } else {
                check.isFirstGroup = false;
                check.otherDistance = source.otherDistance + 1;
                if (check.otherDistance < treeConfig.keepLeavesRange) {
                    this.searchList.add(check);
                    this.checkedList.add(check);
                } else {
                    this.checkedList.add(check);
                }
            }
        } else {
            BlockInfo find = this.checkedList.get(index);
            if (source.isFirstGroup) {
                if (check.isFirstGroup) {
                    check.distance = source.distance + 1;
                    if (find.distance <= check.distance) {
                        return;
                    }
                    if (check.distance <= treeConfig.leavesRange) {
                        this.searchList.add(check);
                        this.checkedList.set(index, check);
                        index = this.searchDestroy(check);
                        if (index == -1) {
                            this.destroyList.add(check);
                        } else {
                            this.destroyList.set(index, check);
                        }
                    } else if (check.distance <= treeConfig.leavesRange + treeConfig.keepLeavesRange) {
                        this.searchList.add(check);
                        this.checkedList.set(index, check);
                    } else {
                        this.checkedList.set(index, check);
                    }
                }
            } else {
                check.isFirstGroup = false;
                check.otherDistance = source.otherDistance + 1;
                if (find.otherDistance <= check.otherDistance) {
                    return;
                }
                if (check.otherDistance < treeConfig.keepLeavesRange) {
                    this.searchList.add(check);
                }
                if (check.otherDistance <= treeConfig.keepLeavesRange) {
                    this.checkedList.set(index, check);
                    index = this.searchDestroy(check);
                    if (index != -1) {
                        this.destroyList.remove(index);
                    }
                }
            }
        }
    }

    private void LeafToOther(ModConfig.Tree treeConfig, BlockInfo source, BlockInfo check) {
        if (check.distance < 0) {
            return;
        }
        check.distance = -1;
        this.checkedList.add(check);
    }

    private void checkLeafToGroup(ModConfig.Tree treeConfig, BlockInfo target) {
        this.checkLeafToLeafAndLog(treeConfig, target, 0, 1, 0);
        this.checkLeafToLeafAndLog(treeConfig, target, -1, 0, 0);
        this.checkLeafToLeafAndLog(treeConfig, target, 1, 0, 0);
        this.checkLeafToLeafAndLog(treeConfig, target, 0, 0, -1);
        this.checkLeafToLeafAndLog(treeConfig, target, 0, 0, 1);
        this.checkLeafToLeafAndLog(treeConfig, target, 0, -1, 0);
    }

    private void OreToOre(ModConfig.Ore oreConfig, BlockInfo base, BlockInfo source, int offsetX, int offsetY, int offsetZ) {
        if (!oreConfig.destroyUnder && source.pos.method_10264() + offsetY < base.pos.method_10264()) {
            return;
        }
        BlockInfo check = this.newBlockInfo(source, offsetX, offsetY, offsetZ);
        if (!this.checkedHash.contains(check)) {
            if (source.blockId.equals(check.blockId)) {
                this.searchList.add(check);
                this.checkedHash.add(check);
                this.destroyList.add(check);
            } else {
                this.checkedHash.add(check);
            }
        }
    }

    private void OreToGroup(ModConfig.Ore oreConfig, BlockInfo base, BlockInfo target) {
        this.OreToOre(oreConfig, base, target, -1, 1, -1);
        this.OreToOre(oreConfig, base, target, 0, 1, -1);
        this.OreToOre(oreConfig, base, target, 1, 1, -1);
        this.OreToOre(oreConfig, base, target, -1, 1, 0);
        this.OreToOre(oreConfig, base, target, 0, 1, 0);
        this.OreToOre(oreConfig, base, target, 1, 1, 0);
        this.OreToOre(oreConfig, base, target, -1, 1, 1);
        this.OreToOre(oreConfig, base, target, 0, 1, 1);
        this.OreToOre(oreConfig, base, target, 1, 1, 1);
        this.OreToOre(oreConfig, base, target, -1, 0, -1);
        this.OreToOre(oreConfig, base, target, 0, 0, -1);
        this.OreToOre(oreConfig, base, target, 1, 0, -1);
        this.OreToOre(oreConfig, base, target, -1, 0, 0);
        this.OreToOre(oreConfig, base, target, 1, 0, 0);
        this.OreToOre(oreConfig, base, target, -1, 0, 1);
        this.OreToOre(oreConfig, base, target, 0, 0, 1);
        this.OreToOre(oreConfig, base, target, 1, 0, 1);
        this.OreToOre(oreConfig, base, target, -1, -1, -1);
        this.OreToOre(oreConfig, base, target, 0, -1, -1);
        this.OreToOre(oreConfig, base, target, 1, -1, -1);
        this.OreToOre(oreConfig, base, target, -1, -1, 0);
        this.OreToOre(oreConfig, base, target, 0, -1, 0);
        this.OreToOre(oreConfig, base, target, 1, -1, 0);
        this.OreToOre(oreConfig, base, target, -1, -1, 1);
        this.OreToOre(oreConfig, base, target, 0, -1, 1);
        this.OreToOre(oreConfig, base, target, 1, -1, 1);
    }

    public boolean destroyTree() {
        String uuid = this.player.method_7334().getId().toString();
        if (!RangeDestroy.config.treeEnable.containsKey(uuid)) {
            return true;
        }
        if (!RangeDestroy.config.treeEnable.get(uuid).booleanValue()) {
            return true;
        }
        int index = RangeDestroy.config.treeSelect.getOrDefault(uuid, 0);
        ModConfig.Tree treeConfig = RangeDestroy.config.trees.get(index);
        if (!this.checkStartTree(treeConfig)) {
            return true;
        }
        if (this.player.method_68878() && treeConfig.invalidCreative) {
            return true;
        }
        this.searchList.clear();
        this.checkedList.clear();
        this.destroyList.clear();
        this.searchList.add(this.newBlockInfo(this.pos, 0));
        this.checkedList.add(this.searchList.getFirst());
        this.destroyList.add(this.searchList.getFirst());
        while (!this.searchList.isEmpty()) {
            BlockInfo target = this.searchList.getFirst();
            this.searchList.removeFirst();
            if (this.compareArray(target.blockId, treeConfig.leefBlockIds)) {
                this.checkLeafToGroup(treeConfig, target);
                continue;
            }
            if (!this.compareArray(target.blockId, treeConfig.logBlockIds)) continue;
            this.checkLogToGroup(treeConfig, target);
        }
        for (BlockInfo destroy : this.destroyList) {
            if (treeConfig.autoCollect) {
                this.breakBlockAndCollect(destroy);
                continue;
            }
            this.breakBlockNoCollect(destroy);
        }
        return false;
    }

    public boolean destroyGround() {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        String uuid = this.player.method_7334().getId().toString();
        if (!RangeDestroy.config.groundEnable.containsKey(uuid)) {
            return true;
        }
        if (!RangeDestroy.config.groundEnable.get(uuid).booleanValue()) {
            return true;
        }
        int index = RangeDestroy.config.groundSelect.getOrDefault(uuid, 0);
        ModConfig.Ground groundConfig = RangeDestroy.config.grounds.get(index);
        if (!this.checkStartGround(groundConfig)) {
            return true;
        }
        if (this.player.method_68878() && groundConfig.invalidCreative) {
            return true;
        }
        this.searchList.clear();
        this.checkedHash.clear();
        this.destroyList.clear();
        BlockInfo base = this.newBlockInfo(this.pos, 0);
        boolean isShovel = this.compareArray(this.itemId, groundConfig.shovelIds);
        int minY = groundConfig.destroyUnder ? base.pos.method_10264() - groundConfig.downRange : base.pos.method_10264();
        int maxY = base.pos.method_10264() + groundConfig.upRange;
        float yaw = this.player.method_36454();
        if ((double)yaw <= -135.0 || (double)yaw > 135.0) {
            minX = base.pos.method_10263() - groundConfig.leftRange;
            maxX = base.pos.method_10263() + groundConfig.rightRange;
            minZ = base.pos.method_10260() - groundConfig.frontRange;
            maxZ = base.pos.method_10260() + groundConfig.backRange;
        } else if ((double)yaw > 45.0) {
            minX = base.pos.method_10263() - groundConfig.frontRange;
            maxX = base.pos.method_10263() + groundConfig.backRange;
            minZ = base.pos.method_10260() - groundConfig.rightRange;
            maxZ = base.pos.method_10260() + groundConfig.leftRange;
        } else if ((double)yaw > -45.0) {
            minX = base.pos.method_10263() - groundConfig.rightRange;
            maxX = base.pos.method_10263() + groundConfig.leftRange;
            minZ = base.pos.method_10260() - groundConfig.backRange;
            maxZ = base.pos.method_10260() + groundConfig.frontRange;
        } else {
            minX = base.pos.method_10263() - groundConfig.backRange;
            maxX = base.pos.method_10263() + groundConfig.frontRange;
            minZ = base.pos.method_10260() - groundConfig.leftRange;
            maxZ = base.pos.method_10260() + groundConfig.rightRange;
        }
        if (groundConfig.connectOnly) {
            this.searchList.add(base);
            this.checkedHash.add(base);
            this.destroyList.add(base);
            boolean isBaseStone = this.compareArray(this.blockId, groundConfig.stoneBlockIds);
            int[] offsetXs = new int[]{1, -1, 0, 0, 0, 0};
            int[] offsetYs = new int[]{0, 0, 1, -1, 0, 0};
            int[] offsetZs = new int[]{0, 0, 0, 0, 1, -1};
            while (!this.searchList.isEmpty()) {
                BlockInfo target = this.searchList.getFirst();
                this.searchList.removeFirst();
                for (int i = 0; i < 6; ++i) {
                    BlockInfo check = this.newBlockInfo(target, offsetXs[i], offsetYs[i], offsetZs[i]);
                    if (this.checkedHash.contains(check)) continue;
                    if (check.pos.method_10264() < minY || check.pos.method_10264() > maxY || check.pos.method_10263() < minX || check.pos.method_10263() > maxX || check.pos.method_10260() < minZ || check.pos.method_10260() > maxZ) {
                        this.checkedHash.add(check);
                        continue;
                    }
                    if (groundConfig.sameOnly) {
                        if (base.blockId.equals(check.blockId)) {
                            this.searchList.add(check);
                            this.destroyList.add(check);
                        }
                        this.checkedHash.add(check);
                        continue;
                    }
                    if (isBaseStone) {
                        if (this.compareArray(check.blockId, groundConfig.stoneBlockIds)) {
                            this.searchList.add(check);
                            this.destroyList.add(check);
                        } else if (this.compareArray(check.blockId, groundConfig.dirtBlockIds) && groundConfig.pickaxeOverShovel) {
                            this.searchList.add(check);
                            this.destroyList.add(check);
                        }
                        this.checkedHash.add(check);
                        continue;
                    }
                    if (this.compareArray(check.blockId, groundConfig.dirtBlockIds)) {
                        this.searchList.add(check);
                        this.destroyList.add(check);
                    } else if (this.compareArray(check.blockId, groundConfig.stoneBlockIds) && groundConfig.pickaxeOverShovel && !isShovel) {
                        this.searchList.add(check);
                        this.destroyList.add(check);
                    }
                    this.checkedHash.add(check);
                }
            }
        } else {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        BlockInfo check = this.newBlockInfo(new class_2338(x, y, z), 0);
                        if (groundConfig.sameOnly) {
                            if (!base.blockId.equals(check.blockId)) continue;
                            this.destroyList.add(check);
                            continue;
                        }
                        if (isShovel) {
                            if (!this.compareArray(check.blockId, groundConfig.dirtBlockIds)) continue;
                            this.destroyList.add(check);
                            continue;
                        }
                        if (this.compareArray(check.blockId, groundConfig.stoneBlockIds)) {
                            this.destroyList.add(check);
                        }
                        if (!groundConfig.pickaxeOverShovel || !this.compareArray(check.blockId, groundConfig.dirtBlockIds)) continue;
                        this.destroyList.add(check);
                    }
                }
            }
        }
        for (BlockInfo destroy : this.destroyList) {
            if (groundConfig.autoCollect) {
                this.breakBlockAndCollect(destroy);
                continue;
            }
            this.breakBlockNoCollect(destroy);
        }
        return false;
    }

    public boolean destroyOre() {
        String uuid = this.player.method_7334().getId().toString();
        if (!RangeDestroy.config.oreEnable.containsKey(uuid)) {
            return true;
        }
        if (!RangeDestroy.config.oreEnable.get(uuid).booleanValue()) {
            return true;
        }
        int index = RangeDestroy.config.oreSelect.getOrDefault(uuid, 0);
        ModConfig.Ore oreConfig = RangeDestroy.config.ores.get(index);
        if (!this.checkStartOre(oreConfig)) {
            return true;
        }
        if (this.player.method_68878() && oreConfig.invalidCreative) {
            return true;
        }
        this.searchList.clear();
        this.checkedHash.clear();
        this.destroyList.clear();
        BlockInfo base = this.newBlockInfo(this.pos, 0);
        this.searchList.add(base);
        this.checkedHash.add(base);
        this.destroyList.add(base);
        while (!this.searchList.isEmpty()) {
            BlockInfo target = this.searchList.getFirst();
            this.searchList.removeFirst();
            this.OreToGroup(oreConfig, base, target);
        }
        for (BlockInfo destroy : this.destroyList) {
            if (oreConfig.autoCollect) {
                this.breakBlockAndCollect(destroy);
                continue;
            }
            this.breakBlockNoCollect(destroy);
        }
        return false;
    }

    public boolean containChecked(BlockInfo block) {
        for (BlockInfo check : this.checkedList) {
            if (block.pos.method_10263() != check.pos.method_10263() || block.pos.method_10264() != check.pos.method_10264() || block.pos.method_10260() != check.pos.method_10260()) continue;
            return true;
        }
        return false;
    }

    public int searchChecked(BlockInfo block) {
        for (int i = 0; i < this.checkedList.size(); ++i) {
            BlockInfo check = this.checkedList.get(i);
            if (block.pos.method_10263() != check.pos.method_10263() || block.pos.method_10264() != check.pos.method_10264() || block.pos.method_10260() != check.pos.method_10260()) continue;
            return i;
        }
        return -1;
    }

    public int searchDestroy(BlockInfo block) {
        for (int i = 0; i < this.destroyList.size(); ++i) {
            BlockInfo destroy = this.destroyList.get(i);
            if (block.pos.method_10263() != destroy.pos.method_10263() || block.pos.method_10264() != destroy.pos.method_10264() || block.pos.method_10260() != destroy.pos.method_10260()) continue;
            return i;
        }
        return -1;
    }

    public List<class_1799> getDrops(class_243 targetVec3d, class_2680 targetBlockState) {
        class_8567.class_8568 lootContext = new class_8567.class_8568(this.world).method_51874(class_181.field_24424, (Object)targetVec3d).method_51874(class_181.field_1226, (Object)this.player).method_51874(class_181.field_1229, (Object)this.tool);
        return targetBlockState.method_26189(lootContext);
    }

    public int getExp(class_2248 block) {
        if (block instanceof class_2431) {
            try {
                Field experienceField = class_2431.class.getDeclaredField("experienceDropped");
                experienceField.setAccessible(true);
                class_6017 experienceDropped = (class_6017)experienceField.get(block);
                return experienceDropped.method_35008(this.world.field_9229);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void breakBlock(BlockInfo block, double posX, double posY, double posZ) {
        this.world.method_22352(block.pos, false);
        boolean allowExpDrop = true;
        for (class_1799 drop : block.drops) {
            if (drop.method_7909().method_7876().equals(block.blockId)) {
                allowExpDrop = false;
            }
            this.world.method_8649((class_1297)new class_1542((class_1937)this.world, posX, posY, posZ, drop));
        }
        if (block.exp > 0 && allowExpDrop) {
            this.world.method_8649((class_1297)new class_1303((class_1937)this.world, posX, posY, posZ, block.exp));
        }
    }

    public void breakBlockNoCollect(BlockInfo block) {
        this.breakBlock(block, block.pos.method_46558().method_10216(), block.pos.method_46558().method_10214(), block.pos.method_46558().method_10215());
    }

    public void breakBlockAndCollect(BlockInfo block) {
        this.breakBlock(block, this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
    }

    public BlockInfo newBlockInfo(class_2338 pos, int distance) {
        BlockInfo newBlockInfo = new BlockInfo();
        newBlockInfo.pos = pos;
        newBlockInfo.distance = distance;
        class_2680 blockState = this.world.method_8320(pos);
        newBlockInfo.blockId = blockState.method_26204().method_63499();
        newBlockInfo.drops = this.getDrops(pos.method_46558(), blockState);
        newBlockInfo.exp = this.getExp(blockState.method_26204());
        return newBlockInfo;
    }

    public BlockInfo newBlockInfo(BlockInfo source, int offsetX, int offsetY, int offsetZ) {
        BlockInfo newBlockInfo = new BlockInfo();
        newBlockInfo.pos = source.pos.method_10069(offsetX, offsetY, offsetZ);
        class_2680 blockState = this.world.method_8320(newBlockInfo.pos);
        newBlockInfo.blockId = blockState.method_26204().method_63499();
        newBlockInfo.drops = this.getDrops(newBlockInfo.pos.method_46558(), blockState);
        newBlockInfo.exp = this.getExp(blockState.method_26204());
        return newBlockInfo;
    }
}

