/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.takaya7s.range_destroy.config.ModConfig;
import com.takaya7s.range_destroy.config.ModConfigOld01;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static File file = null;

    public static ModConfig loadConfig() {
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "range_destroy.json");
        Gson gson = new Gson();
        ModConfig config = null;
        try {
            if (!file.exists()) {
                return ConfigManager.createDefaultConfig();
            }
            FileReader reader = new FileReader(file);
            config = (ModConfig)gson.fromJson((Reader)reader, ModConfig.class);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (config.version == -1) {
            ModConfigOld01 configOld01 = null;
            try {
                FileReader reader = new FileReader(file);
                configOld01 = (ModConfigOld01)gson.fromJson((Reader)reader, ModConfigOld01.class);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            config.version = 2;
            config.trees.clear();
            ModConfig.Tree tree = new ModConfig.Tree();
            tree.leavesRange = configOld01.tree.leavesRange;
            tree.destroyUnderLog = configOld01.tree.destroyUnderLog;
            tree.autoCollect = configOld01.tree.autoCollect;
            tree.keepLeavesRange = configOld01.tree.keepLeavesRange;
            tree.invalidCreative = configOld01.tree.invalidCreative;
            tree.axeIds = configOld01.tree.axeIds;
            tree.logBlockIds = configOld01.tree.logBlockIds;
            tree.leefBlockIds = configOld01.tree.leefBlockIds;
            config.trees.add(tree);
            config.grounds.clear();
            ModConfig.Ground ground = new ModConfig.Ground();
            ground.leftRange = configOld01.ground.leftRange;
            ground.rightRange = configOld01.ground.rightRange;
            ground.upRange = configOld01.ground.upRange;
            ground.downRange = configOld01.ground.downRange;
            ground.frontRange = configOld01.ground.frontRange;
            ground.backRange = configOld01.ground.backRange;
            ground.destroyUnder = configOld01.ground.destroyUnder;
            ground.autoCollect = configOld01.ground.autoCollect;
            ground.connectOnly = configOld01.ground.connectOnly;
            ground.sameOnly = configOld01.ground.sameOnly;
            ground.pickaxeOverShovel = configOld01.ground.pickaxeOverShovel;
            ground.invalidCreative = configOld01.ground.invalidCreative;
            ground.shovelIds = configOld01.ground.shovelIds;
            ground.dirtBlockIds = configOld01.ground.dirtBlockIds;
            ground.pickaxeIds = configOld01.ground.pickaxeIds;
            ground.stoneBlockIds = configOld01.ground.stoneBlockIds;
            config.grounds.add(ground);
            config.ores.clear();
            ModConfig.Ore ore = new ModConfig.Ore();
            ore.destroyUnder = configOld01.ore.destroyUnder;
            ore.autoCollect = configOld01.ore.autoCollect;
            ore.invalidCreative = configOld01.ore.invalidCreative;
            config.ores.add(ore);
            ConcurrentHashMap treeSelect = new ConcurrentHashMap();
            config.treeEnable = configOld01.tree.enable;
            config.treeEnable.forEach((key, value) -> treeSelect.put(key, 0));
            config.treeSelect = treeSelect;
            ConcurrentHashMap groundSelect = new ConcurrentHashMap();
            config.groundEnable = configOld01.ground.enable;
            config.groundEnable.forEach((key, value) -> groundSelect.put(key, 0));
            config.groundSelect = groundSelect;
            ConcurrentHashMap oreSelect = new ConcurrentHashMap();
            config.oreEnable = configOld01.ore.enable;
            config.oreEnable.forEach((key, value) -> oreSelect.put(key, 0));
            config.oreSelect = oreSelect;
        }
        if (config.version == 2) {
            int i;
            config.version = 3;
            for (i = 0; i < config.trees.size(); ++i) {
                config.trees.get((int)i).name = "id" + String.valueOf(i);
            }
            for (i = 0; i < config.grounds.size(); ++i) {
                config.grounds.get((int)i).name = "id" + String.valueOf(i);
            }
            for (i = 0; i < config.ores.size(); ++i) {
                config.ores.get((int)i).name = "id" + String.valueOf(i);
            }
        }
        return config;
    }

    public static void saveConfig(ModConfig config) {
        if (file == null) {
            file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "range_destroy.json");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            config.version = 3;
            FileWriter writer = new FileWriter(file);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void backupConfig() {
        Path sourcePath = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "range_destroy.json");
        Path destPath = Path.of(FabricLoader.getInstance().getConfigDir().toString(), "range_destroy.json.bak");
        if (Files.exists(sourcePath, new LinkOption[0])) {
            try {
                Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ModConfig createDefaultConfig() {
        if (file == null) {
            file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "range_destroy.json");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ModConfig config = new ModConfig();
        config.trees.add(new ModConfig.Tree());
        config.grounds.add(new ModConfig.Ground());
        config.ores.add(new ModConfig.Ore());
        try {
            FileWriter writer = new FileWriter(file);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return config;
        }
    }
}

