/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.takaya7s.range_destroy.RangeDestroy;
import com.takaya7s.range_destroy.config.ConfigManager;
import com.takaya7s.range_destroy.config.ModConfig;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Command {
    private static final String RANGE_DESTROT = "range.destroy";

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> Command.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(Command.range_destroy());
    }

    private static LiteralArgumentBuilder<class_2168> range_destroy() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)RANGE_DESTROT).then(Command.tree())).then(Command.ground())).then(Command.ore())).then(Command.commandPermission())).then(Command.commandReloadConfig());
    }

    private static LiteralArgumentBuilder<class_2168> commandPermission() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"commandPermission").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("commandPermission: " + RangeDestroy.config.commandPermission)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> {
            RangeDestroy.config.commandPermission = (Integer)context.getArgument("value", Integer.class);
            ((class_2168)context.getSource()).method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)("commandPermission: " + RangeDestroy.config.commandPermission)), false);
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> commandReloadConfig() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadConfig").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(context -> {
            RangeDestroy.config = ConfigManager.loadConfig();
            ((class_2168)context.getSource()).method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)"reloaded config").method_27694(style -> style.method_10977(class_124.field_1075)), false);
            RangeDestroy.config.treeSelect.forEach((key, value) -> {
                RangeDestroy.config.treeSelect.replace((String)key, 0);
                RangeDestroy.config.treeEnable.replace((String)key, false);
                class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                if (player != null) {
                    Command.sendInfoMessage((class_1657)player, "tree " + RangeDestroy.config.trees.getFirst().name + " OFF");
                }
            });
            RangeDestroy.config.groundSelect.forEach((key, value) -> {
                RangeDestroy.config.groundSelect.replace((String)key, 0);
                RangeDestroy.config.groundEnable.replace((String)key, false);
                class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                if (player != null) {
                    Command.sendInfoMessage((class_1657)player, "ground " + RangeDestroy.config.grounds.getFirst().name + " OFF");
                }
            });
            RangeDestroy.config.oreSelect.forEach((key, value) -> {
                RangeDestroy.config.oreSelect.replace((String)key, 0);
                RangeDestroy.config.oreEnable.replace((String)key, false);
                class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                if (player != null) {
                    Command.sendInfoMessage((class_1657)player, "ore " + RangeDestroy.config.ores.getFirst().name + " OFF");
                }
            });
            Command.saveConfig();
            return 1;
        });
    }

    private static LiteralArgumentBuilder<class_2168> tree() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tree").then(Command.tree_name())).then(Command.tree_leavesRange())).then(Command.tree_destroyUnderLog())).then(Command.tree_autoCollect())).then(Command.tree_keepLeavesRange())).then(Command.tree_invalidCreative())).then(Command.tree_add())).then(Command.tree_insert())).then(Command.tree_delete());
    }

    private static LiteralArgumentBuilder<class_2168> tree_add() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(context -> {
            RangeDestroy.config.trees.add(new ModConfig.Tree("newConfig"));
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "tree newConfig is added.");
        });
    }

    private static LiteralArgumentBuilder<class_2168> tree_insert() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"insert").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index > RangeDestroy.config.trees.size()) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + RangeDestroy.config.trees.size());
            }
            RangeDestroy.config.trees.add(index, new ModConfig.Tree("newConfig"));
            RangeDestroy.config.treeSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.treeSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "tree newConfig is inserted.");
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.trees, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            RangeDestroy.config.trees.add(index, new ModConfig.Tree("newConfig"));
            RangeDestroy.config.treeSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.treeSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "tree newConfig is inserted.");
        }));
    }

    private static LiteralArgumentBuilder<class_2168> tree_delete() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int size = RangeDestroy.config.trees.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index >= size) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + (size - 1));
            }
            String oldName = RangeDestroy.config.trees.get((int)index).name;
            RangeDestroy.config.trees.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "tree " + oldName + " is deleted.");
            RangeDestroy.config.treeSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.treeSelect.replace((String)key, 0);
                    RangeDestroy.config.treeEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "tree " + RangeDestroy.config.trees.getFirst().name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.treeSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            int size = RangeDestroy.config.trees.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.trees, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            String oldName = RangeDestroy.config.trees.get((int)index).name;
            RangeDestroy.config.trees.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "tree " + oldName + " is deleted.");
            RangeDestroy.config.treeSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.treeSelect.replace((String)key, 0);
                    RangeDestroy.config.treeEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "tree " + RangeDestroy.config.trees.getFirst().name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.treeSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> tree_name() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").executes(Command::execute_tree)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> tree_leavesRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"leavesRange").executes(Command::execute_tree)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)32)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> tree_destroyUnderLog() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"destroyUnderLog").executes(Command::execute_tree)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> tree_autoCollect() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autoCollect").executes(Command::execute_tree)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> tree_keepLeavesRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"keepLeavesRange").executes(Command::execute_tree)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)32)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> tree_invalidCreative() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invalidCreative").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_tree)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(Command::execute_tree));
    }

    private static LiteralArgumentBuilder<class_2168> ground() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ground").then(Command.ground_name())).then(Command.ground_leftRange())).then(Command.ground_rightRange())).then(Command.ground_upRange())).then(Command.ground_downRange())).then(Command.ground_frontRange())).then(Command.ground_backRange())).then(Command.ground_destroyUnder())).then(Command.ground_autoCollect())).then(Command.ground_connectOnly())).then(Command.ground_sameOnly())).then(Command.ground_pickaxeOverShovel())).then(Command.ground_invalidCreative())).then(Command.ground_add())).then(Command.ground_insert())).then(Command.ground_delete());
    }

    private static LiteralArgumentBuilder<class_2168> ground_add() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(context -> {
            RangeDestroy.config.grounds.add(new ModConfig.Ground("newConfig"));
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ground newConfig is added.");
        });
    }

    private static LiteralArgumentBuilder<class_2168> ground_insert() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"insert").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index > RangeDestroy.config.grounds.size()) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + RangeDestroy.config.grounds.size());
            }
            RangeDestroy.config.grounds.add(index, new ModConfig.Ground("newConfig"));
            RangeDestroy.config.groundSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.groundSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ground newConfig is inserted.");
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.grounds, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            RangeDestroy.config.grounds.add(index, new ModConfig.Ground("newConfig"));
            RangeDestroy.config.groundSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.groundSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ground newConfig is inserted.");
        }));
    }

    private static LiteralArgumentBuilder<class_2168> ground_delete() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int size = RangeDestroy.config.grounds.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index >= size) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + (size - 1));
            }
            String oldName = RangeDestroy.config.grounds.get((int)index).name;
            RangeDestroy.config.grounds.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "ground " + oldName + " is deleted.");
            RangeDestroy.config.groundSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.groundSelect.replace((String)key, 0);
                    RangeDestroy.config.groundEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "ground " + RangeDestroy.config.grounds.getFirst().name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.groundSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            int size = RangeDestroy.config.grounds.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.grounds, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            String oldName = RangeDestroy.config.grounds.get((int)index).name;
            RangeDestroy.config.grounds.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "ground " + oldName + " is deleted.");
            RangeDestroy.config.groundSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.groundSelect.replace((String)key, 0);
                    RangeDestroy.config.groundEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "ground " + RangeDestroy.config.grounds.getFirst().name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.groundSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> ground_name() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_leftRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"leftRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_rightRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rightRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_upRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"upRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_downRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"downRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_frontRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"frontRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_backRange() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backRange").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)16)).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_destroyUnder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"destroyUnder").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_autoCollect() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autoCollect").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_connectOnly() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"connectOnly").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_sameOnly() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sameOnly").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_pickaxeOverShovel() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pickaxeOverShovel").executes(Command::execute_ground)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ground_invalidCreative() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invalidCreative").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ground)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(Command::execute_ground));
    }

    private static LiteralArgumentBuilder<class_2168> ore() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ore").then(Command.ore_name())).then(Command.ore_destroyUnder())).then(Command.ore_autoCollect())).then(Command.ore_invalidCreative())).then(Command.ore_add())).then(Command.ore_insert())).then(Command.ore_delete());
    }

    private static LiteralArgumentBuilder<class_2168> ore_add() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(context -> {
            RangeDestroy.config.ores.add(new ModConfig.Ore("newConfig"));
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ore newConfig is added.");
        });
    }

    private static LiteralArgumentBuilder<class_2168> ore_insert() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"insert").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index > RangeDestroy.config.ores.size()) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + RangeDestroy.config.ores.size());
            }
            RangeDestroy.config.ores.add(index, new ModConfig.Ore("newConfig"));
            RangeDestroy.config.oreSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.oreSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ore newConfig is inserted.");
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.ores, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            RangeDestroy.config.ores.add(index, new ModConfig.Ore("newConfig"));
            RangeDestroy.config.oreSelect.forEach((key, value) -> {
                if (value >= index) {
                    RangeDestroy.config.oreSelect.replace((String)key, value + 1);
                }
            });
            Command.saveConfig();
            return Command.sendBroadcast((CommandContext<class_2168>)context, "ore newConfig is inserted.");
        }));
    }

    private static LiteralArgumentBuilder<class_2168> ore_delete() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int size = RangeDestroy.config.ores.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            int index = (Integer)context.getArgument("value", Integer.class);
            if (index >= size) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "range out. range is 0-" + (size - 1));
            }
            String oldName = RangeDestroy.config.ores.get((int)index).name;
            RangeDestroy.config.ores.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "ore " + oldName + " is deleted.");
            RangeDestroy.config.oreSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.oreSelect.replace((String)key, 0);
                    RangeDestroy.config.oreEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "ore " + RangeDestroy.config.ores.get((int)index).name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.oreSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            int size = RangeDestroy.config.ores.size();
            if (size == 1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "cannot be deleted because the setting will be lost.");
            }
            String name = (String)context.getArgument("name", String.class);
            int index = Command.indexOf(RangeDestroy.config.ores, name);
            if (index == -1) {
                return Command.sendErrorMessage((CommandContext<class_2168>)context, "not found name");
            }
            String oldName = RangeDestroy.config.ores.get((int)index).name;
            RangeDestroy.config.ores.remove(index);
            Command.sendBroadcast((CommandContext<class_2168>)context, "ore " + oldName + " is deleted.");
            RangeDestroy.config.oreSelect.forEach((key, value) -> {
                if (value == index) {
                    RangeDestroy.config.oreSelect.replace((String)key, 0);
                    RangeDestroy.config.oreEnable.replace((String)key, false);
                    class_3222 player = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(UUID.fromString(key));
                    if (player != null) {
                        Command.sendInfoMessage((class_1657)player, "ore " + RangeDestroy.config.ores.getFirst().name + " OFF");
                    }
                }
                if (value > index) {
                    RangeDestroy.config.oreSelect.replace((String)key, value - 1);
                }
            });
            Command.saveConfig();
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> ore_name() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").executes(Command::execute_ore)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ore));
    }

    private static LiteralArgumentBuilder<class_2168> ore_destroyUnder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"destroyUnder").executes(Command::execute_ore)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ore));
    }

    private static LiteralArgumentBuilder<class_2168> ore_autoCollect() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autoCollect").executes(Command::execute_ore)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ore));
    }

    private static LiteralArgumentBuilder<class_2168> ore_invalidCreative() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"invalidCreative").requires(context -> context.method_9259(RangeDestroy.config.commandPermission))).executes(Command::execute_ore)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(Command::execute_ore));
    }

    private static int sendInfoMessage(class_1657 player, String text) {
        if (player == null) {
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("RangeDestroy: " + text)).method_27694(style -> style.method_10977(class_124.field_1054)), true);
        return 0;
    }

    private static int sendErrorMessage(CommandContext<class_2168> context, String text) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("RangeDestroy: " + text)).method_27694(style -> style.method_10977(class_124.field_1061)));
        return 0;
    }

    private static int sendExecuter(CommandContext<class_2168> context, String text) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("RangeDestroy: " + text)));
        return 1;
    }

    private static int sendExecuter(CommandContext<class_2168> context, String target, String column, Object value) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)(target + ". " + column + ": " + value.toString())));
        return 1;
    }

    private static int sendBroadcast(CommandContext<class_2168> context, String text) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ((class_2168)context.getSource()).method_9211().method_3760().method_43514((class_2561)class_2561.method_43470((String)("RangeDestroy: " + text)).method_27694(style -> style.method_10977(class_124.field_1075)), false);
        return 1;
    }

    private static int sendBroadcast(CommandContext<class_2168> context, String target, String column, Object value) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        return Command.sendBroadcast(context, target + ". " + column + ": " + value.toString());
    }

    private static int execute_tree(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        String uuid = player.method_7334().id().toString();
        if (!RangeDestroy.config.treeSelect.containsKey(uuid)) {
            return 0;
        }
        int index = RangeDestroy.config.treeSelect.get(uuid);
        String target = ((ParsedCommandNode)context.getNodes().get(1)).getNode().getName();
        String column = ((ParsedCommandNode)context.getNodes().get(2)).getNode().getName();
        if (context.getNodes().size() <= 3) {
            switch (column) {
                case "name": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).name);
                }
                case "leavesRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).leavesRange);
                }
                case "destroyUnderLog": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).destroyUnderLog);
                }
                case "autoCollect": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).autoCollect);
                }
                case "keepLeavesRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).keepLeavesRange);
                }
                case "invalidCreative": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).invalidCreative);
                }
            }
            return Command.sendErrorMessage(context, "syntax error");
        }
        switch (column) {
            case "name": {
                String oldName = RangeDestroy.config.trees.get((int)index).name;
                String name = (String)context.getArgument("name", String.class);
                if (name.isEmpty() || name.isBlank()) {
                    return Command.sendErrorMessage(context, "no name");
                }
                if (Character.isDigit(name.charAt(0))) {
                    return Command.sendErrorMessage(context, "first character cannot be a number.");
                }
                if (Command.indexOf(RangeDestroy.config.trees, name) >= 0) {
                    return Command.sendErrorMessage(context, "this name already exists");
                }
                RangeDestroy.config.trees.get((int)index).name = name;
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + oldName + "]", column, RangeDestroy.config.trees.get((int)index).name);
            }
            case "leavesRange": {
                RangeDestroy.config.trees.get((int)index).leavesRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).leavesRange);
            }
            case "destroyUnderLog": {
                RangeDestroy.config.trees.get((int)index).destroyUnderLog = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).destroyUnderLog);
            }
            case "autoCollect": {
                RangeDestroy.config.trees.get((int)index).autoCollect = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).autoCollect);
            }
            case "keepLeavesRange": {
                RangeDestroy.config.trees.get((int)index).keepLeavesRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).keepLeavesRange);
            }
            case "invalidCreative": {
                RangeDestroy.config.trees.get((int)index).invalidCreative = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.trees.get((int)index).name + "]", column, RangeDestroy.config.trees.get((int)index).invalidCreative);
            }
        }
        return Command.sendErrorMessage(context, "syntax error");
    }

    private static int execute_ground(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        String uuid = player.method_7334().id().toString();
        if (!RangeDestroy.config.groundSelect.containsKey(uuid)) {
            return 0;
        }
        int index = RangeDestroy.config.groundSelect.get(uuid);
        String target = ((ParsedCommandNode)context.getNodes().get(1)).getNode().getName();
        String column = ((ParsedCommandNode)context.getNodes().get(2)).getNode().getName();
        if (context.getNodes().size() <= 3) {
            switch (column) {
                case "name": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).name);
                }
                case "leftRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).leftRange);
                }
                case "rightRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).rightRange);
                }
                case "upRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).upRange);
                }
                case "downRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).downRange);
                }
                case "frontRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).frontRange);
                }
                case "backRange": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).backRange);
                }
                case "destroyUnder": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).destroyUnder);
                }
                case "autoCollect": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).autoCollect);
                }
                case "connectOnly": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).connectOnly);
                }
                case "sameOnly": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).sameOnly);
                }
                case "pickaxeOverShovel": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).pickaxeOverShovel);
                }
                case "invalidCreative": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).invalidCreative);
                }
            }
            return Command.sendErrorMessage(context, "syntax error");
        }
        switch (column) {
            case "name": {
                String oldName = RangeDestroy.config.grounds.get((int)index).name;
                String name = (String)context.getArgument("name", String.class);
                if (name.isEmpty() || name.isBlank()) {
                    return Command.sendErrorMessage(context, "no name");
                }
                if (Character.isDigit(name.charAt(0))) {
                    return Command.sendErrorMessage(context, "first character cannot be a number.");
                }
                if (Command.indexOf(RangeDestroy.config.grounds, name) >= 0) {
                    return Command.sendErrorMessage(context, "this name already exists");
                }
                RangeDestroy.config.grounds.get((int)index).name = name;
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + oldName + "]", column, RangeDestroy.config.grounds.get((int)index).name);
            }
            case "leftRange": {
                RangeDestroy.config.grounds.get((int)index).leftRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).leftRange);
            }
            case "rightRange": {
                RangeDestroy.config.grounds.get((int)index).rightRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).rightRange);
            }
            case "upRange": {
                RangeDestroy.config.grounds.get((int)index).upRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).upRange);
            }
            case "downRange": {
                RangeDestroy.config.grounds.get((int)index).downRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).downRange);
            }
            case "frontRange": {
                RangeDestroy.config.grounds.get((int)index).frontRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).frontRange);
            }
            case "backRange": {
                RangeDestroy.config.grounds.get((int)index).backRange = (Integer)context.getArgument("value", Integer.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).backRange);
            }
            case "destroyUnder": {
                RangeDestroy.config.grounds.get((int)index).destroyUnder = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).destroyUnder);
            }
            case "autoCollect": {
                RangeDestroy.config.grounds.get((int)index).autoCollect = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).autoCollect);
            }
            case "connectOnly": {
                RangeDestroy.config.grounds.get((int)index).connectOnly = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).connectOnly);
            }
            case "sameOnly": {
                RangeDestroy.config.grounds.get((int)index).sameOnly = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).sameOnly);
            }
            case "pickaxeOverShovel": {
                RangeDestroy.config.grounds.get((int)index).pickaxeOverShovel = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).pickaxeOverShovel);
            }
            case "invalidCreative": {
                RangeDestroy.config.grounds.get((int)index).invalidCreative = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.grounds.get((int)index).name + "]", column, RangeDestroy.config.grounds.get((int)index).invalidCreative);
            }
        }
        return Command.sendErrorMessage(context, "syntax error");
    }

    private static int execute_ore(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        String uuid = player.method_7334().id().toString();
        if (!RangeDestroy.config.oreSelect.containsKey(uuid)) {
            return 0;
        }
        int index = RangeDestroy.config.oreSelect.get(uuid);
        String target = ((ParsedCommandNode)context.getNodes().get(1)).getNode().getName();
        String column = ((ParsedCommandNode)context.getNodes().get(2)).getNode().getName();
        if (context.getNodes().size() <= 3) {
            switch (column) {
                case "name": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).name);
                }
                case "destroyUnder": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).destroyUnder);
                }
                case "autoCollect": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).autoCollect);
                }
                case "invalidCreative": {
                    return Command.sendExecuter(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).invalidCreative);
                }
            }
            return Command.sendErrorMessage(context, "syntax error");
        }
        switch (column) {
            case "name": {
                String oldName = RangeDestroy.config.ores.get((int)index).name;
                String name = (String)context.getArgument("name", String.class);
                if (name.isEmpty() || name.isBlank()) {
                    return Command.sendErrorMessage(context, "no name");
                }
                if (Character.isDigit(name.charAt(0))) {
                    return Command.sendErrorMessage(context, "first character cannot be a number.");
                }
                if (Command.indexOf(RangeDestroy.config.ores, name) >= 0) {
                    return Command.sendErrorMessage(context, "this name already exists");
                }
                RangeDestroy.config.ores.get((int)index).name = name;
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + oldName + "]", column, RangeDestroy.config.ores.get((int)index).name);
            }
            case "destroyUnder": {
                RangeDestroy.config.ores.get((int)index).destroyUnder = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).destroyUnder);
            }
            case "autoCollect": {
                RangeDestroy.config.ores.get((int)index).autoCollect = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).autoCollect);
            }
            case "invalidCreative": {
                RangeDestroy.config.ores.get((int)index).invalidCreative = (Boolean)context.getArgument("value", Boolean.class);
                Command.saveConfig();
                return Command.sendBroadcast(context, target + "[" + RangeDestroy.config.ores.get((int)index).name + "]", column, RangeDestroy.config.ores.get((int)index).invalidCreative);
            }
        }
        return Command.sendErrorMessage(context, "syntax error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfig() {
        Object object = RangeDestroy.LOCK_CONFIG;
        synchronized (object) {
            ConfigManager.saveConfig(RangeDestroy.config);
        }
    }

    private static <T extends ModConfig.Base> int indexOf(List<T> list, String searchText) {
        for (int i = 0; i < list.size(); ++i) {
            ModConfig.Base base = (ModConfig.Base)list.get(i);
            if (base.name == null || !base.name.equals(searchText)) continue;
            return i;
        }
        return -1;
    }
}

