/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ModConfig {
    public int version = 3;
    public int commandPermission = 2;
    public List<Tree> trees = new ArrayList<Tree>();
    public List<Ground> grounds = new ArrayList<Ground>();
    public List<Ore> ores = new ArrayList<Ore>();
    public ConcurrentHashMap<String, Boolean> treeEnable = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Boolean> groundEnable = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Boolean> oreEnable = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Integer> treeSelect = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Integer> groundSelect = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Integer> oreSelect = new ConcurrentHashMap();

    public static String toStringTreeConfig(Tree tree) {
        return "leavesRange=" + tree.leavesRange + ", destroyUnderLog=" + tree.destroyUnderLog + ", autoCollect=" + tree.autoCollect + ", keepLeavesRange=" + tree.keepLeavesRange;
    }

    public static String toStringGroundConfig(Ground ground) {
        return "Ranges={front=" + ground.frontRange + ", back=" + ground.backRange + ", right=" + ground.rightRange + ", left=" + ground.leftRange + ", up=" + ground.upRange + ", down=" + ground.downRange + "}, destroyUnder=" + ground.destroyUnder + ", autoCollect=" + ground.autoCollect + ", connectOnly=" + ground.connectOnly + ", sameOnly=" + ground.sameOnly + ", pickaxeOverShovel=" + ground.pickaxeOverShovel;
    }

    public static String toStringOreConfig(Ore ore) {
        return "destroyUnder=" + ore.destroyUnder + ", autoCollect=" + ore.autoCollect;
    }

    public static class Tree
    extends Base {
        public int leavesRange = 8;
        public boolean destroyUnderLog = false;
        public int keepLeavesRange = 3;
        public String[] axeIds = new String[]{"wooden_axe", "stone_axe", "copper_axe", "iron_axe", "golden_axe", "diamond_axe", "netherite_axe"};
        public String[] logBlockIds = new String[]{"oak_log", "birch_log", "acacia_log", "dark_oak_log", "spruce_log", "jungle_log", "mangrove_log", "cherry_log", "crimson_stem", "warped_stem", "pale_oak_log"};
        public String[] leefBlockIds = new String[]{"oak_leaves", "birch_leaves", "acacia_leaves", "dark_oak_leaves", "spruce_leaves", "jungle_leaves", "mangrove_leaves", "cherry_leaves", "azalea_leaves", "pale_oak_leaves"};

        public Tree() {
        }

        public Tree(String name) {
            this.name = name;
        }
    }

    public static class Ground
    extends Base {
        public int leftRange = 1;
        public int rightRange = 1;
        public int upRange = 3;
        public int downRange = 1;
        public int frontRange = 0;
        public int backRange = 0;
        public boolean destroyUnder = true;
        public boolean connectOnly = false;
        public boolean sameOnly = false;
        public boolean pickaxeOverShovel = true;
        public String[] shovelIds = new String[]{"wooden_shovel", "stone_shovel", "copper_shovel", "iron_shovel", "golden_shovel", "diamond_shovel", "netherite_shovel"};
        public String[] dirtBlockIds = new String[]{"grass_block", "dirt", "sand", "gravel", "clay", "mycelium", "coarse_dirt", "podzol", "soul_sand", "soul_soil"};
        public String[] pickaxeIds = new String[]{"wooden_pickaxe", "stone_pickaxe", "copper_pickaxe", "iron_pickaxe", "golden_pickaxe", "diamond_pickaxe", "netherite_pickaxe"};
        public String[] stoneBlockIds = new String[]{"stone", "sandstone", "andesite", "granite", "diorite", "deepslate", "tuff", "ice", "packed_ice", "blue_ice", "netherrack", "crimson_nyliumn", "warped_nylium", "blackstone", "end_stone"};

        public Ground() {
        }

        public Ground(String name) {
            this.name = name;
        }
    }

    public static class Ore
    extends Base {
        public boolean destroyUnder = true;
        public String[] pickaxeIds = new String[]{"wooden_pickaxe", "stone_pickaxe", "copper_pickaxe", "iron_pickaxe", "golden_pickaxe", "diamond_pickaxe", "netherite_pickaxe"};
        public String[] oreBlockIds = new String[]{"coal_ore", "copper_ore", "iron_ore", "lapis_ore", "gold_ore", "emerald_ore", "redstone_ore", "diamond_ore", "deepslate_coal_ore", "deepslate_copper_ore", "deepslate_iron_ore", "deepslate_lapis_ore", "deepslate_gold_ore", "deepslate_emerald_ore", "deepslate_redstone_ore", "deepslate_diamond_ore", "obsidian", "nether_gold_ore", "nether_quartz_ore", "glowstone", "crying_obsidian", "ancient_debris"};

        public Ore() {
        }

        public Ore(String name) {
            this.name = name;
        }
    }

    public static class Base {
        public String name = null;
        public boolean autoCollect = true;
        public boolean invalidCreative = false;

        public Base() {
        }

        public Base(String name) {
            this.name = name;
        }
    }
}

