/*
 * Decompiled with CFR 0.152.
 */
package com.takaya7s.range_destroy.client;

import com.takaya7s.range_destroy.RangeDestroy;
import com.takaya7s.range_destroy.ServerNetwork;
import com.takaya7s.range_destroy.client.RefBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class KeyBindings {
    private static final String KEY_BIND_ID_TREE = RangeDestroy.getKeyBindId("tree");
    private static final String KEY_BIND_ID_GROUND = RangeDestroy.getKeyBindId("ground");
    private static final String KEY_BIND_ID_ORE = RangeDestroy.getKeyBindId("ore");
    private static final String KEY_BIND_CATEGORY = String.join((CharSequence)".", "category.key", "range_destroy");
    public static final class_304 KEY_BINDING_TREE = new class_304(KEY_BIND_ID_TREE, class_3675.class_307.field_1668, 66, KEY_BIND_CATEGORY);
    public static final class_304 KEY_BINDING_GROUND = new class_304(KEY_BIND_ID_GROUND, class_3675.class_307.field_1668, 78, KEY_BIND_CATEGORY);
    public static final class_304 KEY_BINDING_ORE = new class_304(KEY_BIND_ID_ORE, class_3675.class_307.field_1668, 77, KEY_BIND_CATEGORY);
    private static final RefBoolean wasPressedTree = new RefBoolean(false);
    private static final RefBoolean wasPressedGround = new RefBoolean(false);
    private static final RefBoolean wasPressedOre = new RefBoolean(false);
    private static boolean doToggleTreeEnable = false;
    private static boolean doToggleGroundEnable = false;
    private static boolean doToggleOreEnable = false;
    private static Boolean treeEnable = false;
    private static Integer treeSelect = 0;
    private static Boolean groundEnable = false;
    private static Integer groundSelect = 0;
    private static Boolean oreEnable = false;
    private static Integer oreSelect = 0;

    public static void init() {
        KeyBindingHelper.registerKeyBinding((class_304)KEY_BINDING_TREE);
        KeyBindingHelper.registerKeyBinding((class_304)KEY_BINDING_GROUND);
        KeyBindingHelper.registerKeyBinding((class_304)KEY_BINDING_ORE);
        PayloadTypeRegistry.playS2C().register(ServerNetwork.S2C_TreeStatusPayload.ID, ServerNetwork.S2C_TreeStatusPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ServerNetwork.S2C_TreeStatusPayload.ID, KeyBindings::onReceiveTreeStatus);
        PayloadTypeRegistry.playS2C().register(ServerNetwork.S2C_GroundStatusPayload.ID, ServerNetwork.S2C_GroundStatusPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ServerNetwork.S2C_GroundStatusPayload.ID, KeyBindings::onReceiveGroundStatus);
        PayloadTypeRegistry.playS2C().register(ServerNetwork.S2C_OreStatusPayload.ID, ServerNetwork.S2C_OreStatusPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ServerNetwork.S2C_OreStatusPayload.ID, KeyBindings::onReceiveOreStatus);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (KeyBindings.getKeyDown(KEY_BINDING_TREE, wasPressedTree)) {
                doToggleTreeEnable = true;
            }
            if (KeyBindings.getKeyUp(KEY_BINDING_TREE, wasPressedTree)) {
                if (!doToggleTreeEnable) {
                    return;
                }
                treeEnable = treeEnable == false;
                ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_TreeStatusPayload(treeEnable, treeSelect));
            }
            if (KeyBindings.getKeyDown(KEY_BINDING_GROUND, wasPressedGround)) {
                doToggleGroundEnable = true;
            }
            if (KeyBindings.getKeyUp(KEY_BINDING_GROUND, wasPressedGround)) {
                if (!doToggleGroundEnable) {
                    return;
                }
                groundEnable = groundEnable == false;
                ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_GroundStatusPayload(groundEnable, groundSelect));
            }
            if (KeyBindings.getKeyDown(KEY_BINDING_ORE, wasPressedOre)) {
                doToggleOreEnable = true;
            }
            if (KeyBindings.getKeyUp(KEY_BINDING_ORE, wasPressedOre)) {
                if (!doToggleOreEnable) {
                    return;
                }
                oreEnable = oreEnable == false;
                ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_OreStatusPayload(oreEnable, oreSelect));
            }
        });
    }

    public static boolean onMouseScroll(int scroll) {
        if (KeyBindings.wasPressedTree.value) {
            treeSelect = treeSelect - scroll;
            ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_TreeStatusPayload(treeEnable, treeSelect));
            doToggleTreeEnable = false;
            return true;
        }
        if (KeyBindings.wasPressedGround.value) {
            groundSelect = groundSelect - scroll;
            ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_GroundStatusPayload(groundEnable, groundSelect));
            doToggleGroundEnable = false;
            return true;
        }
        if (KeyBindings.wasPressedOre.value) {
            oreSelect = oreSelect - scroll;
            ClientPlayNetworking.send((class_8710)new ServerNetwork.C2S_OreStatusPayload(oreEnable, oreSelect));
            doToggleOreEnable = false;
            return true;
        }
        return false;
    }

    private static void onReceiveTreeStatus(ServerNetwork.S2C_TreeStatusPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            treeEnable = payload.enable();
            treeSelect = payload.select();
        });
    }

    private static void onReceiveGroundStatus(ServerNetwork.S2C_GroundStatusPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            groundEnable = payload.enable();
            groundSelect = payload.select();
        });
    }

    private static void onReceiveOreStatus(ServerNetwork.S2C_OreStatusPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            oreEnable = payload.enable();
            oreSelect = payload.select();
        });
    }

    private static boolean getKeyDown(class_304 binding, RefBoolean wasPressed) {
        boolean isPressed = binding.method_1434();
        if (isPressed && !wasPressed.value) {
            wasPressed.value = true;
            return true;
        }
        return false;
    }

    private static boolean getKeyUp(class_304 binding, RefBoolean wasPressed) {
        boolean isPressed = binding.method_1434();
        if (!isPressed && wasPressed.value) {
            wasPressed.value = false;
            return true;
        }
        wasPressed.value = isPressed;
        return false;
    }
}

