/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass;

import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.config.ModDependencyConfig;
import org.texboobcat.downloadbypass.downloader.ModDownloader;
import org.texboobcat.downloadbypass.downloader.ModFile;
import org.texboobcat.downloadbypass.downloader.ModFileResolver;
import org.texboobcat.downloadbypass.ui.StartupPrompt;
import org.texboobcat.downloadbypass.util.HashUtil;
import org.texboobcat.downloadbypass.util.InstalledManifest;
import org.texboobcat.downloadbypass.util.SkippedModsTracker;

public final class ModInstallerCore {
    private ModInstallerCore() {
    }

    public static void checkAndPromptForMods() {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        List<ModDependency> deps = ModDependencyConfig.loadDependencies();
        if (deps.isEmpty()) {
            return;
        }
        Path modsDir = mc.field_1697.toPath().resolve("mods");
        Path configDir = mc.field_1697.toPath().resolve("config").resolve("downloadbypass");
        ArrayList<ModDependency> missing = new ArrayList<ModDependency>();
        ModFileResolver resolver = new ModFileResolver();
        SkippedModsTracker skipTracker = new SkippedModsTracker(configDir);
        String mcVersion = class_155.method_16673().method_48019();
        for (ModDependency dep : deps) {
            if (dep == null) continue;
            boolean installed = false;
            try {
                ModFile mf;
                Stream<Path> stream;
                if (!Files.exists(modsDir, new LinkOption[0])) {
                    Files.createDirectories(modsDir, new FileAttribute[0]);
                }
                if (dep.getVersion() != null && !dep.getVersion().isBlank() && !dep.getVersion().contains(mcVersion)) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Version mismatch for {}: config '{}', current MC '{}'.", (Object)dep.getName(), (Object)dep.getVersion(), (Object)mcVersion);
                }
                if (dep.getSha256Hash() != null && !dep.getSha256Hash().isBlank()) {
                    stream = Files.list(modsDir);
                    try {
                        installed = stream.filter(p -> p.getFileName().toString().endsWith(".jar")).anyMatch(p -> HashUtil.matchesSha256(p, dep.getSha256Hash()));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (dep.getMd5Hash() != null && !dep.getMd5Hash().isBlank()) {
                    stream = Files.list(modsDir);
                    try {
                        installed = stream.filter(p -> p.getFileName().toString().endsWith(".jar")).anyMatch(p -> HashUtil.matchesMd5(p, dep.getMd5Hash()));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (!installed && (mf = resolver.resolve(dep)) != null) {
                    Path candidate = modsDir.resolve(mf.getFileName());
                    installed = Files.exists(candidate, new LinkOption[0]);
                }
            }
            catch (Exception e) {
                Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Error while checking installed mod {}: {}", (Object)dep.getName(), (Object)e.getMessage());
            }
            if (installed) continue;
            if (!skipTracker.shouldSkip(dep)) {
                missing.add(dep);
                continue;
            }
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Skipping prompt for {} (user declined recently)", (Object)dep.getName());
        }
        if (missing.isEmpty()) {
            return;
        }
        skipTracker.cleanup();
        ModInstallerCore.processNext(mc, modsDir, missing, 0, false, skipTracker);
    }

    private static void processNext(class_310 mc, Path modsDir, List<ModDependency> list, int index, boolean installedAny, SkippedModsTracker skipTracker) {
        if (index >= list.size()) {
            if (installedAny) {
                mc.execute(() -> mc.method_1507((class_437)new SimpleMessageScreen("External Mods Installed", "New mods were installed. Please restart the game.", () -> mc.method_1507((class_437)null), "Remove Auto-Installed", () -> {
                    try {
                        int removed = InstalledManifest.removeAllInstalledMods(modsDir);
                        mc.method_1507((class_437)new SimpleMessageScreen("Removal Complete", removed + " files removed. Restart recommended.", () -> mc.method_1507((class_437)null)));
                    }
                    catch (Exception e) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to remove installed mods: {}", (Object)e.getMessage());
                    }
                })));
            }
            return;
        }
        ModDependency dep = list.get(index);
        AtomicReference<StartupPrompt> promptRef = new AtomicReference<StartupPrompt>();
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Preparing prompt for {}", (Object)dep.getName());
        StartupPrompt prompt = new StartupPrompt(dep, accepted -> {
            if (Boolean.TRUE.equals(accepted)) {
                StartupPrompt p = (StartupPrompt)((Object)((Object)promptRef.get()));
                if (p != null) {
                    p.setDownloading(true);
                }
                ModFileResolver resolver = new ModFileResolver();
                ModDownloader dl = new ModDownloader();
                new Thread(() -> {
                    block20: {
                        boolean ok = false;
                        try {
                            Long expectedSize;
                            ModFile mf = resolver.resolve(dep);
                            if (mf == null) {
                                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Unable to resolve download URL for {}", (Object)dep.getName());
                                break block20;
                            }
                            Path target = modsDir.resolve(mf.getFileName());
                            try {
                                if (!Files.isWritable(modsDir)) {
                                    throw new AccessDeniedException(modsDir.toString());
                                }
                            }
                            catch (Exception e) {
                                boolean required = dep.isRequired();
                                String msg = "Cannot write to mods directory: " + String.valueOf(modsDir) + ". Check permissions.";
                                Downloadbypass.LOGGER.error("[EXTERNAL-MODS] {}", (Object)msg);
                                class_310 mci = mc;
                                mc.execute(() -> mc.method_1507((class_437)new SimpleMessageScreen("Permission Error", msg, () -> {
                                    mc.method_1507(null);
                                    if (required) {
                                        mci.method_1592();
                                    } else {
                                        ModInstallerCore.processNext(mci, modsDir, list, index + 1, installedAny, skipTracker);
                                    }
                                })));
                                boolean finalOk = ok;
                                mc.execute(() -> {
                                    mc.method_1507(null);
                                    if (finalOk) {
                                        ModInstallerCore.processNext(mc, modsDir, list, index + 1, true, skipTracker);
                                    } else if (dep.isRequired()) {
                                        mc.method_1592();
                                    } else {
                                        ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny, skipTracker);
                                    }
                                });
                                return;
                            }
                            Long l = dep.getSizeBytes() != null ? dep.getSizeBytes() : (expectedSize = mf.getFileLength() > 0L ? Long.valueOf(mf.getFileLength()) : null);
                            if (expectedSize != null) {
                                try {
                                    long free = Files.getFileStore(modsDir).getUsableSpace();
                                    long needed = expectedSize + 0xA00000L;
                                    if (free < needed) {
                                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Insufficient disk space. Needed ~{} bytes, free {} bytes", (Object)needed, (Object)free);
                                        boolean required = dep.isRequired();
                                        class_310 mci = mc;
                                        mc.execute(() -> mc.method_1507((class_437)new SimpleMessageScreen("Insufficient Disk Space", "Not enough space to install '" + dep.getName() + "'. Free up disk space and retry.", () -> {
                                            mc.method_1507(null);
                                            if (required) {
                                                mc.method_1592();
                                            } else {
                                                ModInstallerCore.processNext(mci, modsDir, list, index + 1, installedAny, skipTracker);
                                            }
                                        })));
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to check disk space: {}", (Object)e.getMessage());
                                }
                            }
                            if (ok = dl.downloadTo(mf.getDownloadUrl(), target, frac -> {
                                StartupPrompt p3 = (StartupPrompt)((Object)((Object)((Object)((Object)promptRef.get()))));
                                if (p3 != null) {
                                    p3.setProgress((double)frac);
                                }
                            })) {
                                ok = dl.verify(target, dep.getSizeBytes(), dep.getMd5Hash(), dep.getSha256Hash());
                                if (!ok) {
                                    try {
                                        Files.deleteIfExists(target);
                                    }
                                    catch (Exception e) {}
                                } else {
                                    try {
                                        InstalledManifest.recordInstall(dep.getName(), mf.getFileName(), Files.size(target), dep.getMd5Hash(), dep.getSha256Hash(), mf.getDownloadUrl(), System.currentTimeMillis());
                                    }
                                    catch (Exception e) {
                                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to update install manifest: {}", (Object)e.getMessage());
                                    }
                                }
                            }
                        }
                        finally {
                            boolean finalOk = ok;
                            mc.execute(() -> {
                                mc.method_1507(null);
                                if (finalOk) {
                                    ModInstallerCore.processNext(mc, modsDir, list, index + 1, true, skipTracker);
                                } else if (dep.isRequired()) {
                                    mc.method_1592();
                                } else {
                                    ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny, skipTracker);
                                }
                            });
                        }
                    }
                }, "external-mod-downloader").start();
            } else {
                skipTracker.recordSkip(dep);
                if (dep.isRequired()) {
                    mc.method_1592();
                } else {
                    mc.execute(() -> mc.method_1507(null));
                    ModInstallerCore.processNext(mc, modsDir, list, index + 1, installedAny, skipTracker);
                }
            }
        });
        promptRef.set(prompt);
        mc.execute(() -> {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Showing prompt for {}", (Object)dep.getName());
            mc.method_1507((class_437)prompt);
        });
    }

    private static class SimpleMessageScreen
    extends class_437 {
        private final String line1;
        private final Runnable onClose;
        private final String secondaryLabel;
        private final Runnable onSecondary;

        protected SimpleMessageScreen(String title, String line1, Runnable onClose) {
            this(title, line1, onClose, null, null);
        }

        protected SimpleMessageScreen(String title, String line1, Runnable onClose, String secondaryLabel, Runnable onSecondary) {
            super((class_2561)class_2561.method_43470((String)title));
            this.line1 = line1;
            this.onClose = onClose;
            this.secondaryLabel = secondaryLabel;
            this.onSecondary = onSecondary;
        }

        protected void method_25426() {
            int centerX = this.field_22789 / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"OK"), b -> this.onClose.run()).method_46433(centerX - 50, this.field_22790 / 2 + 30).method_46437(100, 20).method_46431());
            if (this.secondaryLabel != null && this.onSecondary != null) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.secondaryLabel), b -> this.onSecondary.run()).method_46433(centerX - 75, this.field_22790 / 2 + 55).method_46437(150, 20).method_46431());
            }
        }

        public void method_25394(class_332 g, int mx, int my, float pt) {
            this.method_25420(g);
            int centerX = this.field_22789 / 2;
            int y = this.field_22790 / 2 - 20;
            g.method_27534(this.field_22793, this.method_25440(), centerX, y - 20, 0xFFFFFF);
            g.method_25300(this.field_22793, this.line1, centerX, y, 0xAAAAAA);
            super.method_25394(g, mx, my, pt);
        }
    }
}

