/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class DownloadCache {
    private static final long DEFAULT_TTL_MS = 300000L;
    private static final String CACHE_FILE_NAME = "download-cache.json";
    private final Path cacheDir;
    private final long ttlMs;
    private final Map<String, CacheEntry> cache;
    private final Gson gson;

    public DownloadCache(Path cacheDir) {
        this(cacheDir, 300000L);
    }

    public DownloadCache(Path cacheDir, long ttlMs) {
        this.cacheDir = cacheDir;
        this.ttlMs = ttlMs;
        this.cache = new ConcurrentHashMap<String, CacheEntry>();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.loadCache();
    }

    public ModFile get(String cacheKey) {
        CacheEntry entry = this.cache.get(cacheKey);
        if (entry == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (now - entry.timestamp > this.ttlMs) {
            Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Cache entry expired for key: {}", (Object)cacheKey);
            this.cache.remove(cacheKey);
            return null;
        }
        Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Cache hit for key: {}", (Object)cacheKey);
        return new ModFile(entry.fileName, entry.downloadUrl, entry.fileLength);
    }

    public void put(String cacheKey, ModFile modFile) {
        if (cacheKey == null || modFile == null) {
            return;
        }
        CacheEntry entry = new CacheEntry();
        entry.fileName = modFile.getFileName();
        entry.downloadUrl = modFile.getDownloadUrl();
        entry.fileLength = modFile.getFileLength();
        entry.timestamp = System.currentTimeMillis();
        this.cache.put(cacheKey, entry);
        Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Cached entry for key: {}", (Object)cacheKey);
        this.saveCache();
    }

    public void invalidate(String cacheKey) {
        this.cache.remove(cacheKey);
        Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Invalidated cache entry: {}", (Object)cacheKey);
        this.saveCache();
    }

    public void clear() {
        this.cache.clear();
        Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Cleared download cache");
        this.saveCache();
    }

    public void cleanup() {
        long now = System.currentTimeMillis();
        int removed = 0;
        for (Map.Entry<String, CacheEntry> entry : this.cache.entrySet()) {
            if (now - entry.getValue().timestamp <= this.ttlMs) continue;
            this.cache.remove(entry.getKey());
            ++removed;
        }
        if (removed > 0) {
            Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Cleaned up {} expired cache entries", (Object)removed);
            this.saveCache();
        }
    }

    public CacheStats getStats() {
        int total = this.cache.size();
        int expired = 0;
        long now = System.currentTimeMillis();
        for (CacheEntry entry : this.cache.values()) {
            if (now - entry.timestamp <= this.ttlMs) continue;
            ++expired;
        }
        return new CacheStats(total, total - expired, expired);
    }

    private void loadCache() {
        try {
            Path cacheFile;
            if (!Files.exists(this.cacheDir, new LinkOption[0])) {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            }
            if (!Files.exists(cacheFile = this.cacheDir.resolve(CACHE_FILE_NAME), new LinkOption[0])) {
                return;
            }
            String json = Files.readString(cacheFile);
            Map loaded = (Map)this.gson.fromJson(json, new TypeToken<Map<String, CacheEntry>>(){}.getType());
            if (loaded != null) {
                this.cache.putAll(loaded);
                Downloadbypass.LOGGER.info("[EXTERNAL-MODS] Loaded {} cache entries from disk", (Object)loaded.size());
            }
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to load cache: {}", (Object)e.getMessage());
        }
    }

    private void saveCache() {
        try {
            if (!Files.exists(this.cacheDir, new LinkOption[0])) {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            }
            Path cacheFile = this.cacheDir.resolve(CACHE_FILE_NAME);
            String json = this.gson.toJson(this.cache);
            Files.writeString(cacheFile, (CharSequence)json, new OpenOption[0]);
            Downloadbypass.LOGGER.debug("[EXTERNAL-MODS] Saved {} cache entries to disk", (Object)this.cache.size());
        }
        catch (IOException e) {
            Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] Failed to save cache: {}", (Object)e.getMessage());
        }
    }

    public static String buildKey(String source2, String identifier, String version) {
        return source2 + ":" + identifier + ":" + (version != null ? version : "latest");
    }

    private static class CacheEntry {
        String fileName;
        String downloadUrl;
        long fileLength;
        long timestamp;

        private CacheEntry() {
        }
    }

    public static class CacheStats {
        public final int total;
        public final int valid;
        public final int expired;

        public CacheStats(int total, int valid, int expired) {
            this.total = total;
            this.valid = valid;
            this.expired = expired;
        }

        public String toString() {
            return String.format("Cache: %d total, %d valid, %d expired", this.total, this.valid, this.expired);
        }
    }
}

