/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.downloadbypass.downloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.texboobcat.downloadbypass.Downloadbypass;
import org.texboobcat.downloadbypass.config.ModDependency;
import org.texboobcat.downloadbypass.downloader.ModFile;

public class GitHubAPI {
    private static final String API_BASE = "https://api.github.com";
    private OkHttpClient client;
    private static final int MAX_RETRIES = 3;
    private static final long INITIAL_BACKOFF_MS = 500L;

    private OkHttpClient client() {
        if (this.client == null) {
            this.client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).build();
        }
        return this.client;
    }

    public ModFile getLatestRelease(String owner, String repo) {
        return this.getLatestRelease(owner, repo, null);
    }

    public ModFile getLatestRelease(String owner, String repo, String assetNamePattern) {
        String url = "https://api.github.com/repos/" + owner + "/" + repo + "/releases/latest";
        return this.fetchReleaseAsset(url, assetNamePattern);
    }

    public ModFile getReleaseByTag(String owner, String repo, String tag, String assetNamePattern) {
        String url = "https://api.github.com/repos/" + owner + "/" + repo + "/releases/tags/" + tag;
        return this.fetchReleaseAsset(url, assetNamePattern);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ModFile getAssetById(String owner, String repo, long assetId) {
        String url = "https://api.github.com/repos/" + owner + "/" + repo + "/releases/assets/" + assetId;
        Request.Builder reqBuilder = new Request.Builder().url(url).get().header("Accept", "application/vnd.github+json").header("User-Agent", "downloadbypass/1.0 (Minecraft Mod Downloader)").header("X-GitHub-Api-Version", "2022-11-28");
        this.addAuthToken(reqBuilder);
        Request request = reqBuilder.build();
        long backoff = 500L;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            block18: {
                try (Response response = this.client().newCall(request).execute();){
                    if (!response.isSuccessful() || response.body() == null) {
                        int code = response.code();
                        boolean retryable = code == 429 || code == 503;
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitHub API error (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (!retryable || attempt == 3) {
                            ModFile modFile = null;
                            return modFile;
                        }
                        break block18;
                    }
                    String body = response.body().string();
                    try {
                        JsonObject asset = JsonParser.parseString((String)body).getAsJsonObject();
                        ModFile modFile = this.parseAsset(asset);
                        return modFile;
                    }
                    catch (JsonSyntaxException e) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid JSON response from GitHub API: {}", (Object)e.getMessage());
                        ModFile modFile = null;
                        if (response != null) {
                            response.close();
                        }
                        return modFile;
                    }
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitHub API IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block18;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
        }
        return null;
    }

    public ModFile resolveModFile(ModDependency dep) {
        if (dep == null) {
            return null;
        }
        String owner = dep.getGithubOwner();
        String repo = dep.getGithubRepo();
        if (owner == null || owner.isBlank() || repo == null || repo.isBlank()) {
            return null;
        }
        String tag = dep.getGithubTag();
        Long assetId = dep.getGithubAssetId();
        String assetPattern = dep.getGithubAssetPattern();
        if (assetId != null) {
            return this.getAssetById(owner, repo, assetId);
        }
        if (tag != null && !tag.isBlank()) {
            return this.getReleaseByTag(owner, repo, tag, assetPattern);
        }
        return this.getLatestRelease(owner, repo, assetPattern);
    }

    public static ModFile fromBrowserUrl(String browserUrl) {
        if (browserUrl == null || !browserUrl.contains("github.com")) {
            return null;
        }
        String[] parts = browserUrl.split("/");
        if (parts.length < 2) {
            return null;
        }
        String fileName = parts[parts.length - 1];
        return new ModFile(fileName, browserUrl, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModFile fetchReleaseAsset(String apiUrl, String assetNamePattern) {
        Request.Builder reqBuilder = new Request.Builder().url(apiUrl).get().header("Accept", "application/vnd.github+json").header("User-Agent", "downloadbypass/1.0 (Minecraft Mod Downloader)").header("X-GitHub-Api-Version", "2022-11-28");
        this.addAuthToken(reqBuilder);
        Request request = reqBuilder.build();
        long backoff = 500L;
        int attempt = 1;
        while (attempt <= 3) {
            block26: {
                try (Response response = this.client().newCall(request).execute();){
                    Object object;
                    JsonObject release;
                    if (!response.isSuccessful() || response.body() == null) {
                        int code = response.code();
                        boolean retryable = code == 429 || code == 503;
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitHub API error (attempt {}/{}): {} {}", (Object)attempt, (Object)3, (Object)code, (Object)response.message());
                        if (!retryable || attempt == 3) {
                            ModFile modFile = null;
                            return modFile;
                        }
                        break block26;
                    }
                    String body = response.body().string();
                    try {
                        release = JsonParser.parseString((String)body).getAsJsonObject();
                    }
                    catch (JsonSyntaxException e) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] Invalid JSON response from GitHub API: {}", (Object)e.getMessage());
                        ModFile modFile = null;
                        if (response == null) return modFile;
                        response.close();
                        return modFile;
                    }
                    if (!release.has("assets")) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitHub release has no assets");
                        ModFile e = null;
                        return e;
                    }
                    JsonArray assets = release.getAsJsonArray("assets");
                    if (assets.size() == 0) {
                        Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitHub release assets array is empty");
                        ModFile modFile = null;
                        return modFile;
                    }
                    JsonObject matchedAsset = null;
                    if (assetNamePattern != null && !assetNamePattern.isBlank()) {
                        for (JsonElement elem : assets) {
                            String name;
                            JsonObject asset = elem.getAsJsonObject();
                            if (!asset.has("name") || asset.get("name").isJsonNull() || !(name = asset.get("name").getAsString()).matches(assetNamePattern)) continue;
                            matchedAsset = asset;
                            break;
                        }
                    } else {
                        matchedAsset = assets.get(0).getAsJsonObject();
                    }
                    if (matchedAsset == null) {
                        Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] No GitHub asset matched pattern: {}", (Object)assetNamePattern);
                        object = null;
                        return object;
                    }
                    object = this.parseAsset(matchedAsset);
                    return object;
                }
                catch (IOException e) {
                    Downloadbypass.LOGGER.warn("[EXTERNAL-MODS] GitHub API IO error (attempt {}/{}): {}", (Object)attempt, (Object)3, (Object)e.getMessage());
                    if (attempt != 3) break block26;
                    return null;
                }
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            backoff = Math.min(backoff * 2L, 4000L);
            ++attempt;
        }
        return null;
    }

    private ModFile parseAsset(JsonObject asset) {
        long size;
        String fileName = asset.has("name") && !asset.get("name").isJsonNull() ? asset.get("name").getAsString() : "asset.jar";
        String downloadUrl = asset.has("browser_download_url") && !asset.get("browser_download_url").isJsonNull() ? asset.get("browser_download_url").getAsString() : null;
        long l = size = asset.has("size") && !asset.get("size").isJsonNull() ? asset.get("size").getAsLong() : -1L;
        if (downloadUrl == null || downloadUrl.isBlank()) {
            Downloadbypass.LOGGER.error("[EXTERNAL-MODS] GitHub asset missing browser_download_url");
            return null;
        }
        return new ModFile(fileName, downloadUrl, size);
    }

    private void addAuthToken(Request.Builder reqBuilder) {
        String token = System.getenv("GITHUB_TOKEN");
        if (token != null && !token.isBlank()) {
            reqBuilder.header("Authorization", "Bearer " + token);
        }
    }
}

